# Dissecting the Sequential Evolution of a Selfish Mitochondrial Genome in Caenorhabditis elegans Data

[https://doi.org/10.5061/dryad.1vhhmgr2z](https://doi.org/10.5061/dryad.1vhhmgr2z)

This data set contains four csv files

Fitness_data.xlsx contains raw measurements for four fitness traits measured in five populations of *C. elegans.*

Heteroplasmic_frequencies_Fig3.csv contains four tables of heteroplasmic frequencies of mitochondrial mutations from a mutation accumulation (MA) replay experiment

mtDNA_copynumber_backcrossed_lines_Fig4.csv contains a table of mitochondrial DNA copy numbers per nuclear genome in backcrossed lines normalized to the average of the wild-type N2 copy number

mtDNA_copynumber_MA_lines_Fig4.csv contains a table of mitochondrial DNA copy numbers per nuclear genome in MA lines normalized to the average of the wild-type N2 copy number

## Description of the data and file structure

* Fitness_data.xlsx
  * ```
    These lines were created by backcrossing the mitochondrial background of mutation accumulation (MA) lines into a wild-type nuclear background. 
    ```
  * ```
    The 5 lines were derived from line MA line 1G, at generations 0 (preMA), 71, 96, 221, and 350
    ```
  * ```
    The four fitness traits measured were productivity, measured as the number of progeny produced by a single nematode; survivorship to adulthood, measured as the % of full sibling nematodes that survived to adulthood; longevity, measured as the number of days until the nematode died/was no longer respiring or responsive; and developmental time, measured as the number of hours an individual nematode took to reach adulthood.
    ```
  * ```
    Each sheet contains all the raw measurements for a given fitness trait in columns grouped by line. Mean, standard deviation, and n also provided. 
    ```
* Heteroplasmic_frequencies_Fig3.csv
  * ```
    Each table contains the heteroplasmic frequencies of a mitochondrial mutation of interest at generations 0, 5, and 10 of MA replay. 
    ```
  * ```
    G71 contains the heteroplasmic frequencies of a ctb-1 deletion as determined by ddPCR (Bio-Rad)
    ```
  * ```
    G96 contains the heteroplasmic frequencies of an nd5 frameshift mutation determined by analyzing peak heights in sanger sequencing chromatograms via FIJI
    ```
  * ```
    G136 contains the heteroplasmic frequencies of an nd5 missense mutation  determined by analyzing peak heights in sanger sequencing chromatograms via FIJI
    ```
  * ```
    G300 contains the heteroplasmic frequencies of a subsequent nd5 frameshift mutation determined by analyzing peak heights in sanger sequencing chromatograms via FIJI
    ```

cells with a value "n/a" are present in the data. These cells and represent samples lost due to single worm DNA extractions yielding too little or too degraded DNA for sequencing and ddPCR

* mtDNA_copynumber_backcrossed_lines_Fig4.csv
  * ```
    Mitochondrial copy number was determined via ddPCR (Bio-Rad)
    ```
  * ```
    Relative mtDNA copy-number was calculated by dividing the copy number of each replicate by the mean copy number of wild-type N2 (WT in table)
    ```
  * ```
    Average was calculated by taking the average of each replicate for each line
    ```

* mtDNA_copynumber_MA_lines_Fig4.csv
  * ```
    Mitochondrial copy number was determined via ddPCR (Bio-Rad)
    ```
  * ```
    Relative mtDNA copy-number was calculated by dividing the copy number of each replicate by the mean copy number of wild-type N2 (WT in table)
    ```
  * ```
    Average was calculated by taking the average of each replicate for each line
    ```

