import glob
import pandas as pd
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.ticker import PercentFormatter

# customizations
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.size'] = 12.0
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['savefig.bbox'] = 'tight'

files = sorted(glob.glob('lang_data/data_*'))
unix_ts = []
data = {}
for f in files:
    ts = int(f[15:])
    unix_ts.append(ts)
    data[ts] = {}
    with open(f) as fh:
        for line in fh:
            percent, language = line.split()
            data[ts][language] = float(percent[:-1])/100.0

modified_data = {
    'Fortran': [],
    'C++': [],
    'Python': [],
    'Other': []
}
for ts in unix_ts:
    other = 0.0
    for lang, num in data[ts].items():
        if lang in modified_data:
            modified_data[lang].append(num)
        else:
            other += num
    modified_data['Other'].append(other)

    for lang, lst in modified_data.items():
        if lang != 'Other' and lang not in data[ts]:
            modified_data[lang].append(0.0)

modified_data['Date'] = pd.to_datetime(unix_ts, unit='s')
df = pd.DataFrame(modified_data)

time = [d.to_pydatetime() for d in df.Date]

sum_fortran = df.Other + df.Fortran
sum_python = sum_fortran + df.Python
sum_cpp = sum_python + df['C++']

plt.fill_between(time, df.Other, sum_fortran, label='Fortran')
plt.fill_between(time, sum_fortran, sum_python, label='Python')
plt.fill_between(time, sum_python, sum_cpp, label='C++')
plt.fill_between(time, df.Other, label='Other')

plt.gca().yaxis.set_major_formatter(PercentFormatter(1.0))
plt.legend(loc='lower right')
plt.xlabel('Year')
plt.ylabel('Percentage')
plt.xlim((time[0], time[-1]))
plt.ylim(0.0, 1.0)
plt.tight_layout()
plt.savefig('languages.pdf')
