#!/bin/bash
set -euo pipefail
arg1=${1}

printf "Generating the CNF files from the source Alloy files into AlloyToCNF/CNF\n"
cd AlloyToCNF
java -jar AlloyToCNF.jar &> /dev/null

printf "Checking ADL pre-execution correctness\n"
cd CNF 
printf "Running the Release Acquire semantics predicates\n" 
printf "p_correct RelAcq-4:\n" 
time (z3 RelAcq-4p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct RelAcq-5:\n" 
time (z3 RelAcq-5p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct RelAcq-6:\n" 
time (z3 RelAcq-6p.cnf | grep SATISFIABLE) 2> >( grep real )
if [ $arg1 = 1 ] 
then 
printf "\np_correct Rlx-7:\n" 
time (z3 Rlx-7p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct RelAcq-8:\n"
time (z3 Rlx-8p.cnf | grep SATISFIABLE) 2> >( grep real )
fi 
printf "\nRunning the Relaxed semantics predicates\n"
printf "p_correct Rlx-4:\n" 
time (z3 Rlx-4p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct Rlx-5:\n" 
time (z3 Rlx-5p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct Rlx-6:\n" 
time (z3 Rlx-6p.cnf | grep SATISFIABLE) 2> >( grep real )
if [ $arg1 = 1 ] 
then 
printf "\np_correct Rlx-7:\n" 
time (z3 Rlx-7p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct Rlx-8:\n" 
time (z3 Rlx-8p.cnf | grep SATISFIABLE) 2> >( grep real )
fi
printf "\nRunning the Relaxed Star semantics predicates\n"
printf "p_correct RlxS-4:\n" 
time (z3 RlxS-4p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct RlxS-5:\n" 
time (z3 RlxS-5p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct RlxS-6:\n" 
time (z3 RlxS-6p.cnf | grep SATISFIABLE) 2> >( grep real )
if [ $arg1 = 1 ] 
then 
printf "\np_correct RlxS-7:\n" 
time (z3 RlxS-7p.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\np_correct RlxS-8:\n" 
time (z3 RlxS-8p.cnf | grep SATISFIABLE) 2> >( grep real )
fi

printf "\nChecking ADL mapping correctness\n" 
printf "Running the Release Acquire semantics predicates\n" 
printf "mapping_correct RelAcq-4:\n" 
time (z3 RelAcq-4m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct RelAcq-5:\n" 
time (z3 RelAcq-5m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct RelAcq-6:\n" 
time (z3 RelAcq-6m.cnf | grep SATISFIABLE) 2> >( grep real )
if [ $arg1 = 1 ] 
then 
printf "\nmapping_correct RelAcq-7:\n" 
time (z3 RelAcq-7m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct RelAcq-8:\n" 
time (z3 RelAcq-8m.cnf | grep SATISFIABLE) 2> >( grep real )
fi
printf "\nRunning the Relaxed semantics predicates\n" 
printf "mapping_correct Rlx-4:\n" 
time (z3 Rlx-4m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct Rlx-5:\n" 
time (z3 Rlx-5m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct Rlx-6:\n" 
time (z3 Rlx-6m.cnf | grep SATISFIABLE) 2> >( grep real )
if [ $arg1 = 1 ] 
then 
printf "\nmapping_correct Rlx-7:\n" 
time (z3 Rlx-7m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct Rlx-8:\n" 
time (z3 Rlx-8m.cnf | grep SATISFIABLE) 2> >( grep real )
fi
printf "\nRunning the Relaxed Star semantics predicates\n" 
printf "mapping_correct RlxS-4:\n" 
time (z3 RlxS-4m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct RlxS-5\n": 
time (z3 RlxS-5m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct RlxS-6\n": 
time (z3 RlxS-6m.cnf | grep SATISFIABLE) 2> >( grep real )
if [ $arg1 = 1 ] 
then 
printf "\nmapping_correct RlxS-7\n": 
time (z3 RlxS-7m.cnf | grep SATISFIABLE) 2> >( grep real )
printf "\nmapping_correct RlxS-8\n": 
time (z3 RlxS-8m.cnf | grep SATISFIABLE) 2> >( grep real )
fi