import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import edu.mit.csail.sdg.ast.Command;
import edu.mit.csail.sdg.ast.Module;
import edu.mit.csail.sdg.parser.CompUtil;
import edu.mit.csail.sdg.translator.A4Options;
import edu.mit.csail.sdg.translator.TranslateAlloyToKodkod;

public class App {
    private void prepAlloyFiles(){
        File AuDaLaSpec = new File("./Alloy/ADL.als");
        File AuDaLa2PTX = new File("./Alloy/compile_adl2ptx.als");
    
        String contentRlxS = "";
        
        try{
            BufferedReader reader = new BufferedReader(new FileReader(AuDaLaSpec));
            for (int i = 0; i < 147; i++){
                contentRlxS = contentRlxS+reader.readLine()+"\n";
            }
            String ADLline148 = reader.readLine();
            ADLline148 = ADLline148.substring(0, ADLline148.indexOf("C")) + "//" + ADLline148.substring(ADLline148.indexOf("C"));
            contentRlxS = contentRlxS + ADLline148 + "\n";
            String ADLline149 = reader.readLine();
            contentRlxS = contentRlxS + ADLline149 + "\n";
            String ADLline150 = reader.readLine();
            ADLline150 = ADLline150.replaceAll("/", "");
            contentRlxS = contentRlxS + ADLline150 + "\n";
            String ADLline151 = reader.readLine();
            ADLline151 = ADLline151.replaceAll("/", "");      
            contentRlxS = contentRlxS + ADLline151 + "\n";
            String line = reader.readLine();
            while (line != null){
                contentRlxS = contentRlxS + line + "\n";
                line = reader.readLine();
            }
            reader.close();
            File ADLRlxS = new File("./Alloy/ADLRlxS.als");
            try {
                FileWriter myWriter = new FileWriter(ADLRlxS);
                myWriter.write(contentRlxS);
                myWriter.close();
            } catch (Exception e) {
                System.out.println("Could not write to ADLRlxS.als.");
                e.printStackTrace();
            }
            String contentAcqRel = "";
            contentRlxS = "";
            reader = new BufferedReader(new FileReader(AuDaLa2PTX));
            for (int i = 0; i < 8; i++){
                String nextline = reader.readLine();
                contentAcqRel = contentAcqRel+nextline+"\n";
                contentRlxS = contentRlxS+nextline+"\n";
            }
            String a2pline9 = reader.readLine();
            contentAcqRel = contentAcqRel+a2pline9+"\n";
            a2pline9 = a2pline9.substring(0, a2pline9.indexOf("[")) + "RlxS" + a2pline9.substring(a2pline9.indexOf("["));
            contentRlxS = contentRlxS+a2pline9+"\n";
            for (int i = 10; i < 42; i++){
                String nextline = reader.readLine();
                contentAcqRel = contentAcqRel+nextline+"\n";
                contentRlxS = contentRlxS+nextline+"\n";
            }
            String a2pline42 = reader.readLine();
            contentRlxS = contentRlxS+a2pline42+"\n";
            a2pline42 = a2pline42.substring(0, a2pline42.indexOf("m")) + "// " + a2pline42.substring(a2pline42.indexOf("m"));
            contentAcqRel = contentAcqRel + a2pline42 + "\n";
            String a2pline43 = reader.readLine();
            contentAcqRel = contentAcqRel + a2pline43 + "\n";
            contentRlxS = contentRlxS+a2pline43+"\n";
            String a2pline44 = reader.readLine();
            contentRlxS = contentRlxS+a2pline44+"\n";
            a2pline44 = a2pline44.replaceAll("/", "");
            a2pline44 = a2pline44.substring(0, 1)+a2pline44.substring(2);
            contentAcqRel = contentAcqRel + a2pline44 + "\n";
            line = reader.readLine();
            while (line != null){
                contentAcqRel = contentAcqRel + line + "\n";
                contentRlxS = contentRlxS + line + "\n";
                line = reader.readLine();
            }
            reader.close();
            File a2pAcqRel = new File("./Alloy/compile_adl2ptxAcqRel.als");
            File a2pRlxS = new File("./Alloy/compile_adl2ptxRlxS.als");
            try {
                FileWriter myWriter = new FileWriter(a2pAcqRel);
                myWriter.write(contentAcqRel);
                myWriter.close();
            } catch (Exception e) {
                System.out.println("Could not write to compile_adl2ptxAcqRel.");
                e.printStackTrace();
            }
            try {
                FileWriter myWriter = new FileWriter(a2pRlxS);
                myWriter.write(contentRlxS);
                myWriter.close();
            } catch (Exception e) {
                System.out.println("Could not write to compile_adl2ptxRlx.S");
                e.printStackTrace();
            }
        } catch (Exception e){
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    private void makeCNFs(){
        makeCNFs(0);
        makeCNFs(1);
        makeCNFs(2);
        makeCNFs(3);
        makeCNFs(4);
        makeCNFs(5);
    }

    private void makeCNFs(int which) {
        Path Spec = null;
        switch (which) {
            case 0: Spec = FileSystems.getDefault().getPath("./Alloy/ADL.als");break;
            case 1: Spec = FileSystems.getDefault().getPath("./Alloy/ADL.als");break;
            case 2: Spec = FileSystems.getDefault().getPath("./Alloy/ADLRlxS.als");break;
            case 3: Spec = FileSystems.getDefault().getPath("./Alloy/compile_adl2ptxAcqRel.als");break;
            case 4: Spec = FileSystems.getDefault().getPath("./Alloy/compile_adl2ptx.als");break;
            case 5: Spec = FileSystems.getDefault().getPath("./Alloy/compile_adl2ptxRlxS.als");break;
        }
        //generate CNF
        String SpecString = "";
        try {
            SpecString = Files.readString(Spec);
        } catch (Exception e) {
            switch(which){
                case 2: System.out.println("File ADLRlxS.als could not be read.");break;
                case 3: System.out.println("File compile_adl2ptxAcqRel.als could not be read");break;
                case 4: System.out.println("File compile_adl2ptx.als could not be read");break;
                case 5: System.out.println("File compile_adl2ptxRlxS.als could not be read");break;
                default: System.out.println("File ADL.als could not be read.");break;
            }
            
        }
        int numberIndex = SpecString.indexOf("8");
        numberIndex = SpecString.indexOf("8", numberIndex + 1);
        for (int i = 4; i < 9; i++){
            String mainString = SpecString.substring(0, numberIndex) + String.valueOf(i) + SpecString.substring(numberIndex+1);
            String outputfile = CNF(mainString, numberIndex, i);
            String filename = null;
            switch(which){
                case 0: filename = "RelAcq-"+String.valueOf(i)+"p";break;
                case 1: filename = "Rlx-"+String.valueOf(i)+"p";break;
                case 2: filename = "RlxS-"+String.valueOf(i)+"p";break;
                case 3: filename = "RelAcq-"+String.valueOf(i)+"m";break;
                case 4: filename = "Rlx-"+String.valueOf(i)+"m";break;
                case 5: filename = "RlxS-"+String.valueOf(i)+"m";break;
            } 
            Path resultPath = FileSystems.getDefault().getPath(outputfile);
            String contents = "";
            try {
                contents = Files.readString(resultPath);
                String newfilePath = "./CNF/" + filename + ".cnf";
                CompUtil.flushModelToFile(contents, new File(newfilePath));
            } catch (Exception e) {
                switch(which){
                    case 0: System.out.println("AcqRel output file for p_correct size " + String.valueOf(i) + " could not be transferred to CNF.");break;
                    case 1: System.out.println("Rlx output file for p_correct size " + String.valueOf(i) + " could not be transferred to CNF.");break;
                    case 2: System.out.println("RlxS output file for p_correct size " + String.valueOf(i) + " could not be transferred to CNF.");break;
                    case 3: System.out.println("AcqRel output file for mapping_correct size " + String.valueOf(i) + " could not be transferred to CNF.");break;
                    case 4: System.out.println("Rlx output file for mapping_correct size " + String.valueOf(i) + " could not be transferred to CNF.");break;
                    case 5: System.out.println("RlxS output file for mapping_correct size " + String.valueOf(i) + " could not be transferred to CNF.");break;
                }  
            } 
        }
    }

    private String CNF(String mainString, int numberIndex, int size) {
        FileReporter rep = new FileReporter();
        File tmpMain = null;
        try {
            tmpMain = CompUtil.flushModelToFile(mainString, new File("./Alloy/tmp.als"));
        } catch (Exception e) {System.out.println("Making a new file failed.");}
        Module world = CompUtil.parseEverything_fromFile(rep, null, tmpMain.getAbsolutePath());
        A4Options opt = new A4Options();
        //opt.tempDirectory = "./CNF";
        opt.solver = A4Options.SatSolver.CNF;
        Command command = world.getAllCommands().get(0);
        System.out.println(command);
        TranslateAlloyToKodkod.execute_command(rep, world.getAllReachableSigs(), command, opt);
        tmpMain.delete();
        return rep.getResultfile();
    }

    public static void main(String[] args) throws Exception {
        App prepApp = new App();
        prepApp.prepAlloyFiles();
        prepApp.makeCNFs();
    }
}
