/** Author: G.P. Leemrijse
	 13-08-2023
	 TU Eindhoven
*/

module compile_adl2ptx
open util as util
open ptx as hw
open ADL[hw/Event, hw/Address, hw/Thread] as sem

fun Device : Scope {
	System.subscope
}

pred map_preex {
	// cmd_map is a 1-to-1 map between sem/Command and hw/Event
	bijective[cmd_map, sem/Command, hw/Event]

	// inst_map is a 1-to-1 map between sem/Instance and hw/Thread
	bijective[inst_map, sem/Instance, hw/Thread]

	// loc_map is a 1-to-1 map between sem/Location and hw/Address
	bijective[loc_map, sem/Location, hw/Address]

	// map next_cmd onto po
	nxt = cmd_map.po.~cmd_map

	// map loc onto address
	loc = cmd_map.address.~loc_map
	
	// map sem/start onto hw/start
	(sem/Instance <: start) = inst_map.(hw/Thread <: start).~cmd_map
	
	// map sem/dep onto hw/dep
	(sem/Command <: dep) = cmd_map.(hw/Event <: dep).~cmd_map

	// Set scopes and rmw properly
	set_scopes_and_rmw
	
	// Pick one:
	// Relaxed
	map_preex_rlx
	// Acquire/Release
	// map_preex_acqrel
}


pred map_preex_rlx {
	// map sem/ReadCommand to hw/Read, but not acquire
	(sem/ReadCommand).cmd_map in (hw/Read - hw/Acquire)
	
	// map sem/WriteCommand to hw/Write, but not release
	(sem/WriteCommand).cmd_map in (hw/Write - hw/Release)
}

pred map_preex_acqrel {
	// map sem/ReadCommand to hw/Acquire
	(sem/ReadCommand).cmd_map in (hw/Acquire)
	
	// map sem/WriteCommand to hw/Release
	(sem/WriteCommand).cmd_map in (hw/Release)
}

pred set_scopes_and_rmw {
	no rmw // No read-modify-write
	one Device // one device
	Device.subscope = hw/Thread // Thread scope is one lvl lower
	(hw/Event).scope = Device // all events have device scope
}

pred reverse_map {
	// Map rf back
	(sem/WriteCommand <: rf) = cmd_map.(hw/Write <: rf).~cmd_map
	
	// Map co back
	(sem/WriteCommand <: co) = cmd_map.(hw/Write <: (same_thread[^co])).~cmd_map
}

assert mapping_correct {
	(wellformed_adl_preex and
	map_preex and
	ptx_mm and
	reverse_map) implies legal_adl_execution
}

check mapping_correct for 8 but 0 hw/Fence, 0 hw/Barrier
