% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture_diversity.VCF.R
\name{capture_diversity.VCF}
\alias{capture_diversity.VCF}
\title{Estimate Minimum Number of Individuals to Sample to Capture Population Genomic Diversity (VCF)}
\usage{
capture_diversity.VCF(
  vcf,
  ploidy,
  r2_threshold = 0.9,
  iterations = 10,
  sample_list = NULL,
  parallel = FALSE,
  batch = 1,
  save.result = TRUE
)
}
\arguments{
\item{vcf}{Path to VCF file (.vcf or .vcf.gz) with genotype information}

\item{ploidy}{The ploidy of the species being analyzed}

\item{r2_threshold}{The ratio of diversity to capture (default = 0.9)}

\item{iterations}{The number of iterations to perform to estimate the average result (default = 10)}

\item{sample_list}{The list of samples to subset from the dataset (optional)}

\item{parallel}{Run the analysis in parallel (True/False) (default = FALSE)}

\item{save.result}{Save the results to a .txt file? (default = TRUE)}
}
\value{
A data.frame with minimum number of samples required to match or exceed the input ratio
}
\description{
This function can be used to estimate the number of individuals to sample from a population
in order to capture a desired percentage of the genomic diversity.
VCF files can be either unzipped or gzipped. All samples must have the same ploidy.
This function was adapted from a previously developed Python method (Sandercock et al., 2023)
(https://github.com/alex-sandercock/Capturing_genomic_diversity/)
}
\references{
Sandercock, A. M., Westbrook, J. W., Zhang, Q., & Holliday, J. A. (2023). The road to restoration: Identifying and conserving the adaptive legacy of American chestnut. bioRxiv, 2023-05.
}
