(*
 * Copyright (c) 2009-2013, Monoidics ltd.
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *)

open! IStd
open Javalib_pack
open Sawja_pack

val create_fieldname : JBasics.class_name -> JBasics.field_signature -> Fieldname.t
(** translate the name of the field *)

val get_method_kind : JCode.jcode Javalib.jmethod -> Procname.Java.kind

val get_method_procname :
     JProgramDesc.t
  -> Tenv.t
  -> JBasics.class_name
  -> JBasics.method_signature
  -> Procname.Java.kind
  -> Procname.t
(** returns a procedure name based on the class name and the method's signature *)

val translate_method_name : JProgramDesc.t -> Tenv.t -> JCode.jcode Javalib.jmethod -> Procname.t
(** translate the SIL procedure name of the Java method *)

val get_class_struct_typ : JProgramDesc.t -> Tenv.t -> JBasics.class_name -> Struct.t
(** [get_class_struct_typ program tenv cn] returns the struct_typ representation of the class *)

val get_class_type_no_pointer : JProgramDesc.t -> Tenv.t -> JBasics.class_name -> Typ.t
(** [get_class_type_no_pointer program tenv cn] returns the sil type representation of the class
    without the pointer part *)

val get_class_type : JProgramDesc.t -> Tenv.t -> JBasics.class_name -> Typ.t
(** [get_class_type program tenv cn] returns the sil type representation of the class *)

val is_autogenerated_assert_field : Fieldname.t -> bool
(** return true if [field_name] is the autogenerated C.$assertionsDisabled field for class C *)

val sizeof_of_object_type : JProgramDesc.t -> Tenv.t -> JBasics.object_type -> Subtype.t -> Exp.t
(** create sizeof expressions from the object type and the list of subtypes *)

val value_type : JProgramDesc.t -> Tenv.t -> JBasics.value_type -> Typ.t
(** transforms a Java type to a Typ.t. *)

val param_type :
  JProgramDesc.t -> Tenv.t -> JBasics.class_name -> JBir.var -> JBasics.value_type -> Typ.t
(** return the type of a formal parameter, looking up the class name in case of "this" *)

val return_type : JProgramDesc.t -> Tenv.t -> JBasics.method_signature -> Typ.t
(** Returns the return type of the method based on the return type specified in ms. *)

val expr_type : JContext.t -> JBir.expr -> Typ.t
(** translates the type of an expression *)

val cast_type : JBir.conv -> Typ.t
(** translates a conversion type from Java to Sil. *)

val create_array_type : Typ.t -> int -> Typ.t
(** [create_array_type typ dim] creates an array type with dimension dim and content typ *)

val object_type_to_string : JBasics.object_type -> string
(** returns a string representation of an object Java type *)
