# Common ant species dominate morphospace: unraveling the morphological diversity in the Brazilian Amazon Basin

[https://doi.org/10.5061/dryad.pg4f4qrzf](https://doi.org/10.5061/dryad.pg4f4qrzf)

Data on ant occurrence by vegetation types (Appendix table S1) and morphological measurements of ant species (Appendix table S2) were recorded in the Brazilian Amazon Basin. Morphological traits were delimited by the first four axes of a principal component analysis (PCA) and were used in the manuscript "Common ant species dominate morphospace: unraveling the morphological diversity in the Brazilian Amazon Basin". Morphological measurements taken for ant species included: HW = Head width; HL = Head length; CL = Clypeus length; ML = Mandible length; MW = Mandible width; FL = Hind femur length; SL = Scape length; WL = Weber’s length; ID = Inter-ocular distance; EL = Eyes length; PrW = Pronotum width; DEM = Distance of eye to mandible insertion; PeL = Petiole length; PeW = Petiole width; PeH = Petiole height.

## Description of the data and file structure

**Table S1**: Occurrence database for ants by vegetation types in the Brazilian Amazon Basin. Ant records used in this study can be retrieved freely from [https://doi.org/10.5061/dryad.ht76hdrj8](https://doi.org/10.5061/dryad.ht76hdrj8), and metadata are available in Andrade-Silva et al. (2022). We used nine main vegetation types in the Brazilian Amazon, as provided by the Instituto Brasileiro de Geografia e Estatística (IBGE 2012): (1) anthropic, (2) white sand forests (Campinaranas), (3) dense ombrophilous forests, (4) open ombrophilous forests, (5) pioneer vegetation (i.e., sand bars, mangroves), (6) savannah, (7) seasonal deciduous forest, (8) seasonal semideciduous forest, and (9) vegetational refuge (i.e., high-altitude fields, peat areas). For more details on each vegetation type, please see 'Table 1' in Andrade-Silva et al. (2024).

**Table S2**: Morphological database developed from a set of 977 ant species (about 91% of the species recorded for the Brazilian Amazon Basin) and 15 continuous morphological traits (see Table S1 in Andrade-Silva et al. 2024). We used the first four axes of an ordination (PCA) to reduce the number of input variables. Measurements were taken primarily through high-definition images available on Antweb or during visits to collections. Taxonomic literature was consulted for morphological measurements of ant species without available high-definition images from online databases.

### Reference cited

Andrade-Silva, J., Baccaro, F. B., Prado, L. P., Guénard, B., Warren, D. L., Kass, J. M., Economo, E. P. and Silva, R. R. 2022. A large-scale assessment of ant diversity across the Brazilian Amazon Basin: integrating geographic, ecological and morphological drivers of sampling bias. Ecography, 9, e06295. [https://doi.org/10.1111/ecog.06295](https://doi.org/10.1111/ecog.06295).

IBGE (Inst. Brasileiro de Geografia e Estatística). 2012. Manual técnico da vegetação brasileira: Sistema fitogeográfico, inventário das formações florestais e campestres, técnicas e manejo de coleções botânicas, procedimentos para mapeamentos. - IBGE.

### Citation:

Andrade-Silva, J., Baccaro, F. B., Prado, L. P., Guenard, B., Kass, J. M., Warren, D. L., Economo, E. P. and Silva, R. R. 2024. Common ant species dominate morphospace: unraveling the morphological diversity in the Brazilian Amazon Basin. Ecography.
