% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aKNNO.R
\name{FindOptimalDelta}
\alias{FindOptimalDelta}
\title{FindOptimalDelta}
\usage{
FindOptimalDelta(
  obj,
  reduction = "pca",
  delta = c(-1, 0),
  cutoff = 5,
  kmax = 20,
  prune.SNN = 1/15,
  dims = 1:50,
  verbose = T
)
}
\arguments{
\item{obj}{A Seurat object}

\item{reduction}{Reduction to use as input to build an aKNN graph. Default is 'pca'}

\item{delta}{The range of delta for the grid search (<=0). Default is c(-1,0)}

\item{cutoff}{The cutoff for the increasing number of communities. Default is 5}

\item{kmax}{The largest k-value. Default is 20}

\item{prune.SNN}{The cutoff for acceptable Jaccard index when computing the neighborhood overlap for the SNN construction. Any edges with values less than or equal to this will be set to 0 and removed from the SNN graph. Default is 1/15}

\item{dims}{Dimensions of reduction to use. Default is 1:50}

\item{verbose}{Print progress message (TRUE or FALSE). Default is TRUE}
}
\value{
A list containing the optimal delta (opt_delta) and a ggplot showing the increased number of communities and singletons along with the decreased delta
}
\description{
Find the optimal delta to construct the adaptive nearest-neighbor graph
}
\examples{
library(aKNNO)
obj<-readRDS(url("https://www.dropbox.com/s/f5khi1zperqkybg/Mouse_Brain_Serial_Section1_SagittalPosterior_rawimage_object.rds?dl=1"))
res <- FindOptimalDelta(obj)
#plot the increasing number of communities/singletons with decreasing delta values
res$plot_delta
# the optimal delta is -0.8
res$opt_delta
}
