% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aKNNO.R
\name{FindNeighbors_aKNN}
\alias{FindNeighbors_aKNN}
\title{aKNN}
\usage{
FindNeighbors_aKNN(
  obj,
  reduction = "pca",
  delta = -0.5,
  dims = 1:50,
  kmax = 20,
  prune.SNN = 1/15
)
}
\arguments{
\item{obj}{A Seurat object}

\item{reduction}{Reduction to use as input to build an aKNN graph. Default is 'pca'}

\item{delta}{The parameter controlling the sensitivity to local distances change (<=0). Default is -0.5}

\item{dims}{Dimensions of reduction to use. Default is 1:50}

\item{kmax}{The largest k-value. Default is 20}

\item{prune.SNN}{The cutoff for acceptable Jaccard index when computing the neighborhood overlap for the SNN construction. Any edges with values less than or equal to this will be set to 0 and removed from the SNN graph. Default is 1/15}
}
\value{
A Seurat object with a shared-adaptive-KNN graph (named as "aKNN") stored in the respective slot.

library(aKNNO)
obj<-readRDS(url("https://www.dropbox.com/s/f5khi1zperqkybg/Mouse_Brain_Serial_Section1_SagittalPosterior_rawimage_object.rds?dl=1"))
obj <- FindNeighbors_aKNN(obj)
}
\description{
An Adaptive K-Nearest-Neighbors Graph (aKNN) Construction Method for  Clustering of Single Cell and Spatial transcriptomics Data
}
