% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aKNNO.R
\name{FindNeighbors_aKNNO}
\alias{FindNeighbors_aKNNO}
\title{aKNNO}
\usage{
FindNeighbors_aKNNO(
  obj,
  cluster = FALSE,
  reduction = "pca",
  delta = c(-1, 0),
  dims = 1:50,
  kmax = 20,
  prune.SNN = 1/15,
  cutoff = 5,
  verbose = T
)
}
\arguments{
\item{obj}{A Seurat object}

\item{cluster}{whether to perform clustering on the aKNNO graph (TRUE or FALSE); If TRUE, Louvain clustering at a resolution of 0.8 in the Seurat will be performed; Default is False.}

\item{reduction}{Reduction to use as input to build an aKNN graph. Default is 'pca'}

\item{delta}{The range of delta for the grid search (<=0). Default is c(-1,0)}

\item{dims}{Dimensions of reduction to use. Default is 1:50}

\item{kmax}{The largest k-value. Default is 20}

\item{prune.SNN}{The cutoff for acceptable Jaccard index when computing the neighborhood overlap for the SNN construction. Any edges with values less than or equal to this will be set to 0 and removed from the SNN graph. Default is 1/15}

\item{cutoff}{The cutoff for the increasing number of communities. Default is 5}

\item{verbose}{Print progress message (TRUE or FALSE). Default is TRUE}
}
\value{
A Seurat object with an optimized shared-adaptive-KNN graph (named as aKNN_O) stored in the respective slot.
}
\description{
An Adaptive K-Nearest-Neighbors Graph with Optimization (aKNNO) for Clustering of Single Cell and Spatial transcriptomics Data
}
\examples{
library(aKNNO)
obj<-readRDS(url("https://www.dropbox.com/s/f5khi1zperqkybg/Mouse_Brain_Serial_Section1_SagittalPosterior_rawimage_object.rds?dl=1"))
obj <- FindNeighbors_aKNNO(obj)
}
