% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNC.R
\name{writeNC}
\alias{writeNC}
\title{Write a magpie object to a netCDF file}
\usage{
writeNC(
  x,
  filename,
  unit,
  ...,
  compression = 2,
  missval = NA,
  gridDefinition = NULL,
  zname = "time",
  progress = FALSE
)
}
\arguments{
\item{x}{A magpie object}

\item{filename}{Name of the netCDF file to write}

\item{unit}{Unit of the data, to omit pass "" (empty string)}

\item{...}{For future expansion}

\item{compression}{Level of compression to use (1-9), NA for no compression}

\item{missval}{The value that encodes NA in the resulting netCDF file}

\item{gridDefinition}{A vector of 5 numeric values: c(xMin, xMax, yMin, yMax, resolution).
Use c(-179.75, 179.75, -89.75, 89.75, 0.5) to write a standard 0.5-degree-resolution
lon/lat grid. If NULL, use min/max of coordinates in x and guessResolution}

\item{zname}{Name of the z dimension in the netCDF file}

\item{progress}{If TRUE, print progress messages}
}
\description{
Write a magpie object to a netCDF file
}
\author{
Pascal Sauer
}
