package uk.ac.bbsrc.tgac.miso.migration.destination;

import java.io.IOException;

import uk.ac.bbsrc.tgac.miso.migration.MigrationData;

public interface MigrationTarget {
  
  /**
   * Saves all included data into the migration target. The provided objects are mutated by this call,
   * including autogenerated IDs. The listener is notified when migration completes
   * 
   * @param data
   * @param listener
   * @throws IOException
   */
  public void migrate(MigrationData data, MigrationCompleteListener listener) throws IOException;

}
