---
layout: page
title: "REST API"
category: ref
date: 2016-01-12 13:48:16
order: 1
---



MISO REST API queries to the above addresses retrieve JSON objects. The REST API only supports GET requests. Authentication ensures that the user can only view elements (projects, samples, libraries, runs) which they have permission to view.

The External Webapp makes calls to the REST API Projects and Runs endpoints.

# Projects

### /rest/project/

Retrieves all projects.

### /rest/project/{projectId}

Retrieves a single project by its ID.

### /rest/project/alias/{projectAlias}

Retrieves a single project by its alias (NB. this needs more testing for potential URL encoding issues).

# Samples

### /rest/sample/{sampleId}

Retrieves a single sample by its ID.

# Libraries

### /rest/library

Retrieves all libraries.

### /rest/library/{libraryId}

Retrieves a single library by its ID.

### /library/barcodeStrategies?platform={platform}

Retrieves all barcode strategies associated with a given platform.

### /library/libraryTypes?platform={platform}

Retrieves all library types associated with a given platform.

### /library/barcodesForPosition?barcodeStrategy={barcodeStrategy}&position={position#}

Should retrieve all barcodes associated with a given position.

# Runs

### /rest/run

Retrieves all runs (slightly different information than _/runs/rest_ above).

### /rest/run/{runId}

Retrieves a single run by its ID.

### /rest/run/{runAlias}

Retrieves a single run by its alias.

### /rest/run/{runAlias}/samplesheet

Retrieves a samplesheet uploaded for run, if one is given.

Headers: `FCID,Lane,SampleID,SampleRef,Index,Description,Control,Recipe,Operator,Project`

# Pools

### /rest/pool/{poolId}

Retrieves a pool by its ID.

### /rest/pool/wizard/librarydilutions

Returns all library dilutions by name.

### /rest/pool/wizard/platformtypes

Returns all platform types.

# Miscellaneous

### /experiments/rest

Retrieves all experiments. (note: plural "experiments" in URL).

### /experiment/rest/{experimentId}

Retrieves a single experiment (note: singular "experiment" in URL).

### /studies/rest

Retrieves all studies (note: plural "studies" in URL).

### /study/rest/{studyId}

Retrieves a single study (note: singular "study" in URL).

### /d3graph/project

Retrieves all projects and names of their associated samples, libraries and runs.

### /d3graph/project/{projectId}

Retrieves a single project and the names of its associated samples, libraries and runs.

### /plate/rest/{plateId}

Retrieves a single plate.
