# COMPAS XR

[![Github Actions Build Status](https://github.com/gramaziokohler/compas_xr/workflows/build/badge.svg)](https://github.com/gramaziokohler/compas_xr/actions)
[![License](https://img.shields.io/github/license/gramaziokohler/compas_xr.svg)](https://pypi.python.org/pypi/compas_xr)
[![pip downloads](https://img.shields.io/pypi/dm/compas_xr)](https://pypi.python.org/project/compas_xr)
[![PyPI Package latest release](https://img.shields.io/pypi/v/compas_xr.svg)](https://pypi.python.org/pypi/compas_xr)
[![Supported implementations](https://img.shields.io/pypi/implementation/compas_xr.svg)](https://pypi.python.org/pypi/compas_xr)
[![DOI](https://zenodo.org/badge/247674503.svg)](https://zenodo.org/doi/10.5281/zenodo.12514526)
[![Twitter Follow](https://img.shields.io/twitter/follow/compas_dev?style=social)](https://twitter.com/compas_dev)

![COMPAS XR](https://raw.githubusercontent.com/gramaziokohler/compas_xr/main/docs/_images/compas_xr_lead_image.png)

`COMPAS XR` streamlines extended reality workflows to ease the implementation of human-machine collaborative applications in architectural research and educational environments.

## Installation

> It is recomended you install `compas_xr` inside a virtual environment.

```bash
pip install compas_xr
```

To install `compas_xr` to Rhino run

```bash
python -m compas_rhino.install
```

## First Steps

* [Documentation](https://gramaziokohler.github.io/compas_xr/)
* [User guide](https://gramaziokohler.github.io/compas_xr/latest/userguide.html)
* [API Reference](https://gramaziokohler.github.io/compas_xr/latest/api.html)

## Questions and feedback

We encourage the use of the [COMPAS framework forum](https://forum.compas-framework.org/)
for questions and discussions.

## Issue tracker

If you found an issue or have a suggestion for a dandy new feature, please file a new issue in our [issue tracker](https://github.com/gramaziokohler/compas_xr/issues).

## Contributing

We love contributions!

Check the [Contributor's Guide](https://github.com/gramaziokohler/compas_xr/blob/main/CONTRIBUTING.md)
for more details.

## Credits

`compas_xr` is currently developed by ETH Zurich (Gramazio Kohler Research) and Princeton University. See the [list of authors](https://github.com/gramaziokohler/compas_xr/blob/main/AUTHORS.md) for a complete overview.
