import sys
import csv


def seconds_to_mmss(the_seconds):
    minutes = int(the_seconds // 60.0)
    seconds = int(the_seconds % 60.0)
    return f"{minutes:02d}:{seconds:02d}"

def calculate_mean_people_count(input_file, frame_window, square0, square1):
    window_counts = {}  # Dictionary to store the count of people detected in each frame
    mean_counts = {}
    frame_counts ={}
    current_frame_start = -1
    is_first_frame = True
    last_frame = -1

    count_by_frame = {}

    x_min0, x_max0, y_min0, y_max0 = square0
    x_min1, x_max1, y_min1,  y_max1 = square1

    with open(input_file, 'r') as file:
        reader = csv.DictReader(file)
        for row in reader:
            frame_number = int(row['frame_number'])
            track_id = int(row['track_id'])
            camera_id = int(row['camera_id'])
            bb_left = float(row['bb_left'])
            bb_top = float(row['bb_top'])

            ts = float(frame_number) * 1/12.5

            formatted_time = seconds_to_mmss(ts)

            if ((camera_id == 0 and x_min0 < bb_left < x_max0 and y_min0 < bb_top < y_max0)) or \
               ((camera_id == 1 and x_min1 < bb_left < x_max1 and y_min1 < bb_top < y_max1)):
                #print(f'OVERLAP ts={ts},{formatted_time} camera_id:{camera_id} bb_left:{bb_left} bb_top:{bb_top}')
                pass
            else:
                if (frame_number!=last_frame):
                    count_by_frame[frame_number] = 1
                else:
                    count_by_frame[frame_number] +=1

                last_frame = frame_number

    last_frame = -1

    for frame_id in count_by_frame.keys():
         #print(f'frame_id= {frame_id} last_frame={last_frame}')

        if (frame_id>last_frame):
            current_frame_start = frame_id
            last_frame = current_frame_start + frame_window

        

        # Update the count of people in the current frame
        if current_frame_start in frame_counts.keys():
            a,b,c = frame_counts[current_frame_start]
            frame_counts[current_frame_start] = (a + count_by_frame[frame_id],b +1,c)
        else:
            ts = float(current_frame_start) * 1/12.5
            formatted_time = seconds_to_mmss(ts)
            frame_counts[current_frame_start] = (count_by_frame[frame_id],1,formatted_time)



    for frame_key in frame_counts.keys():
        #print(f'frame_key= {frame_key}')
        count,num_frames,time = frame_counts[frame_key]
        mean_counts[frame_key]= ((count / num_frames), time)

    return mean_counts

if __name__ == "__main__":
    if len(sys.argv) != 5:
        print("Usage: python script.py input_file frame_window cam0_minx,cam0_maxx,cam0_miny,cam0_maxy cam1_minx,cam1_maxx,cam1_miny,cam1_maxy")
    else:
        input_file = sys.argv[1]
        frame_window = int(sys.argv[2])
        square0 = [float(coord) for coord in sys.argv[3].split(',')]
        square1 = [float(coord) for coord in sys.argv[4].split(',')]
        mean_counts = calculate_mean_people_count(input_file, frame_window, square0, square1)
        #print(f"Mean People Counts in Moving Windows of {frame_window} frames: {mean_counts}")

        for frame_id in mean_counts.keys():
            count, time = mean_counts[frame_id]
            print(f'{time}: {count}')