# README

This repository is related with the next paper. Please cite us if this code is useful to you.

Barral, V., Dominguez-Bolano, T., Escudero, C. J., & Garcia-Naya, J. A. An IoT System for Smart Building Combining Multiple mmWave FMCW Radars Applied to People Counting.

## Python Scripts

- *count_plot.py*: Generates a plot comparing image tracking estimation, radar with DBSCAN, and radar with OPTICS. Use example:

```
python count_plot.py count_video_full.log count_radar_moving_average_30_optics.log count_radar_moving_average_30_dbscan.log "Video" "Radar with OPTICS" "Radar with DBSCAN" average_count_full_optics_dbscan.pdf
```

## Radar measurements

- *test_0.bag*: FMCW mmWave radar measurements from three IWR6843 devices (ISK and AOP). Is a ROS (Robotic Operative System) log, can be played with ```rosbag play test_0.bag```

### Radar people counting logs

- **count_radar_moving_average_30_dbscan.log**: radar people counting estimation using a 30 seconds moving average and DBSCAN as clustering algorithm.

- **count_radar_moving_average_30_optics.log**: radar people counting estimation using a 30 seconds moving average and OPTICS as clustering algorithm.


## Image tracking

### Videos

- *test_0_cam_0.mp4*: Camera 0 capture.
- *test_0_cam_1.mp4*: Camera 1 capture.

### Image tracking logs

- *test_0_cam_0_interp.txt*: People count in camera 0
- *test_0_cam_1_interp.txt*: People count in camera 1

The files have the following format:

frame_number, track_id, bb_left, bb_top, bb_width, bb_height, conf, x, y, z
The coordinates x, y, z are always -1
The bb fields define the bounding box of the detection
If multiple people are detected in a frame, there are several lines with that frame_number, but with different track_ids.

### Image people counting logs

- **count_video_full.log**: image tracking people counting estimation using a 30 seconds moving average.
