#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
void * loram ( int siz ) { return malloc ( siz ) ; }
void loset ( void * x ) { ; }
char daconda [ 1024 ] , dacondb [ 1024 ] , refcond[ 1024 ] ;
char * condpt ; 
int verbose = 0 ; 

/*** Specific decls ******/
char ** locones ; 
int * wasat ; 
int nones , numels , maxposit , hiposit ;
int nfalses ;
unsigned long int numevals = 0 ;
char * conda , * condb ;
double mulprobNOT ( char * , char * ) ;
int max_covariation = 0 ; 

void report_to_user ( int ncuts , int * was , int nels , int istrue , int ismandatory , char * nitcond , char * cond , double prob ) {
  int c ;
  if ( verbose == 1 || ( verbose == 2 && !istrue && ismandatory ) ) {
      for ( c = 0 ; c <= ncuts ; ++ c ) {
              if ( c ) putc ( '-' , stdout ) ;
              printf ( "%i" , was [ c ] ) ; }
      while ( c ++ < nels ) printf ( "  " ) ; 
      printf ( "    %s    " , cond ) ;
      if ( !istrue ) { 
         if ( !ismandatory ) printf ("false         some zeros non-mandatory!" ) ;
         else { 
             printf ( "FALSE %.3f" , prob ) ;
             if ( !strcmp ( cond , nitcond ) ) printf ( "   the original!" ) ; }}
      printf ( "\n" ) ;
      fflush ( stdout ) ; }   
  return ; 
}
  
void format_checking( char * dacond ) {
    char * to ;
    int pars = 0 ; 
    to = dacond ;
    if ( * to != '(' ) {
        printf ( "ERROR: string must start and end with global parents\n" ) ;
        exit ( 0 ) ; }    
    while ( * to ) {
        if ( * to == '(' ) ++ pars ; 
        if ( * to == ')' ) {
            -- pars ;
            if ( !pars && * ( to + 1 ) ) {
                printf ( "ERROR: string must start and end with global parents\n" ) ;
                exit ( 0 ) ; }}
        ++ to ; }
    if ( pars ) {
        printf ( "ERROR: unbalanced parents\n" ) ;
        exit ( 0 ) ; }    
}

int condnu ( void ) {
    int i , back ;
    char * was = condpt ;
    while ( isdigit ( * was ) ) ++ was ;
    i = * was ;
    * was = '\0' ;
    back = atoi ( condpt ) ;
    * ( condpt = was ) = i ;
    return back ; 
}    

int valuator ( void ) {
    int parlevel = 0 , gotaval ;
    int had = 0 , val = 0 ;
    int isor = 1 ;
    while ( 1 ) {
        if ( isspace ( * condpt ) ) { ++ condpt ; continue ; } // this is used only when testing evaluator (expression should have no spaces)
        gotaval = 0 ;
        if ( * condpt == '(' ) 
            if ( !parlevel ) {
              parlevel ++ ;
              ++ condpt ; }
            else {
                val = valuator () ;
                gotaval = 1 ; }
        if ( isdigit ( * condpt ) ) {
            val = condnu () ;
            gotaval = 1 ; }
        if ( gotaval ) 
           if ( isor ) 
               if ( val || had ) had = 1 ;
               else had = 0 ; 
           else
               if ( val && had ) had = 1 ;
               else had = 0 ; 
        if ( * condpt == '&' || * condpt == '|' ) 
            isor = ( '|' == * condpt ++ ) ;
        if ( * condpt == ')' ) { ++ condpt ; return had ; }}
}                

void main ( int argc , char ** argv ) {
    double probis ;
    char * to , * frm ;
    int i ; 
    if ( argc < 3 ) {
        printf ( "\nWhat is the probability of making an initially TRUE\n"
                 "expression FALSE by changing 1s into 0s, by considering\n"
                 "all alternative ways to make the expression FALSE\n"
                 "by non-superfluous changes of 1s into 0s?\n" ) ;
        printf ( "\nGive two strings of 0/1 conditions!\n\n"
                 "Example: \n"
                 "    \"( ( 1|0|0 ) & 1 )\" \"( ( 1|0|0 ) & 0 )\" \n\n" ) ;
        printf ( "                --> P = 0.5 \n\n" ) ; 
        printf ( "\nFirst expression must evaluate as TRUE, second as FALSE.\n" ) ;  
        printf ( "\n\nUse \"-v\" or \"-V\" to display combinations (first one\n"
                 "does all combinations, second does only passing combinations)\n\n" ) ;
        exit ( 0 ) ; }
    // Remove blanks from string 
    to = daconda ; frm = argv[ 1 ] ;
    while ( * frm ) {
        if ( isspace ( * frm ) ) { ++ frm ; continue ; }
        * to ++ = * frm ++ ; }
    * to = '\0' ;
    to = dacondb ; frm = argv[ 2 ] ;
    while ( * frm ) {
        if ( isspace ( * frm ) ) { ++ frm ; continue ; }
        * to ++ = * frm ++ ; }
    * to = '\0' ;
    if ( argc > 3 ) 
        for ( i = 2 ; i < argc ; ++ i ) {
           if ( !strcmp ( argv[ i ] , "-v" ) ) verbose = 1 ;
           if ( !strcmp ( argv[ i ] , "-V" ) ) verbose = 2 ;
           if ( argv[ i ][ 0 ] == '-' && argv[ i ][ 1 ] == 'm' ) {
               to = argv[ i ] + 2 ;
               max_covariation = atoi ( to ) ;
               if ( max_covariation < 2 ) {
                   printf ( "ERROR: maximum covariation must be 2 or more\n" ) ;
                   exit ( 0 ) ; }
               max_covariation -- ; }}
    format_checking( daconda ) ; // this won't be needed in TNT  
    format_checking( dacondb ) ; // this won't be needed in TNT  
    locones = loram ( ( strlen ( daconda ) + 1 ) * sizeof ( char * ) ) ;
    wasat = loram ( ( strlen ( daconda ) + 1 ) * sizeof ( int ) ) ;
    system ( "cls" ) ;
    probis = mulprobNOT ( daconda , dacondb ) ;
    if ( max_covariation ) printf ( "\nMax. covariation: %i\n" , max_covariation ) ; 
    printf ( "\n\nPROB %.4f (%i passing cases, %u total evaluations)\n" , probis , nfalses , numevals ) ; 
    return ;   
}

int noextrazeros( char * condis , char * condwas ) {
    char * cp = condis ;
    int zul ;
    while ( * cp ++ ) {
        ++ condwas ; 
        if ( * cp == '0' && * condwas == '1' ) {
            condpt = condis ;
            * cp = '1' ;
            zul = valuator () ;
            * cp = '0' ;
            if ( !zul ) return 0 ; }}
    return 1 ;     
}

double mulprobNOT ( char * conda , char * condb ) {
    int a ;
    double prob , sumprob = 0 , nitprob = 0 ;
    char * cpa , * cpb , * nitcond ;
    int ismandatory , istrue , nchgs = 0 ; 

    nitcond = refcond ; strcpy ( nitcond , condb ) ; 
    printf ( "\n\nGOT\n    " , conda ) ;
    cpa = conda ;
    while ( * cpa ) printf ( "%c " , * cpa ++ ) ;
    printf ( "\n    " ) ; 
    cpa = conda ;
    cpb = condb ;
    while ( * cpa ) {
        if ( * cpa ++ != * cpb ++ ) putc ( '*' , stdout ) ;
        else putc ( ' ' , stdout ) ;
        putc ( ' ' , stdout ) ; }
    printf ( "\n    " ) ; 
    cpb = condb ;
    while ( * cpb ) printf ( "%c " , * cpb ++ ) ;
    printf ( "\n" ) ;
    if ( verbose ) printf ( "\n" ) ; 
    condpt = conda ; 
    if ( !valuator() ) {
        printf ( "\nInitial condition is already FALSE\n" ) ; 
        return -1 ; }
    condpt = condb ; 
    if ( valuator() ) {
        printf ( "\nFinal condition is TRUE\n" ) ; 
        return -1 ; }
    cpa = conda ;
    condpt = cpb = condb ; 
    while ( * cpa ) {
       if ( * cpa != * cpb ) {
           if ( !isdigit ( * cpa ) || !isdigit ( * cpb ) ) {
               printf ( "\nExpressions must consist of parallel AND's and OR's:\n\n" ) ;
               printf ( "     %s\n     %s\n     " , conda , condb ) ;
               for ( a = 0 ; a < cpa - conda ; ++ a ) putc ( ' ' , stdout ) ; putc ( '^' , stdout ) ;
               return 0 ; }
           nchgs ++ ; 
           if ( max_covariation && ( nchgs > max_covariation ) ) {
               printf ( "\nToo many changes in second condition\n\n" ) ; 
               return 0 ; }
           if ( * cpa < * cpb ) {  
               printf ( "\nHave changes 0->1 in second condition:\n\n" ) ;
               printf ( "     %s\n     %s\n     " , conda , condb ) ;
               for ( a = 0 ; a < cpa - conda ; ++ a ) putc ( ' ' , stdout ) ; putc ( '^' , stdout ) ; 
               return 0 ; }
           * cpb = '1' ;
           condpt = condb ; 
           istrue = valuator () ;
           * cpb = '0' ; 
           if ( !istrue ) {
               printf ( "\nHave superfluous changes 1->0 in second condition:\n\n" ) ;
               printf ( "     %s\n     %s\n     " , conda , condb ) ;
               for ( a = 0 ; a < cpa - conda ; ++ a ) putc ( ' ' , stdout ) ; putc ( '^' , stdout ) ; 
               return 0 ; }}
       if ( * cpa == '1' ) locones[ nones ++ ] = cpa ; 
       ++ cpa ; ++ cpb ; }

    // TEST MAKING ONE's INTO ZEROS's BY TRYING COMBINATIONS 
    numels = maxposit = nones ;
    hiposit = nfalses = 0 ;
    strcpy ( nitcond , conda ) ; 
    for ( a = 0 ; a < numels ; ++ a ) {
          * locones[ wasat [ hiposit ] = a ] = '0' ; 
          condpt = conda ;
          ++ numevals ;
          if ( max_covariation && hiposit + 1 > max_covariation ) istrue = 1 ;
          else istrue  = valuator () ;
          ismandatory = 0 ; 
          if ( !istrue ) 
             if ( noextrazeros ( conda , nitcond ) ) {
                ismandatory = 1 ; 
                ++ nfalses ;
                prob = 1 / ( double ) ( hiposit + 1 ) ;
                sumprob += prob ;
                if ( !strcmp ( conda , condb ) ) nitprob = prob ; }
          report_to_user ( hiposit , wasat , numels , istrue , ismandatory , condb , conda , prob ) ; 
          if ( !hiposit || a < numels - 1 ) ++ hiposit ; 
          else {
            * locones[ wasat [ hiposit ] ] = '1' ; 
            * locones[ a = wasat [ -- hiposit ] ] = '1' ; }
         }
   if ( !sumprob ) return 0 ;       
   prob = nitprob / sumprob ; 
   return prob ;
}



