#!/bin/bash
# This pipeline performs the analysis for relaxation of selection using the HyPhy (Hypothesis Testing using Phylogenies) software package.
# The following package needs to be installed and in your PATH.
# hyphy (http://hyphy.org/)
# Can be installed through conda using the command "conda install -c hyphy"


########################################################################
## RELAX analysis for relaxation of selection using the HyPhy package ##
########################################################################

# IMPORTANT: Labeling of the phylogenetic tree was performed with the phylotree.js web tool (https://phylotree.hyphy.org//)

# run RELAX in group mode
mkdir RELAX_results_group

# labeled phylogeny for group mode analysis
PHY="(((((((((((ArsPerl{nv}:0.00000221239999997902,ArsUK{nv}:0.00000221239999997902){nv}:0.00000221239999997902,(ArsLausane{nv}:0.000020398400000010142,ArsFIN{nv}:0.000020398400000010142){nv}:0.00000221239999997902){nv}:0.00000221239999997902,ArsenophonusDSM15247{nv}:0.000020398400000010142){nv}:0.0009520552999999765,((EB1{nv}:0.00003945259999998951,EA{nv}:0.00003933540000000679){nv}:0.0017576830000000099,(ONit{nv}:0.00030295720000000914,ArsPV{nv}:0.00006963890000000195){nv}:0.000667744299999995){nv}:0.000039321199999997614){nv}:0.0005609930000000096,ArsIxoH{nv}:0.0009358957000000223){nv}:0.00022049309999999656,((((ERR7800036{nv}:0,ERR7800037{nv}:0){nv}:0.00000221239999997902,ERR7799985{nv}:0.00000221239999997902){nv}:0.00000221239999997902,SRR2001675{nv}:0.000020398400000010142){nv}:0.0007256065999999839,((SRR13788625{nv}:0,SRR13788620{nv}:0){nv}:0.00000221239999997902,SRR13788609{nv}:0.00000221239999997902){nv}:0.0006474336999999775){nv}:0.0008084579000000036){nv}:0.013254282200000023,ArsPB:0.006515087699999977):0.006687806500000004,((((((SRR6301423{api}:0.00000221239999997902,SRR2001708{api}:0.00000221239999997902){api}:0.00007864089999998214,ArsBeeUS{api}:0.000020398400000010142){api}:0.0001574630999999771,ArsBee02222015{api}:0.00011778340000001553){api}:0.0014135727999999848,(SRR10590585{api}:0.00000221239999997902,SRR10590592{api}:0.000020398400000010142){api}:0.0009036189000000139){api}:0.0002776962000000105,SRR12528003{api}:0.00042916669999998325){api}:0.00581303620000001,aApi_AU{api}:0.004690375999999996){api}:0.011854958000000027):0.014439693899999995,((((((ArsAsiaII3{ve}:0.006293170399999992,ArsBTMEDQ21{ve}:0.010822736900000018){ve}:0.00418513650000002,EB2{ve}:0.0043568022000000095){ve}:0.0005680905000000069,(ArsenophonusHangzhou{ve}:0.002181625399999998,ArsAcraccivora{ve}:0.006340649699999978){ve}:0.0012147995999999828){ve}:0.0015665977000000053,ArsenophonusENCA{ve}:0.005753013099999982){ve}:0.0020624233000000047,ArsenophonusARAF{ve}:0.012435955300000023){ve}:0.002068706400000009,ARTi{ve}:0.007662145000000009){ve}:0.020322610899999982):0.024091996100000013,SRR5317834:0.027672946199999993):0.12976075955,((Proteus_mirabilis{out}:0.09284769190000003,Morganella_morganii{out}:0.10185245760000003){out}:0.04552430219999998,(Moellerella_wisconsensis{out}:0.06447219520000003,Providencia_stuartii{out}:0.06279846150000001){out}:0.04224457549999999){out}:0.12976075955);"

cd core_pal2nal_busco
find . -name "*.pal2nal" | parallel --gnu -q -j 40 -I% --max-args 1 hyphy relax --alignment % --tree ${PHY} --code Universal --mode "Group mode" --reference-group "out" --srv Yes --starting-points 5 --output ../RELAX_results_group/%.group.json --models Minimal
cd ..

# run posthoc analysis on individual comparisons
# 1. nasoniae clade vs outgroup
# 2. apivola clade vs outgroup
# 3. vertical clade vs outgroup

mkdir -p RELAX_results_posthoc/{nv-out,api-out,ve-out}

# labeled phylogenies for 1by1 comparisons
PHY1="(((((((((((ArsPerl{nv}:0.00000221239999997902,ArsUK{nv}:0.00000221239999997902){nv}:0.00000221239999997902,(ArsLausane{nv}:0.000020398400000010142,ArsFIN{nv}:0.000020398400000010142){nv}:0.00000221239999997902){nv}:0.00000221239999997902,ArsenophonusDSM15247{nv}:0.000020398400000010142){nv}:0.0009520552999999765,((EB1{nv}:0.00003945259999998951,EA{nv}:0.00003933540000000679){nv}:0.0017576830000000099,(ONit{nv}:0.00030295720000000914,ArsPV{nv}:0.00006963890000000195){nv}:0.000667744299999995){nv}:0.000039321199999997614){nv}:0.0005609930000000096,ArsIxoH{nv}:0.0009358957000000223){nv}:0.00022049309999999656,((((ERR7800036{nv}:0,ERR7800037{nv}:0){nv}:0.00000221239999997902,ERR7799985{nv}:0.00000221239999997902){nv}:0.00000221239999997902,SRR2001675{nv}:0.000020398400000010142){nv}:0.0007256065999999839,((SRR13788625{nv}:0,SRR13788620{nv}:0){nv}:0.00000221239999997902,SRR13788609{nv}:0.00000221239999997902){nv}:0.0006474336999999775){nv}:0.0008084579000000036){nv}:0.013254282200000023,ArsPB:0.006515087699999977):0.006687806500000004,((((((SRR6301423:0.00000221239999997902,SRR2001708:0.00000221239999997902):0.00007864089999998214,ArsBeeUS:0.000020398400000010142):0.0001574630999999771,ArsBee02222015:0.00011778340000001553):0.0014135727999999848,(SRR10590585:0.00000221239999997902,SRR10590592:0.000020398400000010142):0.0009036189000000139):0.0002776962000000105,SRR12528003:0.00042916669999998325):0.00581303620000001,aApi_AU:0.004690375999999996):0.011854958000000027):0.014439693899999995,((((((ArsAsiaII3:0.006293170399999992,ArsBTMEDQ21:0.010822736900000018):0.00418513650000002,EB2:0.0043568022000000095):0.0005680905000000069,(ArsenophonusHangzhou:0.002181625399999998,ArsAcraccivora:0.006340649699999978):0.0012147995999999828):0.0015665977000000053,ArsenophonusENCA:0.005753013099999982):0.0020624233000000047,ArsenophonusARAF:0.012435955300000023):0.002068706400000009,ARTi:0.007662145000000009):0.020322610899999982):0.024091996100000013,SRR5317834:0.027672946199999993):0.12976075955,((Proteus_mirabilis{out}:0.09284769190000003,Morganella_morganii{out}:0.10185245760000003){out}:0.04552430219999998,(Moellerella_wisconsensis{out}:0.06447219520000003,Providencia_stuartii{out}:0.06279846150000001){out}:0.04224457549999999){out}:0.12976075955);"
PHY2="(((((((((((ArsPerl:0.00000221239999997902,ArsUK:0.00000221239999997902):0.00000221239999997902,(ArsLausane:0.000020398400000010142,ArsFIN:0.000020398400000010142):0.00000221239999997902):0.00000221239999997902,ArsenophonusDSM15247:0.000020398400000010142):0.0009520552999999765,((EB1:0.00003945259999998951,EA:0.00003933540000000679):0.0017576830000000099,(ONit:0.00030295720000000914,ArsPV:0.00006963890000000195):0.000667744299999995):0.000039321199999997614):0.0005609930000000096,ArsIxoH:0.0009358957000000223):0.00022049309999999656,((((ERR7800036:0,ERR7800037:0):0.00000221239999997902,ERR7799985:0.00000221239999997902):0.00000221239999997902,SRR2001675:0.000020398400000010142):0.0007256065999999839,((SRR13788625:0,SRR13788620:0):0.00000221239999997902,SRR13788609:0.00000221239999997902):0.0006474336999999775):0.0008084579000000036):0.013254282200000023,ArsPB:0.006515087699999977):0.006687806500000004,((((((SRR6301423{api}:0.00000221239999997902,SRR2001708{api}:0.00000221239999997902){api}:0.00007864089999998214,ArsBeeUS{api}:0.000020398400000010142){api}:0.0001574630999999771,ArsBee02222015{api}:0.00011778340000001553){api}:0.0014135727999999848,(SRR10590585{api}:0.00000221239999997902,SRR10590592{api}:0.000020398400000010142){api}:0.0009036189000000139){api}:0.0002776962000000105,SRR12528003{api}:0.00042916669999998325){api}:0.00581303620000001,aApi_AU{api}:0.004690375999999996){api}:0.011854958000000027):0.014439693899999995,((((((ArsAsiaII3:0.006293170399999992,ArsBTMEDQ21:0.010822736900000018):0.00418513650000002,EB2:0.0043568022000000095):0.0005680905000000069,(ArsenophonusHangzhou:0.002181625399999998,ArsAcraccivora:0.006340649699999978):0.0012147995999999828):0.0015665977000000053,ArsenophonusENCA:0.005753013099999982):0.0020624233000000047,ArsenophonusARAF:0.012435955300000023):0.002068706400000009,ARTi:0.007662145000000009):0.020322610899999982):0.024091996100000013,SRR5317834:0.027672946199999993):0.12976075955,((Proteus_mirabilis{out}:0.09284769190000003,Morganella_morganii{out}:0.10185245760000003){out}:0.04552430219999998,(Moellerella_wisconsensis{out}:0.06447219520000003,Providencia_stuartii{out}:0.06279846150000001){out}:0.04224457549999999){out}:0.12976075955);"
PHY3="(((((((((((ArsPerl:0.00000221239999997902,ArsUK:0.00000221239999997902):0.00000221239999997902,(ArsLausane:0.000020398400000010142,ArsFIN:0.000020398400000010142):0.00000221239999997902):0.00000221239999997902,ArsenophonusDSM15247:0.000020398400000010142):0.0009520552999999765,((EB1:0.00003945259999998951,EA:0.00003933540000000679):0.0017576830000000099,(ONit:0.00030295720000000914,ArsPV:0.00006963890000000195):0.000667744299999995):0.000039321199999997614):0.0005609930000000096,ArsIxoH:0.0009358957000000223):0.00022049309999999656,((((ERR7800036:0,ERR7800037:0):0.00000221239999997902,ERR7799985:0.00000221239999997902):0.00000221239999997902,SRR2001675:0.000020398400000010142):0.0007256065999999839,((SRR13788625:0,SRR13788620:0):0.00000221239999997902,SRR13788609:0.00000221239999997902):0.0006474336999999775):0.0008084579000000036):0.013254282200000023,ArsPB:0.006515087699999977):0.006687806500000004,((((((SRR6301423:0.00000221239999997902,SRR2001708:0.00000221239999997902):0.00007864089999998214,ArsBeeUS:0.000020398400000010142):0.0001574630999999771,ArsBee02222015:0.00011778340000001553):0.0014135727999999848,(SRR10590585:0.00000221239999997902,SRR10590592:0.000020398400000010142):0.0009036189000000139):0.0002776962000000105,SRR12528003:0.00042916669999998325):0.00581303620000001,aApi_AU:0.004690375999999996):0.011854958000000027):0.014439693899999995,((((((ArsAsiaII3{ve}:0.006293170399999992,ArsBTMEDQ21{ve}:0.010822736900000018){ve}:0.00418513650000002,EB2{ve}:0.0043568022000000095){ve}:0.0005680905000000069,(ArsenophonusHangzhou{ve}:0.002181625399999998,ArsAcraccivora{ve}:0.006340649699999978){ve}:0.0012147995999999828){ve}:0.0015665977000000053,ArsenophonusENCA{ve}:0.005753013099999982){ve}:0.0020624233000000047,ArsenophonusARAF{ve}:0.012435955300000023){ve}:0.002068706400000009,ARTi{ve}:0.007662145000000009){ve}:0.020322610899999982):0.024091996100000013,SRR5317834:0.027672946199999993):0.12976075955,((Proteus_mirabilis{out}:0.09284769190000003,Morganella_morganii{out}:0.10185245760000003){out}:0.04552430219999998,(Moellerella_wisconsensis{out}:0.06447219520000003,Providencia_stuartii{out}:0.06279846150000001){out}:0.04224457549999999){out}:0.12976075955);"

cd core_pal2nal_busco
find . -name "*.pan2nal" | parallel --gnu -q -j 20 -I% --max-args 1 hyphy relax --alignment % --tree ${PHY1} --code Universal --test "nv" --reference "out" --srv Yes --starting-points 5 --output RELAX_results_posthoc/nv-out/%.nv-out.json --models Minimal &
find . -name "*.pan2nal" | parallel --gnu -q -j 20 -I% --max-args 1 hyphy relax --alignment % --tree ${PHY2} --code Universal --test "api" --reference "out" --srv Yes --starting-points 5 --output RELAX_results_posthoc/api-out/%.api-out.json --models Minimal &
find . -name "*.pan2nal" | parallel --gnu -q -j 20 -I% --max-args 1 hyphy relax --alignment % --tree ${PHY3} --code Universal --test "ve" --reference "out" --srv Yes --starting-points 5 --output RELAX_results_posthoc/ve-out/%.ve-out.json --models Minimal
cd ..
