% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utteranceStatistics.R
\name{utteranceStatistics}
\alias{utteranceStatistics}
\title{Utterance Statistics}
\usage{
utteranceStatistics(t, numberOfFigures = 10, normalizeByDramaLength = TRUE)
}
\arguments{
\item{t}{The dramatic text(s)}

\item{numberOfFigures}{The maximal number of figures per drama to include. Default: 10. Set to FALSE to include all figures.}

\item{normalizeByDramaLength}{Logical value. If true, the resulting values will be normalized by the length of the drama.}
}
\description{
This method calculates the length of each utterance, organised by figure and drama.
}
\examples{
data(rksp.0)
ustat <- utteranceStatistics(rksp.0$mtext, numberOfFigures = 5)
\dontrun{
boxplot(ustat$utteranceLength ~ ustat$figure,
   col=qd.colors[1:5],
   las=2, frame=FALSE)
}
}
