% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaryStatistics.R
\name{regroup}
\alias{regroup}
\title{regroup}
\usage{
regroup(dstat, by = c("Character", "Field"))
}
\arguments{
\item{dstat}{A list generated by `dictionaryStatistics()`, 
using the `asList` parameter}

\item{by}{A character vector, either "Character" or "Field".
Depending on this parameter, we get a list organized by character 
or a list organized by field. If it's organised by character, it allows
comparison of fields for a single character. If organised by field, 
we can compare different characters for a single field.}
}
\description{
This function isolates the dictionary statistics for
each character. The return value is a list containing lists similar
to the output of `dictionaryStatistics()`, but only containing 
the table for one character.
}
\examples{
data(rksp.0)
field <- list(Liebe=c("liebe","lieben","herz"))
dsl <- dictionaryStatistics(rksp.0$mtext, 
   fields=field,
   normalizeByFigure=TRUE,
   asList=TRUE,
   segment="Scene")
dslr <- regroup(dsl, by="Field")
\dontrun{
matplot(apply(dslr$Liebe, 1, cumsum),type="l", main="Liebe", col=rainbow(14))
legend(x="topleft", legend=rownames(dslr$Liebe),lty=1:5,col=rainbow(14), cex = 0.4)
}
}
