% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personnelExchange.R
\name{personnelExchange}
\alias{personnelExchange}
\alias{hamming}
\alias{scenicDifference}
\title{Measuring Personnel Exchange over Boundaries}
\usage{
hamming(mtext, variant = c("Trilcke", "Hamming", "NormalizedHamming"))

scenicDifference(mtext, norm = length(unique(mtext$Speaker.figure_surface)))
}
\arguments{
\item{mtext}{The segmented drama text}

\item{variant}{For hamming(), variants are "Trilcke" (default), "NormalizedHamming", and "Hamming"}

\item{norm}{For scenicDifference(), specifies the normalization constant}
}
\description{
There are multiple ways to quantify the number of characters that are 
exchanged over a scene or act boundary.
}
\examples{
data(rksp.0)
dist_trilcke  <- hamming(rksp.0$mtext)
dist_hamming  <- hamming(rksp.0$mtext, variant = "Hamming")
dist_nhamming <- hamming(rksp.0$mtext, variant = "NormalizedHamming")
}
