% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencytable.R
\name{frequencytable}
\alias{frequencytable}
\title{Word frequencies}
\usage{
frequencytable(t, acceptedPOS = postags$de$words, names = FALSE,
  column = "Token.surface", byFigure = FALSE, sep = "|",
  normalize = FALSE, sortResult = FALSE, by = c("Drama", "Act", "Scene"))
}
\arguments{
\item{t}{The text table, potentially covering multiple texts}

\item{acceptedPOS}{A list of accepted pos tags}

\item{names}{Whether to use figure names or ids}

\item{column}{The column name we should use (should be either Token.surface or Token.lemma)}

\item{byFigure}{Wether the count is by figure or by text}

\item{sep}{The separation character that goes between drama name and figure (if applicable)}

\item{normalize}{Whether to normalize values or not}

\item{sortResult}{Logical. If true, the columns with the highest sum are ordered left (i.e., frequent words are visible first)}

\item{by}{Whether the count is by drama (default), act or scene}
}
\description{
This function generates a matrix of word frequencies 
by drama, act or scene and/or by figure.
}
\examples{
data(rksp.0)
st <- frequencytable(rksp.0$mtext)
\dontrun{
require(stylo)
data(vndf.0.text)
tl <- limitFigures(vndf.0.text, by="tokens", threshold=1000)
stylo_table <- frequencytable(tl, names=TRUE, byFigure=TRUE)
stylo(gui=F, frequencies = stylo_table)
}
}
