% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures.R
\name{figurematrix}
\alias{figurematrix}
\title{Stacked matrix}
\usage{
figurematrix(fstat, column = "tokens", order = -1)
}
\arguments{
\item{fstat}{The figure statistics table, i.e., the output of figureStatistics(). Coerced to a data.table if needed.}

\item{column}{A column name found in the statistics table. This count is used 
as a basis for the plot.}

\item{order}{If set to -1 (default), figures are ranked descending 
(i.e., figure with most spoken words first). If set to 1, 
figures are ranked ascending.}
}
\description{
This function takes a data frame describing various metrics of figures in dramas 
and creates a matrix that can be used to create a stacked bar plot.
}
\examples{
data(rksp.0,rjmw.0)
text <- rbind(rksp.0$mtext,rjmw.0$mtext)
stat <- figureStatistics(text, names = TRUE)
mat <- figurematrix(stat)
# Plot a stacked bar plot
b <- barplot(mat$values,col=qd.colors)
# Add figure names (if needed/wanted)
text(x=b,y=t(mat$cs+(mat$values/2)),labels=t(substr(mat$labels,0,20)))
}
