% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures.R
\name{figureStatistics}
\alias{figureStatistics}
\title{Basic Character Statistics}
\usage{
figureStatistics(t, names = FALSE, normalize = FALSE, segment = c("Drama",
  "Act", "Scene"))
}
\arguments{
\item{t}{A data.table containing the text. Will be coerced into a data.table,
if necessary.}

\item{names}{If set to true, the table will contains figure names instead of ids}

\item{normalize}{Normalising the individual columns}

\item{segment}{"Drama", "Act", or "Scene". Allows calculating statistics on segments of the play}
}
\value{
A data frame with the following columns and one row for each figure:
tokens: The number of tokens spoken by that figure
types : The number of different tokens (= types) spoken by each figure
utterances: The number of utterances
utteranceLengthMean: The mean length of utterances
utteranceLengthSd: The standard deviation in utterance length
}
\description{
This function extracts figure statistics from a drama text table.
}
\examples{
data(rksp.0)
stat <- figureStatistics(rksp.0$mtext, names = FALSE)
}
