% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{dramaHead}
\alias{dramaHead}
\title{Extract section}
\usage{
dramaHead(input, by = c("Act", "Scene"), op = "==", n = 1)
}
\arguments{
\item{input}{Segmented text (can be multiple texts)}

\item{by}{Act or Scene, or matching substring}

\item{op}{Whether to extract exactly one or more than one}

\item{n}{The number of segments to extract}
}
\description{
Extracts a sub segment of the text(s). 
The result is an empty table if more scenes or acts
are given than exist in the play. In this case, a
warning is printed.
}
\examples{
data(rksp.0)
# Extract everything before the 4th scene
dramaHead(rksp.0$mtext, by="Scene", op="<", n=4)
}
