% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genre.R
\name{correlationAnalysis}
\alias{correlationAnalysis}
\title{Correlation analysis}
\usage{
correlationAnalysis(text.ft, outcomes, method = "spearman",
  minimalFrequency = 10)
}
\arguments{
\item{text.ft}{A matrix, containing words in columns and figures (or plays) in rows}

\item{outcomes}{A list of outcomes, will be cast as numeric}

\item{method}{The correlation method, passed on to cor()}

\item{minimalFrequency}{An integer. Words that appear less than x times can be filtered in advance}
}
\description{
Calculates correlation of a frequency table with an outcome list according to given method
}
\examples{
data(rksp.0)
rksp.0.ft <- frequencytable(rksp.0$mtext, byFigure=TRUE, names=TRUE)
g <- factor(c("m","m","m","m","f","m","m","m","f","m","m","f","m"))
rksp.0.cor <- correlationAnalysis(rksp.0.ft,g)
}
