# Content
*Python3* scripts for the numerical simulations of the perihelion motion of Mercury caused by General Relativity.

This folder contains three scripts:
1. `base_solution.py`: The basic simulation and visualization of Mercury orbiting the Sun.
   This program can be used to observe the effects of *1/r^3* and *1/r^4* forces, as well the effects of numerical errors.
2. `template.py`: A template file which can be handed to students.
   The general concepts of programming in python are provided.
   The students have to write the creation of *VPython* objects as well as the computation of forces.
3. `perihelion.py`: An extension of `base_solution.py`.
   In addition to the visualization, this file also provides the numerical extraction of the perihelion motion.
