# Content
*Jupyter Notebook* scripts for the numerical simulations of the perihelion motion of Mercury caused by General Relativity.

This folder contains three scripts:
1. `base_solution.ipynb`: The basic visualization of Mercury orbiting the Sun.
   This program can be used to observe the effects of *1/r^3* and *1/r^4* forces, as well the effects of numerical errors.
2. `template.ipynb`: A template file which can be handed to students.
   The general concepts of programming in python are provided.
   The students have to write the creation of *VPython* objects as well as the computation of forces.
3. `perihelion.ipynb`: An extension of `base_solution.ipynb`.
   In addition to the visualization, this file also provides the numerical extraction of the perihelion motion.


Individual *Jupyter Notebook* cells can be executed by pressing `shift+enter`.
