Bibliography
============

The code in this project is based on ideas from the following publications:

- **[Strathearn2017]** Strathearn et al., *Efficient real-time path integrals for non-Markovian spin-boson models*. [New J. Phys. 19(9), p.093009](https://doi.org/10.1088/1367-2630/aa8744) (2017).
- **[Strathearn2018]** Strathearn et al., *Efficient non-Markovian quantum dynamics using time-evolving matrix product operators*, [Nat. Commun. 9, 3322](https://doi.org/10.1038/s41467-018-05617-3)
  (2018).
- **[Pollock2018]** Pollock et al., *Non-Markovian quantum processes: Complete framework and efficient characterization*, [Phys. Rev. A 97, 012127](https://doi.org/10.1103/PhysRevA.97.012127) (2018).
- **[Jorgensen2019]** Jørgensen and Pollock, *Exploiting the causal tensor network structure of quantum processes to efficiently simulate non-Markovian path integrals*, [Phys. Rev. Lett. 123, 240602](https://doi.org/10.1103/PhysRevLett.123.240602) (2019).
- **[Strathearn2019]** Strathearn, *Modelling Non-Markovian Quantum Systems Using Tensor Networks*, [Springer Theses](https://doi.org/10.1007/978-3-030-54975-6) (2020).
- **[Fux2021]** Fux et al., *Efficient exploration of Hamiltonian parameter space for optimal control of non-Markovian open quantum systems*, [Phys. Rev. Lett. 126, 200401](https://doi.org/10.1103/PhysRevLett.126.200401) (2021).
- **[Gribben2022a]** Gribben et al., *Exact dynamics of non-additive environments in non-Markovian open quantum systems*, [PRX Quantum 3, 10321](https://doi.org/10.1103/PRXQuantum.3.010321) (2022).
- **[Gribben2022b]** Gribben et al., *Using the Environment to Understand non-Markovian Open Quantum Systems*,  [Quantum, 6, 847](https://doi.org/10.22331/q-2022-10-25-847) (2022).
- **[Chiu2022]** Chiu et al., *Numerical evaluation and robustness of the quantum mean-force Gibbs state*, [Phys. Rev. A 106, 012204](https://doi.org/10.1103/PhysRevA.106.012204}) (2022).
- **[FowlerWright2022]** Fowler-Wright et al., *Efficient Many-Body Non-Markovian Dynamics of Organic Polaritons*, [Phys. Rev. Lett. 129, 173001](https://doi.org/10.1103/PhysRevLett.129.173001) (2022).
- **[Fux2023]** Fux et al., *Tensor network simulation of chains of non-Markovian open quantum systems*, [Phys. Rev. Research 5, 033078 ](https://doi.org/10.1103/PhysRevResearch.5.033078}) (2023).
- **[Butler2024]** Butler et al., *Optimizing Performance of Quantum Operations with Non-Markovian Decoherence: The Tortoise or the Hare?*, [Phys. Rev. Lett. 132, 060401 ](https://doi.org/10.1103/PhysRevLett.132.060401}) (2024).


BibTeX:
-------

```
@article{Butler2024,
  title = {Optimizing Performance of Quantum Operations with Non-Markovian Decoherence: The Tortoise or the Hare?},
  author = {Butler, Eoin P. and Fux, Gerald E. and Ortega-Taberner, Carlos and Lovett, Brendon W. and Keeling, Jonathan and Eastham, Paul R.},
  journal = {Phys. Rev. Lett.},
  volume = {132},
  issue = {6},
  pages = {060401},
  numpages = {7},
  year = {2024},
  month = {Feb},
  publisher = {American Physical Society},
  doi = {10.1103/PhysRevLett.132.060401},
  url = {https://doi.org/10.1103/PhysRevLett.132.060401}
}

@article{Chiu2022,
  title = {Numerical evaluation and robustness of the quantum mean-force Gibbs state},
  author = {Chiu, Yiu-Fung and Strathearn, Aidan and Keeling, Jonathan},
  journal = {Phys. Rev. A},
  volume = {106},
  issue = {1},
  pages = {012204},
  numpages = {8},
  year = {2022},
  month = {Jul},
  publisher = {American Physical Society},
  doi = {10.1103/PhysRevA.106.012204},
  url = {https://doi.org/10.1103/PhysRevA.106.012204}
}

@article{FowlerWright2022,
  title = {Efficient Many-Body Non-Markovian Dynamics of Organic Polaritons},
  author = {Fowler-Wright, Piper and Lovett, Brendon W. and Keeling, Jonathan},
  journal = {Phys. Rev. Lett.},
  volume = {129},
  issue = {17},
  pages = {173001},
  numpages = {7},
  year = {2022},
  month = {October},
  publisher = {American Physical Society},
  doi = {10.1103/PhysRevLett.129.173001},
  url = {https://doi.org/10.1103/PhysRevLett.129.173001}
}

@article{Fux2021,
  title = {Efficient Exploration of Hamiltonian Parameter Space for Optimal Control of Non-Markovian Open Quantum Systems},
  author = {Fux, Gerald E. and Butler, Eoin P. and Eastham, Paul R. and Lovett, Brendon W. and Keeling, Jonathan},
  journal = {Phys. Rev. Lett.},
  volume = {126},
  issue = {20},
  pages = {200401},
  numpages = {6},
  year = {2021},
  month = {May},
  publisher = {American Physical Society},
  doi = {10.1103/PhysRevLett.126.200401},
  url = {https://doi.org/10.1103/PhysRevLett.126.200401}
}

@article{Fux2023,
  title = {Tensor network simulation of chains of non-Markovian open quantum systems},
  author = {Fux, Gerald E. and Kilda, Dainius and Lovett, Brendon W. and Keeling, Jonathan},
  journal = {Phys. Rev. Res.},
  volume = {5},
  issue = {3},
  pages = {033078},
  numpages = {14},
  year = {2023},
  month = {Aug},
  publisher = {American Physical Society},
  doi = {10.1103/PhysRevResearch.5.033078},
  url = {https://doi.org/10.1103/PhysRevResearch.5.033078}
}

@article{Gribben2022a,
  title = {Exact Dynamics of Nonadditive Environments in Non-Markovian Open Quantum Systems},
  author = {Gribben, Dominic and Rouse, Dominic M. and Iles-Smith, Jake and Strathearn, Aidan and Maguire, Henry and Kirton, Peter and Nazir, Ahsan and Gauger, Erik M. and Lovett, Brendon W.},
  journal = {PRX Quantum},
  volume = {3},
  issue = {1},
  pages = {010321},
  numpages = {18},
  year = {2022},
  month = {Feb},
  publisher = {American Physical Society},
  doi = {10.1103/PRXQuantum.3.010321},
  url = {https://doi.org/10.1103/PRXQuantum.3.010321}
}

@article{Gribben2022b,
  doi = {10.22331/q-2022-10-25-847},
  url = {https://doi.org/10.22331/q-2022-10-25-847},
  title = {Using the {E}nvironment to {U}nderstand non-{M}arkovian {O}pen {Q}uantum {S}ystems},
  author = {Gribben, Dominic and Strathearn, Aidan and Fux, Gerald E. and Kirton, Peter and Lovett, Brendon W.},
  journal = {{Quantum}},
  issn = {2521-327X},
  publisher = {{Verein zur F{\"{o}}rderung des Open Access Publizierens in den Quantenwissenschaften}},
  volume = {6},
  pages = {847},
  month = oct,
  year = {2022}
}

@article{Jorgensen2019,
  title = {Exploiting the Causal Tensor Network Structure of Quantum
           Processes to Efficiently Simulate Non-Markovian Path Integrals},
  author = {J\o{}rgensen, Mathias R. and Pollock, Felix A.},
  journal = {Phys. Rev. Lett.},
  volume = {123},
  issue = {24},
  pages = {240602},
  numpages = {7},
  year = {2019},
  month = {Dec},
  publisher = {American Physical Society},
  doi = {10.1103/PhysRevLett.123.240602},
  url = {https://doi.org/10.1103/PhysRevLett.123.240602}
}

@misc{OQuPy,
  author={{The TEMPO collaboration}},
  title={{OQuPy: A Python 3 package to efficiently compute
          non-Markovian open quantum systems.}},
  year=2020,
  publisher={GitHub},
  doi={10.5281/zenodo.4428316}
  url={https://github.com/tempoCollaboration/TimeEvolvingMPO}
}

@article{Pollock2018,
  author = {Pollock, Felix A. and Rodr{\'{i}}guez-Rosario, C{\'{e}}sar and
            Frauenheim, Thomas and Paternostro, Mauro and Modi, Kavan},
  doi = {10.1103/PhysRevA.97.012127},
  issn = {24699934},
  journal = {Phys. Rev. A},
  month = {jan},
  number = {1},
  pages = {012127},
  title = {{Non-Markovian quantum processes: Complete framework and
            efficient characterization}},
  url = {https://doi.org/10.1103/PhysRevA.97.012127},
  volume = {97},
  year = {2018}
}

@article{Strathearn_2017,
	doi = {10.1088/1367-2630/aa8744},
	url = {https://doi.org/10.1088/1367-2630/aa8744},
	year = 2017,
	month = {sep},
	publisher = {{IOP} Publishing},
	volume = {19},
	number = {9},
	pages = {093009},
	author = {A Strathearn and B W Lovett and P Kirton},
	title = {Efficient real-time path integrals for non-Markovian spin-boson models},
	journal = {New Journal of Physics},
}

@article{Strathearn2018,
  author = {Strathearn, A. and Kirton, P. and Kilda, D. and Keeling, J. and
            Lovett, B. W.},
  doi = {10.1038/s41467-018-05617-3},
  issn = {20411723},
  journal = {Nat. Commun.},
  month = {dec},
  number = {1},
  pages = {3322},
  pmid = {30127490},
  title = {{Efficient non-Markovian quantum dynamics using time-evolving
            matrix product operators}},
  url = {https://doi.org/10.1038/s41467-018-05617-3},
  volume = {9},
  year = {2018}
}

@book{Strathearn2019,
  address = {Cham},
  author = {Strathearn, Aidan},
  doi = {10.1007/978-3-030-54975-6},
  isbn = {978-3-030-54974-9},
  publisher = {Springer International Publishing},
  series = {Springer Theses},
  title = {{Modelling Non-Markovian Quantum Systems Using Tensor Networks}},
  url = {https://doi.org/10.1007/978-3-030-54975-6},
  year = {2020}
}

```
