# -*- tab-width: 4; indent-tabs-mode: nil  -*-

from common.configs import default_config, default_solver_config
from common.discretizer import discretize
from common.greedy import run_greedy
from common.testing_utility import get_parameter_sets

if __name__ == "__main__":
    config = default_config
    fom = discretize(config, default_solver_config)
    red_config = config['reduction']
    config['testcase'] = 'P2'

    red_config['nTrain_reaction'] = 35
    red_config['nTrain_inflow'] = 1
    for method, mu in zip(['L2', 'H1b', 'fixedMu', 'fixedMu'],
                          [None, None, 0.0, 1.0]):
        red_config['orthonormalization'] = method
        red_config['fixedMu'] = mu
        run_greedy(fom, red_config, config['testcase'],
                   weak_greedy=False)
