# -*- tab-width: 4; indent-tabs-mode: nil  -*-

import numpy as np

from common.configs import default_config, default_solver_config
from common.discretizer import discretize
from common.greedy import run_greedy

if __name__ == "__main__":
    config = default_config
    config['testcase'] = 'P2'

    red_config = config['reduction']
    red_config['nTrain_reaction'] = 35
    red_config['nTrain_inflow'] = 1

    nTest = red_config['nTest']
    nGridwidths = 4
    conditions = -np.ones((nGridwidths,nTest))
    gridwidths = np.logspace(4,4+nGridwidths, num=nGridwidths,
                             base=2, endpoint=False, dtype=int)
    for i,gp in enumerate(gridwidths):
        gridConfig = config['grid']
        gridConfig['yasp_x'] = int(gp)
        gridConfig['yasp_y'] = int(gp)
        config['grid'] = gridConfig
        fom = discretize(config, default_solver_config)

        cond = run_greedy(fom, red_config, config['testcase'],
                                   only_condition=True)
        conditions[i,:cond.shape[0]] = cond

    import csv
    suffix = f'_ntrain_{red_config["nTrain_reaction"]}'
    suffix += f'_{config["testcase"]}_{red_config["orthonormalization"]}'

    header = ['parameter_index']
    header += [f'condition_n_{n}' for n in gridwidths]
    with open('rb_condition_numbers' + suffix + '.csv', 'w', newline='') as csvfile:
        writer = csv.writer(csvfile)
        writer.writerow(header)
        for p in range(nTest):
            row = [p]
            row += [cp if cp>0 else None for cp in conditions[:,p]]
            writer.writerow(tuple(row))
