# Disturbance amplifies sensitivity of dryland productivity to precipitation variability

[https://doi.org/10.5061/dryad.tx95x6b49](https://doi.org/10.5061/dryad.tx95x6b49)

## Description of the data and file structure

This dataset includes remotely sensed data acquired through Google Earth Engine. All pipeline pixels were averaged to the climate pixel level, thus each row of data corresponds to multiple Landsat pixels (30m spatial resolution) either in the pipeline corridor (pipe) or in the adjacent undisturbed vegetation, that are then averaged to the climate pixel scale (1000m spatial resolution).
 

| Field    | Meaning                                                                                                                     |   |
| -------- | --------------------------------------------------------------------------------------------------------------------------- | - |
| WYCoords | Geographic coordinates of climate pixel                                                                                     |   |
| year     | Year of data value                                                                                                          |   |
| pipenpp  | Annual productivity of pipeline pixels within climate pixel                                                                 |   |
| compnpp  | Annual productivity of pixels along undisturbed reference line parallel to the pipeline corridor, averaged to climate pixel |   |
| WYprcp   | Total annual precipitation of water year (Oct-Sep)                                                                          |   |
| pipeherb | Percent cover of herbaceous plants in pipeline pixel                                                                        |   |
| compherb | Percent cover of herbaceous plants in undisturbed comparison pixel                                                          |   |
| compafgc | Percent cover of annual forbs and grasses in pipeline pixel                                                                 |   |
| pipeafgc | Percent cover of annual forbs and grasses in undisturbed comparison pixel                                                   |   |
| compshr  | Percent cover of shrubs in pipeline pixel                                                                                   |   |
| pipeshr  | Percent cover of shrubs in undisturbed comparison pixel                                                                     |   |
| comppfgc | Percent cover of perennial forbs and grasses in pipeline pixel                                                              |   |
| pipepfgc | Percent cover of perennial forbs and grasses in undisturbed comparison pixel                                                |   |
| YSD1     | 1 divided by the sqrt root of years since initial disturbance                                                               |   |
| Pdev     | Annual deviations from mean precipitation                                                                                   |   |
| meanWY   | Average annual precipitation (water year)                                                                                   |   |
| YSD      | Years since initial disturbance                                                                                             |   |
| comptree | Percent cover of trees in pipeline pixel                                                                                    |   |
| pipetree | Percent cover of trees in undisturbed comparison pixel                                                                      |   |
| lat      | Latitude (decimal degrees)                                                                                                  |   |
| long     | Longitude (Decimal Degrees)                                                                                                 |   |
| pipeline | Identity of Pipeline                                                                                                        |   |

**Code/Software**

The code (included in the dataset) is formatted for use in R (version 4.3.2) and uses the following packages within the R framework:

* tidyverse (version 2.0.0)
* splitstackshape (version 1.4.8)
* data.table (version 1.14.8)
* lme4 (version 1.1-34)
* MuMIn (version 1.47.5)
* gstat (version 2.1-1)
* sp (version2.1-2)
* spatstat (version3.0-7)
* viridus (version 0.6.5)
* hrbrthemes (version 0.8.0)
* jtools (version 2.2.2)
* lmerTest (version 3.1-3)
* geoR (version 1.9-2)

The needed data input for the R script is all found within the "dataWYgroups1_19.csv" file.  
