(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='WolframDesktop 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       161,          7]
NotebookDataLength[    499371,      12016]
NotebookOptionsPosition[    421211,      10746]
NotebookOutlinePosition[    424622,      10820]
CellTagsIndexPosition[    423967,      10803]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Pronunciation of the integers with full use of the place value system\
\>", "Title",ExpressionUUID->"d47f7fa6-b14e-4e6a-898d-16012f911dc9"],

Cell["\<\
Thomas Colignatus
http://thomascool.eu
May 9 & 17 2018\
\>", "Text",ExpressionUUID->"acdf4973-e4b8-4f53-b4b4-1258c5167d75"],

Cell["\[Copyright] Thomas Cool CC-BY-NC-ND", "Text",ExpressionUUID->"5e558f0a-9fb9-468e-94c9-bf8fda10ce08"],

Cell[TextData[StyleBox["Abstract",
 FontWeight->"Bold"]], "Text",ExpressionUUID->"43d4427c-2256-44cf-ac7e-5e12135ae034"],

Cell[TextData[{
 "Kids in kindergarten and Grade 1 live in a world of sounds so that the \
pronunciation of numbers is important. When they are learning to read and \
write, the co-ordination of (i) sounds, (ii) numerals and (iii) written words \
is important. We already have the place value system fully in the numerals \
but not yet in pronunciation and written words. The following provides for \
this. The definition should become an ISO standard, though the notebook with \
package is quite simple because of the nature of the issue. The notebook with \
package provides an implementation and transliteration for English, German, \
French, Dutch and Danish, while other languages might employ ",
 StyleBox["Mathematica\[CloseCurlyQuote]",
  FontSlant->"Italic"],
 "s IntegerName and WordTranslation without transliteration. Four levels in \
the curriculum are recognised for which routines are provided: (1) sounds, \
codified by words, (2) learning the numerals, (3) advanced: numerals in \
blocks of three digits, such that 123456 = {1 hundred, 2 ten, 3} thousand & \
{4 hundred, 5 ten, 6}, with the comma pronounced as \[OpenCurlyDoubleQuote]&\
\[CloseCurlyDoubleQuote] too, and (4) accomplished: 123 thousand 456 \
pronounced in above place value manner. The traditional pronunciation has \
level -4."
}], "Text",ExpressionUUID->"71bab785-308f-45ba-8e55-9810e64df125"],

Cell[TextData[StyleBox["Keywords",
 FontWeight->"Bold"]], "Text",ExpressionUUID->"53b58d00-2f14-499d-9470-8e2ca9e5df17"],

Cell["\<\
mathematics education, place value system, pronunciation, Common Core, \
Mathematica, Wolfram language, programming, package\
\>", "Text",ExpressionUUID->"16390071-79db-466e-8f55-9b97e9f1d1e4"],

Cell[TextData[StyleBox["MSC2010",
 FontWeight->"Bold"]], "Text",ExpressionUUID->"cd13beeb-5887-4293-a0a7-c9542c2841c3"],

Cell["97M70 Mathematics education. Behavioral and social sciences", "Text",ExpressionUUID->"517e5435-84df-40ee-b2a7-90a8d5a0965b"],

Cell[TextData[StyleBox["Cloud",
 FontWeight->"Bold"]], "Text",ExpressionUUID->"e6c7d40a-daf6-443a-bd9a-e9d3259728bf"],

Cell["\<\
This notebook with package (updated version) is also available at: \
\>", "Text",ExpressionUUID->"808df93e-ecae-4e18-9c1f-27ff00325148"],

Cell["(1)  http://community.wolfram.com/groups/-/m/t/1334793", "Text",ExpressionUUID->"f22e4a79-f9bf-428e-bf3a-753f942ba7c0"],

Cell["\<\
(2) https://www.wolframcloud.com/objects/thomas-cool/MathEd/2018-05-09-\
Pronunciation-of-integers.nb\
\>", "Text",ExpressionUUID->"f320de8e-4993-4d1e-9011-a8e9d07f413b"],

Cell["\<\
(3) for this notebook with package: https://zenodo.org/record/1244008 or DOI \
10.5281/zenodo.1244008 \
\>", "Text",ExpressionUUID->"d17a7ae1-3cae-4818-ae8e-f231d14085c3"],

Cell["\<\
(4) for the PDF: https://zenodo.org/record/1244063  or DOI \
10.5281/zenodo.1244063 \
\>", "Text",ExpressionUUID->"f075d037-4fcc-4eba-bb05-d82bac80f917"],

Cell["\<\
I have not seen this implementation of pronunciation elsewhere (except in \
Chinese though without &), so please refer to these locations so that others \
can find the full documentation.\
\>", "Text",ExpressionUUID->"d4254562-e5a7-4091-8e5f-b99b3a022705"],

Cell[CellGroupData[{

Cell["Contents", "Subsection",ExpressionUUID->"6fb3b910-20f6-4a1b-957e-96a3c5152df1"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Introduction"
}], "Subsubsection",ExpressionUUID->"09ee1f70-35a4-4392-9863-e8a8919df0fb"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Example in English"
}], "Subsubsection",ExpressionUUID->"8cf14bf4-45ab-45d6-8665-13d14783a751"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". History, tradition, assumptions, advantages"
}], "Subsubsection",ExpressionUUID->"d9acdca8-7519-416d-8030-f6eb19e6d4a2"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". A structure for the curriculum"
}], "Subsubsection",ExpressionUUID->"a9642880-d5bb-4147-8701-6210085b933c"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Zig in German and tig in Dutch"
}], "Subsubsection",ExpressionUUID->"80ec5aff-f149-4ecf-8506-20d96ee7d409"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Translate, transliterate and quality control"
}], "Subsubsection",ExpressionUUID->"e94869d4-775d-4338-92a6-1d8ebaa42cd9"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Conversion tables"
}], "Subsubsection",ExpressionUUID->"8fd0f127-5d5b-456d-a1e0-e7d96816d70e"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". ISO standard"
}], "Subsubsection",ExpressionUUID->"819b7a0d-f4a7-471d-9fd3-7fc95ef60607"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Conclusions"
}], "Subsubsection",ExpressionUUID->"39601f33-f632-40a1-a525-3d788d3ea5ff"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Appendix. The package"
}], "Subsubsection",ExpressionUUID->"cd5a58e9-a605-4b2c-90da-3f5a524d076e"],

Cell[TextData[{
 
 CounterBox["Subsubsection"],
 ". Literature"
}], "Subsubsection",ExpressionUUID->"a4b77063-c21e-45d0-b97c-a323bbb14b4f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Start (subsection for the initialisation cell with the package)\
\>", "Subsection",ExpressionUUID->"a10e6b9e-08b8-4d85-8634-ce9e607827f6"],

Cell[CellGroupData[{

Cell["MathEd`PronounceInteger`", "Subsubsection",ExpressionUUID->"0ea01a1e-814a-4d63-aa74-031e586becdc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "Cool`MathEd`PronounceInteger`"}], " ", 
    "package"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "*******************************************)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Author", ":", " ", 
    RowBox[{"Thomas", " ", "Cool"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Copyright", ":", " ", 
    RowBox[{"Copyright", " ", "2018", " ", "Thomas", " ", "Cool"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Package", " ", "Version"}], ":", "2.0"}], ",", " ", 
    RowBox[{"May", " ", "17", " ", "2018"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Mathematica", " ", "Version"}], ":", "11.2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Keywords", ":"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Limitation", ":"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", "License", ":", " ", 
     RowBox[{"see", " ", 
      RowBox[{"http", ":"}]}]}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{"thomascool", ".", "eu"}], "/", "TheEconomicsPack"}], "/", 
     RowBox[{"index", ".", "html"}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"BeginPackage", "[", 
     RowBox[{"\"\<Cool`MathEd`PronounceInteger`\>\"", ",", " ", 
      RowBox[{"{", "\"\<Cool`MathEd`H`\>\"", "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "[", 
     RowBox[{
     "PlaceValue", ",", " ", "PlaceValueH", ",", "PronounceIntegers", ",", 
      " ", "SpeakTransliteration", ",", "PlaceValueBlock", ",", " ", 
      "PlaceValueDigits", ",", " ", "PlaceValueDigits$Language", ",", 
      "PronounceIntegerReadMe", ",", " ", "PronounceInteger", ",", " ", 
      "PartialPlaceValue", ",", " ", "PlaceValueTable"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LatestPronunciation", "::", "usage"}], " ", "=", " ", 
     "\"\<LatestPronunciation[] contains what a routine in the \
MathEd`PronounceInteger` package could have spoken (but perhaps suppressed by \
an option choice not to speak)\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PronounceIntegerReadMe", "::", "usage"}], "  ", "=", " ", 
     "\"\<PronounceIntegerReadMe[] explains the package\>\""}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PronounceIntegerReadMe", "[", "]"}], "=", " ", "\n", 
     "\"\<Mathematica already provides for (i) IntegerName[n, \
\\\"language\\\"], (ii) IntegerName[n, \\\"DigitsWords\\\"] for blocks of \
three digits, and (iii) WordTranslation for \\\"negative\\\", and (iv) a \
wealth of expression in IntegerString. These all encode tradition: with 56 = \
fifty-six instead of ten\[CenterDot]five & six, except in IntegerString[n, \\\
\"TraditionalChineseDecimal\\\"]. Also, these all tend to hide the steps in \
the place value system that we want to show. Our routines are:\\n(1) \
PronounceInteger provides a switch between methods, and helps to focus on \
your preferred method\\n(2) PlaceValue (main routine): word based, so that \
the pronunciation is unambiguous for the particular language. It also allows \
transliteration (speaking foreign words with approximations in English)\\n(3) \
PlaceValueDigits: integer based, for when kids go from sounds to reading and \
writing numerals\\n(4)PlaceValueBlock: show in blocks of three digits (quite \
alike DigitsWords, but notice the differences).\\n(5) PlaceValueIntegerName \
builds around IntegerName DigitsWords for full place value speech\\nLikely, \
teaching is best done likely in order (2)-(5) so that first the individual \
steps are shown and then the block form. PM. A routine f stores what is \
spoken in LatestPronunciation[] and may display differently, see the \
documentation of f\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "::", "usage"}], " ", "=", 
     "\"\<PlaceValueRules[\\\"Language\\\"] = {True -> t, \\\"OtherLanguage\\\
\" -> f}, with t = {Negative -> string, And -> \\\"&\\\", N -> {strings for \
0...9}, Power -> {strings for 10, ..., 10^6}}, for the true way of writing \
and pronunciation (when this original language = $Language), and f = {... \
similar ...} for the transliteration into the actual $Language. See the \
examples for \\\"English\\\" (f is not required given $Language = \\\"English\
\\\") and \\\"Dutch\\\" (t <> f).\\nNegative -> how the sign of a negative \
number is written or pronounced\\nAnd-> what string is used to separate the \
product terms of weights and place values\\nN -> {names how the digits 0 ... \
9 are written or pronounced}\\nPower -> {names how 10 ... 10^6 are written or \
pronounced}.\\nSee SpeakTransliteration for checking on \
$Language.\\nImplemented are English, German, French, Dutch and Danish (with \
some guessing on transliteration). The language Amplish has True -> with an \
ampersand in a smaller font, and otherwise English. Englishty has ty for 10 \
pronounced as tee. The languages have (Greek) myriad for 10^4 and (Indian) \
lakh for 10^5\\nPlaceValueRules[] contains the list of languages for which \
there is transliteration\\nPlaceValueRules[Select, item, lan, \
translit:\\\"English\\\"] selects for lan the item (e.g. Power) from both \
True and translit, and gives a rule or list of rules (true -> \
transliteration) for replacement\\nPlaceValueRules[Set, \\\"ToLanguage\\\", \
FromLanguage:\\\"English\\\"] uses IntegerName for the digits and \
WordTranslation for \\\"negative\\\", \\\"and\\\" and \\\"million\\\" and \
imposes myriad and lakh. These routines may take time, and thus one is \
advised to save the result. There is no automation for the \
transliteration\\nPlaceValueRules[Check, \\\"Language\\\"] for another \
language than in PlaceValueRules[\\\"Checked\\\"] will issue a warning that \
the place value pronunciation is generated by automation and hasn't been \
checked on conflicts. When you have done the checking then this list can be \
adapted manually or by AppendTo\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpeakTransliteration", " ", "::", "usage"}], " ", "=", " ", 
     "\"\<SpeakTransliteration is an option of PlaceValue with default \
$Language. It selects the relevant setting from the PlaceValueRules. If the \
Language option is equal to the transliterator ($Language) then writing and \
speaking will be done from the True rule. When the option Language is set to \
another value, then the integers are written from True but spoken by the \
transliterator\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "usage"}], " ", "=", " ", 
     "\"\<PlaceValue[n] gives n in the full place value system, as text or in \
Speak, and the latter with pauses for hearing and possible transliteration in \
the system default language (e.g. $Language = English). n is in (-10^7, \
10^7).\\nThe routine is also called with PronounceInteger[n, Level -> \
1]\\nOptions with defaults are:\\nLanguage -> \\\"Amplish\\\" uses \
PlaceValueRules[\\\"Amplish\\\"], see there\\nWordTranslation -> Automatic \
calls IntegerName and WordTranslation when the language is not available in \
PlaceValueRules, which takes some time for initialisation and does not \
provide for transliteration\\nSpeakTransliteration :> $Language (often \
\\\"English\\\"), see there\\nSpeak -> True,\\nLength -> 300, an integer for \
the duration of pause between the positions,\\nJoin -> \\\"\[CenterDot]\\\" \
(unpronounced center dot) between the texts of the weight and place \
value\\nSimplify -> True eliminates terms with 0 weights and replaces 1 P by \
P, for P = 1, 10, ..., 10^6\\nShow -> False does not show the input for \
Speak, so that one reads the words in the language itself and hears the \
transliteration (while reading affects hearing)\\nPronounceInteger[Options, \
\\\"Reset\\\"] resets the options to loading time\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueH", "::", "usage"}], " ", "=", " ", 
     "\"\<PlaceValueH[expr] is PlaceValue[expr /. H -> -1]\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PronounceIntegers", "::", "usage"}], " ", "=", 
     "\"\<PronounceIntegers is obsolete (first version of the package), see \
PlaceValue\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueDigits$Language", "::", "usage"}], " ", "=", " ", 
     "\"\<PlaceValueDigits$Language[n] pronounces n by using digits for the \
place values rather than words (PlaceValue): n can be as large as Mathematica \
allows, but also relies on how $Language pronounces those integers. In \
English 2 100 is pronounced as \\\"two one-hundred\\\". Option Simplify -> \
True (default) for handling of 0 and 1 weights, StepMonitor -> False \
(default) whether to show an intermediate step, Length -> 300 (default) for \
the pause, Join -> \\\"\[CenterDot]\\\" (default) for connection of terms in \
display (not spoken), Speak -> True (default).\\nThe routine is also called \
as a subroutine by PlaceValueDigits[n], which is also called by \
PronounceInteger[n, Level -> 2]\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueBlock", "::", "usage"}], " ", "=", " ", 
     "\"\<PlaceValueBlock[n] pronounces n in digit blocks of 3, and within \
those blocks in place value manner.\\nThe routine is also called with \
PronounceInteger[n, Level -> 3]\\nFor example 123456 = {{1 hundred & 2 ten & \
3}, thousand} & {4 hundred & 5 ten & 6}. This is like common usage except for \
the integers in 11-99. Option Length -> 300 (default) puts \\\"&\\\" in the \
middle of that pause. Option Power -> {...} by default replaces 100 by \
hundred, 1000 by thousand and 10^6 by million. (This is not done in \
PlaceValueDigits$Language, because there are more words, like for the digits, \
and including the awkward 10^4 and 10^5). The numbers 11-99 use the options \
of PlaceValueDigits$Language, namely to display in numbers and not words. If \
your $Language is not \\\"English\\\", then you might consider to adapt the \
settings manually. The following is an automation \
though:\\nPlaceValueBlock[SetOptions, \\\"language\\\"] sets the options to \
stated \\\"language\\\", using WordTranslation from the current language in \
the Options (default \\\"English\\\")\\nPlaceValueBlock[Options, \
\\\"Reset\\\"] resets to the Options at loading\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueIntegerName", "::", "usage"}], " ", "=", " ", 
     "\"\<PlaceValueIntegerName[n] lets IntegerName[n, \\\"DigitsWords\\\"] \
make the blocks of 3 digits, and then calls PlaceValue on these digits. \
IntegerName DigitsWords uses text for Abs[n] < 1000, and we follow this. The \
block bases of thousand, million etcetera are translated by WordTranslation. \
The text displayed has blocks of digits, with block bases separated by option \
And -> \\\", \\\" (default). This option is not passed on to PlaceValue for \
speech of the blocks. The spoken text can be recovered from \
LatestPronunciation[]. Transliteration is called but will slow the \
execution\\nThe routine is also called with PronounceInteger[n, Level -> 4]\>\
\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PronounceInteger", "::", "usage"}], " ", "=", " ", 
     "\"\<PronounceInteger[n] pronounces n. Options are passed on to the \
routine that is called, except: if the chosen Language is equal to $Language \
then it is not passed on. It uses first the Level and then the Method setting \
in the options, default Level -> 1, Method -> PlaceValue. Option All -> {...} \
gives the methods in the MathEd`PronounceInteger` package. See the \
documentation per routine. If you want to specify the selection by Method -> \
routine name, select also Level -> 0. Perhaps easier to remember than the \
routine names, and taking advantage of the levels of understanding, you can \
also specify the Level -> lev:\\nchosen =Switch[lev, \\n 1, PlaceValue,\\n 2, \
PlaceValueDigits,\\n 3, PlaceValueBlock,\\n 4, PlaceValueIntegerName,\\n-4, \
PartialPlaceValue,\\n_, Null];\\n If none of these is used (say with Level -> \
0) then the Method -> m option is used. If no method is in the list that All \
provided: $Failed\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PartialPlaceValue", "::", "usage"}], " ", "=", " ", 
     "\"\<PartialPlaceValue[n] has the traditional pronunciation and words of \
the numbers 11-99, thus in opposite order of the place value system, when \
speaking the number from Left To Right, and morphing of words. It calls \
IntegerName with DigitsWords. If Abs[n] < 1000 then there are words only, and \
higher n get combinations of both digit blocks and words for digit block \
values (thousand, million). Option defaults are Language -> \\\"English\\\" \
and Speak -> True. Speak apparently fails on the hyphen and thus this \
replaced by a space. Speak[-10] says Minus 10 but IntegerName uses Negative \
10. There is no transliteration.\\nThe routine is also called with \
PronounceInteger[n, Level -> -4]\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueDigits", "::", "usage"}], " ", "=", " ", 
     "\"\<PlaceValueDigits[n] pronounces n by PlaceValue[n] and displays by \
PlaceValueDigits$Language[n]\\nOptions are passed on to said routines, and \
see their own options, like Simplify and Show\\nOwn options are Speak -> True \
(default), Print -> True (default) prints the outcome of PlaceValue[n]. \
LatestPronunciation[Print] stores what is printed\\nThe routine is also \
called with PronounceInteger[n, Level -> 2]\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueTable", "::", "usage"}], " ", "=", " ", 
     "\"\<PlaceValueTable[{n}] gives a table of {n} with rows {n, \
pronunciation in PlaceValue, PV Digits, traditional pronunciation}. Options \
are passed on to PlaceValue (default Speak -> True) and \
PartialPlaceValue(default Speak -> False)\\nPlaceValueTable[n] gives the \
table with only n\\nPlaceValueTable[Row, n || {n}] gives the rows as lists \
only\\nPlaceValueTable[First, n] gives {n, PV, PV Digits}\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "::", "wrn"}], " ", "=", " ", 
     "\"\<Warning: automated translation of `1` and not carefully checked on \
conflicts and peculiarities\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", 
      RowBox[{"Check", ",", " ", "lan_String"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"PlaceValueRules", "[", "\"\<Checked\>\"", "]"}], ",", " ", 
          "lan"}], "]"}]}], ",", " ", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"PlaceValueRules", "::", "wrn"}], ",", " ", "lan"}], "]"}]}],
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueTable", "[", 
     RowBox[{"First", ",", " ", "n_Integer", ",", " ", "opts___Rule"}], "]"}],
     " ", ":=", " ", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"n", ",", " ", 
      RowBox[{"PlaceValue", "[", 
       RowBox[{"n", ",", " ", "opts"}], "]"}], ",", " ", 
      RowBox[{"PlaceValueDigits", "[", 
       RowBox[{"n", ",", " ", 
        RowBox[{"Print", " ", "\[Rule]", " ", "False"}], ",", " ", 
        RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", "opts"}], 
       "]"}]}], "}"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueTable", "[", 
     RowBox[{"Row", ",", " ", "n_Integer", ",", " ", "opts___Rule"}], "]"}], 
    " ", ":=", " ", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"n", ",", " ", "\"\< \>\"", ",", " ", 
      RowBox[{"PlaceValue", "[", 
       RowBox[{"n", ",", " ", "opts"}], "]"}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"PlaceValueDigits", "[", 
       RowBox[{"n", ",", " ", 
        RowBox[{"Print", " ", "\[Rule]", " ", "False"}], ",", " ", 
        RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", "opts"}], 
       "]"}], ",", "\[IndentingNewLine]", "  ", "\"\< \>\"", ",", 
      RowBox[{"PartialPlaceValue", "[", 
       RowBox[{"n", ",", " ", "opts", ",", " ", 
        RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueTable", "[", 
     RowBox[{"Row", ",", " ", 
      RowBox[{"{", "n__Integer", "}"}], ",", " ", "opts___Rule"}], "]"}], " ",
     ":=", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"PlaceValueTable", "[", 
       RowBox[{"Row", ",", "#", ",", " ", "opts"}], "]"}], "&"}], " ", "/@", 
     " ", 
     RowBox[{"{", "n", "}"}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueTable", "[", " ", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"PlaceValueTable", "[", " ", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", " ", "opts"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueTable", "[", 
     RowBox[{
      RowBox[{"{", "n__Integer", "}"}], ",", " ", "opts___Rule"}], "]"}], " ",
     ":=", " ", "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"PlaceValueRules", "[", 
       RowBox[{"Check", ",", " ", 
        RowBox[{
         RowBox[{"Language", " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValue", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TableForm", "[", 
       RowBox[{
        RowBox[{"PlaceValueTable", "[", 
         RowBox[{"Row", ",", " ", 
          RowBox[{"{", "n", "}"}], ",", " ", "opts"}], "]"}], ",", "opts", 
        ",", " ", 
        RowBox[{"TableSpacing", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", " ", "3"}], "}"}]}], ",", "\[IndentingNewLine]",
         " ", 
        RowBox[{"TableHeadings", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"None", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<Integer\>\"", ",", " ", "\"\<\>\"", ",", " ", 
             "\"\<Place Value\>\"", ",", " ", "\"\<PV Digits\>\"", ",", " ", 
             "\"\<\>\"", ",", " ", "\"\<Traditional\>\""}], "}"}]}], 
          "}"}]}]}], "]"}]}], ")"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "PlaceValueDigits", "]"}], " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
       RowBox[{"Print", " ", "\[Rule]", " ", "True"}]}], "}"}]}], " ", ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueDigits", "[", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "res", ",", " ", "speakq", ",", "  ", "toshow", ",", " ", "prq"}], 
       "}"}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"split", " ", "show", " ", "and", " ", "speak"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"speakq", ",", " ", "prq"}], "}"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Speak", ",", " ", "Print"}], "}"}], " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValueDigits", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"toshow", " ", "=", " ", 
        RowBox[{"PlaceValueDigits$Language", "[", 
         RowBox[{"n", ",", " ", 
          RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", "opts"}],
          "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", "  ", 
        RowBox[{"PlaceValue", "[", 
         RowBox[{"n", ",", " ", 
          RowBox[{"Speak", " ", "\[Rule]", " ", "speakq"}], ",", " ", 
          "opts"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"prq", " ", "===", " ", "True"}], ",", "  ", 
         RowBox[{
          RowBox[{
           RowBox[{"LatestPronunciation", "[", "Print", "]"}], " ", "=", " ", 
           "res"}], ";", 
          RowBox[{"Print", "[", "res", "]"}]}]}], "]"}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"LatestPronunciation", "[", "]"}], " ", "set", " ", "by", 
         " ", 
         RowBox[{"P", ".", "V", ".", "O", "."}]}], " ", "*)"}], 
       "\[IndentingNewLine]", "toshow"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "PartialPlaceValue", "]"}], " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Language", " ", "\[Rule]", " ", "\"\<English\>\""}], ",", " ", 
       RowBox[{"Speak", " ", "\[Rule]", " ", "True"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PartialPlaceValue", "[", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"res", ",", " ", "lan", ",", " ", "speakq", ",", " ", "rul"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lan", ",", " ", "speakq"}], "}"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Language", ",", " ", "Speak"}], "}"}], " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PartialPlaceValue", "]"}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"rul", " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "$Language", ",", " ", "\"\<Amplish\>\"", ",", " ", 
              "\"\<Englishty\>\""}], "}"}], ",", " ", "lan"}], "]"}], ",", 
          " ", "\[IndentingNewLine]", 
          RowBox[{"ToExpression", "[", "\"\<Sequence[]\>\"", "]"}], ",", " ", 
          RowBox[{"Language", " ", "\[Rule]", " ", "lan"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", "  ", 
        RowBox[{"IntegerName", "[", 
         RowBox[{"n", ",", " ", 
          RowBox[{"{", "\"\<DigitsWords\>\"", "}"}], ",", " ", "rul"}], 
         "]"}]}], " ", ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"StringReplace", "[", 
         RowBox[{"res", ",", " ", 
          RowBox[{"\"\<\[Hyphen]\>\"", " ", "\[Rule]", " ", "\"\< \>\""}]}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"LatestPronunciation", "[", "]"}], " ", "=", "res"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"speakq", ",", " ", 
         RowBox[{"Speak", "[", "res", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "res"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "PronounceInteger", "]"}], " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Level", " ", "\[Rule]", " ", "1"}], ",", " ", 
       RowBox[{"Method", " ", "\[Rule]", " ", "PlaceValue"}], ",", " ", 
       RowBox[{"Language", " ", "\[Rule]", " ", "\"\<English\>\""}], ",", 
       "  ", "\[IndentingNewLine]", 
       RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
       RowBox[{"All", " ", "\[Rule]", " ", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
         "PlaceValue", ",", " ", "PlaceValueH", ",", " ", "PlaceValueDigits", 
          ",", "\[IndentingNewLine]", "PlaceValueDigits$Language", ",", 
          "PlaceValueBlock", ",", "\[IndentingNewLine]", 
          "PlaceValueIntegerName", ",", " ", "PartialPlaceValue", ",", " ", 
          "PlaceValueTable"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PronounceInteger", "::", "unk"}], " ", "=", " ", 
     "\"\<Unknown Level -> `1` and Method -> `2`\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PronounceInteger", "[", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "m", ",", " ", "lan", ",", " ", "all", ",", " ", "rul", ",", " ", 
        "res", ",", " ", "speakq", ",", " ", "lev", ",", " ", "k"}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "lev", ",", " ", "m", ",", " ", "lan", ",", " ", "all", ",", " ", 
          "speakq"}], "}"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "Level", ",", " ", "Method", ",", " ", "Language", ",", " ", "All",
             ",", " ", "Speak"}], "}"}], " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PronounceInteger", "]"}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"rul", " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lan", " ", "===", " ", "$Language"}], ",", " ", 
          RowBox[{"ToExpression", "[", "\"\<Sequence[]\>\"", "]"}], ",", " ", 
          RowBox[{"Language", " ", "\[Rule]", " ", "lan"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"k", " ", "=", 
        RowBox[{"Switch", "[", 
         RowBox[{
         "lev", ",", " ", "\[IndentingNewLine]", "1", ",", " ", "PlaceValue", 
          ",", "\[IndentingNewLine]", "2", ",", " ", "PlaceValueDigits", ",", 
          "\[IndentingNewLine]", "3", ",", " ", "PlaceValueBlock", ",", 
          "\[IndentingNewLine]", "4", ",", " ", "PlaceValueIntegerName", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"-", "4"}], ",", " ", "PartialPlaceValue", ",", 
          "\[IndentingNewLine]", "_", ",", " ", "Null"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ",", " ", "1", ",", " ", "2", ",", " ", "3", 
             ",", " ", "4"}], "}"}], ",", " ", "lev"}], "]"}], ",", " ", 
         RowBox[{"Return", "[", 
          RowBox[{"k", "[", 
           RowBox[{"n", ",", " ", "rul", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "speakq"}], ",", " ", 
            "opts"}], "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "routines", " ", "that", " ", "have", " ", "not", " ", "been", " ", 
         "assigned", " ", "a", " ", "level"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{"all", ",", " ", "m"}], "]"}], ",", " ", 
         RowBox[{"Return", "[", 
          RowBox[{"m", "[", 
           RowBox[{"n", ",", " ", "rul", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "speakq"}], ",", " ", 
            "opts"}], "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"PronounceInteger", "::", "unk"}], ",", " ", "lev", ",", " ",
          "m"}], "]"}], ";", " ", "\[IndentingNewLine]", "$Failed"}]}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "PlaceValueIntegerName", "]"}], " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Language", " ", "\[Rule]", " ", "\"\<English\>\""}], ",", " ", 
       RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
       RowBox[{"And", " ", "\[Rule]", " ", "\"\<, \>\""}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pvoin", "[", 
      RowBox[{"x_", ",", " ", "lan_String"}], "]"}], " ", ":=", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"lan", " ", "===", " ", "\"\<English\>\""}], ",", " ", "x", 
       ",", "\[IndentingNewLine]", 
       RowBox[{"First", "[", 
        RowBox[{"WordTranslation", "[", 
         RowBox[{"x", ",", " ", 
          RowBox[{"\"\<English\>\"", " ", "\[Rule]", " ", "lan"}]}], "]"}], 
        "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pvoin", "[", 
      RowBox[{"x_", ",", " ", "lan_String", ",", " ", "rul_"}], "]"}], " ", ":=",
      " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"lan", " ", "===", " ", "\"\<English\>\""}], ",", " ", "x", 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"First", "[", 
          RowBox[{"WordTranslation", "[", 
           RowBox[{"x", ",", " ", 
            RowBox[{"\"\<English\>\"", " ", "\[Rule]", " ", "lan"}]}], "]"}], 
          "]"}], ")"}], " ", "/.", " ", "rul"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueIntegerName", "[", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "lan", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"lan", "=", " ", 
        RowBox[{
         RowBox[{"Language", " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValueIntegerName", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"lan", " ", "===", " ", "$Language"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlaceValueIntegerName", "[", 
          RowBox[{"\"\<Fast\>\"", ",", " ", "n", ",", " ", "opts"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"PlaceValueIntegerName", "[", 
          RowBox[{"\"\<Slow\>\"", ",", " ", "n", ",", " ", "opts"}], "]"}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueIntegerName", "[", 
     RowBox[{"\"\<Fast\>\"", ",", " ", "n_Integer", ",", " ", "opts___Rule"}],
      "]"}], " ", ":=", " ", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "res", ",", " ", "lan", ",", " ", "speakq", ",", " ", "rul", ",", " ", 
        "toshow", ",", " ", "tospeak", ",", " ", "and", ",", "nopts", ",", 
        " ", "na"}], "}"}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "IntegerName", " ", "in", " ", "English", " ", "displays", " ", 
         "blocks", " ", "of", " ", "3", " ", "digits"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"but", " ", "for", " ", "values", " ", 
          RowBox[{"Abs", "[", "n", "]"}]}], " ", "<", " ", 
         RowBox[{
         "1000", " ", "and", " ", "in", " ", "\[IndentingNewLine]", 
          "translation", " ", "it", " ", "switches", " ", "to", " ", 
          RowBox[{"names", ".", " ", "We"}], " ", "need", " ", "the", " ", 
          "digits"}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lan", ",", " ", "speakq", ",", " ", "and"}], "}"}], " ", 
        "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Language", ",", " ", "Speak", ",", " ", "And"}], "}"}], 
          " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValueIntegerName", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Check", "[", 
        RowBox[{
         RowBox[{"IntegerName", "[", 
          RowBox[{"0", ",", " ", "\"\<Words\>\"", ",", " ", 
           RowBox[{"Language", " ", "->", " ", "lan"}]}], "]"}], ",", " ", 
         RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"speakq", " ", "=", " ", 
        RowBox[{"speakq", " ", "===", " ", "True"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"StringQ", "[", "and", "]"}]}], ",", "  ", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"PlaceValue", "::", "str"}], " ", ",", " ", "And", ",", 
            " ", "and"}], "]"}], ";", 
          RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"nopts", " ", "=", " ", 
        RowBox[{"Sequence", " ", "@@", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", "opts", "}"}], " ", "/.", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Rule", "[", 
              RowBox[{"And", ",", " ", "x_"}], "]"}], " ", "\[RuleDelayed]", 
             " ", 
             RowBox[{"Sequence", "[", "]"}]}], ")"}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"rul", " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lan", " ", "===", " ", "$Language"}], ",", " ", 
          RowBox[{"ToExpression", "[", "\"\<Sequence[]\>\"", "]"}], ",", " ", 
          RowBox[{"Language", " ", "\[Rule]", " ", "lan"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", "n", "]"}], " ", "<", " ", "1000"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"PlaceValue", "[", 
           RowBox[{"n", ",", " ", "rul", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "speakq"}], ",", " ", 
            "nopts"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", "else", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"IntegerName", "[", 
            RowBox[{"n", ",", " ", 
             RowBox[{"{", 
              RowBox[{"\"\<DigitsWords\>\"", ",", " ", "\"\<English\>\""}], 
              "}"}]}], "]"}]}], " ", ";", "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"StringSplit", "[", "res", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"toshow", " ", "=", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"DigitQ", "[", "#", "]"}], ",", " ", "#", ",", " ", 
               RowBox[{
                RowBox[{"pvoin", "[", 
                 RowBox[{"#", ",", " ", "lan"}], "]"}], "<>", "and"}]}], 
              "]"}], "&"}], " ", "/@", " ", "res"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"toshow", " ", "=", " ", 
           RowBox[{"StringJoin", " ", "@@", "  ", 
            RowBox[{"Riffle", "[", 
             RowBox[{"toshow", " ", ",", " ", "\"\<  \>\""}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"na", "=", " ", 
           RowBox[{"StringLength", "[", "and", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"toshow", ",", " ", 
               RowBox[{"-", "na"}]}], "]"}], " ", "===", "  ", "and"}], ",", 
            " ", 
            RowBox[{"toshow", " ", "=", " ", 
             RowBox[{"StringDrop", "[", 
              RowBox[{"toshow", ",", " ", 
               RowBox[{"-", "na"}]}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"DigitQ", "[", "#", "]"}], ",", " ", 
               RowBox[{"ToExpression", "[", "#", "]"}], ",", " ", 
               RowBox[{
                RowBox[{"pvoin", "[", 
                 RowBox[{"#", ",", " ", "lan"}], "]"}], "<>", " ", "and"}]}], 
              "]"}], "&"}], " ", "/@", " ", "res"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"re", "-", 
            RowBox[{
            "introduce", " ", "English", " ", "because", " ", "of", " ", 
             "Amplish"}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"res", " ", "/.", " ", 
            RowBox[{"x_Integer", " ", "\[RuleDelayed]", " ", 
             RowBox[{"PlaceValue", "[", 
              RowBox[{"x", ",", " ", "rul", ",", " ", 
               RowBox[{"Language", " ", "\[Rule]", " ", "\"\<English\>\""}], 
               ",", " ", 
               RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
               "nopts"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"tospeak", " ", "=", " ", 
           RowBox[{"StringJoin", " ", "@@", "  ", 
            RowBox[{"Riffle", "[", 
             RowBox[{"res", ",", " ", "\"\<  \>\""}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"tospeak", ",", " ", 
               RowBox[{"-", "na"}]}], "]"}], " ", "===", "  ", "and"}], ",", 
            " ", 
            RowBox[{"tospeak", " ", "=", " ", 
             RowBox[{"StringDrop", "[", 
              RowBox[{"tospeak", ",", " ", 
               RowBox[{"-", "na"}]}], "]"}]}]}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"LatestPronunciation", "[", "]"}], "=", " ", "tospeak"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"speakq", " ", "===", " ", "True"}], ",", " ", 
         RowBox[{"Speak", "[", "tospeak", "]"}]}], "]"}], ";", " ", 
       "\[IndentingNewLine]", "toshow"}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueIntegerName", "[", 
     RowBox[{"\"\<Slow\>\"", ",", " ", "n_Integer", ",", " ", "opts___Rule"}],
      "]"}], " ", ":=", " ", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "res", ",", " ", "lan", ",", " ", "speakq", ",", " ", "rul", ",", " ", 
        "toshow", ",", " ", "tospeak", ",", " ", "and", ",", "na", ",", " ", 
        "nopts", ",", " ", "sp", ",", " ", "h", ",", " ", "trans", ",", " ", 
        "las"}], "}"}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "IntegerName", " ", "in", " ", "English", " ", "displays", " ", 
         "blocks", " ", "of", " ", "3", " ", "digits"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"but", " ", "for", " ", "values", " ", 
          RowBox[{"Abs", "[", "n", "]"}]}], " ", "<", " ", 
         RowBox[{
         "1000", " ", "and", " ", "in", " ", "\[IndentingNewLine]", 
          "translation", " ", "it", " ", "switches", " ", "to", " ", 
          RowBox[{"names", ".", " ", "We"}], " ", "need", " ", "the", " ", 
          "digits"}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lan", ",", " ", "speakq", ",", " ", "and"}], "}"}], " ", 
        "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Language", ",", " ", "Speak", ",", " ", "And"}], "}"}], 
          " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValueIntegerName", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Check", "[", 
        RowBox[{
         RowBox[{"IntegerName", "[", 
          RowBox[{"0", ",", " ", "\"\<Words\>\"", ",", " ", 
           RowBox[{"Language", " ", "->", " ", "lan"}]}], "]"}], ",", " ", 
         RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"speakq", " ", "=", " ", 
        RowBox[{"speakq", " ", "===", " ", "True"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"StringQ", "[", "and", "]"}]}], ",", "  ", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"PlaceValue", "::", "str"}], " ", ",", " ", "And", ",", 
            " ", "and"}], "]"}], ";", 
          RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"nopts", " ", "=", " ", 
        RowBox[{"Sequence", " ", "@@", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", "opts", "}"}], " ", "/.", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Rule", "[", 
              RowBox[{"And", ",", " ", "x_"}], "]"}], " ", "\[RuleDelayed]", 
             " ", 
             RowBox[{"Sequence", "[", "]"}]}], ")"}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"rul", " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lan", " ", "===", " ", "$Language"}], ",", " ", 
          RowBox[{"ToExpression", "[", "\"\<Sequence[]\>\"", "]"}], ",", " ", 
          RowBox[{"Language", " ", "\[Rule]", " ", "lan"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", "n", "]"}], " ", "<", " ", "1000"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"PlaceValue", "[", 
           RowBox[{"n", ",", " ", "rul", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "speakq"}], ",", " ", 
            "nopts"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", "else", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"IntegerName", "[", 
            RowBox[{"n", ",", " ", 
             RowBox[{"{", 
              RowBox[{"\"\<DigitsWords\>\"", ",", " ", "\"\<English\>\""}], 
              "}"}]}], "]"}]}], " ", ";", "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"StringSplit", "[", "res", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", "toshow", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"toshow", " ", "=", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"DigitQ", "[", "#", "]"}], ",", " ", "#", ",", " ", 
               RowBox[{
                RowBox[{"pvoin", "[", 
                 RowBox[{"#", ",", " ", "lan"}], "]"}], "<>", " ", "and"}]}], 
              "]"}], "&"}], " ", "/@", " ", "res"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"toshow", " ", "=", " ", 
           RowBox[{"StringJoin", " ", "@@", "  ", 
            RowBox[{"Riffle", "[", 
             RowBox[{"toshow", " ", ",", " ", "\"\<  \>\""}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"na", "=", " ", 
           RowBox[{"StringLength", "[", "and", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"toshow", ",", " ", 
               RowBox[{"-", "na"}]}], "]"}], " ", "===", "  ", "and"}], ",", 
            " ", 
            RowBox[{"toshow", " ", "=", " ", 
             RowBox[{"StringDrop", "[", 
              RowBox[{"toshow", ",", " ", 
               RowBox[{"-", "na"}]}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", "tospeak", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"h", "[", "x_", "]"}], " ", ":=", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Speak", "[", "x", "]"}], ";", "x"}], ")"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"sp", "[", "x_", "]"}], " ", ":=", " ", 
           RowBox[{"If", "[", 
            RowBox[{"speakq", ",", " ", 
             RowBox[{
              RowBox[{"Hold", "[", "h", "]"}], "[", "x", "]"}], ",", " ", 
             "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"trans", " ", "=", " ", 
           RowBox[{"PlaceValueRules", "[", 
            RowBox[{"Select", ",", "Power", ",", " ", "lan"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"trans", " ", "===", " ", "$Failed"}], " ", "||", " ", 
             RowBox[{"!", "speakq"}]}], ",", " ", 
            RowBox[{"trans", " ", "=", " ", 
             RowBox[{"ToExpression", "[", "\"\<Sequence[]\>\"", "]"}]}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"DigitQ", "[", "#", "]"}], ",", " ", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Hold", "[", " ", "PlaceValue", "]"}], "[", 
                RowBox[{
                 RowBox[{"ToExpression", "[", "#", "]"}], ",", " ", "rul", 
                 ",", " ", 
                 RowBox[{"Speak", " ", "\[Rule]", " ", "speakq"}], ",", " ", 
                 RowBox[{"Show", " ", "\[Rule]", " ", "True"}], ",", " ", 
                 "nopts"}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"sp", "[", 
                RowBox[{
                 RowBox[{"pvoin", "[", 
                  RowBox[{"#", ",", " ", "lan", ",", " ", "trans"}], "]"}], "<>",
                  " ", "and"}], "]"}]}], "]"}], "&"}], " ", "/@", " ", 
            "res"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "clean", " ", "up", " ", "if", " ", "last", " ", "is", " ", "a", 
            " ", "base", " ", "with", " ", "and"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"las", " ", "=", " ", 
           RowBox[{"Last", "[", "res", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"las", " ", "=", " ", 
           RowBox[{"las", " ", "/.", " ", 
            RowBox[{"x_String", " ", "\[RuleDelayed]", " ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"StringTake", "[", 
                 RowBox[{"x", ",", " ", 
                  RowBox[{"-", "na"}]}], "]"}], " ", "===", "  ", "and"}], 
               ",", " ", 
               RowBox[{"StringDrop", "[", 
                RowBox[{"x", ",", " ", 
                 RowBox[{"-", "na"}]}], "]"}], ",", " ", "x"}], "]"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"Append", "[", 
            RowBox[{
             RowBox[{"Drop", "[", 
              RowBox[{"res", ",", " ", 
               RowBox[{"-", "1"}]}], "]"}], ",", " ", "las"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"ReleaseHold", "[", "res", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"tospeak", " ", "=", " ", 
           RowBox[{"StringJoin", " ", "@@", "  ", 
            RowBox[{"Riffle", "[", 
             RowBox[{"res", ",", " ", "\"\<  \>\""}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"LatestPronunciation", "[", "]"}], "=", " ", "tospeak"}], 
          ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "toshow"}]}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "PlaceValueDigits$Language", "]"}], " ", "=", 
     " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Length", " ", "\[Rule]", " ", "300"}], ",", " ", 
        RowBox[{"Simplify", " ", "\[Rule]", " ", "True"}], ",", " ", 
        RowBox[{"Join", " ", "\[Rule]", " ", "\"\<\[CenterDot]\>\""}], ",", 
        " ", 
        RowBox[{"And", " ", "\[Rule]", " ", "\"\<&\>\""}], ",", " ", 
        RowBox[{"StepMonitor", " ", "\[Rule]", " ", "False"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Speak", " ", "\[Rule]", " ", "True"}]}], "}"}], " ", "//", 
      " ", "Sort"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueDigits$Language", "[", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "g", ",", " ", "h", ",", " ", "len", ",", " ", "res", ",", " ", 
        "pause", ",", " ", "simpq", ",", " ", "np", ",", " ", "join", ",", 
        " ", "smq", ",", " ", "temp", ",", " ", "speakq", ",", " ", "and", 
        ",", " ", "paund"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "simpq", ",", " ", "pause", ",", " ", "join", ",", " ", "smq", ",", 
          " ", "speakq", ",", " ", "and"}], "}"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "Simplify", ",", " ", "Length", ",", " ", "Join", ",", " ", 
            "StepMonitor", ",", " ", "Speak", ",", " ", "And"}], "}"}], " ", "/.",
           " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValueDigits$Language", "]"}]}]}], " ", 
       ";", "\[IndentingNewLine]", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"StringQ", "[", "and", "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"PlaceValue", "::", "str"}], ",", " ", "\"\<and\>\"", ",",
             " ", "and"}], "]"}], ";", " ", 
          RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"join", " ", "=", " ", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"\"\< \>\"", ",", " ", "join", ",", " ", "\"\< \>\""}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "pause", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"pause", " ", "=", " ", 
          RowBox[{"\"\< <silence msec=\\\"\>\"", " ", "<>", " ", 
           RowBox[{"ToString", "[", "pause", "]"}], " ", "<>", " ", 
           "\"\<\\\"/> \>\""}]}], " ", ",", "\[IndentingNewLine]", " ", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"PlaceValue", "::", "pau"}], ",", " ", "pause"}], "]"}], 
          ";", 
          RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"h", " ", "=", " ", 
        RowBox[{"IntegerDigits", "[", "n", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"len", " ", "=", " ", 
        RowBox[{"Length", "[", "h", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"g", " ", "=", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"10", "^", "k"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"k", ",", " ", "0", ",", " ", "len"}], "}"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"g", " ", "=", " ", 
        RowBox[{"Reverse", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"g", ",", " ", "len"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"Inner", "[", 
         RowBox[{"times", ",", " ", "h", ",", " ", "g", ",", " ", "TheSum"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "no", " ", "speaking", " ", "since", " ", "wrong", " ", "pauses"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"smq", " ", "===", " ", "True"}], " ", ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"temp", " ", "=", " ", 
           RowBox[{"ToString", "[", "res", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"temp", " ", "=", " ", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"temp", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"ToString", "[", "times", "]"}], " ", "\[Rule]", " ", 
                "\"\<times\>\""}], ",", " ", 
               RowBox[{
                RowBox[{"ToString", "[", "TheSum", "]"}], " ", "\[Rule]", 
                " ", "\"\<TheSum\>\""}]}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", "temp", "]"}], ";"}]}], " ", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Speak", "[", "temp", "]"}], " ", "*)"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"simpq", " ", "===", " ", "True"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"res", " ", "/.", " ", 
            RowBox[{
             RowBox[{"times", "[", 
              RowBox[{"0", ",", " ", "x_"}], "]"}], " ", "\[RuleDelayed]", 
             " ", 
             RowBox[{"Sequence", "[", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"res", " ", "/.", " ", 
            RowBox[{
             RowBox[{"times", "[", " ", 
              RowBox[{"1", ",", " ", "x_"}], "]"}], " ", "\[RuleDelayed]", 
             " ", "x"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"res", " ", "/.", " ", 
            RowBox[{
             RowBox[{"times", "[", " ", 
              RowBox[{"x_", ",", " ", "1"}], "]"}], " ", "\[RuleDelayed]", 
             " ", "x"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"n", " ", "===", " ", "0"}], ",", " ", 
            RowBox[{"res", " ", "=", " ", 
             RowBox[{"{", "0", "}"}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
        "]"}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"res", " ", "/.", " ", 
         RowBox[{"TheSum", " ", "\[Rule]", " ", "List"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"paund", " ", "=", " ", 
        RowBox[{
        "pause", " ", "<>", " ", "\"\< \>\"", " ", "<>", " ", "and", " ", "<>",
          " ", "\"\<   \>\""}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"paund", ",", " ", 
            RowBox[{"ToString", "[", "#", "]"}]}], "]"}], "&"}], " ", "/@", 
         " ", "res"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"StringJoin", " ", "@@", " ", "res"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"StringDrop", "[", 
         RowBox[{"res", ",", "  ", 
          RowBox[{"StringLength", "[", "paund", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", " ", "<", " ", "0"}], ",", "  ", 
         RowBox[{"res", " ", "=", " ", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<negative \>\"", ",", " ", "res"}], "]"}]}]}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"StringReplace", "[", 
         RowBox[{"res", ",", " ", 
          RowBox[{"{", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"ToString", "[", "TheSum", "]"}], "\[Rule]", " ", 
             "\"\<\>\""}], ",", " ", 
            RowBox[{
             RowBox[{"ToString", "[", "times", "]"}], "\[Rule]", " ", 
             "\"\<\>\""}], ",", "  ", 
            RowBox[{"\"\<, \>\"", " ", "\[Rule]", "  ", "join"}], ",", " ", 
            RowBox[{"\"\<[\>\"", " ", "\[Rule]", " ", "\"\<\>\""}], ",", " ", 
            RowBox[{"\"\<]\>\"", " ", "\[Rule]", " ", "\"\<\>\""}]}], "}"}]}],
          "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"speakq", " ", "===", " ", "True"}], ",", " ", 
         RowBox[{"Speak", "[", "res", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"LatestPronunciation", "[", "]"}], " ", "=", "res"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"StringReplace", "[", 
        RowBox[{"res", ",", " ", 
         RowBox[{"pause", " ", "\[Rule]", " ", "\"\<  \>\""}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PronounceIntegers", "[", "x__", "]"}], " ", ":=", " ", 
    RowBox[{"PlaceValue", "[", "x", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueH", "[", 
     RowBox[{"n_", ",", " ", "opts___Rule"}], "]"}], " ", ":=", " ", 
    RowBox[{"PlaceValue", "[", 
     RowBox[{
      RowBox[{"n", " ", "/.", " ", 
       RowBox[{"H", " ", "\[Rule]", " ", 
        RowBox[{"-", "1"}]}]}], ",", " ", "opts"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"digits", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "\"\<zero\>\"", ",", " ", "\"\<one\>\"", ",", " ", "\"\<two\>\"", ",", 
       " ", "\"\<three\>\"", ",", " ", "\"\<four\>\"", ",", " ", 
       "\"\<five\>\"", ",", " ", "\"\<six\>\"", ",", " ", "\"\<seven\>\"", 
       ",", " ", "\"\<eight\>\"", ",", " ", "\"\<nine\>\""}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"powers", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ten\>\"", ",", " ", "\"\<hundred\>\"", ",", " ", 
       "\"\<thousand\>\"", ",", " ", "\"\<myriad\>\"", ",", " ", 
       "\"\<lakh\>\"", ",", " ", "\"\<million\>\""}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "[", "IntegerDigits", "]"}], " ", "=", " ", 
     "digits"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "[", "Power", "]"}], " ", "=", " ", "powers"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "amp", " ", "=", "  ", "\"\<\!\(\*StyleBox[\"&\",FontSize->10]\)\>\""}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<English\>\"", "]"}], "  ", "=", " ",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"True", " ", "\[Rule]", "  ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negative\>\""}], ",", 
         "  ", 
         RowBox[{"And", "  ", "\[Rule]", " ", "\"\<&\>\""}], ",", " ", 
         RowBox[{"N", " ", "\[Rule]", " ", "digits"}], ",", " ", 
         RowBox[{"Power", " ", "\[Rule]", "  ", "powers"}]}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<Amplish\>\"", "]"}], "  ", "=", " ",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negative\>\""}], ",", 
          "  ", 
          RowBox[{"And", "  ", "\[Rule]", " ", "amp"}], ",", " ", 
          RowBox[{"N", " ", "\[Rule]", " ", "digits"}], ",", " ", 
          RowBox[{"Power", " ", "\[Rule]", "  ", "powers"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"\"\<English\>\"", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negative\>\""}], ",", 
          "  ", 
          RowBox[{"And", "  ", "\[Rule]", "  ", "\"\<&\>\""}], ",", " ", 
          RowBox[{"N", " ", "\[Rule]", " ", "digits"}], ",", " ", 
          RowBox[{"Power", " ", "\[Rule]", "  ", "powers"}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<Englishty\>\"", "]"}], "  ", "=", 
     " ", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negative\>\""}], ",", 
          "  ", 
          RowBox[{"And", "  ", "\[Rule]", " ", "amp"}], ",", " ", 
          RowBox[{"N", " ", "\[Rule]", " ", "digits"}], ",", " ", 
          "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<ty\>\"", ",", " ", "\"\<hundred\>\"", ",", " ", 
             "\"\<thousand\>\"", ",", " ", "\"\<myriad\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<million\>\""}], "}"}]}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"\"\<English\>\"", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negative\>\""}], ",", 
          "  ", 
          RowBox[{"And", "  ", "\[Rule]", "  ", "\"\<&\>\""}], ",", " ", 
          RowBox[{"N", " ", "\[Rule]", " ", "digits"}], ",", " ", 
          RowBox[{"Power", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<tee\>\"", ",", " ", "\"\<hundred\>\"", ",", " ", 
             "\"\<thousand\>\"", ",", " ", "\"\<myriad\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<million\>\""}], "}"}]}]}], 
         "}"}]}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"not", " ", "\"\<English\>\""}], ","}], " ", "*)"}], " ", 
       RowBox[{
       "\"\<Dutch\>\"", ",", " ", "\"\<French\>\"", ",", " ", 
        "\"\<German\>\"", ",", " ", "\"\<Danish\>\"", ",", " ", 
        "\"\<Amplish\>\"", ",", " ", "\"\<Englishty\>\""}], "}"}], " ", "//", 
      " ", "Sort"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<Checked\>\"", "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"{", "\"\<English\>\"", "}"}], " ", "~", "Join", "~", "  ", 
      RowBox[{"PlaceValueRules", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<Dutch\>\"", "]"}], "  ", "=", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<min\>\""}], " ", 
          RowBox[{"(*", " ", "\"\<negatief\>\"", " ", "*)"}], ",", " ", 
          RowBox[{"And", "  ", "\[Rule]", " ", "amp"}], ",", " ", 
          RowBox[{"(*", "\"\<en\>\"", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<nul\>\"", ",", " ", "\"\<een\>\"", ",", " ", "\"\<twee\>\"", 
             ",", " ", "\"\<drie\>\"", ",", " ", "\"\<vier\>\"", ",", " ", 
             "\"\<vijf\>\"", ",", " ", "\"\<zes\>\"", ",", " ", 
             "\"\<zeven\>\"", ",", " ", "\"\<acht\>\"", ",", " ", 
             "\"\<negen\>\""}], "}"}]}], ",", " ", "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<tig\>\"", ",", " ", "\"\<honderd\>\"", ",", " ", 
             "\"\<duizend\>\"", ",", " ", "\"\<myriad\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<miljoen\>\""}], "}"}]}]}], 
         "}"}]}], ",", "  ", "\[IndentingNewLine]", 
       RowBox[{"\"\<English\>\"", "\[Rule]", "  ", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<min\>\""}], " ", 
          RowBox[{"(*", "\"\<nayguhteef\>\"", "*)"}], ",", " ", 
          RowBox[{"And", " ", "\[Rule]", " ", "\"\<n\>\""}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<nuhl\>\"", ",", " ", "\"\<ayn\>\"", ",", " ", "\"\<tway\>\"",
              ",", " ", "\"\<dree\>\"", ",", " ", "\"\<fear\>\"", ",", " ", 
             "\"\<vaif\>\"", ",", " ", "\"\<zes\>\"", " ", ",", 
             "\"\<zayven\>\"", ",", "  ", "\"\<ahgt\>\"", 
             RowBox[{"(*", 
              RowBox[{"\"\<akht\>\"", " ", "\"\<ugt\>\""}], "*)"}], ",", 
             "  ", "\"\<naigen\>\""}], " ", "}"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<tikgh\>\"", ",", " ", "\"\<hon dairt\>\"", ",", " ", 
             "\"\<duuzand\>\"", ",", " ", "\"\<myriad\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<milyoon\>\""}], "}"}]}]}], 
         "}"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"deux", " ", "as", " ", "in", " ", "bird"}], ",", " ", 
     RowBox[{
     "but", " ", "no", " ", "way", " ", "to", " ", "get", " ", "it"}]}], 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<French\>\"", "]"}], "  ", "=", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negative\>\""}], " ", 
          ",", " ", 
          RowBox[{"And", "  ", "\[Rule]", "  ", "amp"}], ",", " ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"And", " ", "\[Rule]", " ", "\"\<et\>\""}], ","}], " ", 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<zero\>\"", ",", " ", "\"\<un\>\"", ",", " ", "\"\<deux\>\"", 
             ",", " ", "\"\<trois\>\"", ",", " ", "\"\<quatre\>\"", ",", " ", 
             "\"\<cinq\>\"", ",", " ", "\"\<six\>\"", ",", " ", 
             "\"\<sept\>\"", ",", " ", "\"\<huit\>\"", ",", " ", 
             "\"\<neuf\>\""}], " ", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<dix\>\"", ",", " ", "\"\<cent\>\"", ",", " ", 
             "\"\<mille\>\"", ",", " ", "\"\<myriade\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<million\>\""}], "}"}]}]}], 
         "}"}]}], ",", "  ", "\[IndentingNewLine]", 
       RowBox[{"\"\<English\>\"", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<nayguhteef\>\""}], 
          ",", " ", 
          RowBox[{"And", " ", "\[Rule]", " ", "\"\<ayh\>\""}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<zeyrouh\>\"", ",", " ", "\"\<uhnn\>\"", ",", " ", 
             "\"\<duh\>\"", ",", " ", "\"\<trouwah\>\"", ",", " ", 
             "\"\<kahtruh\>\"", ",", " ", "\"\<saink\>\"", ",", " ", 
             "\"\<sees\>\"", ",", " ", "\"\<seht\>\"", ",", " ", 
             "\"\<weet\>\"", ",", " ", "\"\<neuhf\>\""}], " ", "}"}]}], ",", 
          " ", "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<dees\>\"", ",", " ", "\"\<sun\>\"", ",", " ", "\"\<meel\>\"",
              ",", " ", "\"\<meeri udd\>\"", ",", " ", "\"\<lakh\>\"", ",", 
             " ", "\"\<meelyon\>\""}], "}"}]}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<German\>\"", "]"}], "  ", "=", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negativ\>\""}], " ", 
          ",", " ", 
          RowBox[{"And", "  ", "\[Rule]", " ", "amp"}], ",", " ", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"And", " ", "\[Rule]", " ", "\"\<und\>\""}], ","}], 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<null\>\"", ",", " ", "\"\<ein\>\"", ",", " ", "\"\<zwei\>\"",
              ",", " ", "\"\<drei\>\"", ",", " ", "\"\<vier\>\"", ",", " ", 
             "\"\<fuenf\>\"", ",", " ", "\"\<sechs\>\"", ",", " ", 
             "\"\<sieb\>\"", ",", " ", "\"\<acht\>\"", ",", " ", 
             "\"\<neun\>\""}], " ", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<zig\>\"", ",", " ", "\"\<hundert\>\"", ",", " ", 
             "\"\<tausend\>\"", ",", " ", "\"\<myriad\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<million\>\""}], "}"}]}]}], 
         "}"}]}], ",", "  ", "\[IndentingNewLine]", 
       RowBox[{"\"\<English\>\"", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<nayguhteef\>\""}], 
          ",", " ", 
          RowBox[{"And", " ", "\[Rule]", " ", "\"\<oond\>\""}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<noul\>\"", ",", " ", "\"\<ayen\>\"", ",", " ", 
             "\"\<tsvwaayie\>\"", ",", " ", "\"\<dryie\>\"", ",", " ", 
             "\"\<fear\>\"", ",", " ", "\"\<fuihnf\>\"", ",", " ", 
             "\"\<sex\>\"", ",", " ", "\"\<sieb\>\"", ",", " ", 
             "\"\<akht\>\"", ",", " ", "\"\<noin\>\""}], " ", "}"}]}], ",", 
          " ", "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<tzeeg\>\"", ",", " ", "\"\<hoondert\>\"", ",", " ", 
             "\"\<tausand\>\"", ",", " ", "\"\<myriad\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<meelyohn\>\""}], "}"}]}]}], 
         "}"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValueRules", "[", "\"\<Danish\>\"", "]"}], "  ", "=", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", " ", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<negativ\>\""}], " ", 
          ",", " ", 
          RowBox[{"And", "  ", "\[Rule]", " ", "amp"}], ",", " ", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"And", " ", "\[Rule]", " ", "\"\<og\>\""}], ","}], "*)"}],
           "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<nul\>\"", ",", " ", "\"\<en\>\"", ",", " ", "\"\<to\>\"", 
             ",", " ", "\"\<tre\>\"", ",", " ", "\"\<fire\>\"", ",", " ", 
             "\"\<fem\>\"", ",", " ", "\"\<seks\>\"", ",", " ", "\"\<syv\>\"",
              ",", " ", "\"\<otte\>\"", ",", " ", "\"\<ni\>\""}], " ", 
            "}"}]}], ",", " ", "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<ti\>\"", ",", " ", "\"\<hundrede\>\"", ",", " ", 
             "\"\<tusind\>\"", ",", " ", "\"\<myriade\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<million\>\""}], "}"}]}]}], 
         "}"}]}], ",", "  ", "\[IndentingNewLine]", 
       RowBox[{"\"\<English\>\"", "\[Rule]", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", "\"\<nayguhtew\>\""}], ",",
           " ", 
          RowBox[{"And", " ", "\[Rule]", " ", "\"\<oh\>\""}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<nul\>\"", ",", " ", "\"\<ayn\>\"", ",", " ", "\"\<toh\>\"", 
             ",", " ", "\"\<trya\>\"", ",", " ", "\"\<fear\>\"", ",", " ", 
             "\"\<fem\>\"", ",", " ", "\"\<sex\>\"", ",", " ", "\"\<suwe\>\"",
              ",", " ", "\"\<ude\>\"", ",", " ", "\"\<knee\>\""}], " ", 
            "}"}]}], ",", " ", "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
            "\"\<tee\>\"", ",", " ", "\"\<hoonah\>\"", ",", " ", 
             "\"\<toosind\>\"", ",", " ", "\"\<myriade\>\"", ",", " ", 
             "\"\<lakh\>\"", ",", " ", "\"\<meelyohn\>\""}], "}"}]}]}], 
         "}"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueRules", "[", 
     RowBox[{"Set", ",", " ", "lan_String", ",", " ", 
      RowBox[{"org_String:", "\"\<English\>\""}]}], "]"}], " ", " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"res", ",", " ", "f", ",", " ", "g", ",", " ", "zero"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Check", "[", 
        RowBox[{
         RowBox[{"IntegerName", "[", 
          RowBox[{"0", ",", " ", "\"\<Words\>\"", ",", " ", 
           RowBox[{"Language", " ", "->", " ", "lan"}]}], "]"}], ",", " ", 
         RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
        RowBox[{"IntegerName", "[", 
         RowBox[{"x", ",", " ", "\"\<Words\>\"", ",", " ", 
          RowBox[{"Language", " ", "->", " ", "lan"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"g", "[", "x_", "]"}], " ", ":=", " ", 
        RowBox[{"First", "[", 
         RowBox[{"WordTranslation", "[", 
          RowBox[{"x", ",", " ", 
           RowBox[{"org", " ", "\[Rule]", " ", "lan"}]}], "]"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Negative", " ", "\[Rule]", " ", 
           RowBox[{"g", "[", "\"\<negative\>\"", "]"}]}], ",", " ", 
          RowBox[{"And", " ", "\[Rule]", " ", 
           RowBox[{"g", "[", "\"\<and\>\"", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"N", " ", "\[Rule]", " ", 
           RowBox[{"(", 
            RowBox[{"f", " ", "/@", " ", 
             RowBox[{"Range", "[", 
              RowBox[{"0", ",", " ", "9"}], "]"}]}], ")"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          RowBox[{"Power", " ", "\[Rule]", "  ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"f", "[", "10", "]"}], ",", " ", 
             RowBox[{"f", "[", "100", "]"}], ",", " ", 
             RowBox[{"f", "[", "100", "]"}], ",", " ", "\"\<myriad\>\"", ",", 
             " ", "\"\<lakh\>\"", ",", "  ", 
             RowBox[{"g", "[", "\"\<million\>\"", "]"}]}], "}"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{
         RowBox[{"PlaceValueRules", "[", "]"}], ",", " ", "lan"}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"PlaceValueRules", "[", 
        RowBox[{"Check", ",", " ", "lan"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Set", "[", 
        RowBox[{
         RowBox[{"PlaceValueRules", "[", "lan", "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"True", " ", "\[Rule]", " ", "res"}], ",", "  ", 
           RowBox[{"org", " ", "\[Rule]", " ", "res"}]}], "}"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueRules", "[", 
     RowBox[{"Select", ",", " ", "item_", ",", " ", "lan_String", ",", " ", 
      RowBox[{"trans_String:", "\"\<English\>\""}]}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"res", ",", " ", "true"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"PlaceValueRules", "[", "]"}], ",", " ", "lan"}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res", " ", "=", " ", 
          RowBox[{"PlaceValueRules", "[", "lan", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"true", " ", "=", " ", 
          RowBox[{"True", " ", "/.", " ", "res"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"true", " ", "=", " ", 
          RowBox[{"item", " ", "/.", " ", "true"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"res", " ", "=", " ", 
          RowBox[{"trans", " ", "/.", " ", "res"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"res", " ", "=", " ", 
          RowBox[{"item", "/.", " ", "res"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Thread", "[", 
          RowBox[{"true", " ", "\[Rule]", " ", "res"}], "]"}]}], ",", " ", 
        "$Failed"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"compose", "[", 
     RowBox[{
     "digits_List", ",", " ", "lis_List", ",", " ", "pause_String", ",", " ", 
      "s_Integer", ",", " ", "neg_String", ",", " ", "and_String"}], "]"}], 
    " ", ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"combination", ",", " ", "paund"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"paund", " ", "=", " ", 
        RowBox[{
        "pause", " ", "<>", " ", "\"\< \>\"", "  ", "<>", " ", "and", " ", "<>",
          " ", "\"\<  \>\""}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"combination", " ", "=", "  ", 
        RowBox[{"MapThread", "[", 
         RowBox[{"StringJoin", ",", " ", 
          RowBox[{"{", 
           RowBox[{"digits", " ", ",", " ", "lis"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"combination", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"paund", " ", "<>", " ", "#"}], "  ", "&"}], "/@", " ", 
         "combination"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"combination", " ", "=", " ", 
        RowBox[{"StringJoin", " ", "@@", " ", "combination"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"combination", " ", "=", " ", 
        RowBox[{"StringDrop", "[", 
         RowBox[{"combination", ",", " ", 
          RowBox[{"StringLength", "[", "paund", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"s", " ", "<", " ", "0"}], ",", " ", 
         RowBox[{
         "neg", " ", "<>", " ", "pause", " ", "<>", " ", "combination"}], ",",
          " ", "combination"}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "PlaceValue", "]"}], " ", "=", " ", 
     RowBox[{"reset", " ", "=", " ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Show", " ", "\[Rule]", " ", "False"}], ",", " ", 
         RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Amplish\>\""}], ",", 
         " ", 
         RowBox[{
         "SpeakTransliteration", "  ", "\[RuleDelayed]", " ", "$Language"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Length", " ", "\[Rule]", " ", "300"}], " ", 
         RowBox[{"(*", " ", 
          RowBox[{"was", " ", "\"\< <silence msec=\\\"300\\\"/> \>\""}], " ", 
          "*)"}], ",", " ", "\[IndentingNewLine]", 
         RowBox[{"Simplify", " ", "\[Rule]", "  ", "True"}], ",", " ", 
         RowBox[{"Join", " ", "\[Rule]", " ", "\"\<\[CenterDot]\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"WordTranslation", " ", "\[Rule]", " ", "Automatic"}]}], 
        "}"}], "  ", "//", " ", "Sort"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValue", "[", 
     RowBox[{"Options", ",", " ", "\"\<Reset\>\""}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Unprotect", "[", "PlaceValue", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Options", "[", "PlaceValue", "]"}], " ", "=", " ", "reset"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "PlaceValue", "]"}], ";", " ", "reset"}], " ", 
     ")"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "rul"}], " ", "=", " ", 
     "\"\<No list of rules found for `1` `2`\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "int"}], " ", "=", " ", 
     "\"\<Initialisation with IntegerName and WordTranslation: please \
wait\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "len"}], " ", "=", " ", 
     "\"\<Length of `1` is not `2` but `3`\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "num"}], " ", "=", " ", 
     "\"\<No list of names found for `1` `2`\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "not"}], " ", "=", " ", 
     "\"\<Not tested: Speak with other than $Language\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "ran"}], " ", "=", " ", 
     "\"\<Integer not in domain -`1` < `2` < `1`\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "pau"}], " ", "=", " ", 
     "\"\<Pause length `1` must be a number\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "::", "str"}], " ", "=", " ", 
     "\"\<Symbol for `1` is `2` but must be a string\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"inputtest", "[", 
     RowBox[{
     "ns_", ",", " ", "ps_", ",", " ", "type_", ",", " ", "neg_", ",", " ", 
      "and_"}], "]"}], " ", ":=", "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"ListQ", "[", "ns", "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"PlaceValue", "::", "num"}], " ", ",", " ", 
           RowBox[{"{", 
            RowBox[{"type", ",", "\"\<digits\>\""}], "}"}], ",", " ", "ns"}], 
          "]"}], ";", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"ListQ", "[", "ps", "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"PlaceValue", "::", "num"}], " ", ",", 
           RowBox[{"{", 
            RowBox[{"type", ",", "\"\<powers\>\""}], "}"}], ",", " ", "ps"}], 
          "]"}], ";", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "ns", "]"}], " ", "=!=", " ", "10"}], ",", 
        " ", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"PlaceValue", "::", "len"}], " ", ",", 
           RowBox[{"{", 
            RowBox[{"type", ",", "\"\<digits\>\""}], "}"}], ",", " ", "10", 
           ",", " ", 
           RowBox[{"Length", "[", "ns", "]"}]}], "]"}], ";", " ", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "ps", "]"}], " ", "=!=", " ", "6"}], ",", " ", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"PlaceValue", "::", "len"}], " ", ",", " ", 
           RowBox[{"{", 
            RowBox[{"type", ",", "\"\<powers\>\""}], "}"}], ",", " ", "6", 
           ",", " ", 
           RowBox[{"Length", "[", "ps", "]"}]}], "]"}], ";", " ", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"StringQ", "[", "neg", "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"PlaceValue", "::", "str"}], ",", " ", "\"\<negative\>\"", 
           ",", " ", "neg"}], "]"}], ";", " ", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"StringQ", "[", "and", "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"PlaceValue", "::", "str"}], ",", " ", "\"\<and\>\"", ",", 
           " ", "and"}], "]"}], ";", " ", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "  ", ")"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pihelper", "[", 
     RowBox[{
     "n_Integer", ",", " ", "neg_String", ",", " ", "ipause_String", ",", " ",
       "nsi_List", ",", " ", "psi_List", ",", " ", "simpq_", ",", " ", 
      "join_String", ",", " ", "speakq_", ",", " ", "and_String"}], "]"}], 
    " ", ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "pause", ",", " ", "s", ",", " ", "powers", ",", " ", "d", ",", " ", 
        "digits", ",", " ", "len", ",", " ", "lis", ",", " ", "sel", ",", " ",
         "h", ",", " ", "zeros", ",", " ", "pos", ",", " ", "ns", " ", ",", 
        " ", "ps"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pause", " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"speakq", " ", "=!=", " ", "True"}], ",", " ", "\"\< \>\"", 
          ",", " ", "ipause"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"s", " ", "=", " ", 
        RowBox[{"Sign", "[", "n", "]"}]}], ";", " ", 
       RowBox[{"ns", " ", "=", " ", "nsi"}], ";", " ", 
       RowBox[{"ps", " ", "=", " ", "psi"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"**", " ", "actual"}], " ", "***)"}], "\[IndentingNewLine]", 
       RowBox[{"PrependTo", "[", 
        RowBox[{"ps", ",", " ", 
         RowBox[{"ns", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"powers", " ", "=", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"10", "^", "k"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"k", ",", " ", "0", ",", " ", "6"}], "}"}]}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"d", "=", " ", 
        RowBox[{"IntegerDigits", "[", "n", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"digits", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"ns", "[", 
           RowBox[{"[", 
            RowBox[{"#", "+", "1"}], "]"}], "]"}], "&"}], " ", "/@", " ", 
         "d"}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"len", " ", "=", " ", 
        RowBox[{"Length", "[", "d", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"lis", " ", "=", " ", 
        RowBox[{"Take", "[", 
         RowBox[{"ps", ",", " ", "len"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "basically", " ", "finished", " ", "but", " ", "simplification"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "1", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"simpq", " ", "===", " ", "True"}], ",", "  ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"h", " ", "=", " ", 
           RowBox[{"Last", "[", "d", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"ns", ",", " ", "\"\<\>\""}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"d", " ", "=", " ", 
           RowBox[{"d", " ", "/.", " ", 
            RowBox[{"1", " ", "\[Rule]", " ", "10"}]}]}], "  ", ";", 
          "\[IndentingNewLine]", 
          RowBox[{"digits", " ", "=", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"ns", "[", 
              RowBox[{"[", 
               RowBox[{"#", "+", "1"}], "]"}], "]"}], "&"}], " ", "/@", " ", 
            "d"}]}], ";", " ", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"h", " ", "=!=", " ", "1"}], ",", " ", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{
              "then", " ", "not", " ", "removed", " ", "at", " ", "the", " ", 
               "last", " ", "position"}], ",", " ", 
              RowBox[{"and", " ", "thus", " ", "adjust", " ", "lis"}]}], 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"lis", " ", "=", " ", 
              RowBox[{
               RowBox[{"{", "\"\<\>\"", "}"}], " ", "~", "Join", "~", " ", 
               RowBox[{"Rest", "[", "lis", "]"}]}]}], ";"}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{"reverse", ":", " ", 
             RowBox[{"india", " ", "and", " ", "arabia"}]}], " ", "*)"}], " ",
            "\[IndentingNewLine]", "]"}]}]}], "]"}], ";", " ", 
       RowBox[{"(*", 
        RowBox[{"end", " ", "simpq"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"lis", " ", "=", "  ", 
        RowBox[{"Reverse", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"join", " ", "<>", " ", "#"}], "  ", "&"}], "/@", " ", 
          "lis"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "0", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"simpq", " ", "===", " ", "True"}], " ", "&&", " ", 
          RowBox[{"d", " ", "=!=", " ", 
           RowBox[{"{", "0", "}"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"zeros", " ", "=", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"#", " ", "===", " ", "0"}], ",", " ", "0", ",", " ", 
               "1"}], "]"}], "&"}], " ", "/@", " ", "d"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"pos", " ", "=", " ", 
           RowBox[{"Position", "[", 
            RowBox[{"zeros", ",", " ", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"pos", " ", "=!=", " ", 
             RowBox[{"{", "}"}]}], ",", "  ", 
            RowBox[{"(*", 
             RowBox[{"superfluous", " ", "..."}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"digits", " ", "=", " ", 
              RowBox[{"Extract", "[", 
               RowBox[{"digits", ",", " ", "pos"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"lis", " ", "=", " ", 
              RowBox[{"Extract", "[", 
               RowBox[{"lis", ",", " ", "pos"}], "]"}]}], ";"}]}], 
           "\[IndentingNewLine]", "]"}]}]}], "]"}], ";", " ", 
       RowBox[{"(*", 
        RowBox[{"end", " ", "simpq"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"compose", "[", 
        RowBox[{
        "digits", ",", " ", "lis", ",", " ", "pause", ",", " ", "s", ",", " ",
          "neg", ",", " ", "and"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValue", "[", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"Catch", "[", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "ns", ",", " ", "ps", ",", " ", "speakq", ",", "  ", "combination", 
         ",", " ", "pause", ",", " ", "neg", ",", " ", "simpq", ",", " ", 
         "join", ",", " ", "translit", ",", " ", "lan", ",", " ", "rul", ",", 
         "  ", "lanrul", ",", " ", "nottested", ",", " ", "showq", ",", " ", 
         "missingq", ",", " ", "and"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "speakq", ",", " ", "pause", ",", " ", "simpq", ",", " ", "join", 
           ",", " ", "translit", ",", " ", "lan", ",", " ", "showq", ",", " ",
            "missingq"}], "}"}], "  ", "=", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "Speak", ",", " ", "Length", ",", " ", "Simplify", ",", " ", 
             "Join", ",", "SpeakTransliteration", ",", " ", "Language", ",", 
             " ", "Show", ",", " ", "WordTranslation"}], "}"}], " ", "/.", 
           " ", 
           RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
          RowBox[{"Options", "[", "PlaceValue", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"**", " ", "input"}], " ", "and", " ", "testing", " ", "of",
           " ", "it"}], " ", "***)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "also", " ", "test", " ", "even", " ", "when", " ", "not", " ", 
          "spoken"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"NumberQ", "[", "pause", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"pause", " ", "=", " ", 
           RowBox[{"\"\< <silence msec=\\\"\>\"", " ", "<>", " ", 
            RowBox[{"ToString", "[", "pause", "]"}], " ", "<>", " ", 
            "\"\<\\\"/> \>\""}]}], " ", ",", "\[IndentingNewLine]", " ", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"PlaceValue", "::", "pau"}], ",", " ", "pause"}], "]"}], 
           ";", 
           RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", "n", "]"}], " ", ">", " ", 
           RowBox[{
            RowBox[{"10", "^", "7"}], "-", "1"}]}], ",", " ", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"PlaceValue", "::", "ran"}], ",", "  ", "\"\<10^7\>\"", 
             ",", " ", "n"}], "]"}], ";", 
           RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nottested", " ", "=", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"speakq", " ", "===", " ", "True"}], " ", "&&", " ", 
           RowBox[{"translit", " ", "=!=", " ", "$Language"}]}], ")"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"nottested", ",", " ", 
          RowBox[{"Message", "[", 
           RowBox[{"PlaceValue", "::", "not"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"if", " ", 
          RowBox[{"lan", " ", "<>", " ", "$Language"}], " ", "then", " ", 
          "write", " ", "in", " ", "lan", " ", "True", " ", "or", " ", 
          "speak", " ", "in", " ", "translit"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"lanrul", " ", "=", "  ", 
         RowBox[{"PlaceValueRules", "[", "lan", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"ListQ", "[", "lanrul", "]"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"PlaceValue", "::", "rul"}], " ", ",", " ", 
             "\"\<language\>\"", ",", " ", "lan"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"missingq", " ", "===", " ", "Automatic"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Message", "[", 
               RowBox[{"PlaceValue", "::", "int"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Check", "[", 
               RowBox[{
                RowBox[{"IntegerName", "[", 
                 RowBox[{"0", ",", " ", "\"\<Words\>\"", ",", " ", 
                  RowBox[{"Language", " ", "->", " ", "lan"}]}], "]"}], ",", 
                " ", 
                RowBox[{"Throw", "[", "$Failed", "]"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"PlaceValueRules", "[", 
               RowBox[{"Set", ",", "lan"}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Throw", "[", "$Failed", "]"}]}], "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lan", " ", "===", " ", "translit"}], ",", " ", 
          RowBox[{"translit", " ", "=", " ", "True"}]}], "]"}], ";", " ", 
        RowBox[{"(*", "key", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "using", " ", "a", " ", "switch", " ", "in", " ", "case", " ", 
          "only", " ", "one", " ", "call", " ", "suffices"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"rul", " ", "=", " ", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"speakq", " ", "===", " ", "True"}], ")"}], ",", " ", 
            "translit", ",", " ", "True"}], "]"}], " ", "/.", " ", 
          "lanrul"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"ListQ", "[", "rul", "]"}]}], ",", " ", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"PlaceValue", "::", "rul"}], " ", ",", 
             RowBox[{"{", 
              RowBox[{"translit", ",", " ", "True"}], "}"}], ",", " ", 
             "rul"}], "]"}], ";", 
           RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ns", ",", " ", "ps", ",", "  ", "neg", ",", " ", "and"}], 
          "}"}], "  ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "N", ",", " ", "Power", ",", " ", "Negative", ",", " ", "And"}], 
            "}"}], " ", "/.", " ", 
           RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", "rul"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"inputtest", "[", 
         RowBox[{
         "ns", ",", " ", "ps", ",", " ", "speakq", ",", " ", "neg", ",", " ", 
          "and"}], "]"}], " ", ";", "\[IndentingNewLine]", 
        RowBox[{"combination", " ", "=", " ", 
         RowBox[{"pihelper", "[", 
          RowBox[{
          "n", ",", " ", "neg", ",", " ", "pause", ",", " ", "ns", ",", " ", 
           "ps", ",", " ", "simpq", ",", " ", "join", ",", " ", "speakq", ",",
            " ", "and"}], "]"}]}], " ", ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"LatestPronunciation", "[", "]"}], " ", "=", "combination"}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"speakq", " ", "=!=", " ", "True"}], ",", " ", 
          "\[IndentingNewLine]", "combination", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Speak", "[", "combination", "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"showq", " ", "===", " ", "True"}], ",", " ", 
             "combination", ",", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "redo", " ", "the", " ", "whole", " ", "thing", " ", "for", " ",
                "the", " ", "written", " ", "version"}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "overdone", " ", "to", " ", "turn", " ", "this", " ", "into", 
               " ", "a", " ", "subroutine"}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"rul", " ", "=", " ", 
               RowBox[{"True", " ", "/.", " ", "lanrul"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"!", 
                 RowBox[{"ListQ", "[", "rul", "]"}]}], ",", " ", 
                RowBox[{
                 RowBox[{"Message", "[", 
                  RowBox[{
                   RowBox[{"PlaceValue", "::", "rul"}], " ", ",", 
                   RowBox[{"{", 
                    RowBox[{"translit", ",", " ", "True"}], "}"}], ",", " ", 
                   "rul"}], "]"}], ";", 
                 RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"ns", ",", " ", "ps", ",", "  ", "neg", ",", "and"}], 
                "}"}], "  ", "=", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                  "N", ",", " ", "Power", ",", " ", "Negative", ",", " ", 
                   "And"}], "}"}], " ", "/.", " ", 
                 RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", "rul"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"inputtest", "[", 
               RowBox[{
               "ns", ",", " ", "ps", ",", " ", "False", ",", " ", "neg", ",", 
                " ", "and"}], "]"}], " ", ";", "\[IndentingNewLine]", 
              RowBox[{"combination", " ", "=", " ", 
               RowBox[{"pihelper", "[", 
                RowBox[{
                "n", ",", " ", "neg", ",", " ", "pause", ",", " ", "ns", ",", 
                 " ", "ps", ",", " ", "simpq", ",", " ", "join", ",", " ", 
                 "False", ",", "and"}], "]"}]}]}]}], " ", 
            "\[IndentingNewLine]", "]"}]}]}], "]"}]}]}], " ", 
      RowBox[{"(*", "endif", "*)"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
   " ", 
   RowBox[{"(*", 
    RowBox[{"end", " ", "catch", " ", "module"}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], "]"}], " ", ":=", 
    " ", 
    RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "y_", ",", " ", "x_"}], "}"}], "]"}], " ", ":=", 
    " ", 
    RowBox[{"{", " ", 
     RowBox[{"myspeak", "[", 
      RowBox[{
       RowBox[{"y", " ", "*", " ", "10"}], " ", "+", " ", "x"}], "]"}], 
     "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", 
      RowBox[{"z_", ",", " ", "0", ",", " ", "0"}], "}"}], "]"}], " ", ":=", 
    " ", 
    RowBox[{"{", 
     RowBox[{"speak", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "z", "]"}], " ", "<>", "  ", "hundred"}], 
      "]"}], "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", 
      RowBox[{"z_", ",", " ", "y_", ",", " ", "x_"}], "}"}], "]"}], " ", ":=",
     " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"speak", "[", 
       RowBox[{
        RowBox[{"ToString", "[", "z", "]"}], " ", "<>", " ", "hundred"}], 
       "]"}], ",", " ", "nfx", ",", " ", 
      RowBox[{"myspeak", "[", 
       RowBox[{
        RowBox[{"y", " ", "*", " ", "10"}], " ", "+", " ", "x"}], "]"}]}], 
     "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0"}], "}"}], "]"}], " ", ":=", " ", 
    RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", 
      RowBox[{"y_", ",", " ", "x_"}], "}"}], "]"}], " ", ":=", " ", 
    RowBox[{"{", 
     RowBox[{"myspeak", "[", 
      RowBox[{
       RowBox[{"y", " ", "*", " ", "10"}], " ", "+", " ", "x"}], "]"}], 
     "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", "0", "}"}], "]"}], " ", ":=", " ", 
    RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tosimp", "[", 
     RowBox[{"{", "x_", "}"}], "]"}], " ", ":=", " ", 
    RowBox[{"{", 
     RowBox[{"speak", "[", "x", "]"}], "}"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tospeak", "[", 
     RowBox[{"{", 
      RowBox[{"z_", ",", " ", "y_", ",", " ", "x_"}], "}"}], "]"}], " ", ":=",
     " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"speak", "[", 
       RowBox[{
        RowBox[{"ToString", "[", "z", "]"}], " ", "<>", " ", "hundred"}], 
       "]"}], ",", "nfx", ",", "  ", 
      RowBox[{"myspeak", "[", 
       RowBox[{
        RowBox[{"y", " ", "*", " ", "10"}], " ", "+", " ", "x"}], "]"}]}], 
     "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tospeak", "[", 
     RowBox[{"{", 
      RowBox[{"y_", ",", " ", "x_"}], "}"}], "]"}], " ", ":=", " ", 
    RowBox[{"{", 
     RowBox[{"myspeak", "[", 
      RowBox[{
       RowBox[{"y", " ", "*", " ", "10"}], " ", "+", " ", "x"}], "]"}], 
     "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tospeak", "[", 
     RowBox[{"{", "x_", "}"}], "]"}], " ", ":=", " ", 
    RowBox[{"{", 
     RowBox[{"speak", "[", "x", "]"}], "}"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"this", " ", "applies", " ", "to", " ", "g"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tospeak", "[", "1", "]"}], " ", ":=", " ", "one"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tospeak", "[", "x_Integer", "]"}], " ", ":=", " ", 
    RowBox[{"speak", "[", "x", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "PlaceValueBlock", "]"}], " ", "=", " ", 
     RowBox[{"resetblock", " ", "=", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Language", "  ", "\[Rule]", " ", "\"\<Amplish\>\""}], ",", 
         " ", 
         RowBox[{"And", " ", "\[Rule]", " ", "\"\<&\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Length", " ", "\[Rule]", " ", "300"}], ",", " ", 
         RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
         RowBox[{"Join", "  ", "\[Rule]", " ", "\"\<\[CenterDot]\>\""}], ",", 
         " ", 
         RowBox[{"Simplify", " ", "\[Rule]", " ", "True"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Power", " ", "\[Rule]", "  ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "^", "6"}], " ", "\[Rule]", " ", 
             "\"\<million\>\""}], ",", " ", 
            RowBox[{
             RowBox[{"10", "^", "3"}], " ", "\[Rule]", " ", 
             "\"\<thousand\>\""}], ",", " ", 
            RowBox[{"100", " ", "->", " ", "\"\<hundred\>\""}]}], "}"}]}]}], 
        "}"}], " ", "//", " ", "Sort"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueBlock", "[", 
     RowBox[{"Options", ",", " ", "\"\<Reset\>\""}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Unprotect", "[", "PlaceValueBlock", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Options", "[", "PlaceValueBlock", "]"}], " ", "=", " ", 
       "resetblock"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "PlaceValueBlock", "]"}], ";", " ", 
      "resetblock"}], " ", ")"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueBlock", "[", 
     RowBox[{"SetOptions", ",", " ", "lan_String"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "rul", ",", " ", "numbers", ",", " ", "words", ",", " ", "trans", ",", 
        " ", "default"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"default", ",", " ", "rul"}], "}"}], " ", "=", " ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Language", ",", " ", "Power"}], "}"}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValueBlock", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"numbers", ",", " ", "words"}], "}"}], " ", "=", " ", 
        RowBox[{"Transpose", "[", 
         RowBox[{"rul", " ", "/.", " ", 
          RowBox[{"Rule", " ", "\[Rule]", " ", "List"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"trans", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"WordTranslation", "[", 
           RowBox[{"#", ",", " ", 
            RowBox[{"default", " ", "\[Rule]", " ", "lan"}]}], "]"}], "&"}], 
         " ", "/@", " ", "words"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"trans", " ", "=", " ", 
        RowBox[{"First", " ", "/@", " ", "trans"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"PlaceValueBlock", ",", " ", 
         RowBox[{"Language", " ", "\[Rule]", " ", "lan"}], ",", " ", 
         RowBox[{"Power", " ", "\[Rule]", " ", 
          RowBox[{"Thread", "[", 
           RowBox[{"numbers", " ", "\[Rule]", " ", "trans"}], "]"}]}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PlaceValueBlock", "[", 
     RowBox[{"n_Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "h", ",", " ", "len", ",", " ", "g", ",", " ", "q", ",", " ", "p", ",",
         " ", "res", ",", " ", "pause", ",", " ", "rep", ",", " ", "speakq", 
        ",", " ", "join", ",", " ", "rule100", ",", " ", "simpq", ",", " ", 
        "and", ",", " ", "paund"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "pause", ",", " ", "rep", ",", " ", "speakq", ",", " ", "join", ",", 
          " ", "simpq", ",", " ", "and"}], "}"}], "  ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "Length", ",", " ", "Power", ",", " ", "Speak", ",", " ", "Join", 
            ",", " ", "Simplify", ",", " ", "And"}], "}"}], " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "PlaceValueBlock", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"hundred", " ", "=", " ", 
        RowBox[{
        "\"\< \>\"", " ", "<>", " ", "join", " ", "<>", " ", "\"\< \>\"", " ",
          "<>", "  ", 
         RowBox[{"(", 
          RowBox[{"100", " ", "/.", " ", "rep"}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"StringQ", "[", "and", "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"PlaceValue", "::", "str"}], ",", " ", "\"\<and\>\"", ",",
             " ", "and"}], "]"}], ";", " ", 
          RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"rule100", " ", "=", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"100", " ", "/.", " ", "rep"}], ")"}], " ", "\[Rule]", 
         "  ", "\"\<100\>\""}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"speakq", " ", "=", " ", 
        RowBox[{"speakq", " ", "===", " ", "True"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "pause", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"pause", " ", "=", " ", 
          RowBox[{"\"\< <silence msec=\\\"\>\"", " ", "<>", " ", 
           RowBox[{"ToString", "[", 
            RowBox[{"Round", "[", 
             RowBox[{"pause", "/", "2"}], "]"}], "]"}], " ", "<>", " ", 
           "\"\<\\\"/> \>\""}]}], " ", ",", "\[IndentingNewLine]", " ", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"PlaceValue", "::", "pau"}], ",", " ", "pause"}], "]"}], 
          ";", 
          RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"h", " ", "=", " ", 
        RowBox[{"IntegerDigits", "[", "n", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"len", " ", "=", " ", 
        RowBox[{"Length", "[", "h", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"g", " ", "=", " ", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"10", "^", "k"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"k", ",", " ", "0", ",", " ", 
             RowBox[{"len", "-", "1"}], ",", " ", "3"}], "}"}]}], "]"}], " ", 
         "//", "Reverse"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"p", " ", "=", " ", 
        RowBox[{"Partition", "[", 
         RowBox[{
          RowBox[{"Reverse", "[", "h", "]"}], ",", " ", 
          RowBox[{"UpTo", "[", "3", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"p", " ", "=", " ", 
        RowBox[{"Reverse", "[", 
         RowBox[{"Reverse", " ", "/@", " ", "p"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"simpq", " ", "===", " ", "True"}], ",", " ", 
         RowBox[{"q", " ", "=", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"u", "/@", " ", 
             RowBox[{"(", 
              RowBox[{"tosimp", " ", "/@", " ", "p"}], ")"}]}], ")"}], "  ", "/.",
            " ", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"{", "}"}], "]"}], " ", "\[RuleDelayed]", " ", 
            RowBox[{"u", "[", "]"}]}]}]}]}], " ", "]"}], ";", "  ", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"simpq", " ", "=!=", " ", "True"}], ",", " ", 
         RowBox[{"q", " ", "=", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"u", "/@", " ", 
             RowBox[{"(", 
              RowBox[{"tospeak", " ", "/@", " ", "p"}], ")"}]}], ")"}], "  ", 
           "/.", " ", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"{", "}"}], "]"}], " ", "\[RuleDelayed]", " ", 
            RowBox[{"u", "[", "]"}]}]}]}]}], " ", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"g", " ", "=", " ", 
        RowBox[{"(", 
         RowBox[{"u", " ", "/@", " ", 
          RowBox[{"(", 
           RowBox[{"tospeak", " ", "/@", " ", "g"}], ")"}]}], ")"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{
         RowBox[{"Inner", "[", 
          RowBox[{"w", ",", " ", "q", ",", "  ", "g", ",", "  ", "head"}], 
          "]"}], "/.", " ", 
         RowBox[{"u", " ", "\[Rule]", " ", "Sequence"}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{
         RowBox[{"res", " ", "/.", " ", 
          RowBox[{
           RowBox[{"w", "[", "]"}], " ", "\[RuleDelayed]", " ", 
           RowBox[{"Sequence", "[", "]"}]}]}], "  ", "/.", " ", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"speak", "[", "y_", "]"}], "]"}], " ", "\[RuleDelayed]", 
          " ", 
          RowBox[{"Sequence", "[", "]"}]}]}]}], ";", "  ", 
       RowBox[{"(*", 
        RowBox[{"zero", " ", "weights"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", 
        RowBox[{
         RowBox[{"res", " ", "/.", "  ", 
          RowBox[{"w", " ", "\[Rule]", " ", "List"}]}], " ", "/.", " ", 
         RowBox[{"head", " ", "\[Rule]", " ", "List"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"res", " ", "/.", " ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x___List", ",", " ", "one"}], "}"}], " ", 
          "\[RuleDelayed]", " ", "x"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"speakq", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"sp", "[", "x_", "]"}], " ", ":=", " ", 
          RowBox[{"Hold", "[", 
           RowBox[{
            RowBox[{"Speak", "[", "x", "]"}], ";", " ", "x"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"sp", "[", "x_", "]"}], " ", ":=", " ", 
          RowBox[{"Hold", "[", "x", "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"mysp", "[", "x_", "]"}], " ", ":=", " ", 
        RowBox[{"Hold", "[", 
         RowBox[{"PlaceValueDigits$Language", "[", 
          RowBox[{"x", ",", " ", 
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"Speak", " ", "\[Rule]", " ", "speakq"}], ",", " ", 
             RowBox[{"And", " ", "\[Rule]", " ", "and"}], ",", "  ", "opts"}],
             "]"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"never", " ", "show", " ", "the", " ", "pause"}], " ", "*)"}],
        "\[IndentingNewLine]", 
       RowBox[{"paund", " ", "=", " ", 
        RowBox[{"pause", " ", "<>", "and", " ", "<>", " ", "pause"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"and", " ", "=", " ", 
        RowBox[{"\"\< \>\"", "<>", "and", "<>", "\"\< \>\""}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"Riffle", "[", 
         RowBox[{"res", ",", " ", 
          RowBox[{"If", "[", 
           RowBox[{"speakq", ",", " ", 
            RowBox[{"Hold", "[", 
             RowBox[{
              RowBox[{"Speak", "[", "paund", "]"}], ";", " ", "and"}], "]"}], 
            ",", " ", "and"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", " ", "<", " ", "0"}], ",", " ", 
         RowBox[{"PrependTo", "[", 
          RowBox[{"res", ",", " ", 
           RowBox[{"Hold", "[", 
            RowBox[{
             RowBox[{"Speak", "[", "\"\<negative\>\"", "]"}], ";", 
             "\"\<negative\>\""}], "]"}]}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"res", " ", "/.", " ", "rep"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"res", " ", "/.", " ", 
         RowBox[{"nfx", " ", "\[Rule]", " ", 
          RowBox[{"sp", "[", "and", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"res", " ", "/.", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"myspeak", " ", "\[Rule]", " ", "mysp"}], ",", " ", 
           RowBox[{"speak", " ", "\[Rule]", " ", "sp"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"LatestPronunciation", "[", "Hold", "]"}], " ", "=", "res"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"ReleaseHold", "[", "res", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"LatestPronunciation", "[", "]"}], " ", "=", "res"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "=", " ", 
        RowBox[{"res", " ", "/.", " ", 
         RowBox[{"(", 
          RowBox[{"rep", " ", "/.", " ", 
           RowBox[{
            RowBox[{"Rule", "[", 
             RowBox[{"a_", ",", " ", "b_"}], "]"}], " ", "\[RuleDelayed]", 
            " ", 
            RowBox[{"Rule", "[", 
             RowBox[{"b", ",", " ", "a"}], "]"}]}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", " ", "/.", " ", 
        RowBox[{"x_String", " ", "\[RuleDelayed]", " ", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"x", ",", " ", "rule100"}], "]"}]}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"End", "[", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", 
     RowBox[{
     "PlaceValue", ",", " ", "PlaceValueH", ",", " ", "PronounceIntegers", 
      ",", " ", "SpeakTransliteration", ",", " ", "PlaceValueBlock", ",", " ",
       "PlaceValueDigits", ",", " ", "PlaceValueDigits$Language", ",", 
      "PronounceIntegerReadMe", ",", " ", "PronounceInteger", ",", " ", 
      "PartialPlaceValue", ",", " ", "PlaceValueTable"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"EndPackage", "[", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"857aa95a-df77-4958-8d1e-e7af0224747a"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "Get","noopen",
    "\"Cannot open \\!\\(\\*FormBox[\\\"\\\\\\\"Cool`MathEd`H`\\\\\\\"\\\", \
TraditionalForm]\\).\"",2,363,81,32540151164407676168,"Local"},
   "MessageTemplate"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"b5b027a4-1624-4789-90e6-a9916cc6736a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["MathEd`CCSSMath`", "Subsubsection",ExpressionUUID->"5a8dd12a-3de4-44d6-9ecb-831c36ab298e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "Cool`MathEd`CCSSMath`"}], " ", "package"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "*******************************************)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Author", ":", " ", 
    RowBox[{"Thomas", " ", "Cool"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Copyright", ":", " ", 
    RowBox[{
     RowBox[{"Copyright", " ", "2018", " ", "Thomas", " ", "Cool"}], " ", "-",
      " ", 
     RowBox[{
     "except", " ", "for", " ", "CCSS", " ", "texts", " ", "of", " ", 
      "course"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Package", " ", "Version"}], ":", " ", "1.0"}], ",", " ", 
    RowBox[{"May", " ", "16", " ", "2018"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Mathematica", " ", "Version"}], ":", "11.2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", "Reference", ":", " ", "http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"www", ".", "corestandards", ".", "org"}], "/", "Math"}], "/", 
      "Content"}], "/", "NBT"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Keywords", ":"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", "Limitation", ":"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", "License", ":", " ", 
     RowBox[{"see", " ", 
      RowBox[{"http", ":"}]}]}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{"thomascool", ".", "eu"}], "/", "TheEconomicsPack"}], "/", 
     RowBox[{"index", ".", "html"}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"BeginPackage", "[", 
     RowBox[{"\"\<Cool`MathEd`CCSSMath`\>\"", ",", " ", 
      RowBox[{"{", "\"\<Cool`MathEd`PronounceInteger`\>\"", "}"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "[", 
     RowBox[{"CCSSMathContent", ",", " ", "CCSSMathExercise"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "::", "usage"}], " ", "=", " ", 
     "\"\<CCSSMathContent[domain, grade, labels] quotes the CCCSS standards \
for the domain and grade.\\nCCSSMathContent[] contains the list what is \
included in the package. Only included is NBT = Number & Operations in Base \
Ten, and then only for Kindergarten, Grade 1 and a bit of Grade 2\>\""}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathExercise", "::", "usage"}], " ", "=", " ", 
     "\"\<CCSSMathExercise[n, ..., m, opts] passes the numbers on to a \
routine that recognises the CCSSMathContent labels in opts, see \
Options[CCSSMathExercise] and CCSSMathContent. When Show -> True then the \
CCSSMathContent on those labels is shown (default \
False)\\nCCSSMathExercice[n, m:10] for \\\"Grade\\\" -> \\\"Kindergarten\\\" \
or \\\"Grade 1\\\" counts from m to n. Defaults Speak -> False, IntegerDigits \
-> False (if True, the exercise question shows digits, but still speaks full \
place value)\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "CCSSMathExercise", "]"}], " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Domain", " ", "\[Rule]", " ", "\"\<NBT\>\""}], ",", " ", 
       RowBox[{"\"\<Grade\>\"", " ", "\[Rule]", " ", "\"\<Kindergarten\>\""}],
        ",", " ", 
       RowBox[{"\"\<Code\>\"", " ", "\[Rule]", " ", "\"\<A.1\>\""}], ",", " ", 
       RowBox[{"Show", " ", "\[Rule]", " ", "False"}], ",", " ", 
       RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
       RowBox[{"IntegerDigits", "\[Rule]", " ", "False"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CCSSMathExercise", "[", 
     RowBox[{"n__Integer", ",", " ", "opts___Rule"}], "]"}], " ", ":=", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sq", ",", " ", "kind", ",", " ", "res"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"kind", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Grade\>\"", ",", "Domain", ",", " ", "\"\<Code\>\""}],
            "}"}], " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "CCSSMathExercise", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"sq", " ", "=", " ", 
        RowBox[{
         RowBox[{"Show", " ", "/.", " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "CCSSMathExercise", "]"}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"sq", " ", "===", " ", "True"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"res", " ", "=", " ", 
           RowBox[{"CCSSMathContent", " ", "@@", " ", "kind"}]}], ";", " ", 
          RowBox[{"Print", "[", "res", "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CCSSMathExercise", "[", 
        RowBox[{"n", ",", "  ", "kind", ",", " ", "opts"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathExercise", "::", "ran"}], " ", "=", " ", 
     "\"\<Number `1` must be in range `2`\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CCSSMathExercise", "[", 
     RowBox[{"n_Integer", ",", "m___Integer", " ", ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Kindergarten\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", 
        "\"\<A.1\>\""}], "}"}], ",", " ", "opts___Rule"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"10", " ", "<", " ", "n", " ", "<", " ", "20"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"CCSSMathExercise", "[", 
       RowBox[{
       "\"\<Kindergarten\>\"", ",", " ", "Count", ",", " ", "n", ",", "m", 
        ",", " ", "opts"}], "]"}], " ", ",", " ", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"CCSSMathExercise", "::", "ran"}], ",", " ", "n", ",", " ", 
        "\"\<11-19\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CCSSMathExercise", "[", 
     RowBox[{
     "\"\<Kindergarten\>\"", ",", " ", "Count", ",", "xtext_String", ",", " ",
       "basetext_String", ",", " ", "ytext_String"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"StringReplace", "[", 
     RowBox[{
     "\"\<You know the numbers yyy and base, and how to speak them. You now \
count yyy up from base, and then you find the number xxx. You now learn to \
speak the number xxx.\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<xxx\>\"", " ", "\[Rule]", "  ", "xtext"}], ",", " ", 
        RowBox[{"\"\<base\>\"", " ", "->", " ", "basetext"}], ",", " ", 
        RowBox[{"\"\<yyy\>\"", " ", "\[Rule]", "  ", "ytext"}]}], "}"}]}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CCSSMathExercise", "[", 
     RowBox[{
     "\"\<Kindergarten\>\"", ",", " ", "Count", ",", " ", "x_Integer", ",", 
      " ", 
      RowBox[{"base_Integer:", "10"}], ",", " ", "opts___Rule"}], "]"}], " ", 
    ":=", " ", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "xtext", ",", " ", "basetext", ",", " ", "ytext", ",", " ", "digits", 
        ",", " ", "speakq", ",", " ", "f", ",", " ", "famp", ",", " ", "fpv", 
        ",", " ", "toshow", ",", " ", "tospeak"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"digits", ",", " ", "speakq"}], "}"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"IntegerDigits", ",", " ", "Speak"}], "}"}], " ", "/.", 
          " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "CCSSMathExercise", "]"}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"fpv", " ", "=", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PlaceValue", "[", 
           RowBox[{"#", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
            RowBox[{"Language", " ", "\[Rule]", " ", "\"\<English\>\""}], ",",
             " ", "opts"}], "]"}], "&"}], ")"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"famp", " ", "=", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PlaceValue", "[", 
           RowBox[{"#", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
            RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Amplish\>\""}], ",",
             " ", "opts"}], "]"}], "&"}], ")"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"to", " ", "show"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"f", " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"digits", " ", "===", " ", "False"}], ",", " ", "famp", ",",
           " ", "ToString"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"xtext", ",", " ", "basetext", ",", " ", "ytext"}], "}"}], 
        " ", "=", " ", 
        RowBox[{"f", " ", "/@", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", " ", "base", ",", " ", 
           RowBox[{"x", " ", "-", " ", "base"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"toshow", " ", "=", " ", 
        RowBox[{"CCSSMathExercise", "[", 
         RowBox[{
         "\"\<Kindergarten\>\"", ",", " ", "Count", ",", "xtext", ",", " ", 
          "basetext", ",", " ", "ytext"}], "]"}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"to", " ", "speak"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"speakq", " ", "===", " ", "True"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xtext", ",", " ", "basetext", ",", " ", "ytext"}], "}"}],
            " ", "=", " ", 
           RowBox[{"fpv", " ", "/@", " ", 
            RowBox[{"{", 
             RowBox[{"x", ",", " ", "base", ",", " ", 
              RowBox[{"x", " ", "-", " ", "base"}]}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"tospeak", " ", "=", " ", 
           RowBox[{"CCSSMathExercise", "[", 
            RowBox[{
            "\"\<Kindergarten\>\"", ",", " ", "Count", ",", "xtext", ",", " ",
              "basetext", ",", " ", "ytext"}], "]"}]}], " ", ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"LatestPronunciation", "[", "]"}], " ", "=", " ", 
           "tospeak"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Speak", "[", "tospeak", "]"}]}]}], "\[IndentingNewLine]", 
        "]"}], ";", " ", "\[IndentingNewLine]", "toshow"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CCSSMathExercise", "[", 
     RowBox[{"n_Integer", ",", " ", "m___Integer", ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", "\"\<A.1\>\""}], 
       "}"}], ",", " ", "opts___Rule"}], "]"}], " ", ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"0", " ", "<=", " ", "n", " ", "<=", " ", "120"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"CCSSMathExercise", "[", 
       RowBox[{"Count", ",", " ", "n", ",", " ", "m", ",", " ", "opts"}], 
       "]"}], " ", ",", " ", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"CCSSMathExercise", "::", "ran"}], ",", " ", "n", ",", " ", 
        "\"\<0-120\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CCSSMathExercise", "[", 
     RowBox[{
     "Count", ",", "xtext_String", ",", " ", "basetext_String", ",", " ", 
      "ytext_String"}], "]"}], " ", ":=", "\[IndentingNewLine]", 
    RowBox[{"StringReplace", "[", 
     RowBox[{
     "\"\<You know the numbers yyy and base, and how to write and speak them. \
You now count yyy up from base, and then you find the number xxx. You now \
learn to write and speak the number xxx.\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<xxx\>\"", " ", "\[Rule]", "  ", "xtext"}], ",", " ", 
        RowBox[{"\"\<base\>\"", " ", "->", " ", "basetext"}], ",", " ", 
        RowBox[{"\"\<yyy\>\"", " ", "\[Rule]", "  ", "ytext"}]}], "}"}]}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CCSSMathExercise", "[", 
     RowBox[{"Count", ",", " ", "x_Integer", ",", " ", 
      RowBox[{"base_Integer:", "10"}], ",", " ", "opts___Rule"}], "]"}], " ", 
    ":=", " ", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "xtext", ",", " ", "basetext", ",", " ", "ytext", ",", " ", "digits", 
        ",", " ", "speakq", ",", " ", "f", ",", " ", "famp", ",", " ", "fpv", 
        ",", " ", "toshow", ",", " ", "tospeak"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"digits", ",", " ", "speakq"}], "}"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"IntegerDigits", ",", " ", "Speak"}], "}"}], " ", "/.", 
          " ", 
          RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
         RowBox[{"Options", "[", "CCSSMathExercise", "]"}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"fpv", " ", "=", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PlaceValue", "[", 
           RowBox[{"#", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
            RowBox[{"Language", " ", "\[Rule]", " ", "\"\<English\>\""}], ",",
             " ", "opts"}], "]"}], "&"}], ")"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"famp", " ", "=", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PlaceValue", "[", 
           RowBox[{"#", ",", " ", 
            RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
            RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Amplish\>\""}], ",",
             " ", "opts"}], "]"}], "&"}], ")"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"to", " ", "show"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"f", " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"digits", " ", "===", " ", "False"}], ",", " ", "famp", ",",
           " ", "ToString"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"xtext", ",", " ", "basetext", ",", " ", "ytext"}], "}"}], 
        " ", "=", " ", 
        RowBox[{"f", " ", "/@", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", " ", "base", ",", " ", 
           RowBox[{"x", " ", "-", " ", "base"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"toshow", " ", "=", " ", 
        RowBox[{"CCSSMathExercise", "[", 
         RowBox[{
         "Count", ",", "xtext", ",", " ", "basetext", ",", " ", "ytext"}], 
         "]"}]}], " ", ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"to", " ", "speak"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"speakq", " ", "===", " ", "True"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xtext", ",", " ", "basetext", ",", " ", "ytext"}], "}"}],
            " ", "=", " ", 
           RowBox[{"fpv", " ", "/@", " ", 
            RowBox[{"{", 
             RowBox[{"x", ",", " ", "base", ",", " ", 
              RowBox[{"x", " ", "-", " ", "base"}]}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"tospeak", " ", "=", " ", 
           RowBox[{"CCSSMathExercise", "[", 
            RowBox[{
            "Count", ",", "xtext", ",", " ", "basetext", ",", " ", "ytext"}], 
            "]"}]}], " ", ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"LatestPronunciation", "[", "]"}], " ", "=", " ", 
           "tospeak"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Speak", "[", "tospeak", "]"}]}]}], "\[IndentingNewLine]", 
        "]"}], ";", " ", "\[IndentingNewLine]", "toshow"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Kindergarten\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1\>\""}],
         "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.A\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.B\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.C\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.3\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<C.4\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<C.5\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<C.6\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1.A\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1.B\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.2\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.3\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.4\>\""}], 
        "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.5\>\""}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Kindergarten\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1\>\""}], 
      "]"}], "=", " ", 
     "\"\<Work with numbers 11-19 to gain foundations for place value. \
CCSS.Math.Content.K.NBT.A.1.\\n  Compose and decompose numbers from 11 to 19 \
into ten ones and some further ones, e.g., by using objects or drawings, and \
record each composition or decomposition by a drawing or equation (such as 18 \
= 10 + 8); understand that these numbers are composed of ten ones and one, \
two, three, four, five, six, seven, eight, or nine ones.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1\>\""}], "]"}],
      "=", "\"\<Extend the counting sequence. CCSS.Math.Content.1.NBT.A.1\n  \
Count to 120, starting at any number less than 120. In this range, read and \
write numerals and represent a number of objects with a written \
numeral.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2\>\""}], "]"}],
      "=", "\"\<Understand place value. CCSS.Math.Content.1.NBT.B.2\n\
Understand that the two digits of a two-digit number represent amounts of \
tens and ones. Understand the following as special cases: B.2.A, B.2.B, B.2.C\
\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.A\>\""}], 
      "]"}], "=", 
     "\"\<Understand place value. CCSS.Math.Content.1.NBT.B.2.A\n  10 can be \
thought of as a bundle of ten ones \[LongDash] called a \\\"ten.\\\"\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.B\>\""}], 
      "]"}], "=", "\[IndentingNewLine]", 
     "\"\<Understand place value. CCSS.Math.Content.1.NBT.B.2.B\n  The \
numbers from 11 to 19 are composed of a ten and one, two, three, four, five, \
six, seven, eight, or nine ones.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.C\>\""}], 
      "]"}], "=", 
     "\"\<Understand place value. CCSS.Math.Content.1.NBT.B.2.C\nThe numbers \
10, 20, 30, 40, 50, 60, 70, 80, 90 refer to one, two, three, four, five, six, \
seven, eight, or nine tens (and 0 ones)\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.3\>\""}], "]"}],
      "=", "\"\<Understand place value. CCSS.Math.Content.1.NBT.B.3\n  \
Compare two two-digit numbers based on meanings of the tens and ones digits, \
recording the results of comparisons with the symbols >, =, and <.\n  Use \
place value understanding and properties of operations to add and subtract.\>\
\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<C.4\>\""}], "]"}],
      "=", "\"\<Use place value understanding and properties of operations to \
add and subtract. CCSS.Math.Content.1.NBT.C.4\n  Add within 100, including \
adding a two-digit number and a one-digit number, and adding a two-digit \
number and a multiple of 10, using concrete models or drawings and strategies \
based on place value, properties of operations, and/or the relationship \
between addition and subtraction; relate the strategy to a written method and \
explain the reasoning used. Understand that in adding two-digit numbers, one \
adds tens and tens, ones and ones; and sometimes it is necessary to compose a \
ten.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<C.5\>\""}], "]"}],
      "=", "\"\<Use place value understanding and properties of operations to \
add and subtract. \[IndentingNewLine]CCSS.Math.Content.1.NBT.C.5\n  Given a \
two-digit number, mentally find 10 more or 10 less than the number, without \
having to count; explain the reasoning used.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<C.6\>\""}], "]"}],
      "=", "\"\<Use place value understanding and properties of operations to \
add and subtract. CCSS.Math.Content.1.NBT.C.6\nSubtract multiples of 10 in \
the range 10-90 from multiples of 10 in the range 10-90 (positive or zero \
differences), using concrete models or drawings and strategies based on place \
value, properties of operations, and/or the relationship between addition and \
subtraction; relate the strategy to a written method and explain the \
reasoning used.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1\>\""}], "]"}],
      "=", "\"\<Understand place value. CCSS.Math.Content.2.NBT.A.1\n\
Understand that the three digits of a three-digit number represent amounts of \
hundreds, tens, and ones; e.g., 706 equals 7 hundreds, 0 tens, and 6 ones. \
Understand the following as special cases: A.1.A, A.1.B\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1.A\>\""}], 
      "]"}], "=", 
     "\"\<Understand place value. CCSS.Math.Content.2.NBT.A.1.A\n  100 can be \
thought of as a bundle of ten tens \[LongDash] called a \
\\\"hundred.\\\"\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1.B\>\""}], 
      "]"}], "=", 
     "\"\<Understand place value. CCSS.Math.Content.2.NBT.A.1.B\n  The \
numbers 100, 200, 300, 400, 500, 600, 700, 800, 900 refer to one, two, three, \
four, five, six, seven, eight, or nine hundreds (and 0 tens and 0 \
ones).\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.2\>\""}], "]"}],
      "=", "\"\<Understand place value. CCSS.Math.Content.2.NBT.A.2\n  Count \
within 1000; skip-count by 5s, 10s, and 100s.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.3\>\""}], "]"}],
      "=", "\"\<Understand place value. CCSS.Math.Content.2.NBT.A.3\n  Read \
and write numbers to 1000 using base-ten numerals, number names, and expanded \
form.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.4\>\""}], "]"}],
      "=", "\"\<Understand place value. CCSS.Math.Content.2.NBT.A.4\n  \
Compare two three-digit numbers based on meanings of the hundreds, tens, and \
ones digits, using >, =, and < symbols to record the results of comparisons.\n\
  Use place value understanding and properties of operations to add and \
subtract.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{
      "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.5\>\""}], "]"}],
      "=", "\"\<Use place value understanding and properties of operations to \
add and subtract. CCSS.Math.Content.2.NBT.B.5\n  Fluently add and subtract \
within 100 using strategies based on place value, properties of operations, \
and/or the relationship between addition and subtraction.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{"\"\<Grade 3\>\"", ",", "\"\<OA\>\"", ",", "\"\<D.9\>\""}], 
      "]"}], "=", 
     "\"\<Solve problems involving the four operations, and identify and \
explain patterns in arithmetic. CCSS.Math.Content.3.OA.D.9\nIdentify \
arithmetic patterns (including patterns in the addition table or \
multiplication table), and explain them using properties of \
operations.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CCSSMathContent", "[", 
      RowBox[{"\"\<Grade 4\>\"", ",", "\"\<NBT\>\"", ",", "\"\<A.2\>\""}], 
      "]"}], "=", 
     "\"\<Generalize place value understanding for multi-digit whole numbers. \
CCSS.Math.Content.4.NBT.A.2\nRead and write multi-digit whole numbers using \
base-ten numerals, number names, and expanded form. Compare two multi-digit \
numbers based on meanings of the digits in each place, using >, =, and < \
symbols to record the results of comparisons.\>\""}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"End", "[", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", 
     RowBox[{"CCSSMathContent", ",", " ", "CCSSMathExercise"}], "]"}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"EndPackage", "[", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2b3586a5-a63a-4420-85b0-de1c5c3236e7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". ",
 "Introduction"
}], "Section",
 PageBreakAbove->True,ExpressionUUID->"dd253a8a-4545-4d7c-9848-b28ec9cc8037"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Key example"
}], "Subsection",ExpressionUUID->"c56043f7-3d05-4ae6-9e74-37a782e1dea9"],

Cell["A picture says more than a thousand words:", "Text",ExpressionUUID->"03b8e842-313d-46d9-aee6-734a5821c435"],

Cell[TextData[{
 "\t\t\t\t\t25 = 2 \[Times] 10  +  5 = two\[CenterDot]ten  ",
 StyleBox["&",
  FontSize->12],
 "  five"
}], "Text",ExpressionUUID->"56bea39a-562a-4a49-a3d5-c871af2d9eaa"],

Cell["The default is Speak \[Rule] True.", "Text",ExpressionUUID->"a9186ceb-30d8-45a9-851a-4ceff5c3e3e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValue", "[", "25", "]"}], " "}]], "Input",ExpressionUUID->\
"ed0f07cf-9d78-41b6-b123-f2c9710323b0"],

Cell[BoxData[
 FormBox["\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  five\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"90a187dc-cb02-436e-98c9-\
0979700c37b4"]
}, Open  ]],

Cell[TextData[{
 "The connectives \[OpenCurlyDoubleQuote]",
 StyleBox["&",
  FontSize->14],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]\[CenterDot]\
\[CloseCurlyDoubleQuote] are used to codify the sound, and differ from the \
operators \[OpenCurlyDoubleQuote]plus\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]group\[CloseCurlyDoubleQuote] (multi-plus, repeat, \
times), since + and \[Times] have commutation, association and distribution. "
}], "Text",ExpressionUUID->"55cc0400-0cf8-4dcc-9d9d-824d473c525d"],

Cell["\<\
The center dot (\[CenterDot]) is unpronounced. The trailing center dot is \
deliberate and indicates the ghost of the departed one. The strict use of the \
place value system is that 1 is actually 1 of 1 (also distinguishing numbers \
and digits). Normally we simplify, but we should be able to show how the \
system actually works.\
\>", "Text",ExpressionUUID->"8585725a-4e1a-45f5-bcab-25fb51485114"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValue", "[", 
   RowBox[{"25", ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
    RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"93793cb5-ad94-45ea-94c5-5e571ff279ea"],

Cell[BoxData[
 FormBox["\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  five\[CenterDot]one\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"34d857f4-f3da-473e-9d5a-\
423d05a9e8bc"]
}, Open  ]],

Cell[TextData[{
 "The ampersand (",
 StyleBox["&",
  FontSize->12],
 ") will surprise native speakers of English but derives from quite some \
consideration. German (\[OpenCurlyDoubleQuote]und\[CloseCurlyDoubleQuote]), \
Dutch (\[OpenCurlyDoubleQuote]en\[CloseCurlyDoubleQuote]) and Danish (\
\[OpenCurlyDoubleQuote]og\[CloseCurlyDoubleQuote]) have the \
\[OpenCurlyDoubleQuote]",
 StyleBox["&",
  FontSize->14],
 "\[CloseCurlyDoubleQuote] connective and for good reason. See the discussion \
of the connectives below. "
}], "Text",ExpressionUUID->"452f1a68-e23b-4dd0-aa77-31c447ffd7b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueTable", "[", 
   RowBox[{"25", ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}], " "}]], "Input",\
ExpressionUUID->"bb5d849a-e405-40f7-a6e1-16ce0e1c7b83"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"25", "\<\" \"\>", "\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  five\[CenterDot]\"\>", "\<\"2 \
\[CenterDot] 10   &   5\"\>", "\<\" \"\>", "\<\"twenty five\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Speak -> False, TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"7b78bbce-ba1e-44c5-827c-f8710204409e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueTable", "[", 
   RowBox[{"25", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Danish\>\""}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "True"}]}], "]"}], " "}]], "Input",E\
xpressionUUID->"f35a09dc-03b1-46b6-a28a-c2d4694bda18"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"25", "\<\" \"\>", "\<\"to\[CenterDot]ti  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  fem\[CenterDot]\"\>", "\<\"2 \
\[CenterDot] 10   &   5\"\>", "\<\" \"\>", "\<\"fem\[DiscretionaryHyphen]og\
\[DiscretionaryHyphen]tyve\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Language -> "Danish", Speak -> True, TableSpacing -> {1.5, 3},
      TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"d75ed71c-e4f3-43a7-8ea4-f063cf661e0f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Kids live in a world of sounds"
}], "Subsection",ExpressionUUID->"4ea18dd3-0eaa-4b30-bdd8-bc38088a0a64"],

Cell["\<\
A number consists of sound, numeral, word (that records the sound). Kids in \
kindergarten and Grade 1 live in a world of sounds so that the pronunciation \
of numbers is important. When they are learning to read and write, the \
co-ordination of (i) sounds, (ii) numerals and (iii) written words \
(subvocalisation but still sounds) is important. We already have the place \
value system fully in the numerals but not yet in pronunciation and words. \
\>", "Text",ExpressionUUID->"d017fd01-b0dc-45b9-8226-2bad506985b6"],

Cell[TextData[{
 "The place value system puts digits in positions, with the digit being the ",
 StyleBox["weight",
  FontSlant->"Italic"],
 " and the position the ",
 StyleBox["place value",
  FontSlant->"Italic"],
 " (in our case a power of 10). The traditional pronunciation  has these \
breaches upon the full use of the place value system:"
}], "Text",ExpressionUUID->"ee1eefa4-e827-4443-9da0-0c98a850e9d0"],

Cell[CellGroupData[{

Cell["\<\
On order: nine-teen instead of ten & nine. (Rule: speak the highest place \
value first.)\
\>", "Item",ExpressionUUID->"a8be31c5-1d09-4ea9-872c-2c0da65cdb2a"],

Cell["\<\
On weights: twenty instead of two\[CenterDot]ten. (Rule: speak the weight of \
the place value.)\
\>", "Item",ExpressionUUID->"5872fd41-a378-4621-a8b3-162cc0caa79c"]
}, Open  ]],

Cell[TextData[{
 "We do not have to assume that kids must learn ",
 StyleBox["formal",
  FontSlant->"Italic"],
 " multiplication (grouping) and the table and the powers of 10 before they \
can work with the numbers and the place value system. But it is another thing \
to hide the very structure that is the object of learning. It is better to \
use the full place value system, which will support the involved learning of \
arithmetic."
}], "Text",ExpressionUUID->"f7fc37ef-6116-4bde-8346-0bd1d24f9ada"],

Cell[TextData[{
 "The US Common Core State Standards (2018) rightly wants for kindergarten: \
\[OpenCurlyDoubleQuote]Work with numbers 11-19 to gain foundations for place \
value: CCSS.Math.Content.K.NBT.A.1.\[CloseCurlyDoubleQuote] They do not say \
that they implement only a ",
 StyleBox["partial ",
  FontSlant->"Italic"],
 "and not the",
 StyleBox[" full ",
  FontSlant->"Italic"],
 "place value system. "
}], "Text",ExpressionUUID->"5405f25b-fb0e-438b-9b34-b280865ea569"],

Cell["\<\
PM. The West reads and writes from left to right, while the numbers came from \
a region in India that read and wrote from right to left. We can leave this \
phenomenon as it is because there is advantage in beginning the pronunciation \
with the highest place value with nonzero weight.\
\>", "Text",ExpressionUUID->"f90e2d3c-ee56-473f-a13d-1246511908b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". What this notebook with package provides"
}], "Subsection",ExpressionUUID->"cb4e819a-049d-445a-8cb9-4a54ceeb8f77"],

Cell[TextData[{
 "This notebook with package provides an implementation for English, German, \
French, Dutch and Danish. For these languages there is a transliteration in \
English. For other languages ",
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s ",
 StyleBox["IntegerName",
  FontWeight->"Bold"],
 " and ",
 StyleBox["WordTranslation",
  FontWeight->"Bold"],
 " can be used for an automated translation, see the examples for Italian and \
Spanish, but then without transliteration. Only needed are 18 terms, for \
sign, \[OpenCurlyDoubleQuote]&\[CloseCurlyDoubleQuote], ten digits and the \
powers of 10 to a million (for our main application). The ampersand (&) is \
quite universal but will be pronounced differently, and the center dot (\
\[CenterDot]) remains unpronounced."
}], "Text",ExpressionUUID->"dbffefa3-cb25-4636-8352-5adb65ba6370"],

Cell["\<\
The reason to have more languages is that this is an international issue, \
though fragmented over the languages. A windfall benefit is that the reader \
and listener may experience a little bit how it would be for kids to rely on \
sounds  to learn about numbers and their structure.\
\>", "Text",ExpressionUUID->"57ae8348-47ed-4856-bd7f-9dd33092c972"],

Cell["\<\
Colignatus (2015b, 2018a) manually typed out conversion tables for English, \
German, French, Dutch and Danish. This close reading is important since \
natural languages (and their language committees) develop peculiarities, \
while there also can be conflicts between current pronunciation and the \
simple elaboration with 10, see German zehn | zig and Dutch tien | tig below. \
Adapting to another language than those checked ones may still cause such \
conflicts for the proposed full use of the place value system. The feature of \
transliteration started out for presentation (of the checked languages) but \
appears to be important as a gateway for quality control (of unchecked \
languages) as well.\
\>", "Text",ExpressionUUID->"74d69a68-3275-46af-8e91-ee4e4aff5e16"],

Cell["\<\
The US Common Core (2018) has negative numbers only in Grade 6, and Holland \
and the UK only in Grade 7 (junior highschool). For us it remains useful to \
include the negative sign too.\
\>", "Text",ExpressionUUID->"f15b328c-50b6-4175-89bb-4f9163f09f24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". A natural language as a dialect of mathematics"
}], "Subsection",ExpressionUUID->"68c76caa-659b-4d0d-9f0b-0e69090ff6d0"],

Cell["\<\
We tend to use the term \[OpenCurlyDoubleQuote]natural language\
\[CloseCurlyDoubleQuote] but we should not forget that scores of influential \
authors and committees have been working on the traditional pronunciation of \
the natural numbers. When there is scope for improvement then it can be \
discussed. This is not an issue of spelling reform but an issue of \
mathematics education. Arithmetic and number sense are not only about \
numerals and the operations but also about how you pronounce the numbers, \
especially for kids who cannot read or write yet, and how it percolates into \
later thought (that might be \[OpenCurlyDoubleQuote]subvocalised speaking\
\[CloseCurlyDoubleQuote]).\
\>", "Text",ExpressionUUID->"d4abd553-cd2b-44a1-8350-e64431579b6e"],

Cell[TextData[{
 "The suggestion is that schools indeed embrace this ",
 StyleBox["full use of the place value system",
  FontSlant->"Italic"],
 ", so that language at school is the ",
 StyleBox["language of arithmetic",
  FontSlant->"Italic"],
 ", and so that the common language on the numbers used at home can be \
regarded as a ",
 StyleBox["dialect ",
  FontSlant->"Italic"],
 "of this language of arithmetic. Kids can deal with such differences in \
language. It is 12 years after the implementation from kindergarten and up \
that the national judicial system must have worked out whether the \
pronunciation of arithmetic would also be relevant and acceptable for legal \
issues. "
}], "Text",ExpressionUUID->"254c9614-03d9-4ee2-aa07-e666731118c0"],

Cell[TextData[{
 "Colignatus (2015a),",
 StyleBox[" A child wants nice and no mean numbers",
  FontSlant->"Italic"],
 "."
}], "Item",ExpressionUUID->"622c1098-f1ed-4309-8374-db69eae42246"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". The need for an ISO standard"
}], "Subsection",ExpressionUUID->"55e2c961-2553-405c-84f1-c6c73952e0dc"],

Cell[TextData[{
 "The system proposed here is simple but still supports a",
 StyleBox[" full use of the place value system",
  FontSlant->"Italic"],
 " for education in kindergarten and elementary school. It must become an ISO \
standard, so that educators and textbook & software publishers but also \
researchers have stability of their environment. Even when schools would not \
implement the system (so fast), researchers and teacher trainers require a \
standard to correct their research findings for confounding by the natural \
languages. The definition of this standard is given here, and this notebook \
with package only provide an implementation:"
}], "Text",ExpressionUUID->"ffc739bc-d4cc-4273-b69b-982ef919ded0"],

Cell[CellGroupData[{

Cell[TextData[{
 "Colignatus (2015b, 2018a), ",
 StyleBox["The need for a standard for the mathematical pronunciation of the \
natural numbers. Suggested principles of design. Implementation for English, \
German, French, Dutch and Danish.",
  FontSlant->"Italic"]
}], "Item",ExpressionUUID->"d59db348-3b66-44d7-bdfe-a0ab0083d648"],

Cell["\<\
The amendment in 2018a is the use of the connectives, see below.\
\>", "Item",ExpressionUUID->"80d2863d-03f2-4547-a251-d547a5825c23"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Discussion on content and a technical report"
}], "Subsection",ExpressionUUID->"38a809cc-ab3e-47aa-a230-ff997099a297"],

Cell["\<\
The suggestion for a full place value system was motivated by education. The \
package implements this, and this notebook contains much of a technical \
discussion on how to use the package. However, the very reason to make the \
suggestion derives from education, and we should not forget about this very \
motivation. This notebook thus also looks at how the package might be applied \
for the Common Core State Standards (2018). We can identify 4 levels of \
number sense relevant for pronunciation and the full use of the place value \
system that are supported by 4 routines in the package. This discussion is \
not intended as a comment on the curriculum or as a suggestion how the \
curriculum might look like. \
\>", "Text",ExpressionUUID->"22291fad-2403-46b8-8a8b-8f115a746f99"],

Cell[TextData[{
 "This present discussion on content does not discuss the fundamentals for \
the standard, and the reader is referred to (2015ab, 2018a) for the more \
involved discussion. This present notebook with package provides for a \
software implementation in ",
 StyleBox["Mathematica, ",
  FontSlant->"Italic"],
 "and we concentrate on the latter. "
}], "Text",ExpressionUUID->"8e1dc970-c142-4167-b5bc-68727460fc26"],

Cell["\<\
Though the package contains the full system - with the definition that must \
become an ISO standard - it has practical limitations. The main purpose of \
this notebook is to set some first steps towards implementation and to \
circulate the idea. Programming on language is quite involved, and \
implementing change even more. \
\>", "Text",ExpressionUUID->"8357d9d3-657a-491c-a875-ea24bbcba3d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Transliteration for a quick impression"
}], "Subsection",ExpressionUUID->"9e9aa5c1-49d5-41cc-9904-bd30a3bf4a00"],

Cell[TextData[{
 "When you install ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "you select your ",
 StyleBox["$Language",
  FontWeight->"Bold"],
 " in the Preferences. You can change the Preferences for another language \
and then do a restart. A setting of $Language will also provide for such \
pronunciation of the digits and numerals, though in traditional fashion. The \
routines provided here should give access to the full place value system of \
your $Language, though with these warnings: (i) except for the comment on \
quality control (see above), (ii) and perhaps except for the setting of some \
options, likely an adaptation of the connectives (see below). I did not test \
changing $Language from \
\[OpenCurlyDoubleQuote]English\[CloseCurlyDoubleQuote]."
}], "Text",ExpressionUUID->"b5a8a71e-8bce-4b5e-8a62-7d8fa0e8d28e"],

Cell["\<\
At times it is an acceptable and faster way to transliterate words. Tourists \
are familiar with transliterations in their tourist guides. For example, \
French \"deux\" is pronounced in English as \"duh\". We use this \
transliteration now since it provides for a quick impression (without \
restart) how the full use of the place value system would look also in some \
other languages. This helps to identify that this is an international issue \
that is served by an ISO standard. Indeed, other languages are also included \
in the proposal Colignatus (2015b, 2018a) but it makes a difference to \
actually hear it pronounced.\
\>", "Text",ExpressionUUID->"9117fb9a-1d58-462b-aa6c-f6033f21d12f"],

Cell[TextData[{
 "The transliteration must be defined for the $Language in your installment \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The package basically allows for different settings, yet has been \
developed while using $Language = \"English\"."
}], "Text",ExpressionUUID->"f5e48677-9102-4f1d-815e-91f5fceb3f7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Structure of the paper"
}], "Subsection",ExpressionUUID->"30f7c03b-64a4-4633-a1f5-b571ac567845"],

Cell[TextData[{
 "Below, I briefly indicate some history and other researchers. The main \
section explains the working of the package. It will be most instructive \
though to start with examples that highlight the properties. The main body of \
the text will use English, French and German while there will be a bit more \
later about Dutch and Danish. The definitions of the routines are printed in \
the ",
 StyleBox["Appendix",
  FontWeight->"Bold"],
 ". The standard routines in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "provide for a link to the current (traditional) pronunciation in the \
natural languages. The traditional (wrong) pronunciation and notation has \
received quite some support, but let us now look at the full use of the place \
value system."
}], "Text",ExpressionUUID->"ac38fcca-4e12-440d-ab26-1129be33f6df"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". Example in English"
}], "Section",ExpressionUUID->"1d3a3429-18ab-42e3-a14a-86bfc503de30"],

Cell[TextData[{
 "The following describes our implementation (and not the English language as \
it is). There could be a difference between the output that the package \
generates, intended for interactive learning, and texts that a textbook could \
show. For example, a textbook could have two\[CenterDot]ten ",
 StyleBox["&",
  FontSize->14],
 " five but the package may put in some more blanks. "
}], "Text",ExpressionUUID->"7c1eedd0-102b-48c8-b0be-db10d8b41ec6"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Speaking and writing"
}], "Subsection",ExpressionUUID->"b3f630e1-4a77-4cf4-bc68-e99941933552"],

Cell["\<\
There is a difference between speaking and writing. Speaking uses a pause. \
The present pause might be a bit long, but this length was pleasant for the \
transliteration of other languages. The routines tend to have default Speak \
\[Rule] True, but you can turn it off. The routines show the words in the \
chosen language and not the transliterations, unless you explicitly ask for \
the transliterations.\
\>", "Text",ExpressionUUID->"b5dfe3fb-9240-47a2-be89-94049d629194"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValue", "[", "21", "]"}], "   ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"default", " ", "Speak"}], " ", "\[Rule]", " ", "True"}], " ", 
   "*)"}]}]], "Input",ExpressionUUID->"760683a1-9b8c-4fdd-884f-3c62c381a7f3"],

Cell[BoxData[
 FormBox["\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]one\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"cdbc4e93-5aa2-41ec-85c0-\
43749ffb95fe"]
}, Open  ]],

Cell["\<\
The routines store what was spoken (or often what could have been spoken if \
not turned off).\
\>", "Text",ExpressionUUID->"5a1dc4e8-265f-48db-b81f-da5429df18de"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"69ffae27-44e4-49e0-9471-50c246171e5d"],

Cell[BoxData[
 FormBox["\<\"two\[CenterDot]ten <silence msec=\\\"300\\\"/>  &  \
\[CenterDot]one\"\>", TraditionalForm]], "Output",ExpressionUUID->"8b69770a-\
ef39-4f12-b7b1-dad7feb28c75"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Simplify"
}], "Subsection",ExpressionUUID->"57aba9e3-242b-4193-bddc-18a3c128d14a"],

Cell["\<\
For the place value system, it is important to recognise that 1 is actualy 1 \
of 1 (with a conceptual difference between digits and single digit numbers). \
After a short while this meticulous accuracy becomes annoying whence we \
simplify. It is advisable to teach the place value system, but it is also \
acceptable to simplify \[OpenCurlyDoubleQuote]one hundred\
\[CloseCurlyDoubleQuote] into \[OpenCurlyDoubleQuote]hundred\
\[CloseCurlyDoubleQuote], and to pronounce 10 as \[OpenCurlyDoubleQuote]ten\
\[CloseCurlyDoubleQuote] and not as \[OpenCurlyDoubleQuote]0 hundred, 1 ten, \
0 one\[CloseCurlyDoubleQuote]. Nevertheless, for teaching it is important to \
show both the whole system and its simplification. The trailing dot appears \
to be a quite useful indicator of this simplification.\
\>", "Text",ExpressionUUID->"63e0e076-de96-4a57-aa26-b51772dd071c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"1", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",Expressi\
onUUID->"5d09ee7c-b461-4462-a299-4c79efd813e9"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]one\"\>", TraditionalForm]], "Output",ExpressionUUID->"ae382fe8-1407-48cc-b42f-17b66b079611"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"1", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",Expre\
ssionUUID->"d545c501-14c6-4792-922d-399e9e3fb5bb"],

Cell[BoxData[
 FormBox["\<\"one\[CenterDot]one\"\>", TraditionalForm]], "Output",ExpressionU\
UID->"739e092d-d714-43f5-9433-bc507e1ed254"]
}, Open  ]],

Cell["\<\
Above, there has been simplification of 21, indicated by a trailing dot.\
\>", "Text",ExpressionUUID->"552bc966-94a5-4ee8-9b4c-0635bc85e8a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"21", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",Expre\
ssionUUID->"318f073e-dc27-4b13-9f64-a77f2452efb2"],

Cell[BoxData[
 FormBox["\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  one\[CenterDot]one\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"ae17b37c-24b2-4924-8846-\
9e1ca255dc47"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Traditional pronunciation"
}], "Subsection",ExpressionUUID->"04844e49-fd65-4b25-9e9b-dbf3de9c3239"],

Cell[TextData[{
 "PartialPlaceValue calls ",
 StyleBox["Mathematica\[CloseCurlyQuote]",
  FontSlant->"Italic"],
 "s IntegerName and gives the traditional pronunciation."
}], "Text",ExpressionUUID->"927d47f7-018a-48c4-b6d4-c8d52c951c32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartialPlaceValue", "[", "123", "]"}]], "Input",ExpressionUUID->"579ca52e-40c0-41fd-89b8-a83ab43ef024"],

Cell[BoxData[
 FormBox["\<\"one hundred twenty three\"\>", TraditionalForm]], "Output",Expre\
ssionUUID->"baba444c-e897-4bf5-8d1f-e6b78b26730b"]
}, Open  ]],

Cell["PlaceValue gives the full place value pronunciation.", "Text",ExpressionUUID->"d098cb13-2dd7-4dd8-ac47-febe931a0f13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", "123", "]"}]], "Input",ExpressionUUID->"29c98061-6d70-4e6f-ae8f-a091ce4d7527"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]hundred  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  three\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"ac5a75c6-6697-4151-9e07-\
3fcec0516a97"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". The connectives"
}], "Subsection",ExpressionUUID->"aaa35a86-1771-43c2-9b9f-0d024b01c867"],

Cell[TextData[{
 "The connectives \[OpenCurlyDoubleQuote]",
 StyleBox["&",
  FontSize->14],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]\[CenterDot]\
\[CloseCurlyDoubleQuote] have an important role. They differ from the \
operators \[OpenCurlyDoubleQuote]plus\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]group\[CloseCurlyDoubleQuote] (multi-plus, repeat, \
times), since + and \[Times] have commutation, association and distribution."
}], "Text",ExpressionUUID->"8c6af9b1-4dd4-4008-afe8-792bde7b3f02"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ampersand (",
 StyleBox["&",
  FontSize->14],
 ") is the ghost of addition, but simply \[OpenCurlyDoubleQuote]and\
\[CloseCurlyDoubleQuote], and not the operator \[OpenCurlyDoubleQuote]plus\
\[CloseCurlyDoubleQuote] with all its properties. The ampersand should be \
pronounced, namely to separate the place value positions. It is already \
(often) pronounced in German, Dutch and Danish. Other languages better adopt \
this practice too. Remember that we are speaking about the language of \
arithmetic to be used in school and not about an integral language reform \
(that would evolve)."
}], "Item",ExpressionUUID->"c217df7a-8cc4-4ec3-80a1-5da3324e59c2"],

Cell[TextData[{
 "The center dot (not pronounced) is the ghost of multiplication of the ",
 StyleBox["weight ",
  FontSlant->"Italic"],
 "and the ",
 StyleBox["place value",
  FontSlant->"Italic"],
 ". Remember: 5 days 2 hamburgers is not the same as 2 days 5 hamburgers."
}], "Item",ExpressionUUID->"cf27fc44-2070-49a3-bad7-7003654b5f1e"]
}, Open  ]],

Cell[TextData[{
 "Kids in kindergarten and Grade 1 live in a world of sounds. Thus they \
should be provided with the &-separator of the place value positions, so that \
they have this anchor on which is what. For adults and native speakers of \
English it may seem superfluous. Indeed, I myself in (2015a, footnote 10, and \
2015b before the amendment in 2018a) found the use of \[OpenCurlyDoubleQuote]",
 StyleBox["&",
  FontSize->14],
 "\[CloseCurlyDoubleQuote] \[OpenCurlyDoubleQuote]distractive\
\[CloseCurlyDoubleQuote]. My proposal then was to use the center dot for \
\[OpenCurlyDoubleQuote]",
 StyleBox["&",
  FontSize->14],
 "\[CloseCurlyDoubleQuote] too: thus without the distinction and merely as an \
unpronounced connective, as 25 = two\[CenterDot]ten\[CenterDot]five. However, \
in reconsideration, the empirical observation is that the ",
 StyleBox["&",
  FontSize->14],
 "-separator really is there. Its existence must be acknowledged instead of \
hidden from sight."
}], "Text",ExpressionUUID->"a5d3c6d2-a9a1-40c7-b5b0-f90792e5056f"],

Cell[TextData[{
 "Namely, in natural language, putting two terms alongside, like in 2 km, \
means scalar multiplication. In multiplication as grouping, kids learn to use \
the times-symbol, but we do not write 2 \[Times] km. Later students will \
learn that 2 ",
 StyleBox["a ",
  FontSlant->"Italic"],
 "is multiplication in general, also dropping the times-symbol. If they would \
have been trained by the pronunciation of the very numbers (and ",
 StyleBox["a ",
  FontSlant->"Italic"],
 "in 2",
 StyleBox["a ",
  FontSlant->"Italic"],
 "would be a number, in this scenario like ",
 StyleBox["a ",
  FontSlant->"Italic"],
 "= 25 = two\[CenterDot]ten five, thus without the \[OpenCurlyDoubleQuote]",
 StyleBox["&",
  FontSize->14],
 "\[CloseCurlyDoubleQuote]) then we create a conundrum: (1) within \
\[OpenCurlyDoubleQuote]",
 StyleBox["a ",
  FontSlant->"Italic"],
 "= 25 = two\[CenterDot]ten five\[CloseCurlyDoubleQuote] the lack of an \
interfix means addition and (ii) outside of this, in 2 ",
 StyleBox["a,",
  FontSlant->"Italic"],
 " the lack of an interfix means multiplication ? We should not create \
conundrums. Thus 25 =  two\[CenterDot]ten ",
 StyleBox["&",
  FontSize->14],
 " five. It should help understand 2 \[Times] 25. Perhaps adults might not \
speak the ampersand but for kindergarten and elementary school it is part of \
the system."
}], "Text",ExpressionUUID->"1952608a-1378-4a88-a0e4-dec8ed76d37b"],

Cell[TextData[{
 "Indeed, in kindergarten and Grade 1 kids will tend to focus on the ",
 StyleBox["&",
  FontSize->14],
 " as an important new symbol in their universe, but this is not \
\[OpenCurlyDoubleQuote]distractive\[CloseCurlyDoubleQuote] but only \
fortunate, because it will form a stepping stone for the later learning on \
addition, i.e. using plus. Eventually they would tend to focus on the figures \
in the numbers and not the connectives. "
}], "Text",ExpressionUUID->"1fbe04bb-4dcc-4fe7-bed5-378ddc893c57"],

Cell["\<\
NB. The ampersand is remarkably large in common fonts (like upper case), and \
it is better displayed in a smaller font (like lower case). It appears that \
Speak cannot deal with a Stylebox in the strings that we are using. The \
solution was to create the language \[OpenCurlyDoubleQuote]Amplish\
\[CloseCurlyDoubleQuote], that has the True form with the smaller font for \
the ampersand, and that is transliterated in English in the default font. \
This worked fine, and thus all languages here have the smaller ampersand \
(which might cause that one has to adapt the package to work under a \
different $Language). The functionality of providing transliteration was \
useful here too. This only applies for the routines PlaceValue and \
PlaceValueRules.  It is useful to know for the option settings. Check the \
visual difference:\
\>", "Text",ExpressionUUID->"45f04847-06a0-48c0-8a31-aa271fc5e08e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValue", "[", 
   RowBox[{"25", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Amplish\>\""}]}], "]"}], 
  "  ", 
  RowBox[{"(*", "default", "*)"}]}]], "Input",ExpressionUUID->"343eb347-3119-\
482c-9a40-51ffc54a2c7d"],

Cell[BoxData[
 FormBox["\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  five\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"8ba551a0-fa67-451a-9364-\
6e54770b3420"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"25", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<English\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"522a76e0-6fe0-4cd1-ba40-ce63041dbf48"],

Cell[BoxData[
 FormBox["\<\"two\[CenterDot]ten  &  five\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"b7b9d730-df81-4bd4-8e3d-\
bdb81a1c46e6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Do not use ones, tens, hundreds"
}], "Subsection",ExpressionUUID->"db0271a0-358a-4614-9574-89706b61379e"],

Cell["The Common Core (2018) has:", "Text",ExpressionUUID->"624571c0-80e4-421e-b648-bda059b37f52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.C\>\""}], 
  "]"}]], "Input",ExpressionUUID->"8f8ab4c1-9652-4690-bc26-1e678272871a"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.1.NBT.B.2.C\\nThe \
numbers 10, 20, 30, 40, 50, 60, 70, 80, 90 refer to one, two, three, four, \
five, six, seven, eight, or nine tens (and 0 ones)\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"0cc63be6-3db6-4ae5-91b1-\
65a9e6a36359"]
}, Open  ]],

Cell["\<\
CCSS writes about \[OpenCurlyDoubleQuote]tens\[CloseCurlyDoubleQuote], and \
elsewhere also about \[OpenCurlyDoubleQuote]ones\[CloseCurlyDoubleQuote].  \
CCSS likely can be so sloppy since common English has \
\[OpenCurlyDoubleQuote]twenty\[CloseCurlyDoubleQuote] instead of \
\[OpenCurlyDoubleQuote]two\[CenterDot]tens\[CloseCurlyDoubleQuote] etcetera. \
If English had adopted such system with the plurals of the bases, with a \
multitude of s\[CloseCurlyQuote]s, then the abuse might be noticed sooner.\
\>", "Text",ExpressionUUID->"16520f85-abb7-4fbd-9c2b-336be71f37ee"],

Cell["\<\
For CCSS \"two \[Times] three\" should also be \"twos \[Times] threes\", \
because the two implies that the threes are plural, and the three implies \
that the twos are plural. It shows that one doesn\[CloseCurlyQuote]t \
understand what a number is. Instead of \[OpenCurlyDoubleQuote]5 tens\
\[CloseCurlyDoubleQuote] one better says \[OpenCurlyDoubleQuote]5 of ten\
\[CloseCurlyDoubleQuote], since \[OpenCurlyDoubleQuote]of\
\[CloseCurlyDoubleQuote] means grouping (multiplication).\
\>", "Text",ExpressionUUID->"0311b5df-370e-432c-a8e7-0811ec2aced2"],

Cell["\<\
The use of \[OpenCurlyDoubleQuote]ones\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]tens\[CloseCurlyDoubleQuote] pre-dates the development \
of the place value system, and is not supported in pronunciation, since the \
numbers 11-19 are properly pronounced in place value manner. The proper \
expression for 20 is 2\[CenterDot]10, and we speak the base, which is 10 and \
not \[OpenCurlyDoubleQuote]tens\[CloseCurlyDoubleQuote]. One should avoid \
speaking about \[OpenCurlyDoubleQuote]ones\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]tens\[CloseCurlyDoubleQuote]. These plurals arise in a \
context when teachers are groping for a way of expression, but those words \
are confusing for kids as if these words would really be defined. Likely this \
is similar to 1 car versus 2 cars, but a base has a different linguistic \
treatment. (We are not pronouncing telephone numbers by rattling of the \
digits either.) \
\>", "Text",ExpressionUUID->"32ef7ae0-4ca9-4a7e-8c6a-1d06d11eb8f5"],

Cell["\<\
Remember that a puzzle is only complete when all pieces are in the proper \
places. When something has a logical structure then people are bound to get \
at least one piece wrong and develop an emotional hangup on it, and each \
person or nation another piece. There is no other solution than to clarify \
the logical structure.\
\>", "Text",ExpressionUUID->"a27fd3d9-a822-43dd-9210-faa5f5cd464c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Myriad and lakh"
}], "Subsection",ExpressionUUID->"a3d55f82-4db9-4ea7-8d93-5fe4e8de1995"],

Cell[TextData[{
 "The figure 10,000 tends to be pronounced commonly as \
\[OpenCurlyDoubleQuote]ten thousand\[CloseCurlyDoubleQuote]. Remarkably, \
there are no specific terms for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"4", " "}]], TraditionalForm]],ExpressionUUID->
  "4e05b950-5259-41f2-a254-71fb805dc4d9"],
 "and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "5"], TraditionalForm]],ExpressionUUID->
  "c2b4abd5-e8fc-4766-8881-e172ea00240a"],
 " in all the languages in the package. Perhaps French may have a more common \
acceptance of the Greek myriad = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["100", "2"], TraditionalForm]],ExpressionUUID->
  "886e28a3-eb7d-4e62-9e64-e06cd10f28ac"],
 ". This is another breach of the place value system. Wikipedia (a portal and \
no source) observes the lack too, and mentions Greek myriad and Indian lakh. \
I have adopted these words for the languages mentioned in the packages too. \
It takes some adjustment to hear 500,000 being pronounced as 5 lakh, but such \
adjustment is the very purpose of the exercise. It is not an urgent issue for \
kindergarten though."
}], "Text",ExpressionUUID->"6316c80d-e408-471f-808e-785db04a7331"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"500000", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",Expressi\
onUUID->"d34bd369-a92f-4840-b867-97c88fe5e5d9"],

Cell[BoxData[
 FormBox["\<\"five\[CenterDot]lakh\"\>", TraditionalForm]], "Output",Expressio\
nUUID->"a830ef07-f96d-4d4c-b149-4fbf132538cf"]
}, Open  ]],

Cell["\<\
These names are used in the main method that pronounces each entry \
separately. When the blocks of 3 digits are pronounced then they are \
superfluous.\
\>", "Text",ExpressionUUID->"3ca23b10-2f7d-437b-85fd-997e2d58acc7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". The sign"
}], "Subsection",ExpressionUUID->"b5361e00-b2fc-49bb-8bd2-01afe5c04f8b"],

Cell[TextData[{
 "The proper pronunciation of the minus sign in numbers is \
\[OpenCurlyDoubleQuote]negative\[CloseCurlyDoubleQuote], because \
\[OpenCurlyDoubleQuote]minus\[CloseCurlyDoubleQuote] is used for the binary \
operation. ",
 StyleBox["Mathematica\[CloseCurlyQuote]",
  FontSlant->"Italic"],
 "s IntegerName gives the number and uses \[OpenCurlyDoubleQuote]negative\
\[CloseCurlyDoubleQuote] indeed. "
}], "Text",ExpressionUUID->"5d18b350-b8d1-4009-aabf-33bb229a1e2d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartialPlaceValue", "[", 
  RowBox[{"-", "10"}], "]"}]], "Input",ExpressionUUID->"eace1411-ac68-4f04-\
840c-2307de8919df"],

Cell[BoxData[
 FormBox["\<\"negative ten\"\>", TraditionalForm]], "Output",ExpressionUUID->"8a7ac892-dd0f-449d-8b59-86bf81cd3d8f"]
}, Open  ]],

Cell["\<\
The new routines allow us to show the structure of the place value system.\
\>", "Text",ExpressionUUID->"e8d4fd39-ae4e-4abd-aafa-c5df734254c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{
   RowBox[{"-", "10"}], ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",Expre\
ssionUUID->"bee22bc1-5faf-4153-a544-9558a8a47622"],

Cell[BoxData[
 FormBox["\<\"negative one\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  zero\[CenterDot]one\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"15198ac8-29a8-45e0-a222-\
997f6e154233"]
}, Open  ]],

Cell[TextData[{
 "Unfortunately ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "uses Minus[",
 StyleBox["x",
  FontSlant->"Italic"],
 "] for -",
 StyleBox["x, ",
  FontSlant->"Italic"],
 "and also pronounces it that way (it may pronounces the format in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rather than the number). Wikipedia (a portal and no source) regards \
\[OpenCurlyDoubleQuote]negative\[CloseCurlyDoubleQuote] as American English, \
but the better diagnosis is that British English is imprecise. Dutch can \
distinguish 7 minus 10 = min 3."
}], "Text",ExpressionUUID->"785de669-22a0-47cc-a2c7-e175cc5b65d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Minus"}]], "Input",ExpressionUUID->"224c2900-c32b-4f14-b816-c37c7048b5aa"],

Cell[BoxData[
 RowBox[{"\<\"\\!\\(\\*RowBox[{\\\"-\\\", StyleBox[\\\"x\\\", \
\\\"TI\\\"]}]\\) is the arithmetic negation of \\!\\(\\*StyleBox[\\\"x\\\", \
\\\"TI\\\"]\\). \"\>", "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minus"]}]], "Print", "PrintUsage",
 CellTags->
  "Info2763735558483-8910602",ExpressionUUID->"5cd5b3eb-85eb-481c-a10d-\
be0b3eb04703"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Minus", "[", "10", "]"}], ",", " ", 
   RowBox[{"-", "10"}]}], "}"}]], "Input",ExpressionUUID->"8019815f-ca64-4fc5-\
9256-f5810979cfc1"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "10"}], ",", 
    RowBox[{"-", "10"}]}], "}"}], TraditionalForm]], "Output",ExpressionUUID->\
"18c78772-3bb4-4b91-aa90-502a2b6cc953"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Speak", "[", "%", "]"}]], "Input",ExpressionUUID->"8dffe4cf-1508-4d63-9181-ba7ebbdab83c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". History, tradition, assumptions, advantages"
}], "Section",ExpressionUUID->"4f57d334-90ba-4ab9-a136-ee836f6a4eda"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". History of proposals for change"
}], "Subsection",ExpressionUUID->"b107f0f6-43a5-4f6c-b298-150ad443f237"],

Cell["\<\
Jane Austen (1775-1817) apparently still wrote \[OpenCurlyDoubleQuote]three \
and twenty\[CloseCurlyDoubleQuote] insteady of \
\[OpenCurlyDoubleQuote]twenty-three\[CloseCurlyDoubleQuote]. The English \
speaking people are lucky that they managed the change on the order (major) \
though unlucky with the loss of \[OpenCurlyDoubleQuote]and\
\[CloseCurlyDoubleQuote] (minor).\
\>", "Text",ExpressionUUID->"701564d1-1be3-4f18-9769-b8b069e23c1a"],

Cell["Norway managed the change in the 1950s.", "Text",ExpressionUUID->"9e98273e-8bc9-47e4-a486-7f6ebce80f22"],

Cell["\<\
Fred Schuh (1875-1966) of TU Delft proposed this in the 1950s in Holland but \
he didn\[CloseCurlyQuote]t convince the minister of education. I am not aware \
of other Dutch authors who propose this nowadays.\
\>", "Text",ExpressionUUID->"b4c67a8a-00ad-49ea-bc27-fd108e4832d6"],

Cell["\<\
In Germany there is a small movement with Lothar Gerritzen to change their \
\"ein und zwanzig\" (perhaps no blanks) into \"zwanzigeins\" (apparently no \
blanks): https://zwanzigeins.jetzt/\
\>", "Text",ExpressionUUID->"0ab4c52b-6568-4c47-bf36-4b87b1d3b8dc"],

Cell["\<\
In Denmark there are Lisser Rye Ejersbo and Morten Misfeldt at Aarhus. \
Ejersbo recommends the recent book of the 23rd ICMI conference,  Bussi & Sun \
(ed.)(2018). See \
http://vbn.aau.dk/da/publications/danish-number-names-and-number-concepts(\
7b79a70d-d42b-49dc-af1f-75775c9292f6)/export.html  \
\>", "Text",ExpressionUUID->"68dae29b-ce3e-451b-9fb5-d8bc70196662"],

Cell[TextData[{
 "China uses the place value system in the form of Level 2 discussed below. I \
am only kicking in open doors. It might be an option to translate a number \
first into Chinese and then transcribe back, see Uy (2003) . However, this \
present notebook with package gives more control and includes didactic \
notions. Chinese does not pronounce the connective \[OpenCurlyDoubleQuote]&\
\[CloseCurlyDoubleQuote] (though it is implied) and we should better use it. ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "already provides this routine."
}], "Text",ExpressionUUID->"0e4f95a0-6be5-48ba-b1b0-3be3e3b446b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IntegerString", "[", 
     RowBox[{
      RowBox[{"10", "^", "k"}], ",", " ", 
      "\"\<TraditionalChineseDecimal\>\""}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"k", ",", " ", "0", ",", " ", "4"}], "}"}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"5899e718-c4a8-4c66-be8f-0c9af8ed7d3b"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"\:4e00\"\>", ",", "\<\"\:4e00\:3007\"\>", 
    ",", "\<\"\:4e00\:3007\:3007\"\>", 
    ",", "\<\"\:4e00\:3007\:3007\:3007\"\>", 
    ",", "\<\"\:4e00\:3007\:3007\:3007\:3007\"\>"}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"0918e733-fb84-4657-b1e0-\
a23fa281e3fd"]
}, Open  ]],

Cell["\<\
Fateman (2013) discusses computerised speaking of math, with a proper \
distinction between how we currently pronounce the numbers and how we \
\[OpenCurlyDoubleQuote]should\[CloseCurlyDoubleQuote] do this. It is much \
wider and deeper than my  present purposes.\
\>", "Text",ExpressionUUID->"ffb3dfa6-fe61-468e-9cd5-da79fe4cda2c"],

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "provides routines IntegerName and WordTranslation but we cannot always use \
them, since (i) we must avoid the breaches, put terms into proper order and \
get rid of \[OpenCurlyDoubleQuote]twenty\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]ten thousand\[CloseCurlyDoubleQuote], and (ii) we want \
to show the intermediate steps without simplification so that kids can see \
what the place value system actually is."
}], "Text",ExpressionUUID->"a9e162e3-9b54-48aa-b8df-5e9728a62ffb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Tradition is not without reason but still counterproductive"
}], "Subsection",ExpressionUUID->"2462ab98-6b3b-4a3f-816f-888b01c28089"],

Cell["\<\
Traditional pronunciation and its didactics are not without reason. \
\>", "Text",ExpressionUUID->"e8b2ee5b-f448-423b-a0f3-69b45ae05a31"],

Cell["\<\
Kids start with 0-10, in which 10 is a new name \"ten\" and not \"1\
\[CenterDot]ten\" and then simplified. These kids would use grouping \
(multiplication) but have no developed vocabulary and command on this. When \
continuing with 11-20 (\"eleven\" is \"one left over\" after 10) and speaking \
from right to left (and perhaps writing so too), they write 19 and in the \
conventional dialect speak \"nine-teen\", which fits the order of their low \
numbers writing from right to left. Our reference to left and right is tricky \
since kids might still be struggling with which is what. \"Twenty\" again is \
a single notion, since kids might not have command of multiplication yet. In \
English kids make the switch to \"speak the highest place value first\" at \
20. In German and Dutch they do so at 100. This focus might make sense in \
kindergarten and Grade 1, if we neglect the existence of other numbers, or if \
we neglect that the same kids in kindergarten and Grade 1 grow up and have to \
learn those other numbers too.\
\>", "Text",ExpressionUUID->"136c6d0e-b6c0-44d9-8b89-0f079b9de358"],

Cell[TextData[{
 "If kids in kindergarten and elementary really started out writing from \
right to left in general, also for words, from the argument that empirical \
research has shown that this would be easier for them, then one might have an \
argument that 13 best is pronounced from right to left. Likely though, the \
order survives from the Fibonacci\[CloseCurlyQuote]s ",
 StyleBox["Liber Abaci ",
  FontSlant->"Italic"],
 "of 1202. Not only the current order but also the traditional pronunciation \
is simply ",
 StyleBox["imposed ",
  FontSlant->"Italic"],
 "upon them, with the only argument that school teaches tradition for the \
sake of tradition. A change may require retraining kindergarten teachers who \
may be weak on arithmetic anyway yet this is a one-time investment with major \
persistent benefits."
}], "Text",ExpressionUUID->"8544f518-6051-425b-a4b4-2a1ff0f7fae2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Assumptions"
}], "Subsection",ExpressionUUID->"2324503b-0afd-4140-9e3f-c451bcb77958"],

Cell["Full use of the place value system:", "Text",ExpressionUUID->"8d04974f-bc81-444e-ad37-c1e4048f5f5c"],

Cell[CellGroupData[{

Cell["\<\
does not require kids to understand formal multiplication and have command of \
the table of 10 and later the powers of 10, but only adopts a pronunciation \
and way of writing of both numerals and words that support this later \
development rather than hindering it\
\>", "ItemNumbered",ExpressionUUID->"6816dfe3-081f-43a1-911f-1080820dfd69"],

Cell["\<\
makes the switch to \"spreak the highest place value first\" already at 10 \
(and not 20 or 100), which is precisely the moment when the phenomenon occurs \
for the first time, and which thus establishes the system without exception \
(and kids can be told about this rule)\
\>", "ItemNumbered",ExpressionUUID->"5f292f1a-d261-4a7e-91f7-385b49c2891d"],

Cell["\<\
recognises that \"teen\" and \"ty\" (indeed in the world of sounds) are \
useful indicators for value (compare: three, thirteen, thirty, third) but \
sees more profit in fully using the place value system so that value \
transpires from the structure in the pronunciation rather than from employing \
different sounds (since sounds can also sabotage and obscure the structure).\
\>", "ItemNumbered",ExpressionUUID->"afe9767f-562a-4d86-ab45-b2660318ef39"]
}, Open  ]],

Cell[TextData[{
 "This approach makes the assumption that kids can acquire a structure. This \
is a weak assumption since kids can already acquire language and a sense of \
reality that are filled with all kinds of structures. If kids can learn \
something illogical then they should be able to learn something logical. \
Chinese kids learn the place value system on a regular basis. Our topic is \
not really an issue of empirical research but one of traditional thinking in \
the world of educators and researchers. Complications are: The latter world \
of education may have little command of mathematics and think that tradition \
already captures mathematics. ",
 StyleBox["Sacrosanct ",
  FontSlant->"Italic"],
 "means: high respect for something that you do not grasp. Mathematicians \
dealing with arithmetic in school may think abstractly and have no background \
in empirics, and focus on learning the numerals."
}], "Text",ExpressionUUID->"22520985-02e0-49f1-b2c7-cca82c28e19a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Main advantages"
}], "Subsection",ExpressionUUID->"ca9f0a94-4a4e-4c91-b5fa-71b3f9398bca"],

Cell[TextData[{
 "To teach the place value system, it is advisable",
 StyleBox[" to actually use it",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"10d08bc5-c7ef-4e5c-8781-dea5332eb335"],

Cell[CellGroupData[{

Cell["\<\
Pronuncation (that kids start with) would be co-ordinated with the numerals, \
and later with the written words. (Number: pronunciation, numeral, word.)\
\>", "Item",ExpressionUUID->"df71fc2f-3eb6-45ce-9293-b20fcebb3a95"],

Cell["\<\
The workflow is into a single direction, and does not jump around.\
\>", "Item",ExpressionUUID->"aeda0c55-11fd-49b0-a429-7014bddae90e"],

Cell["\<\
Merely speaking a number aloud can already solve calculation questions. (For \
many kids: thinking may be \[OpenCurlyDoubleQuote]subvocalised speaking\
\[CloseCurlyDoubleQuote], as reading is subvocalised.)\
\>", "Item",ExpressionUUID->"4de36ae4-61a8-4db4-a627-72bb6b01772a"],

Cell["\<\
Current co-ordination failures (i.e. the breaches) often are not discussed so \
that kids simply do not know why they find issues complicated, and they are \
groping in the dark. \
\>", "Item",ExpressionUUID->"38948c75-734b-4696-83d1-7817b6939bb6"],

Cell["\<\
There will be a sizeable savings in teaching and learning time, that can be \
spent on real issues.\
\>", "Item",ExpressionUUID->"e7fe130c-e95a-456f-b864-8831322a11d9"],

Cell["\<\
Research on mathematical skill and number sense is highly contaminated by \
this pronunciation issue. Much research draws invalid conclusions. Doing good \
research is quite impossible because you cannot simply experiment on kids by \
first training them on your own theory on the place value method. We neither \
can compare international results when there is such variety and invalidity. \
(In studies in Holland and Denmark, kids were observed to use English, and \
telling others to do so too, because they better understood the numbers in \
that way.) \
\>", "Item",ExpressionUUID->"3d8f6436-b2a6-4344-88ff-1648bb5c8cf0"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". A structure for the curriculum"
}], "Section",ExpressionUUID->"8228ad1f-a662-4922-a9dd-e46a6f07fd68"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Overview"
}], "Subsection",ExpressionUUID->"907e9818-6f1b-4f51-93c7-945b6b83e13c"],

Cell["\<\
This notebook with package is not intended as a course on the full place \
value system for kindergarten and elementary school. Teachers would tend to \
start with discussion in print for their first orientation. Colignatus \
(2015b, 2018a) is such an introduction, and provides tables for the \
pronunciation of the integers in the full place value system, for English, \
German, French, Dutch and Danish. This notebook with package supplements this \
material with the ability of sound (basically in $Language, but for practical \
purposes now in transliteration). We mimick the situations that kids would be \
in, at different levels of competence. The purpose of this Section is to \
indicate which aspect of the place value system is highlighted by what \
routine. \
\>", "Text",ExpressionUUID->"92ba9114-9b6f-493a-b68f-19b74e22dfe4"],

Cell["\<\
We will quote from: http://www.corestandards.org/Math/Content/NBT.\
\>", "Text",ExpressionUUID->"b01421d1-61aa-430b-8a3d-3bcf5f74e7eb"],

Cell[TextData[{
 "Below we start with counting but of course quickly meet with the transition \
from counting to addition. We focus on the pronunciation and leave this \
transition aside, though there is a clear link of course between the \
ampersand and plus. See Colignatus (2018b),",
 StyleBox[" Tables for addition and subtraction with better use of the place \
value system.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"5d46543d-6074-4c45-bb98-d664181ef0af"],

Cell["\<\
For the curriculum on the place value system we can recognise a structure \
with the following levels. Per level there is a supporting routine. We first \
discuss the levels, and later collect them into a switching routine. This \
switching routine can now be used for a quick overview of what the routines \
do. These examples use higher numbers merely to show the properties. \
Obviously kids start with 0-10 but such a number doesn\[CloseCurlyQuote]t \
highlight what the routine does.\
\>", "Text",ExpressionUUID->"c6e679d2-93e6-478e-8c8a-847e346c9643"],

Cell[TextData[{
 StyleBox["Level 1.",
  FontWeight->"Bold"],
 " Sounds only (kids cannot read and write). Words record the sounds for us. \
Speaking them gives their world."
}], "Text",ExpressionUUID->"d13f20fb-830a-4e9f-ace0-8341fe62d12d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PronounceInteger", "[", 
   RowBox[{"12", ",", " ", 
    RowBox[{"Level", " ", "\[Rule]", " ", "1"}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}], "   ", 
  RowBox[{"(*", 
   RowBox[{"overview", " ", "without", " ", "Speak"}], "*)"}]}]], "Input",Expr\
essionUUID->"c32dc581-d3b3-4f09-835f-f1732ba8ae27"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
two\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->"8ba2a7e9-\
90dd-4dbc-a8cc-0c2a25b4fe39"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Level 2. ",
  FontWeight->"Bold"],
 "Learning the digits and numerals (already having the sounds for the digits)."
}], "Text",ExpressionUUID->"d6ba139b-d0b4-496c-af60-0d75054e735f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PronounceInteger", "[", 
   RowBox[{"1234", ",", " ", 
    RowBox[{"Level", " ", "\[Rule]", " ", "2"}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
    RowBox[{"Print", " ", "\[Rule]", " ", "False"}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"overview", " ", "without", " ", "Speak"}], "*)"}]}]], "Input",Expr\
essionUUID->"0c2b47b7-1d9a-428d-83f1-37cc5fcdb08a"],

Cell[BoxData[
 FormBox["\<\"1000   &   2 \[CenterDot] 100   &   3 \[CenterDot] 10   &   4\"\
\>", TraditionalForm]], "Output",ExpressionUUID->"fd12b677-9e9d-4bc3-ada4-\
b84a28120dd5"]
}, Open  ]],

Cell["Also learning how to write the words.", "Text",ExpressionUUID->"7c9faa32-adbe-4a02-b365-0ceef44c92fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PronounceInteger", "[", 
   RowBox[{"1234", ",", " ", 
    RowBox[{"Level", " ", "\[Rule]", " ", "2"}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}], " ", 
  RowBox[{"(*", "default", "*)"}]}]], "Input",ExpressionUUID->"ab7a755c-940a-\
402c-af4d-f9679a3b0cea"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]thousand  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\
\\)  two\[CenterDot]hundred  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
three\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  four\
\[CenterDot]\"\>", TraditionalForm]], "Print",ExpressionUUID->"7874b6ed-46d7-\
4f09-96c7-4e967a24eebd"],

Cell[BoxData[
 FormBox["\<\"1000   &   2 \[CenterDot] 100   &   3 \[CenterDot] 10   &   4\"\
\>", TraditionalForm]], "Output",ExpressionUUID->"ba548d4c-2056-49e5-a0d7-\
ffd52e17fcee"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Level 3.",
  FontWeight->"Bold"],
 " Advanced: putting digits in blocks of three. (There are slightly special \
lists because we want to Speak \[OpenCurlyDoubleQuote]one hundred\
\[CloseCurlyDoubleQuote] instead of \[OpenCurlyDoubleQuote]one one-hundred\
\[CloseCurlyDoubleQuote].)"
}], "Text",ExpressionUUID->"587f5540-c05a-4d77-9430-674f6f3ab5b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PronounceInteger", "[", 
   RowBox[{"123456", ",", " ", 
    RowBox[{"Level", " ", "\[Rule]", " ", "3"}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"overview", " ", "without", " ", "Speak"}], "*)"}]}]], "Input",Expr\
essionUUID->"05e7e654-2965-4364-bfd2-fc3bdc0279d2"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"1 \[CenterDot] 100\"\>", ",", "\<\" & \"\>", 
        ",", "\<\"2 \[CenterDot] 10    &    3\"\>"}], "}"}], ",", "1000"}], 
     "}"}], ",", "\<\" & \"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"4 \[CenterDot] 100\"\>", ",", "\<\" & \"\>", 
      ",", "\<\"5 \[CenterDot] 10    &    6\"\>"}], "}"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"a1434104-3624-4695-8db3-\
f0593e9548b4"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Level 4.",
  FontWeight->"Bold"],
 " Accomplished: using blocks of three digits (but pronounced in full place \
value)."
}], "Text",ExpressionUUID->"9ce2d523-c77b-4019-ad12-7141f5266244"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PronounceInteger", "[", 
   RowBox[{"123456", ",", " ", 
    RowBox[{"Level", " ", "\[Rule]", " ", "4"}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"overview", " ", "without", " ", "Speak"}], "*)"}]}]], "Input",Expr\
essionUUID->"1fe34dcc-6d11-4bcf-828a-dc3459b3a693"],

Cell[BoxData[
 FormBox["\<\"123  thousand,   456\"\>", TraditionalForm]], "Output",Expressio\
nUUID->"48eddee4-bdc0-44e9-b870-8993d33ccefd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"32e2bfbc-f8e9-4e45-b2df-4c53713f6675"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]hundred  &  two\[CenterDot]ten  &  \
three\[CenterDot]  thousand,   four\[CenterDot]hundred  &  \
five\[CenterDot]ten  &  six\[CenterDot]\"\>", TraditionalForm]], "Output",Expr\
essionUUID->"79cfdae8-9a15-40f3-a7bf-a455118874f4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 1. Sounds"
}], "Subsection",ExpressionUUID->"dd7f7cea-ff28-4c7c-bbc8-617637fe8fd6"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". No reading and writing yet"
}], "Subsubsection",ExpressionUUID->"0b4e0786-4a8d-417e-ab93-befef5f9e1bf"],

Cell["\<\
Kids in kindergarten start with pronunciation. They cannot read and write \
yet. Their sounds are encoded in words but only the teacher would know how to \
write those words. The teacher must get used to the full place value system, \
and will first rely on written words. The advantage of using words is that \
the pronunciation becomes unambiguous for the particular language. \
\>", "Text",ExpressionUUID->"b5dd6183-60d1-4879-8239-d5dc250668df"],

Cell["\<\
The main routine supports this situation by using words for pronunciation and \
transliteration.  We produce the sounds that kids would hear and what they \
would copy in rehearsing, and we print the spoken words in the chosen \
language for the sake of the teacher. The routine speaks in $Language (here \
\"English\") but may use transliteration.\
\>", "Text",ExpressionUUID->"7f173597-b729-4c1c-8798-0afe996133e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PlaceValue", "[", 
    RowBox[{"#", ",", " ", 
     RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], "]"}], 
   "&"}], " ", "/@", " ", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", " ", "10"}], "]"}]}]], "Input",ExpressionUUID->"4c0518c4-\
1172-4e42-981d-78b2fa731d0f"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"zero\[CenterDot]\"\>", ",", "\<\"\[CenterDot]un\"\>", 
    ",", "\<\"deux\[CenterDot]\"\>", ",", "\<\"trois\[CenterDot]\"\>", 
    ",", "\<\"quatre\[CenterDot]\"\>", ",", "\<\"cinq\[CenterDot]\"\>", 
    ",", "\<\"six\[CenterDot]\"\>", ",", "\<\"sept\[CenterDot]\"\>", 
    ",", "\<\"huit\[CenterDot]\"\>", ",", "\<\"neuf\[CenterDot]\"\>", 
    ",", "\<\"\[CenterDot]dix\"\>"}], "}"}], TraditionalForm]], "Output",Expre\
ssionUUID->"be1bd2fe-37d1-43e8-bde3-ae5288eeff5a"]
}, Open  ]],

Cell["\<\
Rehearsing the sequence will cause kids to regard these words as a sequence, \
and the sequence can be related to other phenomena.\
\>", "Text",ExpressionUUID->"492c38ae-5460-4e76-b164-ae882c002702"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Common Core on 11-19 in sounds"
}], "Subsubsection",ExpressionUUID->"afee3218-0698-4c08-81c5-afe829aabb79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathContent", "[", 
   RowBox[{
   "\"\<Kindergarten\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", "\"\<A.1\>\""}],
    "]"}], " "}]], "Input",ExpressionUUID->"77989bfb-4e22-44ad-b163-\
8af1142da806"],

Cell[BoxData[
 FormBox["\<\"Work with numbers 11-19 to gain foundations for place value. \
CCSS.Math.Content.K.NBT.A.1.\\n  Compose and decompose numbers from 11 to 19 \
into ten ones and some further ones, e.g., by using objects or drawings, and \
record each composition or decomposition by a drawing or equation (such as 18 \
= 10 + 8); understand that these numbers are composed of ten ones and one, \
two, three, four, five, six, seven, eight, or nine ones.\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"e388e4ab-7201-42b2-8307-\
d80c3feb829a"]
}, Open  ]],

Cell[TextData[{
 "Observe that CCSS speaks about \[OpenCurlyDoubleQuote]ten ones\
\[CloseCurlyDoubleQuote] instead of \[OpenCurlyDoubleQuote]ten of one\
\[CloseCurlyDoubleQuote], and see the rejection of \
\[OpenCurlyDoubleQuote]ones\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]tens\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]hundreds\[CloseCurlyDoubleQuote] above. Kids can \
collect ten apples in a basket of ten. They can agree that there are ",
 StyleBox["ten of 1 apple",
  FontSlant->"Italic"],
 " and ",
 StyleBox["1 basket of ten apples",
  FontSlant->"Italic"],
 ". If kids can count, then they also should know what they are counting \
(fingers, cars, baskets), and thus it is proper to explicitly discuss with \
them what to take as unit of account. Taking the basket of ten as the base, \
they may accept that a number is spoken as \[OpenCurlyDoubleQuote]one of ten\
\[CloseCurlyDoubleQuote] but simplified to ten since this is the base. "
}], "Text",ExpressionUUID->"a3086da8-5907-4a2b-99fd-6845ab1bd6b5"],

Cell["\<\
Instead of rehearsing all numbers from 0 to 20, we speak a small selection \
now.\
\>", "Text",ExpressionUUID->"367b57f3-c5d2-4234-bb90-a4e8b2952c2b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"PlaceValue", " ", "/@", " ", 
    RowBox[{"Range", "[", 
     RowBox[{"8", ",", " ", "13"}], "]"}]}], ")"}], " ", "//", " ", 
  "MatrixForm"}]], "Input",ExpressionUUID->"d791c9c7-fb8a-4359-80cf-\
ac52842cb6ca"],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", 
    TagBox[GridBox[{
       {"\<\"eight\[CenterDot]\"\>"},
       {"\<\"nine\[CenterDot]\"\>"},
       {"\<\"\[CenterDot]ten\"\>"},
       {"\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
\[CenterDot]one\"\>"},
       {"\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
two\[CenterDot]\"\>"},
       {"\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
three\[CenterDot]\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.5599999999999999]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Column], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], TraditionalForm]], "Output",ExpressionUUID->\
"34b930ac-2a94-42ef-8117-abf6b7afcf00"]
}, Open  ]],

Cell["The latter in French.", "Text",ExpressionUUID->"f7db2c3b-d9d4-47ce-95ea-1ab0fd4045fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"PlaceValue", "[", 
      RowBox[{"#", ",", " ", 
       RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], "]"}], 
     "&"}], " ", "/@", " ", 
    RowBox[{"Range", "[", 
     RowBox[{"8", ",", " ", "13"}], "]"}]}], ")"}], " ", "//", " ", 
  "MatrixForm"}]], "Input",ExpressionUUID->"184435d3-c3ea-415c-b114-\
6b11cb8850f2"],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", 
    TagBox[GridBox[{
       {"\<\"huit\[CenterDot]\"\>"},
       {"\<\"neuf\[CenterDot]\"\>"},
       {"\<\"\[CenterDot]dix\"\>"},
       {"\<\"\[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
\[CenterDot]un\"\>"},
       {"\<\"\[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
deux\[CenterDot]\"\>"},
       {"\<\"\[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
trois\[CenterDot]\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.5599999999999999]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Column], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], TraditionalForm]], "Output",ExpressionUUID->\
"c1eb3a52-cf8f-4ee2-aa7c-7ab14fc155a4"]
}, Open  ]],

Cell["\<\
If your $Language = \[OpenCurlyDoubleQuote]English\[CloseCurlyDoubleQuote] \
too, then you can verify that the latter French words were transliterated in \
English.\
\>", "Text",ExpressionUUID->"393e3262-5ce0-4454-971c-8cfa51098463"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LatestPronunciation", "[", "]"}], " "}]], "Input",ExpressionUUID->\
"679de973-c903-4080-8237-b3d20f5d6ff8"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]dees <silence msec=\\\"300\\\"/>  ayh  trouwah\
\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->"160584e7-9eeb-\
44c2-ba1d-a5d0aa03e88b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". A possible exercise still in speaking only"
}], "Subsubsection",ExpressionUUID->"b40861dc-0436-42e1-a89c-83852c282f54"],

Cell["\<\
The following exercise is only in English and not in the other languages. The \
routine has the answer of the sum as input. In this case we select an outcome \
less than 20.\
\>", "Text",ExpressionUUID->"7267bc0c-e5d3-4dea-ae41-b974c6c38467"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathExercise", "[", 
   RowBox[{"15", ",", " ", "12", ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "True"}]}], "]"}], "  "}]], "Input",\
ExpressionUUID->"5d5e7b95-0568-49e6-8479-6db961eeb3b5"],

Cell[BoxData[
 FormBox["\<\"You know the numbers three\[CenterDot] and \[CenterDot]ten  \\!\
\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  two\[CenterDot], and how to speak \
them. You now count three\[CenterDot] up from \[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  two\[CenterDot], and then you \
find the number \[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\) \
 five\[CenterDot]. You now learn to speak the number \[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  five\[CenterDot].\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"a0c0666f-95a8-4a84-939e-\
120dc7398d0e"]
}, Open  ]],

Cell["The exercise is done by speaking the counts.", "Text",ExpressionUUID->"a45ce415-5a1d-4f01-832b-3e3e79d03c39"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"PlaceValue", " ", "/@", " ", 
    RowBox[{"Range", "[", 
     RowBox[{"12", ",", " ", "15"}], "]"}]}], ")"}], " ", "//", " ", 
  "MatrixForm"}]], "Input",ExpressionUUID->"71fbc622-f522-415b-8b66-\
f304aa8a0128"],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", 
    TagBox[GridBox[{
       {"\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
two\[CenterDot]\"\>"},
       {"\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
three\[CenterDot]\"\>"},
       {"\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
four\[CenterDot]\"\>"},
       {"\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
five\[CenterDot]\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.5599999999999999]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Column], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], TraditionalForm]], "Output",ExpressionUUID->\
"744346cd-8740-4ccf-8273-1af1264e3cf1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 2. Sounds and numerals, and then reading and writing"
}], "Subsection",ExpressionUUID->"691f773c-a1ee-46c8-8426-fedc33f63930"],

Cell["\<\
At the second level, kids learn to read and write the digits 0, ..., 9 and \
the numerals 0, ..., 9. \
\>", "Text",ExpressionUUID->"9d61baf4-49ea-45eb-81ef-d39cf0c23df6"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Showing the numeral and speaking it"
}], "Subsubsection",ExpressionUUID->"14727591-dd20-40ee-9a47-63100c2f6a91"],

Cell["\<\
The first step mimicks this learning process by showing the numeral and \
speaking the (transliterated) word. Running this routine often might cause \
that the association between the sound and the picture is transferred into \
human memory.\
\>", "Text",ExpressionUUID->"cb2a255d-1bb2-45f5-a4b6-817b21b96edf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"4", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}], ",", " ", 
    RowBox[{"Print", " ", "\[Rule]", " ", "False"}]}], "]"}], " "}]], "Input",\
ExpressionUUID->"f9ad06a1-184c-4b4e-b686-1c7160f1fc93"],

Cell[BoxData[
 FormBox["\<\"4\"\>", TraditionalForm]], "Output",ExpressionUUID->"2cca5c89-971d-42f1-a23a-425a5487df30"]
}, Open  ]],

Cell["\<\
Of course, this does not yet give information about how this 4 relates to the \
other numbers. We are only discussing the link between the pronunciation \
(often already known) and the figure.\
\>", "Text",ExpressionUUID->"0e7e8eda-cf35-41fe-b635-4269006e5714"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Showing the numeral, speaking it, and learning the word"
}], "Subsubsection",ExpressionUUID->"b91dc25d-75c8-4214-bfd9-08eeb37dfa57"],

Cell["\<\
In a second step kids also learn the word. The routine shows the numeral and \
official word, and speaks the (transliterated) word. Again, running the \
routine often might cause that the association is transferred into human \
memory. I do not want to imply that kids first must learn to write the word \
before they can continue with the numerals. This only intends to show that \
the routines can support such learning, assuming having or getting command of \
sounds.\
\>", "Text",ExpressionUUID->"60416342-615f-4f76-9536-6bb8f5c90bfb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"4", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}]}], "]"}], 
  "  ", 
  RowBox[{"(*", 
   RowBox[{"Print", " ", "default"}], "*)"}]}]], "Input",ExpressionUUID->\
"0d69d654-6b6b-4c06-8d5e-054bfe8446fb"],

Cell[BoxData[
 FormBox["\<\"quatre\[CenterDot]\"\>", TraditionalForm]], "Print",ExpressionUU\
ID->"7ccd76fc-2a39-4d47-8a05-2d442fbc1209"],

Cell[BoxData[
 FormBox["\<\"4\"\>", TraditionalForm]], "Output",ExpressionUUID->"8158871d-6e2a-43bd-a15c-89b939843fba"]
}, Open  ]],

Cell["\<\
The following statement collects the input, what has been printed and spoken, \
and the output. \
\>", "Text",ExpressionUUID->"ed5e883c-6249-4441-a8c0-5b9431a560c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", " ", 
   RowBox[{"LatestPronunciation", "[", "Print", "]"}], ",", " ", 
   RowBox[{"LatestPronunciation", "[", "]"}], ",", " ", "result"}], 
  "}"}]], "Input",ExpressionUUID->"8885b0ae-746f-429b-b8ed-1b9d1d404a63"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "4", ",", "\<\"quatre\[CenterDot]\"\>", ",", "\<\"kahtruh\[CenterDot]\"\>",
     ",", "\<\"4\"\>"}], "}"}], TraditionalForm]], "Output",ExpressionUUID->\
"b21ba155-7ba9-4737-b684-e666181056b3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". The digit / numeral by itself is not place value yet"
}], "Subsubsection",ExpressionUUID->"fbcb7d41-4f3a-411d-8064-6676757d6dee"],

Cell["\<\
Observe that digits do not have a trailing dot. Learning the digits differs \
from learning the numbers in a place value system. The digits could also be \
used in another system.\
\>", "Text",ExpressionUUID->"44b0853d-d38c-4742-b628-d3b850c0ca47"],

Cell["\<\
It depends upon didactics and empirical research whether it is useful at this \
stage to discuss that 4 can also be understood as 4\[CenterDot]1 in full \
place value system. Likely this would be totally confusing. I advise against \
this, and I actually do not think that research on this would be so urgent.\
\>", "Text",ExpressionUUID->"dcead662-b95c-45ab-9b96-849fccdda16d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"4", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}], ",", " ", 
    RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}]}], "]"}], 
  "  "}]], "Input",ExpressionUUID->"02906bd4-dbf8-4ea5-8582-3ab0770316d5"],

Cell[BoxData[
 FormBox["\<\"quatre\[CenterDot]un\"\>", TraditionalForm]], "Print",Expression\
UUID->"85094dd8-d564-4b44-9bc8-a916bd9775c9"],

Cell[BoxData[
 FormBox["\<\"4 \[CenterDot] 1\"\>", TraditionalForm]], "Output",ExpressionUUI\
D->"6bdbcfb5-53ed-4863-aaf1-3602439df5fe"]
}, Open  ]],

Cell[TextData[{
 "The latter gives the new number denoted in the place value system (though \
not yet constructed at this stage), its unsimplified pronunciation, and its \
decomposition in the ",
 StyleBox["weighted ",
  FontSlant->"Italic"],
 "place values. Do not use this here. It only becomes a useful insight when \
the system is already quite developed. I only mention it here to issue the \
warning not to use it here."
}], "Text",ExpressionUUID->"88bbeabc-1154-4970-b437-69aeec1cc1f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Introducing the symbol 10"
}], "Subsubsection",ExpressionUUID->"6c79858b-c5c8-4d81-8f4d-31ccd225def1"],

Cell[TextData[{
 "Once the digits and numbers 0 ... 9 have been mastered (to a sufficient \
degree to move on) there is the crucial step of ",
 StyleBox["creating ",
  FontSlant->"Italic"],
 "the positional system, moving into the numerals of 10 ... 20. "
}], "Text",ExpressionUUID->"c15b6632-0e2a-40f8-86ad-ed2773073680"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.A\>\""}], 
  "]"}]], "Input",ExpressionUUID->"83a25e62-4db7-47c1-9d1f-687d8f62727a"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.1.NBT.B.2.A\\n  10 \
can be thought of as a bundle of ten ones \[LongDash] called a \\\"ten.\\\"\"\
\>", TraditionalForm]], "Output",ExpressionUUID->"687ccf26-9b43-4cbc-acd6-\
2e608036c74c"]
}, Open  ]],

Cell["\<\
CCSS seems confused between (i) learning what ten is and (ii) learning how to \
write it in numeral and word. CCSS again speaks about \
\[OpenCurlyDoubleQuote]ten ones\[CloseCurlyDoubleQuote] instead of \
\[OpenCurlyDoubleQuote]ten of one\[CloseCurlyDoubleQuote].\
\>", "Text",ExpressionUUID->"95ee8eea-18b6-4abb-bae7-c64fa0879b10"],

Cell["\<\
Likely Grade 1 has already been counting from zero to ten because of the \
fingers. In that case the sound \[OpenCurlyDoubleQuote]ten\
\[CloseCurlyDoubleQuote]with its numerical meaning would have been introduced \
above already. (Remember CCSS.Math.Content.K.NBT.A.1 above !) The crux here \
is to relate the familiar sound to the new picture of 10 (writing is drawing \
small pictures). The teacher can explain that there are ten digits 0, ..., 9, \
and that we need a new symbol for ten, and that this new symbol is 10. This \
will not be the telephone number \[OpenCurlyDoubleQuote]one-zero\
\[CloseCurlyDoubleQuote] but a written \[OpenCurlyDoubleQuote]10\
\[CloseCurlyDoubleQuote] is pronounced as \[OpenCurlyDoubleQuote]ten\
\[CloseCurlyDoubleQuote].\
\>", "Text",ExpressionUUID->"9a293a5d-2031-4644-b4e8-18e5e588b81c"],

Cell["\<\
Running this routine often might cause that the association between the sound \
and the picture is transferred into human memory. (It is important to \
identify the moments and methods of learning.)\
\>", "Text",ExpressionUUID->"90ddfd65-0e13-45b3-ae6e-89421bad0a1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueDigits", "[", "10", "]"}]], "Input",ExpressionUUID->"f443cd33-53ca-4008-bd1a-ac049c7934b1"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]ten\"\>", TraditionalForm]], "Print",ExpressionUUID->"64739abd-3558-4885-9edd-5d0b7d4f5099"],

Cell[BoxData[
 FormBox["\<\"10\"\>", TraditionalForm]], "Output",ExpressionUUID->"11bde66e-4f3e-423e-8e39-991fc7eb0294"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueDigits", "[", 
  RowBox[{"10", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"4234072f-8235-43e4-baf4-5a528f189f22"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]dix\"\>", TraditionalForm]], "Print",ExpressionUUID->"be019707-9e36-42bf-aa63-2c610623fbc8"],

Cell[BoxData[
 FormBox["\<\"10\"\>", TraditionalForm]], "Output",ExpressionUUID->"64f21101-849e-4539-966e-30219c9ce45e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Building up 11-19 as symbols"
}], "Subsubsection",ExpressionUUID->"d53c63fa-b917-468f-8251-e8c7f12cc33f"],

Cell["\<\
Having 10, it is easy to say that additional counts 1, ..., 9 will be \
recorded in the position of the 0. Again, kids have already learned aspects \
about the numbers 11, ..., 19 entirely in their world of sounds (see the \
subsection above), and the learning goal now is to read and write the \
figures. A major issue is to write (from left to right) first the 1 and then \
the additional count, The 1 is higher because it represents 10. The shortcut \
(pons asinorum) is that the count is recorded in the place of the 0.\
\>", "Text",ExpressionUUID->"775f1394-515b-4345-9cbe-77248ffe73a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.B\>\""}], 
  "]"}]], "Input",ExpressionUUID->"fce1c662-2810-49a4-ab4d-2c00d41b2a93"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.1.NBT.B.2.B\\n  The \
numbers from 11 to 19 are composed of a ten and one, two, three, four, five, \
six, seven, eight, or nine ones.\"\>", TraditionalForm]], "Output",ExpressionU\
UID->"e6a20a65-3443-4005-9bb0-8572cf2e27db"]
}, Open  ]],

Cell["Basically we have vector addition. ", "Text",ExpressionUUID->"5572a850-1437-461d-bff0-1cf51e718363"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", " ", "0"}], "}"}], " ", "+", " ", 
  RowBox[{"{", 
   RowBox[{"0", ",", " ", "count"}], "}"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"10", " ", "+", " ", "count"}], ",", " ", 
    RowBox[{"decomposed", " ", "by", " ", "positions"}]}], " ", 
   "*)"}]}]], "Input",ExpressionUUID->"f2977981-75aa-4739-8cf2-a14a2c0ce056"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"1", ",", "count"}], "}"}], TraditionalForm]], "Output",ExpressionU\
UID->"33388d95-d27e-4db4-8d18-880795c16d07"]
}, Open  ]],

Cell["\<\
It might become feasible to show the kids numerals in a question like this.\
\>", "Text",ExpressionUUID->"3bd1e3d8-2adf-4283-b6f6-7b2348f2c63e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathExercise", "[", 
   RowBox[{"15", ",", " ", "12", ",", 
    RowBox[{"\"\<Grade\>\"", " ", "\[Rule]", " ", "\"\<Grade 1\>\""}], ",", 
    "  ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
    RowBox[{"IntegerDigits", " ", "\[Rule]", " ", "True"}]}], "]"}], 
  "  "}]], "Input",ExpressionUUID->"9000380b-7d6a-465e-8455-60a67f2b3a8c"],

Cell[BoxData[
 FormBox["\<\"You know the numbers 3 and 12, and how to write and speak them. \
You now count 3 up from 12, and then you find the number 15. You now learn to \
write and speak the number 15.\"\>", TraditionalForm]], "Output",ExpressionUUI\
D->"1086fc89-d99e-43a9-b0b6-b59e7f671ba3"]
}, Open  ]],

Cell["\<\
The above was spoken in full place value manner. You might recognise the \
larger ampersand.\
\>", "Text",ExpressionUUID->"ff4aebc4-979a-4ef0-92ba-efded2620dc0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"3f4029e6-1a8d-4989-8bd9-fcea6e2a1ca6"],

Cell[BoxData[
 FormBox["\<\"You know the numbers three\[CenterDot] and \[CenterDot]ten  &  \
two\[CenterDot], and how to write and speak them. You now count three\
\[CenterDot] up from \[CenterDot]ten  &  two\[CenterDot], and then you find \
the number \[CenterDot]ten  &  five\[CenterDot]. You now learn to write and \
speak the number \[CenterDot]ten  &  five\[CenterDot].\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"0046fb8f-cee8-40a1-aa31-\
28fdb12d3692"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{
    RowBox[{"inp", " ", "=", " ", "15"}], ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], 
   "]"}]}]], "Input",ExpressionUUID->"a231637e-a5cb-475c-87c0-87e296330c7c"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
cinq\[CenterDot]\"\>", TraditionalForm]], "Print",ExpressionUUID->"247cf805-\
a34c-4699-9e45-780dd248a926"],

Cell[BoxData[
 FormBox["\<\"10   &   5\"\>", TraditionalForm]], "Output",ExpressionUUID->"cb17454e-c7b5-4b52-b6fa-4715ceed25e4"]
}, Open  ]],

Cell[TextData[{
 "We thus have the new number denoted in the place value system, its \
pronunciation, and its decomposition in the ",
 StyleBox["weighted ",
  FontSlant->"Italic"],
 "place values."
}], "Text",ExpressionUUID->"d37aa0ca-4c5d-4b75-8773-c26d017a0d9f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"inp", ",", " ", 
   RowBox[{"LatestPronunciation", "[", "Print", "]"}], ",", "  ", "result"}], 
  "}"}]], "Input",ExpressionUUID->"69e11500-96ae-4eaa-8724-2f98672363b9"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "15", ",", "\<\"\[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\
\\)  cinq\[CenterDot]\"\>", ",", "\<\"10   &   5\"\>"}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"9d3fa64c-7f2a-4721-8e9b-\
7125e0b774ad"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Introducing 20"
}], "Subsubsection",ExpressionUUID->"833dd599-1ae5-4eb0-9ff7-6465693b4e53"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2\>\""}], 
  "]"}]], "Input",ExpressionUUID->"693c1513-a2e0-454f-9038-15970a07dc83"],

Cell[BoxData[
 FormBox["\<\"Understand place value. \
CCSS.Math.Content.1.NBT.B.2\\nUnderstand that the two digits of a two-digit \
number represent amounts of tens and ones. Understand the following as \
special cases: B.2.A, B.2.B, B.2.C\"\>", TraditionalForm]], "Output",Expressio\
nUUID->"d1ad0311-b586-4c00-8d13-a645d7eaa920"]
}, Open  ]],

Cell["\<\
After 9, we have no longer digits available to record at the position zero, \
and we make the transition of the position.\
\>", "Text",ExpressionUUID->"38169750-f79e-4a31-be9f-1538b0d807a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", " ", "0"}], "}"}], " ", "+", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", " ", "0"}], "}"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"10", " ", "+", " ", 
    RowBox[{"10", " ", "decomposed", " ", "by", " ", "positions"}]}], 
   "*)"}]}]], "Input",ExpressionUUID->"2f1f5215-a9ca-4fdd-855d-3bcf1d4c2f40"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"2", ",", "0"}], "}"}], TraditionalForm]], "Output",ExpressionUUID-\
>"520b968f-32de-46e1-9646-c97648f7f627"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathExercise", "[", 
   RowBox[{
    RowBox[{"inp", " ", "=", " ", "20"}], ",", " ", "19", ",", 
    RowBox[{"\"\<Grade\>\"", " ", "\[Rule]", " ", "\"\<Grade 1\>\""}], ",", 
    "  ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
    RowBox[{"IntegerDigits", " ", "\[Rule]", " ", "True"}]}], "]"}], 
  "  "}]], "Input",ExpressionUUID->"a67ecacf-9250-487a-830c-239dd82dfa36"],

Cell[BoxData[
 FormBox["\<\"You know the numbers 1 and 19, and how to write and speak them. \
You now count 1 up from 19, and then you find the number 20. You now learn to \
write and speak the number 20.\"\>", TraditionalForm]], "Output",ExpressionUUI\
D->"22bf3163-2a62-482d-b480-f39c42d7e9dd"]
}, Open  ]],

Cell["\<\
From the rehearsing the sequences before, the kid likely already knows that \
20 comes after 19. The present learning goal is how to record the sound using \
digits. \
\>", "Text",ExpressionUUID->"81cec938-4fc5-4a0a-9a63-d2e138465a59"],

Cell["\<\
It depends upon empirics how much can be discussed about place value \
arithmetic. We have: 19 + 1 = 10 + 9 + 1 = 10 + 10 = 20. Thus we unpack 19, \
reorder, pack 9 + 1 and pack 10 + 10 .\
\>", "Text",ExpressionUUID->"6a831ab0-550c-4294-90eb-b0920ce95cef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"inp", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}]}], "]"}], 
  "  "}]], "Input",ExpressionUUID->"542866be-d527-4482-af18-e2d8296290e0"],

Cell[BoxData[
 FormBox["\<\"deux\[CenterDot]dix\"\>", TraditionalForm]], "Print",ExpressionU\
UID->"ced9ae8d-a9f6-43b9-aaf9-a530cb7e62c4"],

Cell[BoxData[
 FormBox["\<\"2 \[CenterDot] 10\"\>", TraditionalForm]], "Output",ExpressionUU\
ID->"6ab9bed7-0e0a-4c52-a86e-e51756b4ad9f"]
}, Open  ]],

Cell[TextData[{
 "We thus have the new number denoted in the place value system, its \
pronunciation, and its decomposition in the ",
 StyleBox["weighted ",
  FontSlant->"Italic"],
 "place values."
}], "Text",ExpressionUUID->"1f13dc3e-a256-4860-9d00-a4c6decdcca9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"inp", ",", " ", 
   RowBox[{"LatestPronunciation", "[", "Print", "]"}], ",", "  ", "result"}], 
  "}"}]], "Input",ExpressionUUID->"4db6c2d3-f09a-4d96-a421-04a1c8ab0dfd"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "20", ",", "\<\"deux\[CenterDot]dix\"\>", 
    ",", "\<\"2 \[CenterDot] 10\"\>"}], "}"}], TraditionalForm]], "Output",Exp\
ressionUUID->"34083d85-a440-4712-9ffd-6d1a0ab8649a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Building up 21-29"
}], "Subsubsection",ExpressionUUID->"78dbf143-2424-4f05-9686-53eccc04ee1c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2\>\""}], 
  "]"}]], "Input",ExpressionUUID->"55be71f4-aa2a-4b5f-8072-32b1aacd7630"],

Cell[BoxData[
 FormBox["\<\"Understand place value. \
CCSS.Math.Content.1.NBT.B.2\\nUnderstand that the two digits of a two-digit \
number represent amounts of tens and ones. Understand the following as \
special cases: B.2.A, B.2.B, B.2.C\"\>", TraditionalForm]], "Output",Expressio\
nUUID->"9748afd3-5dd5-434c-9f27-5ddfceb02278"]
}, Open  ]],

Cell["\<\
See Colignatus (2018b) for tables of addition and subtraction with full use \
of place value.\
\>", "Text",ExpressionUUID->"734286d2-48b8-4a79-b92b-02299e29d3a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], " ", "+", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", " ", "4"}], "}"}], "   "}]], "Input",ExpressionUUID->\
"c61ef045-d1bc-406b-9424-f68606732d3c"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"2", ",", "6"}], "}"}], TraditionalForm]], "Output",ExpressionUUID-\
>"d646f00a-1290-4edc-ac41-160e29f9b25a"]
}, Open  ]],

Cell["\<\
The excercise mentions counting but we are not looking at the shift from \
counting to addition here. Numerals are shown but the exercise is pronounced \
in full place value manner.\
\>", "Text",ExpressionUUID->"2db1528f-d56c-4541-be29-e100a4086076"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathExercise", "[", 
   RowBox[{
    RowBox[{"inp", " ", "=", "26"}], ",", " ", "12", ",", " ", 
    RowBox[{"\"\<Grade\>\"", " ", "\[Rule]", " ", "\"\<Grade 1\>\""}], ",", 
    "  ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
    RowBox[{"IntegerDigits", " ", "\[Rule]", " ", "True"}]}], "]"}], 
  "  "}]], "Input",ExpressionUUID->"67966a45-65f0-4b85-be0a-ddffd1231480"],

Cell[BoxData[
 FormBox["\<\"You know the numbers 14 and 12, and how to write and speak \
them. You now count 14 up from 12, and then you find the number 26. You now \
learn to write and speak the number 26.\"\>", TraditionalForm]], "Output",Expr\
essionUUID->"1d0d3d16-0541-4503-9b59-46e1072e2b49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"c874286d-d5c9-4a40-b5b3-d2b8e9eef638"],

Cell[BoxData[
 FormBox["\<\"You know the numbers \[CenterDot]ten  &  four\[CenterDot] and \
\[CenterDot]ten  &  two\[CenterDot], and how to write and speak them. You now \
count \[CenterDot]ten  &  four\[CenterDot] up from \[CenterDot]ten  &  two\
\[CenterDot], and then you find the number two\[CenterDot]ten  &  six\
\[CenterDot]. You now learn to write and speak the number two\[CenterDot]ten  \
&  six\[CenterDot].\"\>", TraditionalForm]], "Output",ExpressionUUID->\
"4725498d-2e67-4a87-bd83-9bb7fe559202"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"inp", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}]}], "]"}], 
  "  "}]], "Input",ExpressionUUID->"027fdd8a-eac2-434c-8bd3-1600f2e5ab35"],

Cell[BoxData[
 FormBox["\<\"deux\[CenterDot]dix  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  six\[CenterDot]\"\>", 
  TraditionalForm]], "Print",ExpressionUUID->"aaf6c19f-f242-4e57-a994-\
15a20be74205"],

Cell[BoxData[
 FormBox["\<\"2 \[CenterDot] 10   &   6\"\>", TraditionalForm]], "Output",Expr\
essionUUID->"8c6067a9-0809-433d-889b-64eb32af2ed4"]
}, Open  ]],

Cell[TextData[{
 "We thus have the new number denoted in the place value system, its \
pronunciation, and its decomposition in the ",
 StyleBox["weighted ",
  FontSlant->"Italic"],
 "place values."
}], "Text",ExpressionUUID->"6c45634d-4902-48a2-9476-c8347af53189"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"inp", ",", " ", 
   RowBox[{"LatestPronunciation", "[", "Print", "]"}], ",", "  ", "result"}], 
  "}"}]], "Input",ExpressionUUID->"32363af1-be9f-41f5-b423-8f7c948be15d"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "26", ",", "\<\"deux\[CenterDot]dix  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  six\[CenterDot]\"\>", 
    ",", "\<\"2 \[CenterDot] 10   &   6\"\>"}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"2a0927a3-84f2-4080-9f8d-\
cf3b031b56ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". The table of 10"
}], "Subsubsection",ExpressionUUID->"bfcfa38e-8eff-4153-b840-fc7899594a34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<B.2.C\>\""}], 
  "]"}]], "Input",ExpressionUUID->"f72bb924-ba7e-43c8-b4ff-9f18ed4125a1"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.1.NBT.B.2.C\\nThe \
numbers 10, 20, 30, 40, 50, 60, 70, 80, 90 refer to one, two, three, four, \
five, six, seven, eight, or nine tens (and 0 ones)\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"572c5477-cbb3-4170-b8c3-\
6a199ba1bc1b"]
}, Open  ]],

Cell["\<\
See the comment above on avoiding \[OpenCurlyDoubleQuote]tens\
\[CloseCurlyDoubleQuote], and how the \[OpenCurlyDoubleQuote]s\
\[CloseCurlyDoubleQuote] would pollute the table of ten.\
\>", "Text",ExpressionUUID->"b0e1782d-e117-4d27-b4e4-63756b3a10b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueTable", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"10", ",", " ", "90", ",", " ", "10"}], "]"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"27724928-e009-44f8-8fcd-fb33350b8c32"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"10", "\<\" \"\>", "\<\"\[CenterDot]dix\"\>", "\<\"10\"\>", "\<\" \
\"\>", "\<\"dix\"\>"},
      {"20", "\<\" \"\>", "\<\"deux\[CenterDot]dix\"\>", "\<\"2 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"vingt\"\>"},
      {"30", "\<\" \"\>", "\<\"trois\[CenterDot]dix\"\>", "\<\"3 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"trente\"\>"},
      {"40", "\<\" \"\>", "\<\"quatre\[CenterDot]dix\"\>", "\<\"4 \
\[CenterDot] 10\"\>", "\<\" \"\>", "\<\"quarante\"\>"},
      {"50", "\<\" \"\>", "\<\"cinq\[CenterDot]dix\"\>", "\<\"5 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"cinquante\"\>"},
      {"60", "\<\" \"\>", "\<\"six\[CenterDot]dix\"\>", "\<\"6 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"soixante\"\>"},
      {"70", "\<\" \"\>", "\<\"sept\[CenterDot]dix\"\>", "\<\"7 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"soixante-dix\"\>"},
      {"80", "\<\" \"\>", "\<\"huit\[CenterDot]dix\"\>", "\<\"8 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"quatre-vingts\"\>"},
      {"90", "\<\" \"\>", "\<\"neuf\[CenterDot]dix\"\>", "\<\"9 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"quatre-vingt-dix\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Language -> "French", TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"31e29a5a-7dce-4d3a-867a-815704bf942b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlaceValueTable"}]], "Input",ExpressionUUID->"c14d5b97-1a64-4530-8600-745d9412aa90"],

Cell[BoxData["\<\"PlaceValueTable[{n}] gives a table of {n} with rows {n, \
pronunciation in PlaceValue, PV Digits, traditional pronunciation}. Options \
are passed on to PlaceValue (default Speak -> True) and \
PartialPlaceValue(default Speak -> False)\\nPlaceValueTable[n] gives the \
table with only n\\nPlaceValueTable[Row, n || {n}] gives the rows as lists \
only\\nPlaceValueTable[First, n] gives {n, PV, PV Digits}\"\>"], "Print", \
"PrintUsage",
 CellTags->
  "Info3203735558484-8910602",ExpressionUUID->"8858f879-1d7a-45d7-8439-\
565566841b9d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Building up the positional system"
}], "Subsubsection",ExpressionUUID->"1c7717ab-6835-45ec-a377-0deeaeae8771"],

Cell[TextData[{
 "We now repeat the above, in ever higher numbers, with the next place value \
transition at ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "2"], TraditionalForm]],ExpressionUUID->
  "22dbc2b0-8023-4bc6-931b-4ca5fc6cdd53"],
 "."
}], "Text",ExpressionUUID->"bf3dadba-b76a-4c20-8787-8f0e0a4e6374"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 1\>\"", ",", " ", "\"\<NBT\>\"", ",", "\"\<A.1\>\""}], 
  "]"}]], "Input",ExpressionUUID->"2c913406-c227-4da4-9ec8-e1a7057d04ed"],

Cell[BoxData[
 FormBox["\<\"Extend the counting sequence. CCSS.Math.Content.1.NBT.A.1\\n  \
Count to 120, starting at any number less than 120. In this range, read and \
write numerals and represent a number of objects with a written numeral.\"\>",
   TraditionalForm]], "Output",ExpressionUUID->"fea39f16-20ea-4ba0-8baf-\
63d3633320df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], " ", "+", " ", 
  RowBox[{"{", 
   RowBox[{"0", ",", " ", "count10", ",", " ", "count1"}], "}"}], 
  "  "}]], "Input",ExpressionUUID->"429d3601-9cd1-4581-a86e-fb7e58818908"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"1", ",", "count10", ",", "count1"}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"6c2927bf-6a49-486a-b5ab-\
eb52241f0ed9"]
}, Open  ]],

Cell["The following is spoken in full place value manner.", "Text",ExpressionUUID->"80f16469-0b0e-49c1-998f-8f44602d7c3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathExercise", "[", 
   RowBox[{"120", ",", " ", "119", ",", 
    RowBox[{"\"\<Grade\>\"", " ", "\[Rule]", " ", "\"\<Grade 1\>\""}], ",", 
    "  ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "True"}], ",", " ", 
    RowBox[{"IntegerDigits", " ", "\[Rule]", " ", "True"}]}], "]"}], 
  "  "}]], "Input",ExpressionUUID->"3cce4913-ec73-43d6-9667-f5ded62c00c5"],

Cell[BoxData[
 FormBox["\<\"You know the numbers 1 and 119, and how to write and speak \
them. You now count 1 up from 119, and then you find the number 120. You now \
learn to write and speak the number 120.\"\>", TraditionalForm]], "Output",Exp\
ressionUUID->"2f9957f2-335d-4abd-8605-9e802439f141"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"87ddbe7a-8af9-4b56-9803-46f18424c357"],

Cell[BoxData[
 FormBox["\<\"You know the numbers \[CenterDot]one and \[CenterDot]hundred  & \
 \[CenterDot]ten  &  nine\[CenterDot], and how to write and speak them. You \
now count \[CenterDot]one up from \[CenterDot]hundred  &  \[CenterDot]ten  &  \
nine\[CenterDot], and then you find the number \[CenterDot]hundred  &  two\
\[CenterDot]ten. You now learn to write and speak the number \
\[CenterDot]hundred  &  two\[CenterDot]ten.\"\>", TraditionalForm]], "Output",\
ExpressionUUID->"d0e475ba-c5f7-4540-bfea-098a94b450ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{
    RowBox[{"inp", " ", "=", " ", "120"}], ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f9487182-b928-4f20-8719-852eeb72c2ad"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]cent  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
deux\[CenterDot]dix\"\>", TraditionalForm]], "Print",ExpressionUUID->\
"f57ce141-62b5-441b-b0a0-885a51ba3d79"],

Cell[BoxData[
 FormBox["\<\"100   &   2 \[CenterDot] 10\"\>", TraditionalForm]], "Output",Ex\
pressionUUID->"7fc9ff33-60ff-4bd4-aa6c-2cba9742f5da"]
}, Open  ]],

Cell[TextData[{
 "We thus have the new number denoted in the place value system, its \
pronunciation, and its decomposition in the ",
 StyleBox["weighted ",
  FontSlant->"Italic"],
 "place values."
}], "Text",ExpressionUUID->"8a622e29-599f-480b-84da-1f647c5dde89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"inp", ",", " ", 
   RowBox[{"LatestPronunciation", "[", "Print", "]"}], ",", "  ", "result"}], 
  "}"}]], "Input",ExpressionUUID->"87ecd9ea-9672-4897-82de-e43b7adc3290"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "120", ",", "\<\"\[CenterDot]cent  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  deux\[CenterDot]dix\"\>", 
    ",", "\<\"100   &   2 \[CenterDot] 10\"\>"}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"3ec7434c-ce5b-4a8a-988a-\
dc95f6bd2448"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Grade 2 and 100"
}], "Subsubsection",ExpressionUUID->"577b03bb-835e-4cf4-b27b-398478cb9b45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathContent", "[", 
   RowBox[{
   "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", "\"\<A.1.A\>\""}], 
   "]"}], " "}]], "Input",ExpressionUUID->"de37d6b6-4a73-449a-9109-\
43762d380453"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.2.NBT.A.1.A\\n  100 \
can be thought of as a bundle of ten tens \[LongDash] called a \\\"hundred.\\\
\"\"\>", TraditionalForm]], "Output",ExpressionUUID->"1e085599-e596-4125-a59f-\
93cd078ba00d"]
}, Open  ]],

Cell[TextData[{
 "Surprisingly, CCSS requires kids of Grade 1 to count to 120 but CCSS also \
wants that the word \[OpenCurlyDoubleQuote]hundred\[CloseCurlyDoubleQuote] is \
mentioned only in Grade 2 ? Likely kids at that stage would also know that \
100 is 10 of 10. My impression is: CCSS wants Grade 2 to grow aware that 100 \
features in the place value system precisely because it is a power of 10. My \
other impression is that it suffices to show the role of 10, 100, 1000 \
etcetera but discuss the power structure only later. Often you better use \
something first, so that the explanation can better be understood once you \
know what it is about. Dutch mathematician and teacher Gerrit Mannoury \
(1867-1956): \[OpenCurlyDoubleQuote]The meaning of words is their use.\
\[CloseCurlyDoubleQuote] (my transscription) - and this was later also seen \
by Ludwig Wittgenstein (1889-1951), and likely before by C.S. Peirce \
(1839-1914) though I do not have a quote. Do not wait too long with the \
explanation otherwise students develop awkward misunderstandings and habits. \
My third impression is that CCSS is pernicious on grouping. They avoid the \
term \[OpenCurlyDoubleQuote]grouping\[CloseCurlyDoubleQuote] (multiplication) \
but use \[OpenCurlyDoubleQuote]bundling\[CloseCurlyDoubleQuote], as a lawyer \
might suggest that bundling doesn\[CloseCurlyQuote]t necessarily mean \
grouping, and hide definitions to make it seem serious. My suggestion is to \
do a proper table of 10, so that also 10 of 10 = 100 = hundred is included \
(and not limit this to 90 as in CCSS.Math.Content.1.NBT.B.2.C above). In the \
full place value, 100 is not decomposed in ten\[CenterDot]ten. But we \
obviously want kids to know this. At some point it can be explained that \
using ten digits to construct numerals causes the use of the powers of ten. A \
square of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "2"], TraditionalForm]],ExpressionUUID->
  "383a3de3-cb37-4c84-bfb9-102841515bcc"],
 " and a cube of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "3"], TraditionalForm]],ExpressionUUID->
  "faa650f2-57d7-4d95-9735-ab340a206d71"],
 " should not be hard to grasp. PM. Tradition simplifies for one 1 but \
curiously doesn\[CloseCurlyQuote]t simplify fully for one 100."
}], "Text",ExpressionUUID->"65218399-5420-439f-82f6-334d0ca5af43"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueTable", "[", "100", "]"}]], "Input",ExpressionUUID->"27137d26-99e8-467e-8b99-ab23318c61fb"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"100", "\<\" \"\>", "\<\"\[CenterDot]hundred\"\>", "\<\"100\"\>", \
"\<\" \"\>", "\<\"one hundred\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"6f0eb0dc-579d-488e-b5c5-3003ecbbde1c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueTable", "[", 
  RowBox[{"100", ",", " ", 
   RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",Expre\
ssionUUID->"3d8e91d9-f67d-45a3-b227-2841a23ae434"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"100", "\<\" \"\>", "\<\"one\[CenterDot]hundred  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  zero\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  zero\[CenterDot]one\"\>", \
"\<\"1 \[CenterDot] 100   &   0 \[CenterDot] 10   &   0 \[CenterDot] 1\"\>", \
"\<\" \"\>", "\<\"one hundred\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Simplify -> False, TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"f2deaa4b-00eb-4cec-b8ad-a7af1e9b5d3e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Grade 2 and 100 - 1000"
}], "Subsubsection",ExpressionUUID->"120640ff-31d5-4752-b7d3-f2557001ba93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{
  "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", "\"\<A.1\>\""}], 
  "]"}]], "Input",ExpressionUUID->"5c7134b6-fda8-4a01-b838-ba675f8a836f"],

Cell[BoxData[
 FormBox["\<\"Understand place value. \
CCSS.Math.Content.2.NBT.A.1\\nUnderstand that the three digits of a \
three-digit number represent amounts of hundreds, tens, and ones; e.g., 706 \
equals 7 hundreds, 0 tens, and 6 ones. Understand the following as special \
cases: A.1.A, A.1.B\"\>", TraditionalForm]], "Output",ExpressionUUID->\
"c799b2b6-e075-466d-96a0-2e957c934680"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"706", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"a1d5e0f2-e0ea-4add-b138-ce760e86a334"],

Cell[BoxData[
 FormBox["\<\"sept\[CenterDot]cent  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\
\\)  six\[CenterDot]\"\>", TraditionalForm]], "Print",ExpressionUUID->\
"e884c791-6ba4-44eb-9965-b092e4dd8c9c"],

Cell[BoxData[
 FormBox["\<\"7 \[CenterDot] 100   &   6\"\>", TraditionalForm]], "Output",Exp\
ressionUUID->"e8c1b188-2642-4dfe-8319-179b0f8d6764"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"706", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}], ",", " ", 
    RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"97af576c-b142-42b7-8785-28c57af50ab3"],

Cell[BoxData[
 FormBox["\<\"sept\[CenterDot]cent  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\
\\)  zero\[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  six\
\[CenterDot]un\"\>", TraditionalForm]], "Print",ExpressionUUID->"32e43fe7-\
00ed-45c7-ae41-23c63579990c"],

Cell[BoxData[
 FormBox["\<\"7 \[CenterDot] 100   &   0 \[CenterDot] 10   &   6 \[CenterDot] \
1\"\>", TraditionalForm]], "Output",ExpressionUUID->"cb98c509-4b8b-4378-a8c7-\
3abfac1af407"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathContent", "[", 
   RowBox[{
   "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", "\"\<A.1.B\>\""}], 
   "]"}], " "}]], "Input",ExpressionUUID->"fe72b4ba-c104-4204-b5d7-\
264e5ddeae1f"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.2.NBT.A.1.B\\n  The \
numbers 100, 200, 300, 400, 500, 600, 700, 800, 900 refer to one, two, three, \
four, five, six, seven, eight, or nine hundreds (and 0 tens and 0 ones).\"\>",
   TraditionalForm]], "Output",ExpressionUUID->"e481164b-8c5b-4d8b-abf0-\
590cbfc10346"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathContent", "[", 
   RowBox[{
   "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", "\"\<A.2\>\""}], 
   "]"}], " "}]], "Input",ExpressionUUID->"eac51c33-8ec9-43d3-83cc-\
27eed0f0465b"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.2.NBT.A.2\\n  Count \
within 1000; skip-count by 5s, 10s, and 100s.\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"b98e37ea-9abe-4883-b369-\
54e908716ef6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CCSSMathContent", "[", 
   RowBox[{
   "\"\<Grade 2\>\"", ",", " ", "\"\<NBT\>\"", ",", " ", "\"\<A.3\>\""}], 
   "]"}], " "}]], "Input",ExpressionUUID->"c4114b22-d532-461f-b0b4-\
5f398e47b988"],

Cell[BoxData[
 FormBox["\<\"Understand place value. CCSS.Math.Content.2.NBT.A.3\\n  Read \
and write numbers to 1000 using base-ten numerals, number names, and expanded \
form.\"\>", TraditionalForm]], "Output",ExpressionUUID->"7c1d6ed8-da81-4be9-\
ac0c-c0cb15965f21"]
}, Open  ]],

Cell["\<\
From the Glossary: \[OpenCurlyDoubleQuote]Expanded form. A multi-digit number \
is expressed in expanded form when it is written as a sum of single-digit \
multiples of powers of ten. For example, 643 = 600 + 40 + 3.\
\[CloseCurlyDoubleQuote]\
\>", "Text",ExpressionUUID->"c55549d5-bedb-4473-9ddb-b846ce9a8c22"],

Cell["Our routines allow digging deeper.", "Text",ExpressionUUID->"ef9926a3-fc40-4c84-9884-15fe428c66da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"643", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}], ",", " ", 
    RowBox[{"And", " ", "\[Rule]", " ", "\"\<+\>\""}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"b0540536-27a9-459f-b01b-bfbf9da0c64c"],

Cell[BoxData[
 FormBox["\<\"six\[CenterDot]cent  +  quatre\[CenterDot]dix  +  trois\
\[CenterDot]\"\>", TraditionalForm]], "Print",ExpressionUUID->"22860f58-9f54-\
4afe-8c59-3480d3835f53"],

Cell[BoxData[
 FormBox["\<\"6 \[CenterDot] 100   +   4 \[CenterDot] 10   +   3\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"146efc4d-6981-4a0d-bf38-\
969c62f46e56"]
}, Open  ]],

Cell[TextData[{
 "We already had this in \[OpenCurlyDoubleQuote]&\[CloseCurlyDoubleQuote] but \
CCSS only knows about \[OpenCurlyDoubleQuote]+\[OpenCurlyDoubleQuote]. My \
suggestion is that kids know about secret codes, and thus know about the \
distinction between ",
 StyleBox["content ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["coding",
  FontSlant->"Italic"],
 ". They should be able to understand that \[OpenCurlyDoubleQuote]&\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]\[CenterDot]\
\[CloseCurlyDoubleQuote] are used to encode the pronunciation of the numbers \
and that \[OpenCurlyDoubleQuote]+\[OpenCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]\[Times]\[CloseCurlyDoubleQuote] are the operators \
with properties of commutation, association and distribution.  If they don\
\[CloseCurlyQuote]t get it then it is the objective of education that they \
get it. Watching movies with secret codes is an acquired taste."
}], "Text",ExpressionUUID->"7b97a3ee-4356-4de3-8bef-238b635ea697"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Grades 3 & 4 and 100 - 1000"
}], "Subsubsection",ExpressionUUID->"bf2dd29c-fde9-4502-9277-c3d81896b4b4"],

Cell["\<\
Grade 3 has multiplication and Grade 4 is more aware of complexities.\
\>", "Text",ExpressionUUID->"533cc1d7-9f7e-4133-a40c-b3fab7e02638"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 3\>\"", ",", "\"\<OA\>\"", ",", "\"\<D.9\>\""}], 
  "]"}]], "Input",ExpressionUUID->"1eac009e-0932-4b3f-afeb-0b08cf277a86"],

Cell[BoxData[
 FormBox["\<\"Solve problems involving the four operations, and identify and \
explain patterns in arithmetic. CCSS.Math.Content.3.OA.D.9\\nIdentify \
arithmetic patterns (including patterns in the addition table or \
multiplication table), and explain them using properties of operations.\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"1b652533-24d8-4138-8371-\
cb30c7e10fc6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CCSSMathContent", "[", 
  RowBox[{"\"\<Grade 4\>\"", ",", "\"\<NBT\>\"", ",", "\"\<A.2\>\""}], 
  "]"}]], "Input",ExpressionUUID->"0c458b29-0d1a-4a70-ad4d-630c25e3dffc"],

Cell[BoxData[
 FormBox["\<\"Generalize place value understanding for multi-digit whole \
numbers. CCSS.Math.Content.4.NBT.A.2\\nRead and write multi-digit whole \
numbers using base-ten numerals, number names, and expanded form. Compare two \
multi-digit numbers based on meanings of the digits in each place, using >, \
=, and < symbols to record the results of comparisons.\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"6504b30e-d66b-4788-84ee-\
03d196595e24"]
}, Open  ]],

Cell["\<\
Students are now up to a discussion of the full place value system using \
their command of numbers and multiplication. This shows how the place value \
system works, though using $Language for the (single) StepMonitor and again \
using \[OpenCurlyDoubleQuote]+\[OpenCurlyDoubleQuote]. We might show with and \
without simplification. \
\>", "Text",ExpressionUUID->"78239c5d-2f96-4d68-b710-1b0f3fe389c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"643", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", "  ", "\"\<French\>\""}], ",", " ", 
    RowBox[{"StepMonitor", " ", "\[Rule]", " ", "True"}], ",", " ", 
    RowBox[{"And", " ", "\[Rule]", " ", "\"\<+\>\""}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"fed8c7db-d25d-4fbc-a2dd-32d89a7201c3"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"TheSum[times[6, 100], times[4, 10], times[3, 1]]\"\>", 
  TraditionalForm]], "Print",ExpressionUUID->"8e07e28e-ba91-47ce-a37e-\
af7fc13638a6"],

Cell[BoxData[
 FormBox["\<\"six\[CenterDot]cent  +  quatre\[CenterDot]dix  +  trois\
\[CenterDot]\"\>", TraditionalForm]], "Print",ExpressionUUID->"94d6e026-0397-\
44c0-a7cb-7579fc894337"]
}, Open  ]],

Cell[BoxData[
 FormBox["\<\"6 \[CenterDot] 100   +   4 \[CenterDot] 10   +   3\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"9520b2db-416f-4f04-8cec-\
a4a505be5e20"]
}, Open  ]],

Cell[TextData[{
 "PM. The place value system speaks all positions separately, e.g. also ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"4", " "}]], TraditionalForm]],ExpressionUUID->
  "9c9846e3-7071-440a-ae44-6a52b0f7c2c5"],
 "and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "5"], TraditionalForm]],ExpressionUUID->
  "4fea5093-6931-4973-bf59-a533a0be477b"],
 ". We write out all zeros (1000) and do not use exponents since we assume \
that kids haven\[CloseCurlyQuote]t had exponents yet but they can count the \
number of zeros.  The following obviously is not for 2nd Grade, but it shows \
how the routine works. The spoken and written version is actually the Chinese \
method, see Uy (2003), though with the added feature here of the ampersand \
infixes. We have freedom to choose the infix (but a StyleBox will not work)."
}], "Text",ExpressionUUID->"427b99d5-92ea-4bac-8866-d9dd46e9e251"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueDigits", "[", 
   RowBox[{"1115124", ",", " ", 
    RowBox[{"And", " ", "\[Rule]", " ", "\"\<,\>\""}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"ab278507-5365-491b-b704-a6ca33955c44"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]million  ,  \[CenterDot]lakh  ,  \[CenterDot]myriad \
 ,  five\[CenterDot]thousand  ,  \[CenterDot]hundred  ,  two\[CenterDot]ten  \
,  four\[CenterDot]\"\>", TraditionalForm]], "Print",ExpressionUUID->\
"d1029c5c-5509-4e14-92fc-aa56993cc4e3"],

Cell[BoxData[
 FormBox["\<\"1000000    \[CenterDot]   100000    \[CenterDot]   10000    \
\[CenterDot]   5 \[CenterDot] 1000    \[CenterDot]   100    \[CenterDot]   2 \
\[CenterDot] 10    \[CenterDot]   4\"\>", TraditionalForm]], "Output",Expressi\
onUUID->"6698af76-73fe-436e-9254-b0c66c2e847c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 3. Blocks of three digits"
}], "Subsection",ExpressionUUID->"d52264bd-fb2b-4606-b62a-03df387f0394"],

Cell["\<\
I did not see the following in the CCSS but may have overlooked it. \
\>", "Text",ExpressionUUID->"6e0ce7fd-115c-4883-9864-aa2eab5ffbe2"],

Cell[TextData[{
 "The students learn higher numbers, and how to pronounce them by blocks of 3 \
digits. This convention is efficient - and avoids the need for special names \
for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]],ExpressionUUID->
  "cc28b862-ec3c-4611-8e98-46419a4ee5fc"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "5"], TraditionalForm]],ExpressionUUID->
  "c1c5e5be-140c-4c4a-8d03-54fa6c3ffddd"],
 ". The insertion of \[OpenCurlyDoubleQuote]and\[CloseCurlyDoubleQuote] \
between the blocks and their weights provides a useful resting pause. "
}], "Text",ExpressionUUID->"ba4817bf-88ee-4376-80dd-877f1a0300e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"PlaceValueBlock", "[", "654121", "]"}]}]], "Input",ExpressionUUID->\
"23f34578-6c0a-4e92-b004-5441bdd92766"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"6 \[CenterDot] 100\"\>", ",", "\<\" & \"\>", 
        ",", "\<\"5 \[CenterDot] 10    &    4\"\>"}], "}"}], ",", "1000"}], 
     "}"}], ",", "\<\" & \"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"1 \[CenterDot] 100\"\>", ",", "\<\" & \"\>", 
      ",", "\<\"2 \[CenterDot] 10    &    1\"\>"}], "}"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"5f9fd6ed-64ce-47e8-9b23-\
0f02502c1bd9"]
}, Open  ]],

Cell["\<\
For larger values we might display without the ampersand (which is the form \
in the Abstract).\
\>", "Text",ExpressionUUID->"671d5261-f175-4ce6-b6c1-3405726421af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueBlock", "[", 
   RowBox[{"654121", ",", " ", 
    RowBox[{"And", " ", "\[Rule]", " ", "\"\<\>\""}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}], " "}]], "Input",\
ExpressionUUID->"519192b8-d85f-4c34-b83b-b49327517603"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"6 \[CenterDot] 100\"\>", ",", "\<\"  \"\>", 
        ",", "\<\"5 \[CenterDot] 10        4\"\>"}], "}"}], ",", "1000"}], 
     "}"}], ",", "\<\"  \"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"1 \[CenterDot] 100\"\>", ",", "\<\"  \"\>", 
      ",", "\<\"2 \[CenterDot] 10        1\"\>"}], "}"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"ab3dbe16-46a6-4572-bb2b-\
60ed2806a4c2"]
}, Open  ]],

Cell["\<\
The layout of these lists has the following explanation: The routine \
PlaceValueBlock only uses $Language. The package was written with $Language = \
\[OpenCurlyDoubleQuote]English\[CloseCurlyDoubleQuote].  It appears that \
Speak[100] is \[OpenCurlyDoubleQuote]one hundred\[CloseCurlyDoubleQuote] and \
Speak[1\[CenterDot]100] thus is \[OpenCurlyDoubleQuote]one one-hundred\
\[CloseCurlyDoubleQuote]. The \[OpenCurlyDoubleQuote]one one-hundred\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]one one-thousand\
\[CloseCurlyDoubleQuote] were so annoying, if not confusing, in combination \
with pronouncing the three digits and their place values, that I changed to \
\[OpenCurlyDoubleQuote]hundred\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]thousand\[CloseCurlyDoubleQuote] in speech. \
\>", "Text",ExpressionUUID->"7adcc57d-63d2-4f5e-8815-f49cb0ae3ca9"],

Cell[TextData[{
 "There is a difference between what we want ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "to Speak (with the infixes) and what we want to Show now (at the head of \
the expression). The following is somewhat okay.  "
}], "Text",ExpressionUUID->"aaabb330-5444-494b-a8c6-1e2c0b52adfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"result", "/.", " ", 
   RowBox[{
    RowBox[{"List", "[", 
     RowBox[{"x_", ",", " ", "\"\< & \>\"", ",", " ", "y_"}], "]"}], " ", 
    "\[RuleDelayed]", " ", 
    RowBox[{"(", 
     RowBox[{"x", " ", "~", "\"\< & \>\"", "~", " ", "y"}], ")"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"9350569b-a058-497a-aeeb-37b642c0a4cc"],

Cell[BoxData[
 FormBox[
  GraphicsBox[
   TagBox[
    GraphicsComplexBox[{{2.071419837175451, 2.259730731464128}, {
     1.129865365732064, 1.5064871543094187`}, {0.7532435771547095, 
     0.7532435771547092}, {0., 0.}, {0.7532435771547095, 0.}, {
     1.506487154309419, 0.}, {1.506487154309419, 0.7532435771547092}, {
     3.012974308618838, 1.5064871543094187`}, {2.259730731464128, 
     0.7532435771547092}, {3.012974308618838, 0.7532435771547092}, {
     3.766217885773547, 0.7532435771547092}}, {
      {RGBColor[0.55, 0.45, 0.45], 
       LineBox[{{1, 2}, {1, 8}, {2, 3}, {2, 7}, {3, 4}, {3, 5}, {3, 6}, {8, 
        9}, {8, 10}, {8, 11}}]}, {
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["\<\" & \"\>", "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 1],
         TagBox[
          RowBox[{"\" & \"", "(", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", 
                    
                    RowBox[{
                    "\"6 \[CenterDot] 100\"", ",", "\" & \"", ",", 
                    "\"5 \[CenterDot] 10    &    4\""}], "}"}], ",", "1000"}],
                 "}"}], ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"1 \[CenterDot] 100\"", ",", "\" & \"", ",", 
                  "\"2 \[CenterDot] 10    &    1\""}], "}"}]}], ")"}], 
          HoldForm]],
        Annotation[#, 
         HoldForm[
          
          " & "[{{"6 \[CenterDot] 100", " & ", "5 \[CenterDot] 10    &    4"},
             1000}, {
           "1 \[CenterDot] 100", " & ", "2 \[CenterDot] 10    &    1"}]], 
         "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["List", "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 2],
         TagBox[
          RowBox[{"{", 
            RowBox[{
              RowBox[{"{", 
                
                RowBox[{
                 "\"6 \[CenterDot] 100\"", ",", "\" & \"", ",", 
                  "\"5 \[CenterDot] 10    &    4\""}], "}"}], ",", "1000"}], 
            "}"}], HoldForm]],
        Annotation[#, 
         HoldForm[{{
           "6 \[CenterDot] 100", " & ", "5 \[CenterDot] 10    &    4"}, 
           1000}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["List", "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 3],
         TagBox[
          RowBox[{"{", 
            
            RowBox[{"\"6 \[CenterDot] 100\"", ",", "\" & \"", ",", 
              "\"5 \[CenterDot] 10    &    4\""}], "}"}], HoldForm]],
        Annotation[#, 
         HoldForm[{
          "6 \[CenterDot] 100", " & ", "5 \[CenterDot] 10    &    4"}], 
         "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\<\"6 \[CenterDot] 100\"\>",
             HoldForm], "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 4],
         TagBox["\"6 \[CenterDot] 100\"", HoldForm]],
        Annotation[#, 
         HoldForm["6 \[CenterDot] 100"], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\<\" & \"\>",
             HoldForm], "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 5],
         TagBox["\" & \"", HoldForm]],
        Annotation[#, 
         HoldForm[" & "], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\<\"5 \[CenterDot] 10    &    4\"\>",
             HoldForm], "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 6],
         TagBox["\"5 \[CenterDot] 10    &    4\"", HoldForm]],
        Annotation[#, 
         HoldForm["5 \[CenterDot] 10    &    4"], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["1000",
             HoldForm], "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 7],
         TagBox["1000", HoldForm]],
        Annotation[#, 
         HoldForm[1000], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["List", "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 8],
         TagBox[
          RowBox[{"{", 
            
            RowBox[{"\"1 \[CenterDot] 100\"", ",", "\" & \"", ",", 
              "\"2 \[CenterDot] 10    &    1\""}], "}"}], HoldForm]],
        Annotation[#, 
         HoldForm[{
          "1 \[CenterDot] 100", " & ", "2 \[CenterDot] 10    &    1"}], 
         "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\<\"1 \[CenterDot] 100\"\>",
             HoldForm], "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 9],
         TagBox["\"1 \[CenterDot] 100\"", HoldForm]],
        Annotation[#, 
         HoldForm["1 \[CenterDot] 100"], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\<\" & \"\>",
             HoldForm], "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 10],
         TagBox["\" & \"", HoldForm]],
        Annotation[#, 
         HoldForm[" & "], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\<\"2 \[CenterDot] 10    &    1\"\>",
             HoldForm], "TraditionalForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.023529411764705882`],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 11],
         TagBox["\"2 \[CenterDot] 10    &    1\"", HoldForm]],
        Annotation[#, 
         HoldForm["2 \[CenterDot] 10    &    1"], "Tooltip"]& ]}}],
    Annotation[#, 
     VertexCoordinateRules -> {{2.071419837175451, 2.259730731464128}, {
      1.129865365732064, 1.5064871543094187`}, {0.7532435771547095, 
      0.7532435771547092}, {0., 0.}, {0.7532435771547095, 0.}, {
      1.506487154309419, 0.}, {1.506487154309419, 0.7532435771547092}, {
      3.012974308618838, 1.5064871543094187`}, {2.259730731464128, 
      0.7532435771547092}, {3.012974308618838, 0.7532435771547092}, {
      3.766217885773547, 0.7532435771547092}}]& ],
   AspectRatio->NCache[2 17^Rational[-1, 2], 0.48507125007266594`],
   FormatType:>StandardForm,
   FrameTicks->Automatic,
   ImageSize->{474., Automatic},
   PlotRange->All,
   PlotRangePadding->Scaled[0.1]], TraditionalForm]], "Output",ExpressionUUID-\
>"a924c0f9-4d82-4591-aa5f-66f171b6e664"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 4. Daily use"
}], "Subsection",ExpressionUUID->"d610a309-632e-4334-9c3e-8df7e7138c9d"],

Cell[TextData[{
 "In the final phase kids are mastering or have mastered the place value \
system. The following routine adopts the convention of ",
 StyleBox["Mathematica\[CloseCurlyQuote]",
  FontSlant->"Italic"],
 "s IntegerName: absolute values less than 1000 are given as words \
(effectively PlaceValue), and higher values are combinations of blocks of \
digits and their bases in words (thousand, million, etc.). This allows high \
numbers. The block bases can be submitted to WordTranslation. Drawbacks: (i) \
The use of another language is relatively slow because of WordTranslation. \
(ii) Transliteration was included later and wasn\[CloseCurlyQuote]t designed \
for speed.  PM. We separate the digit bases by a comma. This option for And \
can be adapted but is not passed on to PlaceValue."
}], "Text",ExpressionUUID->"4d62e208-a8a0-499e-a62f-da719cfb0872"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueIntegerName", "[", 
  RowBox[{"99", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"a203be12-0f2f-415a-911e-ab93b7524e11"],

Cell[BoxData[
 FormBox["\<\"neuf\[CenterDot]dix  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  neuf\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"449328d6-f233-491b-a750-\
8c532b4a74f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueIntegerName", "[", 
   RowBox[{"1011", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], "]"}], 
  "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"above", " ", "999"}], " ", "*)"}]}]], "Input",ExpressionUUID->\
"9a3bb9ba-0003-4f5f-ac91-20e54537eae7"],

Cell[BoxData[
 FormBox["\<\"1  mille,   11\"\>", TraditionalForm]], "Output",ExpressionUUID->"2902bc21-4145-4dc0-8957-b24e8de43147"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"11c57439-05ca-49ac-8b06-4c499954a9c7"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]uhnn  meel,   \[CenterDot]dees <silence \
msec=\\\"300\\\"/>  ayh  \[CenterDot]uhnn\"\>", TraditionalForm]], "Output",Ex\
pressionUUID->"ec29b6f3-9800-4299-a299-6e6b77c366ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueIntegerName", "[", "1090011", "]"}], " "}]], "Input",Expr\
essionUUID->"6f40e717-ac9c-4f74-9f2a-34527cd7f432"],

Cell[BoxData[
 FormBox["\<\"1  million,   90  thousand,   11\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"f01e145a-d517-4792-8a40-\
04f6d8e6e676"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"c9ab698b-937b-4648-b486-5da0e7055f8e"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]one  million,   nine\[CenterDot]ten  thousand,   \
\[CenterDot]ten  &  \[CenterDot]one\"\>", TraditionalForm]], "Output",Expressi\
onUUID->"d4b769da-514c-4a19-8378-b60ebbd8d19a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueIntegerName", "[", 
   RowBox[{"1234451011", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}], ",", " ", 
    RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}], " "}]], "Input",\
ExpressionUUID->"51f74d66-71aa-4489-8a0d-1b7fd7df9547"],

Cell[BoxData[
 FormBox["\<\"1  billion,   234  million,   451  mille,   11\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"5ec963b8-8068-4f3b-9d83-\
4fef55c4b32a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"9b461c04-78c9-4abd-817e-8c86720540c3"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]un  billion,   deux\[CenterDot]cent  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  trois\[CenterDot]dix  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  quatre\[CenterDot]  million,   \
quatre\[CenterDot]cent  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  cinq\
\[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]un \
 mille,   \[CenterDot]dix  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
\[CenterDot]un\"\>", TraditionalForm]], "Output",ExpressionUUID->"74042ddb-\
9996-459b-b26b-7af510a58bc2"]
}, Open  ]],

Cell["\<\
Just to be sure: WordTranslation provided two possibilities, and the routine \
always takes the first.\
\>", "Text",ExpressionUUID->"8728c911-cad2-4cc0-a0db-0481cae92bb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordTranslation", "[", 
  RowBox[{"\"\<billion\>\"", ",", " ", 
   RowBox[{"\"\<English\>\"", " ", "\[Rule]", " ", "\"\<French\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"1e25a513-eb49-40dd-b5d8-688b93869fc7"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"billion\"\>", ",", "\<\"milliard\"\>"}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"186e2e45-e142-421a-862b-\
1370995f23af"]
}, Open  ]],

Cell[TextData[{
 "The LatestPronunciation[] gives  words in French without transliteration \
into English, because of the option Speak \[Rule] False. Speaking it in \
English will be far removed from the actual pronunciation in French. If you \
want a transliteration then use Speak \[Rule] True, or Level 1 again (that \
also drops the first \[OpenCurlyDoubleQuote]un\[CloseCurlyDoubleQuote]). In \
all cases transliteration is restricted to absolute numbers less than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "7"], TraditionalForm]],ExpressionUUID->
  "2b497394-d4ac-48d3-afc1-bb19671bad64"],
 " (and thus \[OpenCurlyDoubleQuote]billion\[CloseCurlyDoubleQuote] is \
pronounced in English)."
}], "Text",ExpressionUUID->"50272a56-cb4b-42e2-a3a1-18b8fcd86a8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level -4. Traditional pronunciation"
}], "Subsection",ExpressionUUID->"2c839bff-5816-4ab6-a62a-bc3a75388acc"],

Cell[TextData[{
 "Traditional pronunciation uses the place value system partially, with \
breaches of order and structure. Given the diagnosis in my booklet (2015a)",
 StyleBox[" A child wants nice and no mean numbers",
  FontSlant->"Italic"],
 ", it was tempting to use the name MeanNumbers for the tradition routine, \
but there is a difference between an expresssive book title and programming, \
and thus I settled for PartialPlaceValue. It is at level -4. Conventionally \
it uses the blocks of 3 digits. The routine uses ",
 StyleBox["Mathematica\[CloseCurlyQuote]",
  FontSlant->"Italic"],
 "s IntegerName using DigitsWords and adopts its convention: For -1000 < ",
 StyleBox["n ",
  FontSlant->"Italic"],
 "< 1000 only words are shown but for higher absolute values the blocks of \
digits are shown. Drawback: no transliteration."
}], "Text",ExpressionUUID->"a471d5b9-d4bd-434d-97e5-02dbc9520eaf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PartialPlaceValue", "[", "321", "]"}], " "}]], "Input",ExpressionUU\
ID->"28de830a-cb09-4362-b742-34a1811f2d33"],

Cell[BoxData[
 FormBox["\<\"three hundred twenty one\"\>", TraditionalForm]], "Output",Expre\
ssionUUID->"5d6af71e-4415-4b81-9a8c-ebcec70e60c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PartialPlaceValue", "[", "654321", "]"}], " "}]], "Input",Expressio\
nUUID->"77a23d31-eafc-4a72-9223-1868609158d7"],

Cell[BoxData[
 FormBox["\<\"654 thousand 321\"\>", TraditionalForm]], "Output",ExpressionUUI\
D->"31dab452-dcb5-4aaf-8eb0-c75989ada4b7"]
}, Open  ]],

Cell["\<\
Speak stops when meeting a hyphen, and thus hyphens are replaced by blanks. \
Unfortunately for other languages, IntegerName concatenates the words. It is \
too involved to undo this.\
\>", "Text",ExpressionUUID->"7bc19437-b8f1-40fa-9a83-e6e52eb892e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PartialPlaceValue", "[", 
   RowBox[{"21", ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<German\>\""}]}], "]"}], 
  " "}]], "Input",ExpressionUUID->"d6d6d585-1815-4f73-b396-d26e89704b87"],

Cell[BoxData[
 FormBox["\<\"ein\[DiscretionaryHyphen]und\[DiscretionaryHyphen]zwanzig\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"93b51bf0-29af-4045-9cb8-\
1a91078168ac"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReplace", "[", 
   RowBox[{"%", ",", " ", 
    RowBox[{"\"\<und\>\"", " ", "\[Rule]", " ", "\"\< oond \>\""}]}], "]"}], 
  "  ", "//", " ", "Speak"}]], "Input",ExpressionUUID->"b2505de1-69e1-4138-\
83ab-9ac52eac2f94"],

Cell["\<\
When kids have classes on programming, writing code, it might be a nice \
suggestion to let them program the way how they pronounce the integers in the \
full place value system, and how their parents pronounce them in the dialect \
of traditional English. \
\>", "Text",ExpressionUUID->"842e47bd-4fd5-4684-a56a-3578489d5e66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". One switching routine to rule them all"
}], "Subsection",ExpressionUUID->"89f798e5-7158-4d21-9635-4e216995d9cc"],

Cell[TextData[{
 "When you are new to these routines (like I was while writing them) then it \
may be easy to get lost for a moment. With some structure it is easier to see \
how they hang together. Therefor, PronounceInteger is a switching routine for \
selecting Level \[Rule] ",
 StyleBox["level, ",
  FontSlant->"Italic"],
 "with above levels 1, 2, 3, 4 and -4."
}], "Text",ExpressionUUID->"dd37f37e-f5b4-425e-b7a8-f00970fe4b77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PronounceInteger"}]], "Input",ExpressionUUID->"cdbb4338-37fc-44f4-aa5f-e9eb7c1effce"],

Cell[BoxData["\<\"PronounceInteger[n] pronounces n. Options are passed on to \
the routine that is called, except: if the chosen Language is equal to \
$Language then it is not passed on. It uses first the Level and then the \
Method setting in the options, default Level -> 1, Method -> PlaceValue. \
Option All -> {...} gives the methods in the MathEd`PronounceInteger` \
package. See the documentation per routine. If you want to specify the \
selection by Method -> routine name, select also Level -> 0. Perhaps easier \
to remember than the routine names, and taking advantage of the levels of \
understanding, you can also specify the Level -> lev:\\nchosen =Switch[lev, \
\\n 1, PlaceValue,\\n 2, PlaceValueDigits,\\n 3, PlaceValueBlock,\\n 4, \
PlaceValueIntegerName,\\n-4, PartialPlaceValue,\\n_, Null];\\n If none of \
these is used (say with Level -> 0) then the Method -> m option is used. If \
no method is in the list that All provided: $Failed\"\>"], "Print", \
"PrintUsage",
 CellTags->
  "Info3563735558490-8910602",ExpressionUUID->"8de12c97-deb1-4417-8d0d-\
39e7cdf00e10"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "PronounceInteger", "]"}]], "Input",ExpressionUUID->"75651a1d-db11-489a-a776-6079e909cc57"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Level", "\[Rule]", "1"}], ",", 
    RowBox[{"Method", "\[Rule]", "PlaceValue"}], ",", 
    RowBox[{"Language", "\[Rule]", "\<\"English\"\>"}], ",", 
    RowBox[{"Speak", "\[Rule]", "True"}], ",", 
    RowBox[{"All", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "PlaceValue", ",", "PlaceValueH", ",", "PlaceValueDigits", ",", 
       "PlaceValueDigits$Language", ",", "PlaceValueBlock", ",", 
       "PlaceValueIntegerName", ",", "PartialPlaceValue", ",", 
       "PlaceValueTable"}], "}"}]}]}], "}"}], TraditionalForm]], "Output",Expr\
essionUUID->"160f35b7-8acb-4496-8834-fe39da6ec927"]
}, Open  ]],

Cell["\<\
Who knows about PlaceValue or PlaceValueTable would tend to call them \
directly, but the following serves as an illustration. Observe the special \
role of the Language option. We may set the option to say \
\[OpenCurlyDoubleQuote]Italian\[CloseCurlyDoubleQuote], and then \
PronounceInteger will call the routines with that setting. However, when the \
call uses Language \[Rule] $Language, then the option is not passed on, and \
the option settings of the subroutines take precedence. PlaceValue has its \
own setting Language \[Rule] \[OpenCurlyDoubleQuote]Amplish\
\[CloseCurlyDoubleQuote], and thus we can still get the ampersand in smaller \
FontSize.\
\>", "Text",ExpressionUUID->"7abed85f-854c-4663-ab4d-674f8ba08871"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PronounceInteger", "[", "12", "]"}]], "Input",ExpressionUUID->"e7474b9e-2a22-4c4b-9ea5-b008088b2481"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
two\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->"a55b1c3f-\
3048-46b5-a1ea-0da3030a3a27"]
}, Open  ]],

Cell[TextData[{
 "PlaceValueTable itself would not include the traditional pronunciation but \
this call via PronounceInteger inserts the option Speak \[Rule] True. Note: \
\[OpenCurlyDoubleQuote]twelve\[CloseCurlyDoubleQuote] is \
\[OpenCurlyDoubleQuote]two left over after 10\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]ten ",
 StyleBox["&",
  FontSize->14],
 " two\[CloseCurlyDoubleQuote] then is clearer."
}], "Text",ExpressionUUID->"323f7715-0a7a-4d5f-896b-abc9f6162559"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PronounceInteger", "[", 
  RowBox[{"12", ",", " ", 
   RowBox[{"Level", " ", "\[Rule]", " ", "0"}], ",", " ", 
   RowBox[{"Method", " ", "\[Rule]", " ", "PlaceValueTable"}]}], 
  "]"}]], "Input",ExpressionUUID->"1399e4fb-35e9-4456-a3fd-5b14957a5abb"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"12", "\<\" \"\>", "\<\"\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  two\[CenterDot]\"\>", "\<\"10   \
&   2\"\>", "\<\" \"\>", "\<\"twelve\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Speak -> True, Level -> 0, Method -> 
     Cool`MathEd`PronounceInteger`PlaceValueTable, TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"5df2917a-7b13-41d1-a5a8-fe21af36cff2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". Zig in German and tig in Dutch"
}], "Section",
 PageBreakAbove->True,ExpressionUUID->"2d7a5ff0-d2f5-4ced-a2c3-513dbfa99e8d"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Conflict of traditional and proper pronunciation"
}], "Subsection",ExpressionUUID->"4d7c4b3a-17ab-4146-8188-551e2d7e93fd"],

Cell["\<\
For English, traditional 19 = nine-teen and place value 90 = \
nine\[CenterDot]ten (traditionally ninety) are not in conflict.\
\>", "Text",ExpressionUUID->"78f7194e-cb6d-42ca-814d-7cba50aceac0"],

Cell["\<\
For German, traditional 19 = neun-zehn and place value 90 = \
neun\[CenterDot]zehn (traditionally neunzig) are in conflict. Making a \
transition will cause much confusion. Dutch has the same problem. \
\>", "Text",ExpressionUUID->"a6b2d513-0624-4944-b85c-82df51946ffb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". A solution is to use zig in German and tig in Dutch for 10"
}], "Subsection",ExpressionUUID->"5f26de3e-815c-4204-9797-7e2829cc5b59"],

Cell[TextData[{
 "Like English \[OpenCurlyDoubleQuote]-ty\[CloseCurlyDoubleQuote], German \
uses \[OpenCurlyDoubleQuote]-zig\[CloseCurlyDoubleQuote] at the end of 20, \
(30,) 40 through 90. Dutch has \[OpenCurlyDoubleQuote]-tig\
\[CloseCurlyDoubleQuote]. Thus we may use ",
 StyleBox["zig",
  FontSlant->"Italic"],
 " for 10 in German and ",
 StyleBox["tig",
  FontSlant->"Italic"],
 " for 10 in Dutch. For me, this flash of insight in 2012 was a major step \
for accepting that there is scope for a full use of the place value system \
(in Holland). The changes in pronunciation are least with zig and tig."
}], "Text",ExpressionUUID->"5045cc95-3d77-415d-b75e-6751e80ee4e6"],

Cell["\<\
Germans or Dutch who have a problem with zig or tig - with the new phenomenon \
of \[OpenCurlyDoubleQuote]Zehnsucht\[CloseCurlyDoubleQuote] -  and who still \
want to make full use of the place value system, could also consider \
borrowing \[OpenCurlyDoubleQuote]ten\[CloseCurlyDoubleQuote] from English, or \
use scientific \[OpenCurlyDoubleQuote]deca\[CloseCurlyDoubleQuote] (though \
with two syllables). Or Germans could use \[OpenCurlyDoubleQuote]tien\
\[CloseCurlyDoubleQuote] from Dutch, and the Dutch \
\[OpenCurlyDoubleQuote]zehn\[CloseCurlyDoubleQuote] from German. In Dutch \
\[OpenCurlyDoubleQuote]tig\[CloseCurlyDoubleQuote] already is used sometimes \
in the sense of \[OpenCurlyDoubleQuote]some unknown very big number\
\[CloseCurlyDoubleQuote] and the change to tig = 10 can still be made.\
\>", "Text",ExpressionUUID->"e35cbe32-b7bc-4b50-b979-ed5915239799"],

Cell[TextData[{
 "For the following, observe the usefulness of the trailing dot again, that \
helps identify the difference between \[OpenCurlyDoubleQuote]zig ",
 StyleBox["&",
  FontSize->14],
 " neun\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]neun\[CenterDot]zig\[CloseCurlyDoubleQuote]. If you \
reading this, remember that the routines speak the numbers as well."
}], "Text",ExpressionUUID->"ceda04e7-3de3-40fe-b4f8-8bdde2ccbde0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueTable", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"19", ",", " ", "90"}], "}"}], ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<German\>\""}]}], "]"}], 
  "     "}]], "Input",ExpressionUUID->"bf757e00-5d89-4975-a80e-e609efeb849d"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"19", "\<\" \"\>", "\<\"\[CenterDot]zig  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  neun\[CenterDot]\"\>", "\<\"10  \
 &   9\"\>", "\<\" \"\>", "\<\"neunzehn\"\>"},
      {"90", "\<\" \"\>", "\<\"neun\[CenterDot]zig\"\>", "\<\"9 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"neunzig\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Language -> "German", TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"fefe5dec-94ba-455a-9e99-01a40b59e3e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueTable", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"19", ",", " ", "90"}], "}"}], ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Dutch\>\""}]}], "]"}], 
  "     "}]], "Input",ExpressionUUID->"18cbe1de-7899-4e94-b60d-e2d3b286cede"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"19", "\<\" \"\>", "\<\"\[CenterDot]tig  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  negen\[CenterDot]\"\>", "\<\"10 \
  &   9\"\>", "\<\" \"\>", "\<\"negentien\"\>"},
      {"90", "\<\" \"\>", "\<\"negen\[CenterDot]tig\"\>", "\<\"9 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"negentig\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Language -> "Dutch", TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"00f78b01-c7aa-4f00-862f-76f978db7da1"]
}, Open  ]],

Cell["\<\
The German association \[OpenCurlyDoubleQuote]Zwanzig-eins\
\[CloseCurlyDoubleQuote] are not fundamentalists in terms of the full place \
value system.\
\>", "Text",ExpressionUUID->"3a882b1b-51bf-40c0-a02b-04b6f09f1267"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"21", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Simplify", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<German\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"d572e1f9-ba66-42c8-9262-6d08c44b5fa3"],

Cell[BoxData[
 FormBox["\<\"zwei\[CenterDot]zig  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  ein\[CenterDot]ein\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"12f15de7-0f06-451e-b89b-\
6765b70447d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"21", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", "  ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<German\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"4cd7c5b9-2ff3-4bbc-a2fa-9d1923525781"],

Cell[BoxData[
 FormBox["\<\"zwei\[CenterDot]zig  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]ein\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"f3e337f9-d3f6-4538-8cea-\
79c1771c6ac8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Comparison with English"
}], "Subsection",ExpressionUUID->"183a3b28-619d-4193-bbbe-ccf92b602ce1"],

Cell["\<\
Remarkably, the changes for English could well be larger than for German. \
E.g. 60 changes from \[OpenCurlyDoubleQuote]sixty\[CloseCurlyDoubleQuote] to \
\[OpenCurlyDoubleQuote]six\[CenterDot]ten\[CloseCurlyDoubleQuote]. An English \
speaking nation might prefer to change \[OpenCurlyDoubleQuote]ten\
\[CloseCurlyDoubleQuote] into \[OpenCurlyDoubleQuote]ty\
\[CloseCurlyDoubleQuote] and pronounce this as \[OpenCurlyDoubleQuote]t\
\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]tee\[CloseCurlyDoubleQuote] (like in Danish), which \
gives \[OpenCurlyDoubleQuote]six\[CenterDot]ty\[CloseCurlyDoubleQuote] again. \
This would actually minimise the changes, even allowing for the special \
twenty, thirty, forty and fifty. English would also re-introduce the \
\[OpenCurlyDoubleQuote]and\[CloseCurlyDoubleQuote] again that German never \
abolished. Kids find English easier than the reversed order in German, Dutch \
and Danish, which only shows how important that order is, and which likely \
does not give evidence on the \[OpenCurlyDoubleQuote]and\
\[CloseCurlyDoubleQuote]. My impression is that English would rather stick to \
\[OpenCurlyDoubleQuote]ten\[CloseCurlyDoubleQuote] and accept the \
consequences. But, with the available routines, we may create an alternative \
\[OpenCurlyDoubleQuote]Englishty\[CloseCurlyDoubleQuote] and check how it \
sounds.\
\>", "Text",ExpressionUUID->"62466aab-1081-42ea-ba5f-93081ac762ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"11", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Englishty\>\""}], ",", " ", 
   RowBox[{"Show", " ", "\[Rule]", " ", "True"}]}], "]"}]], "Input",Expression\
UUID->"138c00a2-c203-4759-98b8-1ef7843a2db4"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]tee <silence msec=\\\"300\\\"/>  &  \[CenterDot]one\
\"\>", TraditionalForm]], "Output",ExpressionUUID->"0c3e68b5-dd54-45ec-acc9-\
d7e5f749ab6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueTable", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "10", ",", " ", "11", ",", " ", "20", ",", " ", "21", ",", " ", "60", 
      ",", " ", "61"}], "}"}], ",", " ", 
    RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Englishty\>\""}]}], "]"}], 
  "     "}]], "Input",ExpressionUUID->"a0fb5996-6ef1-49c6-9a49-28609f451ee7"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"10", "\<\" \"\>", "\<\"\[CenterDot]ty\"\>", "\<\"10\"\>", "\<\" \
\"\>", "\<\"ten\"\>"},
      {"11", "\<\" \"\>", "\<\"\[CenterDot]ty  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]one\"\>", "\<\"10   \
&   1\"\>", "\<\" \"\>", "\<\"eleven\"\>"},
      {"20", "\<\" \"\>", "\<\"two\[CenterDot]ty\"\>", "\<\"2 \[CenterDot] 10\
\"\>", "\<\" \"\>", "\<\"twenty\"\>"},
      {"21", "\<\" \"\>", "\<\"two\[CenterDot]ty  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]one\"\>", "\<\"2 \
\[CenterDot] 10   &   1\"\>", "\<\" \"\>", "\<\"twenty one\"\>"},
      {"60", "\<\" \"\>", "\<\"six\[CenterDot]ty\"\>", "\<\"6 \[CenterDot] 10\
\"\>", "\<\" \"\>", "\<\"sixty\"\>"},
      {"61", "\<\" \"\>", "\<\"six\[CenterDot]ty  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]one\"\>", "\<\"6 \
\[CenterDot] 10   &   1\"\>", "\<\" \"\>", "\<\"sixty one\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Language -> "Englishty", TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"dd420557-72fb-4226-af91-89c2830eda2b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". When 10 might be changed anyway"
}], "Subsection",ExpressionUUID->"1abcc975-788a-4d14-8709-d89727745e21"],

Cell["\<\
I was surprised to see that Finnish 10 is quite a long word. When adapting to \
the full use of the place value system anyway, one might imagine that there \
is a Finnish National Committee on the Pronunciation of 10 that chooses a \
shorter word.\
\>", "Text",ExpressionUUID->"a4ba592d-3821-4c45-bf7c-d161b32033b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"10", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Finnish\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"6164de74-30aa-45c9-8f4c-c6b3ded4cd7d"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","rul",
    "\"No list of rules found for \\!\\(\\*FormBox[\\\"\\\\\\\"language\\\\\\\
\"\\\", TraditionalForm]\\) \\!\\(\\*FormBox[\\\"\\\\\\\"Finnish\\\\\\\"\\\", \
TraditionalForm]\\)\"",2,132,67,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"244a4817-dd82-4943-9b85-80a6a4c4c821"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","int",
    "\"Initialisation with IntegerName and WordTranslation: please wait\"",2,
    132,68,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"78018439-5283-42bd-b1e9-b6295bd72b57"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValueRules","wrn",
    "\"Warning: automated translation of \\!\\(\\*FormBox[\\\"\\\\\\\"Finnish\
\\\\\\\"\\\", TraditionalForm]\\) and not carefully checked on conflicts and \
peculiarities\"",2,132,69,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValueRules"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"95069f8c-d453-45d1-9593-20307902eb27"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]kymmenen\"\>", TraditionalForm]], "Output",Expressio\
nUUID->"5994833f-4942-40d6-82f5-42432f94e849"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Peculiarities in natural language"
}], "Subsection",ExpressionUUID->"596e53ca-78ab-467a-9396-1652c9850903"],

Cell["\<\
Current German makes a distinction between \[OpenCurlyDoubleQuote]eins\
\[CloseCurlyDoubleQuote] for 1 separately and \[OpenCurlyDoubleQuote]ein\
\[CloseCurlyDoubleQuote] for further use. Current German uses \
\[OpenCurlyDoubleQuote]sieben\[CloseCurlyDoubleQuote] for 7 separately, and \
uses \[OpenCurlyDoubleQuote]sieb\[CloseCurlyDoubleQuote] for combinations. \
Such deviations happen in natural language but a systematic use has only one \
application. I took what currently are most frequent: ein and sieb. (Danish \
has \[OpenCurlyDoubleQuote]syv\[CloseCurlyDoubleQuote].)\
\>", "Text",ExpressionUUID->"cbfc868e-f52a-437f-a415-c74355861ebe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"77", ",", "  ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<German\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"485648cf-c4d4-4846-bfb4-0fe5ccbc84fc"],

Cell[BoxData[
 FormBox["\<\"sieb\[CenterDot]zig  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  sieb\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"ff429b99-6b52-4de9-8445-\
d284064d7631"]
}, Open  ]],

Cell["\<\
The advantage of the routine with the pronunciation and transliteration now \
clearly shows, in that we do not just have the words (for writing essays) but \
also have an approximation how it would sound in rehearsing in class in \
(original) kindergarten (German word), to help judge whether the suggestion \
to adapt \[OpenCurlyDoubleQuote]ein\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]sieb\[CloseCurlyDoubleQuote] could be acceptable to \
consider. \
\>", "Text",ExpressionUUID->"14b6b826-4873-4807-a838-4260539f463e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PlaceValue", "[", 
    RowBox[{"#", ",", "  ", 
     RowBox[{"Language", " ", "\[Rule]", " ", "\"\<German\>\""}]}], "]"}], 
   "&"}], " ", "/@", " ", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", " ", "10"}], "]"}]}]], "Input",ExpressionUUID->"873fb840-\
e33f-419f-80d3-33bc7704c805"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"null\[CenterDot]\"\>", ",", "\<\"\[CenterDot]ein\"\>", 
    ",", "\<\"zwei\[CenterDot]\"\>", ",", "\<\"drei\[CenterDot]\"\>", 
    ",", "\<\"vier\[CenterDot]\"\>", ",", "\<\"fuenf\[CenterDot]\"\>", 
    ",", "\<\"sechs\[CenterDot]\"\>", ",", "\<\"sieb\[CenterDot]\"\>", 
    ",", "\<\"acht\[CenterDot]\"\>", ",", "\<\"neun\[CenterDot]\"\>", 
    ",", "\<\"\[CenterDot]zig\"\>"}], "}"}], TraditionalForm]], "Output",Expre\
ssionUUID->"2bdeb46d-3296-43ad-9fc5-ebec17e9952c"]
}, Open  ]],

Cell["\<\
The present proposal clashes with the \[OpenCurlyDoubleQuote]Zwanzigeins\
\[CloseCurlyDoubleQuote] movement on the numbers 0-20 that are important for \
education: zig for zehn, and thus also 11-19 using zig, and \
zwei\[CenterDot]zig, to show the working of the place value system. Arbitrary \
in my implementation are: ein for eins, sieb for sieben, drei\[SZ]ig would \
also become drei\[CenterDot]zig. See Colignatus (2015b, 2018a). Remember also \
my distinction between the math language in school and the dialect of current \
language outside of school. My suggestion is that the 21 movement could \
become stronger if it includes the full place value system alongside their \
original views, as one of the issues to consider.\
\>", "Text",ExpressionUUID->"6f3835ba-d5b1-44b3-816f-64c2f0a57a7e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". Translate, transliterate and quality control"
}], "Section",ExpressionUUID->"e1fea622-f753-4367-936c-bd734cc1de0b"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Translate versus transliterate"
}], "Subsection",ExpressionUUID->"6758d142-8eb3-47e6-9e07-d235889f2d76"],

Cell[TextData[{
 "To Speak in another language, the user can adapt the $Language in the \
Preferences of ",
 StyleBox["Mathematica, ",
  FontSlant->"Italic"],
 "then restart. Both the numbers and words should be pronounced in the \
specified language, though in traditional manner. "
}], "Text",ExpressionUUID->"6f53edec-04f0-4aa6-b590-a56a24096b10"],

Cell[TextData[{
 "There will be users who have ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "running under one specific language (e.g. $Language = \
\[OpenCurlyDoubleQuote]English\[CloseCurlyDoubleQuote]) and who still have \
interest in the pronunciation of the different languages. In that case, \
transliteration may help. The transliteration is provided in PlaceValueRules[\
\[OpenCurlyDoubleQuote]yourlanguage\[CloseCurlyDoubleQuote]] with the option \
\[OpenCurlyDoubleQuote]transliteratorlanguage\[CloseCurlyDoubleQuote] \[Rule] \
{...}."
}], "Text",ExpressionUUID->"4b6a94ee-86c2-4660-9c3c-ebfbaa457923"],

Cell[TextData[{
 "PlaceValue and PlaceValueRules can also call WordTranslation from English \
to automatically supply the words of another languague. The call \
PlaceValueRules[Set, \[OpenCurlyDoubleQuote]youlanguage\
\[CloseCurlyDoubleQuote]]. This does not provide for the transliteration. One \
is advised to save the resulting \
PlaceValueRules[\[OpenCurlyDoubleQuote]yourlanguage\[CloseCurlyDoubleQuote]] \
because the initialisation takes some moments. The words for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]],ExpressionUUID->
  "419f4dc5-6e6c-43f6-b124-4a3e57d741ee"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "5"], TraditionalForm]],ExpressionUUID->
  "63d6ad9c-d928-403d-ae38-504862542d4c"],
 " are generally missing and thus replaced by myriad and lakh."
}], "Text",ExpressionUUID->"51576d3c-0df9-4d6a-9b34-91dafd6e8d70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Warning: automation does not guarantee quality"
}], "Subsection",ExpressionUUID->"b494d542-83c3-47a4-8f96-f573429e96bf"],

Cell[TextData[{
 "PlaceValueRules[Set, \[OpenCurlyDoubleQuote]youlanguage\
\[CloseCurlyDoubleQuote]] issues a ",
 StyleBox["warning",
  FontWeight->"Bold"],
 " when the submitted language isn't in the list \
PlaceValueRules[\"Checked\"]. One may turn off the message or include a \
language in PlaceValueRules[\[OpenCurlyDoubleQuote]Checked\
\[CloseCurlyDoubleQuote]] provisionally, but it is better to actually check \
first (and then use AppendTo on the list of checked languages).  The package \
is conservative on giving the message but will repeat it on the tables, see \
below."
}], "Text",ExpressionUUID->"742a3c1b-6ae7-406b-b564-b5f949cd76fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Checked in PlaceValueRules: English, German, French, Dutch and Danish"
}], "Subsection",ExpressionUUID->"fb851263-042e-491b-903b-15193303fbd1"],

Cell[TextData[{
 "The package can be simple since we only require 2+10+6 = 18 \
transliterations per language, to pronounce the integers with absolute values \
less than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "7"], TraditionalForm]],ExpressionUUID->
  "b71ee611-f6f2-4d7b-9337-07a4d3b13a0e"],
 "."
}], "Text",ExpressionUUID->"cf47758e-b908-4332-9efd-f15401c26a8e"],

Cell[TextData[{
 "The routine PlaceValue[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] takes the true words and transliterations from the PlaceValueRules[\
\[OpenCurlyDoubleQuote]language\[CloseCurlyDoubleQuote]]. Implemented have \
only been English, German, French, Dutch and Danish, up to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "7"], TraditionalForm]],ExpressionUUID->
  "46200051-27c5-49e7-9a47-3f2b8f4dfff1"],
 ". They have been checked on name conflicts and language peculiars. Amplish \
and Englishty are variants of English that have a role in the exposition."
}], "Text",ExpressionUUID->"ad69172d-b077-4695-ae6e-619bada6b3b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "\"\<Checked\>\"", "]"}]], "Input",Expression\
UUID->"dbb52ca6-d3df-4ddf-b3b7-4c93e191ec54"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"English\"\>", ",", "\<\"Amplish\"\>", ",", "\<\"Danish\"\>", 
    ",", "\<\"Dutch\"\>", ",", "\<\"Englishty\"\>", ",", "\<\"French\"\>", 
    ",", "\<\"German\"\>"}], "}"}], TraditionalForm]], "Output",ExpressionUUID\
->"4710742a-7693-40b7-b2bb-b35b006bafaf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". German"
}], "Subsubsection",ExpressionUUID->"aaa972ce-49ec-40a1-910b-cf8babdbd3e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"9189", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<German\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"ee6aecc4-f097-4c31-891a-84960057a2f1"],

Cell[BoxData[
 FormBox["\<\"neun\[CenterDot]tausend  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]hundert  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  acht\[CenterDot]zig  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  neun\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"74d6ee97-d2aa-47f6-a7ac-\
3dfd747dfbe8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "\"\<German\>\"", "]"}]], "Input",ExpressionU\
UID->"72760207-0adc-4a09-8902-ca3b6c943310"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"True", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"negativ\"\>"}], ",", 
       RowBox[{
       "And", "\[Rule]", \
"\<\"\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"null\"\>", ",", "\<\"ein\"\>", ",", "\<\"zwei\"\>", 
          ",", "\<\"drei\"\>", ",", "\<\"vier\"\>", ",", "\<\"fuenf\"\>", 
          ",", "\<\"sechs\"\>", ",", "\<\"sieb\"\>", ",", "\<\"acht\"\>", 
          ",", "\<\"neun\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"zig\"\>", ",", "\<\"hundert\"\>", 
          ",", "\<\"tausend\"\>", ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"million\"\>"}], "}"}]}]}], "}"}]}], ",", 
    RowBox[{"\<\"English\"\>", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"nayguhteef\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"oond\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"noul\"\>", ",", "\<\"ayen\"\>", 
          ",", "\<\"tsvwaayie\"\>", ",", "\<\"dryie\"\>", ",", "\<\"fear\"\>",
           ",", "\<\"fuihnf\"\>", ",", "\<\"sex\"\>", ",", "\<\"sieb\"\>", 
          ",", "\<\"akht\"\>", ",", "\<\"noin\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"tzeeg\"\>", ",", "\<\"hoondert\"\>", 
          ",", "\<\"tausand\"\>", ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"meelyohn\"\>"}], "}"}]}]}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"430510ba-900e-407b-80e7-\
b9bb9cfd50bd"]
}, Open  ]],

Cell["\<\
Above, we saw \[OpenCurlyDoubleQuote]zig\[CloseCurlyDoubleQuote] in German \
being transliterated by \[OpenCurlyDoubleQuote]tzeeg\[CloseCurlyDoubleQuote] \
in English, for the simple reason that the current setting of $Language is \
\[OpenCurlyDoubleQuote]English\[CloseCurlyDoubleQuote]. \
\>", "Text",ExpressionUUID->"28a7c548-46c5-4532-8ec4-2c186803640b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". French"
}], "Subsubsection",ExpressionUUID->"1579d653-e35b-4af1-a304-46e98baf9719"],

Cell[TextData[{
 "French can use ",
 StyleBox["dix.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"7cf30f7a-3734-4661-a55f-156b0b789b24"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"9189", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<French\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"3db2a3dc-7389-4024-8f35-0238202a0108"],

Cell[BoxData[
 FormBox["\<\"neuf\[CenterDot]mille  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]cent  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  huit\[CenterDot]dix  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  neuf\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"c67dd99e-1c30-4ff5-9fa1-\
8fc8fd91925f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "\"\<French\>\"", "]"}]], "Input",ExpressionU\
UID->"19e744cc-e87b-44da-b1f9-6bde59f8c259"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"True", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"negative\"\>"}], ",", 
       RowBox[{
       "And", "\[Rule]", \
"\<\"\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"zero\"\>", ",", "\<\"un\"\>", ",", "\<\"deux\"\>", 
          ",", "\<\"trois\"\>", ",", "\<\"quatre\"\>", ",", "\<\"cinq\"\>", 
          ",", "\<\"six\"\>", ",", "\<\"sept\"\>", ",", "\<\"huit\"\>", 
          ",", "\<\"neuf\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"dix\"\>", ",", "\<\"cent\"\>", ",", "\<\"mille\"\>", 
          ",", "\<\"myriade\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"million\"\>"}], "}"}]}]}], "}"}]}], ",", 
    RowBox[{"\<\"English\"\>", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"nayguhteef\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"ayh\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"zeyrouh\"\>", ",", "\<\"uhnn\"\>", ",", "\<\"duh\"\>", 
          ",", "\<\"trouwah\"\>", ",", "\<\"kahtruh\"\>", 
          ",", "\<\"saink\"\>", ",", "\<\"sees\"\>", ",", "\<\"seht\"\>", 
          ",", "\<\"weet\"\>", ",", "\<\"neuhf\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"dees\"\>", ",", "\<\"sun\"\>", ",", "\<\"meel\"\>", 
          ",", "\<\"meeri udd\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"meelyon\"\>"}], "}"}]}]}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"868bc1dc-81e9-4763-9efe-\
dc3a417d8876"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Dutch"
}], "Subsubsection",ExpressionUUID->"4a9d7e87-af79-40f5-b51a-c5773e754b59"],

Cell["\<\
For Dutch, the design questions are alike those for German. The best solution \
would be to use \[OpenCurlyDoubleQuote]tig\[CloseCurlyDoubleQuote] for \
\[OpenCurlyDoubleQuote]tien\[CloseCurlyDoubleQuote].\
\>", "Text",ExpressionUUID->"e3c52393-08c8-4358-ac21-402a66c4fd24"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"9189", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Dutch\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"383911b0-a6f4-4369-ba43-5c01e54c3761"],

Cell[BoxData[
 FormBox["\<\"negen\[CenterDot]duizend  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]honderd  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  acht\[CenterDot]tig  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  negen\[CenterDot]\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"b30ea837-e4a1-455b-84d7-\
04137f12659e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueRules", "[", "\"\<Dutch\>\"", "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "distinction", " ", "between", " ", "minus", " ", "and", " ", "min"}], 
   "*)"}]}]], "Input",ExpressionUUID->"d4e17437-559e-459a-9b2b-9191ac82eb1d"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"True", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"min\"\>"}], ",", 
       RowBox[{
       "And", "\[Rule]", \
"\<\"\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"nul\"\>", ",", "\<\"een\"\>", ",", "\<\"twee\"\>", 
          ",", "\<\"drie\"\>", ",", "\<\"vier\"\>", ",", "\<\"vijf\"\>", 
          ",", "\<\"zes\"\>", ",", "\<\"zeven\"\>", ",", "\<\"acht\"\>", 
          ",", "\<\"negen\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"tig\"\>", ",", "\<\"honderd\"\>", 
          ",", "\<\"duizend\"\>", ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"miljoen\"\>"}], "}"}]}]}], "}"}]}], ",", 
    RowBox[{"\<\"English\"\>", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"min\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"n\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"nuhl\"\>", ",", "\<\"ayn\"\>", ",", "\<\"tway\"\>", 
          ",", "\<\"dree\"\>", ",", "\<\"fear\"\>", ",", "\<\"vaif\"\>", 
          ",", "\<\"zes\"\>", ",", "\<\"zayven\"\>", ",", "\<\"ahgt\"\>", 
          ",", "\<\"naigen\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"tikgh\"\>", ",", "\<\"hon dairt\"\>", 
          ",", "\<\"duuzand\"\>", ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"milyoon\"\>"}], "}"}]}]}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"9d5156b7-dcfc-4da5-ab0f-\
06bf9d12ac7b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Danish"
}], "Subsubsection",ExpressionUUID->"fc781194-64c2-4e63-ae59-4ba62fc56f48"],

Cell[TextData[{
 "Danish can use ",
 StyleBox["ti.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"89482403-536c-4995-9d86-c6e8bb86a548"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"9189", ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Danish\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"85653b2f-c7c3-4b11-9f79-4f5ad37126b7"],

Cell[BoxData[
 FormBox["\<\"ni\[CenterDot]tusind  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\
\\)  \[CenterDot]hundrede  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  otte\
\[CenterDot]ti  \\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \
ni\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->"14cbb1f8-\
f746-4d08-86de-2fe856a56805"]
}, Open  ]],

Cell["\<\
For Danish, I transliterated listening to Google Translate. I might not hear \
subtleties that native speakers would hear. The connective \
\[OpenCurlyDoubleQuote]and\[CloseCurlyDoubleQuote] is \
\[OpenCurlyDoubleQuote]og\[CloseCurlyDoubleQuote], which reminds of German \
\[OpenCurlyDoubleQuote]auch\[CloseCurlyDoubleQuote] and Dutch \
\[OpenCurlyDoubleQuote]ook\[CloseCurlyDoubleQuote] meaning \
\[OpenCurlyDoubleQuote]also\[CloseCurlyDoubleQuote]. It is quite a diaspora.\
\>", "Text",ExpressionUUID->"72555d02-bee0-4d91-9393-bc1b6e2e3237"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "\"\<Danish\>\"", "]"}]], "Input",ExpressionU\
UID->"9ab506bb-f607-4ffb-a2dd-eb91d1f94230"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"True", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"negativ\"\>"}], ",", 
       RowBox[{
       "And", "\[Rule]", \
"\<\"\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"nul\"\>", ",", "\<\"en\"\>", ",", "\<\"to\"\>", 
          ",", "\<\"tre\"\>", ",", "\<\"fire\"\>", ",", "\<\"fem\"\>", 
          ",", "\<\"seks\"\>", ",", "\<\"syv\"\>", ",", "\<\"otte\"\>", 
          ",", "\<\"ni\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"ti\"\>", ",", "\<\"hundrede\"\>", ",", "\<\"tusind\"\>",
           ",", "\<\"myriade\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"million\"\>"}], "}"}]}]}], "}"}]}], ",", 
    RowBox[{"\<\"English\"\>", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"nayguhtew\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"oh\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"nul\"\>", ",", "\<\"ayn\"\>", ",", "\<\"toh\"\>", 
          ",", "\<\"trya\"\>", ",", "\<\"fear\"\>", ",", "\<\"fem\"\>", 
          ",", "\<\"sex\"\>", ",", "\<\"suwe\"\>", ",", "\<\"ude\"\>", 
          ",", "\<\"knee\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"tee\"\>", ",", "\<\"hoonah\"\>", ",", "\<\"toosind\"\>",
           ",", "\<\"myriade\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"meelyohn\"\>"}], "}"}]}]}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"56c7ac45-d114-4fe5-b9a2-\
76ad0b96d747"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Using non-implemented languages, e.g. Italian and Spanish"
}], "Subsection",ExpressionUUID->"25d50d3d-624e-417a-96e6-bd8862e7a4fc"],

Cell["Please remember that there is no automated transliteration.", "Text",ExpressionUUID->"f67b6737-c7fa-42f5-88b0-0b430dffa3a4"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Italian"
}], "Subsubsection",ExpressionUUID->"8acb519d-5f47-4d8e-baba-d5f7f3b5d713"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueRules", "[", "\"\<Italian\>\"", "]"}], "   ", 
  RowBox[{"(*", "unknown", "*)"}]}]], "Input",ExpressionUUID->"536e2c58-c401-\
42f1-a24c-e4c491db530a"],

Cell[BoxData[
 FormBox[
  RowBox[{"PlaceValueRules", "(", "\<\"Italian\"\>", ")"}], 
  TraditionalForm]], "Output",ExpressionUUID->"62a5c37a-017a-41df-9253-\
75b8145026f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"134", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Italian\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"5cfdba16-5d1c-440c-9b85-6aa1281840a4"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","rul",
    "\"No list of rules found for \\!\\(\\*FormBox[\\\"\\\\\\\"language\\\\\\\
\"\\\", TraditionalForm]\\) \\!\\(\\*FormBox[\\\"\\\\\\\"Italian\\\\\\\"\\\", \
TraditionalForm]\\)\"",2,130,61,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"3f9db840-5f3f-440f-b9ff-359865fabfb5"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","int",
    "\"Initialisation with IntegerName and WordTranslation: please wait\"",2,
    130,62,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"e7609f3d-238c-481c-8d7f-5c0528cdb37b"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValueRules","wrn",
    "\"Warning: automated translation of \\!\\(\\*FormBox[\\\"\\\\\\\"Italian\
\\\\\\\"\\\", TraditionalForm]\\) and not carefully checked on conflicts and \
peculiarities\"",2,130,63,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValueRules"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"fb331628-44b0-4704-9c5c-df9fea313650"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]cento  e  tre\[CenterDot]dieci  e  quattro\
\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->"b90635a4-e8b4-\
4959-862c-e032b6ff88a6"]
}, Open  ]],

Cell["\<\
After this initialisation, the call is much faster. The user must provide a \
transliteration of \[OpenCurlyDoubleQuote]e\[CloseCurlyDoubleQuote] but \
\[OpenCurlyDoubleQuote]con\[CloseCurlyDoubleQuote] already provides a more \
Italian sound.\
\>", "Text",ExpressionUUID->"122bba55-5789-4b04-9870-6b6796c8732c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"134", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Italian\>\""}], ",", " ", 
   RowBox[{"And", " ", "\[Rule]", " ", "\"\<con\>\""}]}], "]"}]], "Input",Expr\
essionUUID->"41e4631c-c7cb-4861-b360-9213093d7a28"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]cento  con  tre\[CenterDot]dieci  con  quattro\
\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->"8d2d1706-e5d2-\
4427-a730-322e6ba83967"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "\"\<Italian\>\"", "]"}]], "Input",Expression\
UUID->"e9af56f4-f4c1-4c9e-9f9d-529e033c10c5"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"True", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"negativo\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"e\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"zero\"\>", ",", "\<\"uno\"\>", ",", "\<\"due\"\>", 
          ",", "\<\"tre\"\>", ",", "\<\"quattro\"\>", ",", "\<\"cinque\"\>", 
          ",", "\<\"sei\"\>", ",", "\<\"sette\"\>", ",", "\<\"otto\"\>", 
          ",", "\<\"nove\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"dieci\"\>", ",", "\<\"cento\"\>", ",", "\<\"cento\"\>", 
          ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"milione\"\>"}], "}"}]}]}], "}"}]}], ",", 
    RowBox[{"\<\"English\"\>", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"negativo\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"e\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"zero\"\>", ",", "\<\"uno\"\>", ",", "\<\"due\"\>", 
          ",", "\<\"tre\"\>", ",", "\<\"quattro\"\>", ",", "\<\"cinque\"\>", 
          ",", "\<\"sei\"\>", ",", "\<\"sette\"\>", ",", "\<\"otto\"\>", 
          ",", "\<\"nove\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"dieci\"\>", ",", "\<\"cento\"\>", ",", "\<\"cento\"\>", 
          ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"milione\"\>"}], "}"}]}]}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"3537e7c6-dde8-4b6b-b6f3-\
6efa4b7d1a07"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Spanish"
}], "Subsubsection",ExpressionUUID->"0a84e608-3397-41ef-b547-9b68251aa026"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceValueRules", "[", "\"\<Spanish\>\"", "]"}], "  ", 
  RowBox[{"(*", "unknown", "*)"}]}]], "Input",ExpressionUUID->"cf4c5eb1-7c95-\
445f-b9c5-13f691e93580"],

Cell[BoxData[
 FormBox[
  RowBox[{"PlaceValueRules", "(", "\<\"Spanish\"\>", ")"}], 
  TraditionalForm]], "Output",ExpressionUUID->"429df6d2-a5a0-4962-aa10-\
febcd3c99d97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"134", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Spanish\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"0e5d0241-bf2b-4e5d-83c7-de01caf2b487"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","rul",
    "\"No list of rules found for \\!\\(\\*FormBox[\\\"\\\\\\\"language\\\\\\\
\"\\\", TraditionalForm]\\) \\!\\(\\*FormBox[\\\"\\\\\\\"Spanish\\\\\\\"\\\", \
TraditionalForm]\\)\"",2,131,64,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"1b56ff38-88df-48fd-9b71-7ea4a4068a49"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","int",
    "\"Initialisation with IntegerName and WordTranslation: please wait\"",2,
    131,65,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"62964fd9-d1be-4c88-a60b-1040db669bc8"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValueRules","wrn",
    "\"Warning: automated translation of \\!\\(\\*FormBox[\\\"\\\\\\\"Spanish\
\\\\\\\"\\\", TraditionalForm]\\) and not carefully checked on conflicts and \
peculiarities\"",2,131,66,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValueRules"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"8a77cb85-cb99-427e-a4f4-8d83c087efe2"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]cien  y  tres\[CenterDot]diez  y  \
cuatro\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->\
"b6666624-978f-4c26-add7-24aa9465e626"]
}, Open  ]],

Cell["\<\
After this initialisation, the call is much faster. A quick fix for \
pronunciation is perhaps this.\
\>", "Text",ExpressionUUID->"2fd86e17-ce91-4115-b1fa-255bb1b8beae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"134", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Spanish\>\""}], ",", " ", 
   RowBox[{"And", " ", "\[Rule]", " ", "\"\<e\>\""}]}], "]"}]], "Input",Expres\
sionUUID->"4236bac8-9f4a-4d6d-a4aa-8cab0394a3fb"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]cien  e  tres\[CenterDot]diez  e  \
cuatro\[CenterDot]\"\>", TraditionalForm]], "Output",ExpressionUUID->\
"4af968c7-9996-4fd2-bcb7-9499a286c4ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "\"\<Spanish\>\"", "]"}]], "Input",Expression\
UUID->"bfb94494-596e-4098-bac5-18153229f429"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"True", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"negativo\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"y\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"cero\"\>", ",", "\<\"uno\"\>", ",", "\<\"dos\"\>", 
          ",", "\<\"tres\"\>", ",", "\<\"cuatro\"\>", ",", "\<\"cinco\"\>", 
          ",", "\<\"seis\"\>", ",", "\<\"siete\"\>", ",", "\<\"ocho\"\>", 
          ",", "\<\"nueve\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"diez\"\>", ",", "\<\"cien\"\>", ",", "\<\"cien\"\>", 
          ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"mill\[OAcute]n\"\>"}], "}"}]}]}], "}"}]}], ",", 
    RowBox[{"\<\"English\"\>", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Negative", "\[Rule]", "\<\"negativo\"\>"}], ",", 
       RowBox[{"And", "\[Rule]", "\<\"y\"\>"}], ",", 
       RowBox[{"N", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"cero\"\>", ",", "\<\"uno\"\>", ",", "\<\"dos\"\>", 
          ",", "\<\"tres\"\>", ",", "\<\"cuatro\"\>", ",", "\<\"cinco\"\>", 
          ",", "\<\"seis\"\>", ",", "\<\"siete\"\>", ",", "\<\"ocho\"\>", 
          ",", "\<\"nueve\"\>"}], "}"}]}], ",", 
       RowBox[{"Power", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"diez\"\>", ",", "\<\"cien\"\>", ",", "\<\"cien\"\>", 
          ",", "\<\"myriad\"\>", ",", "\<\"lakh\"\>", 
          ",", "\<\"mill\[OAcute]n\"\>"}], "}"}]}]}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"1cb98c1c-07c4-426b-872a-\
8e19307b15de"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". A general comment"
}], "Subsection",ExpressionUUID->"08fb5a69-fe46-4f6d-a62f-704ba076758f"],

Cell["\<\
\[OpenCurlyDoubleQuote]Deux\[CloseCurlyDoubleQuote] in French has been \
transliterated here as \[OpenCurlyDoubleQuote]duh\[CloseCurlyDoubleQuote]. \
English has a closer sound in \[OpenCurlyDoubleQuote]bird\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]dirt\
\[CloseCurlyDoubleQuote]. I found no way to unpack this sound from \
\[OpenCurlyDoubleQuote]bird\[CloseCurlyDoubleQuote] and paste it into \
\[OpenCurlyDoubleQuote]d...h\[CloseCurlyDoubleQuote].\
\>", "Text",ExpressionUUID->"60c9e0d5-9b7d-4afa-b9c5-da6cce09c03c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", " ", "=", " ", 
  RowBox[{"WordData", "[", 
   RowBox[{"\"\<bird\>\"", ",", " ", "\"\<PhoneticForm\>\""}], 
   "]"}]}]], "Input",ExpressionUUID->"ec1867e7-6370-47a8-8a05-3f3a75fedaba"],

Cell[BoxData[
 FormBox[
  StyleBox["\<\"b\:02c8\:025dd\"\>",
   StripOnInput->False,
   FontFamily->"Arial Unicode MS"], TraditionalForm]], "Output",ExpressionUUID\
->"bd945940-6ddf-41f8-938e-76f35964e5e6"]
}, Open  ]],

Cell["InputForm:", "Text",ExpressionUUID->"599c55f4-7f88-48f7-9623-5027bcceb6a0"],

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\<\"b\:02c8\:025dd\"\>", ",", " ", 
   RowBox[{"FontFamily", " ", "->", " ", "\<\"Arial Unicode MS\"\>"}]}], 
  "]"}]], "Output",ExpressionUUID->"0c5854e9-777c-4bd0-a633-cac2e9a02c64"],

Cell["Submitting this to Speak generates a blank.", "Text",ExpressionUUID->"58e44784-e667-4107-a6a4-b4afcbb52203"],

Cell[BoxData[
 RowBox[{"Speak", "[", "\"\<'\:025d\>\"", "]"}]], "Input",ExpressionUUID->"ade85c21-46c1-4aca-9679-a98d87c177ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpokenString", "[", "\"\<'\:025d\>\"", "]"}]], "Input",ExpressionUUI\
D->"3ab0f6df-09cc-47dd-a0ec-2d4c939891b2"],

Cell[BoxData[
 FormBox["\<\"'\:025d\"\>", TraditionalForm]], "Output",ExpressionUUID->"dea5f31b-91b0-4e04-9870-654248e40164"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Speak", "[", "%", "]"}]], "Input",ExpressionUUID->"82f82ffe-72fa-447a-886b-b3feba7d08b6"],

Cell["\<\
For transliteration it would be useful when such phonetic forms could also be \
submitted to Speak. \
\>", "Text",ExpressionUUID->"67a75296-3a47-42de-b71e-7550ff3afd9c"],

Cell["\<\
I don\[CloseCurlyQuote]t know anything about linguistics, and the following \
are some first discoveries. \
\>", "Text",ExpressionUUID->"a48c2e70-5a0a-4431-9db2-9d1a146d1787"],

Cell["\<\
In evolution, disregarding sign language, pronunciation came first, and \
writing was developed by encoding how someone pronounced something (beth = \
house with two rooms = B). In computer programming, the words and \
translations between languages were first, and the pronunciations came later. \
We take pronunciation as (conceptually) basic again since kids live in world \
of sound and only learn to read and write later on.\
\>", "Text",ExpressionUUID->"eac9fc44-d942-4691-93ba-d10d14774ae0"],

Cell["\<\
The International Phonetic Alphabet (IPA). Wikipedia (a portal and no \
source): https://en.wikipedia.org/wiki/International_Phonetic_Alphabet.\
\>", "Text",ExpressionUUID->"2235641a-718d-46bf-a92d-bac9faecdd6e"],

Cell["\<\
https://en.wikipedia.org/wiki/Orthography#Correspondence_with_pronunciation\
\>", "Text",ExpressionUUID->"e127b468-60d6-4cb9-a266-87b529380f44"],

Cell["\<\
See also: http://www.wolframalpha.com/input/?i=pronunciation+of+bird\
\>", "Text",ExpressionUUID->"35533db6-3a49-4733-8ded-5ba0383aa456"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". Conversion tables"
}], "Section",ExpressionUUID->"edcf5474-4dff-4ae6-baaa-b82c1183eb9d"],

Cell["\<\
The routine PlaceValueTable allows the automatic generation of tables of \
conversion, and thus comes with a big warning. Automated translations must be \
scrutinised for flukes. However, creating such tables is quite useful to \
start with the required close reading. For these tables, the message that an \
automated translation hasn\[CloseCurlyQuote]t been checked is a useful \
reminder at each call. Please do not turn this off, but do the checking and \
correcting, and then do an \
AppendTo[PlaceValueRules[\[OpenCurlyDoubleQuote]Checked\
\[CloseCurlyDoubleQuote]], \[OpenCurlyDoubleQuote]yournewlanguage\
\[CloseCurlyDoubleQuote]]].\
\>", "Text",ExpressionUUID->"473ff43a-16dc-4fb4-bcce-a3748e2b64b7"],

Cell["\<\
Standard conversion tables would be 0-10, 20-30, 30-40, etcetera. We can also \
consider other tables.\
\>", "Text",ExpressionUUID->"2ac6ff94-de6f-4895-8298-9125f233cc34"],

Cell["The table of 7 in English.", "Text",ExpressionUUID->"310b9c21-96eb-4b21-ad41-083a3b36a4e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueTable", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"7", ",", " ", "70", ",", " ", "7"}], "]"}], "]"}]], "Input",Expres\
sionUUID->"ccb1aaf0-24b0-48ee-975d-63fd22517ee3"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"7", "\<\" \"\>", "\<\"seven\[CenterDot]\"\>", "\<\"7\"\>", "\<\" \
\"\>", "\<\"seven\"\>"},
      {"14", "\<\" \"\>", "\<\"\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  four\[CenterDot]\"\>", "\<\"10  \
 &   4\"\>", "\<\" \"\>", "\<\"fourteen\"\>"},
      {"21", "\<\" \"\>", "\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  \[CenterDot]one\"\>", "\<\"2 \
\[CenterDot] 10   &   1\"\>", "\<\" \"\>", "\<\"twenty one\"\>"},
      {"28", "\<\" \"\>", "\<\"two\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  eight\[CenterDot]\"\>", "\<\"2 \
\[CenterDot] 10   &   8\"\>", "\<\" \"\>", "\<\"twenty eight\"\>"},
      {"35", "\<\" \"\>", "\<\"three\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  five\[CenterDot]\"\>", "\<\"3 \
\[CenterDot] 10   &   5\"\>", "\<\" \"\>", "\<\"thirty five\"\>"},
      {"42", "\<\" \"\>", "\<\"four\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\
\",FontSize->10]\\)  two\[CenterDot]\"\>", "\<\"4 \[CenterDot] 10   &   \
2\"\>", "\<\" \"\>", "\<\"forty two\"\>"},
      {"49", "\<\" \"\>", "\<\"four\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\
\",FontSize->10]\\)  nine\[CenterDot]\"\>", "\<\"4 \[CenterDot] 10   &   \
9\"\>", "\<\" \"\>", "\<\"forty nine\"\>"},
      {"56", "\<\" \"\>", "\<\"five\[CenterDot]ten  \\!\\(\\*StyleBox[\\\"&\\\
\",FontSize->10]\\)  six\[CenterDot]\"\>", "\<\"5 \[CenterDot] 10   &   \
6\"\>", "\<\" \"\>", "\<\"fifty six\"\>"},
      {"63", "\<\" \"\>", "\<\"six\[CenterDot]ten  \
\\!\\(\\*StyleBox[\\\"&\\\",FontSize->10]\\)  three\[CenterDot]\"\>", "\<\"6 \
\[CenterDot] 10   &   3\"\>", "\<\" \"\>", "\<\"sixty three\"\>"},
      {"70", "\<\" \"\>", "\<\"seven\[CenterDot]ten\"\>", "\<\"7 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"seventy\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"099dfeb3-1a5d-49cf-8d5f-b4f959c53412"]
}, Open  ]],

Cell["The table of 7 in unchecked Spanish, installed above.", "Text",ExpressionUUID->"ceadd5ef-47ba-4673-a52d-793d6c6d6376"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueTable", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"7", ",", " ", "70", ",", " ", "7"}], "]"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Spanish\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"53613ed5-9e36-46c6-831d-af0076c51482"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValueRules","wrn",
    "\"Warning: automated translation of \\!\\(\\*FormBox[\\\"\\\\\\\"Spanish\
\\\\\\\"\\\", TraditionalForm]\\) and not carefully checked on conflicts and \
peculiarities\"",2,133,70,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValueRules"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"51a00773-ae14-450f-be64-3df7090a6c31"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"7", "\<\" \"\>", "\<\"siete\[CenterDot]\"\>", "\<\"7\"\>", "\<\" \
\"\>", "\<\"siete\"\>"},
      {"14", "\<\" \"\>", "\<\"\[CenterDot]diez  y  cuatro\[CenterDot]\"\>", \
"\<\"10   &   4\"\>", "\<\" \"\>", "\<\"catorce\"\>"},
      {"21", "\<\" \"\>", "\<\"dos\[CenterDot]diez  y  \[CenterDot]uno\"\>", \
"\<\"2 \[CenterDot] 10   &   1\"\>", "\<\" \"\>", "\<\"veintiuno\"\>"},
      {"28", "\<\" \"\>", "\<\"dos\[CenterDot]diez  y  ocho\[CenterDot]\"\>", \
"\<\"2 \[CenterDot] 10   &   8\"\>", "\<\" \"\>", "\<\"veintiocho\"\>"},
      {"35", "\<\" \"\>", "\<\"tres\[CenterDot]diez  y  \
cinco\[CenterDot]\"\>", "\<\"3 \[CenterDot] 10   &   5\"\>", "\<\" \"\>", "\<\
\"treinta y cinco\"\>"},
      {"42", "\<\" \"\>", "\<\"cuatro\[CenterDot]diez  y  \
dos\[CenterDot]\"\>", "\<\"4 \[CenterDot] 10   &   2\"\>", "\<\" \"\>", \
"\<\"cuarenta y dos\"\>"},
      {"49", "\<\" \"\>", "\<\"cuatro\[CenterDot]diez  y  nueve\[CenterDot]\"\
\>", "\<\"4 \[CenterDot] 10   &   9\"\>", "\<\" \"\>", "\<\"cuarenta y \
nueve\"\>"},
      {"56", "\<\" \"\>", "\<\"cinco\[CenterDot]diez  y  \
seis\[CenterDot]\"\>", "\<\"5 \[CenterDot] 10   &   6\"\>", "\<\" \"\>", \
"\<\"cincuenta y seis\"\>"},
      {"63", "\<\" \"\>", "\<\"seis\[CenterDot]diez  y  \
tres\[CenterDot]\"\>", "\<\"6 \[CenterDot] 10   &   3\"\>", "\<\" \"\>", \
"\<\"sesenta y tres\"\>"},
      {"70", "\<\" \"\>", "\<\"siete\[CenterDot]diez\"\>", "\<\"7 \
\[CenterDot] 10\"\>", "\<\" \"\>", "\<\"setenta\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Language -> "Spanish", TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"cf31245d-e726-4dd3-bd3e-cf58aef652b2"]
}, Open  ]],

Cell["\<\
The package is conservative on the warning, and only generates it at \
installation and for these tables.\
\>", "Text",ExpressionUUID->"570de7d0-06fa-4fe5-b5d9-5d78fa42c2ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValue", "[", 
  RowBox[{"1234", ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Spanish\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"5e8328a5-0924-4afe-a07d-008288acd878"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]cien  y  dos\[CenterDot]cien  y  \
tres\[CenterDot]diez  y  cuatro\[CenterDot]\"\>", TraditionalForm]], "Output",\
ExpressionUUID->"20bf2aac-e2ee-4359-be43-16e9b16eb968"]
}, Open  ]],

Cell["\<\
The table of 7 in unchecked Swedish. The warning is issued twice: first at \
installation and secondly at creating the Table.\
\>", "Text",ExpressionUUID->"64500e90-abc1-4b85-ad17-ff015d40c956"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueTable", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"7", ",", " ", "70", ",", " ", "7"}], "]"}], ",", " ", 
   RowBox[{"Language", " ", "\[Rule]", " ", "\"\<Swedish\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"766f9f2b-8be9-4fe4-87ee-f0d2f11388bd"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValueRules","wrn",
    "\"Warning: automated translation of \\!\\(\\*FormBox[\\\"\\\\\\\"Swedish\
\\\\\\\"\\\", TraditionalForm]\\) and not carefully checked on conflicts and \
peculiarities\"",2,134,71,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValueRules"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"132003f9-7a86-4efd-b564-cd28946c2ac3"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","rul",
    "\"No list of rules found for \\!\\(\\*FormBox[\\\"\\\\\\\"language\\\\\\\
\"\\\", TraditionalForm]\\) \\!\\(\\*FormBox[\\\"\\\\\\\"Swedish\\\\\\\"\\\", \
TraditionalForm]\\)\"",2,134,72,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"98b99994-1746-4fe6-84c0-8d543e46c2c6"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValue","int",
    "\"Initialisation with IntegerName and WordTranslation: please wait\"",2,
    134,73,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValue"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"cbee9abb-ef2f-4462-a8b3-f8bd2a930b5e"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PlaceValueRules","wrn",
    "\"Warning: automated translation of \\!\\(\\*FormBox[\\\"\\\\\\\"Swedish\
\\\\\\\"\\\", TraditionalForm]\\) and not carefully checked on conflicts and \
peculiarities\"",2,134,74,32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PlaceValueRules"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"5ad8f04d-ffe6-4697-8ab0-26e0899bccf7"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"Integer\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Place Value\"\>",
        HoldForm], 
       TagBox["\<\"PV Digits\"\>",
        HoldForm], 
       TagBox["\<\"\"\>",
        HoldForm], 
       TagBox["\<\"Traditional\"\>",
        HoldForm]},
      {"7", "\<\" \"\>", "\<\"sju\[CenterDot]\"\>", "\<\"7\"\>", "\<\" \"\>", \
"\<\"sju\"\>"},
      {"14", "\<\" \"\>", "\<\"\[CenterDot]tio  och  fyra\[CenterDot]\"\>", "\
\<\"10   &   4\"\>", "\<\" \"\>", "\<\"fjorton\"\>"},
      {"21", "\<\" \"\>", "\<\"tv\[ARing]\[CenterDot]tio  och  \
\[CenterDot]ett\"\>", "\<\"2 \[CenterDot] 10   &   1\"\>", "\<\" \"\>", \
"\<\"tjugo\[DiscretionaryHyphen]ett\"\>"},
      {"28", "\<\" \"\>", "\<\"tv\[ARing]\[CenterDot]tio  och  \[ARing]tta\
\[CenterDot]\"\>", "\<\"2 \[CenterDot] 10   &   8\"\>", "\<\" \"\>", \
"\<\"tjugo\[DiscretionaryHyphen]\[ARing]tta\"\>"},
      {"35", "\<\" \"\>", "\<\"tre\[CenterDot]tio  och  fem\[CenterDot]\"\>", \
"\<\"3 \[CenterDot] 10   &   5\"\>", "\<\" \"\>", "\<\"trettio\
\[DiscretionaryHyphen]fem\"\>"},
      {"42", "\<\" \"\>", "\<\"fyra\[CenterDot]tio  och  tv\[ARing]\
\[CenterDot]\"\>", "\<\"4 \[CenterDot] 10   &   2\"\>", "\<\" \"\>", \
"\<\"fyrtio\[DiscretionaryHyphen]tv\[ARing]\"\>"},
      {"49", "\<\" \"\>", "\<\"fyra\[CenterDot]tio  och  \
nio\[CenterDot]\"\>", "\<\"4 \[CenterDot] 10   &   9\"\>", "\<\" \"\>", \
"\<\"fyrtio\[DiscretionaryHyphen]nio\"\>"},
      {"56", "\<\" \"\>", "\<\"fem\[CenterDot]tio  och  sex\[CenterDot]\"\>", \
"\<\"5 \[CenterDot] 10   &   6\"\>", "\<\" \"\>", "\<\"femtio\
\[DiscretionaryHyphen]sex\"\>"},
      {"63", "\<\" \"\>", "\<\"sex\[CenterDot]tio  och  tre\[CenterDot]\"\>", \
"\<\"6 \[CenterDot] 10   &   3\"\>", "\<\" \"\>", "\<\"sextio\
\[DiscretionaryHyphen]tre\"\>"},
      {"70", "\<\" \"\>", "\<\"sju\[CenterDot]tio\"\>", "\<\"7 \[CenterDot] \
10\"\>", "\<\" \"\>", "\<\"sjuttio\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.6]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, Language -> "Swedish", TableSpacing -> {1.5, 3}, 
     TableHeadings -> {
      None, {"Integer", "", "Place Value", "PV Digits", "", 
        "Traditional"}}]]], TraditionalForm]], "Output",ExpressionUUID->\
"262c4324-4edf-4e9a-a494-347106b52018"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". ISO standard"
}], "Section",ExpressionUUID->"233f5033-1372-48f1-a996-f705e8a997a1"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ISO and NEN"
}], "Subsection",ExpressionUUID->"7a4aff8b-d607-4cc5-a944-c7ad338e0de0"],

Cell["\<\
Colignatus (2015b, 2018a) contains the definition for the full use of the \
place value system in a way that fits education. It should become an ISO \
standard, so that educators, researchs and textbook and software publishers \
have a persistent environment. This notebook with package implements this. \
The latter has some limitations on maximum place value million, and has some \
language particulars, but those are not material to the standard.\
\>", "Text",ExpressionUUID->"85abff96-3fda-41cd-99ec-786f5176c40a"],

Cell["\<\
In Holland, NEN is the portal for International ISO: \
https://www.nen.nl/About-NEN.htm. They are no public utility so that the \
development of norms and standards must be paid for by users. They also have \
a crowd-funding option for such initiatives: https://nencrowd.nl. Before they \
allow their crowd-funding support, they want some guarantee that there is a \
community with an interest in the project. For this issue it would be \
researchers, the Ministry of Education and publishers. To my regret, I have \
met no interest yet.\
\>", "Text",ExpressionUUID->"45a5d232-5edd-4566-8013-d22d8bad3ad3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Open source journals"
}], "Subsection",ExpressionUUID->"cbd978bd-d431-4999-bd1c-917d5f202355"],

Cell[TextData[{
 "Publication could be done in an open access journal, and the proper way to \
get open access journals is by the universities, see Gowers (2017) and my \
letter to VSNU, Colignatus (2016). Present (paywall) journals tend to be \
specialised on approaches to education and psychology, and may require field \
testing on actual implementation, and apparently are not open to the \
particular approach of ",
 StyleBox["redesign of mathematics education ",
  FontSlant->"Italic"],
 "that this notebook with package presents. Thus I observed that such \
journals can publish invalid research but will not publish or even report \
about this present proposal for improvement. Quis custodiet ipsos custodes ?"
}], "Text",ExpressionUUID->"1bb95773-d6ac-41cd-8eb1-32ebc060c3e0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". ",
 "Conclusions"
}], "Section",ExpressionUUID->"45f5643b-ec68-4a7f-8787-941ec93d96ba"],

Cell["\<\
We already have the place value system in the numerals but not yet in \
pronunciation and written words. A unity of using the full place value system \
will work wonders in school. This is an issue of mathematics education, with \
the distinction between the language of arithmetic in school and its dialect \
of the common language outside of school. It is only a question whether the \
educational system would be willing to adapt. \
\>", "Text",ExpressionUUID->"64e55278-4438-4e97-bb55-26f6a2bfd1f6"],

Cell[TextData[{
 "Colignatus (2015b, 2018a) gives the definition for a full use of the place \
value system for kindergarten and elementary school. This is simple by the \
nature of the issue. My own change from (2015b) to (2018a) on the \
\[OpenCurlyDoubleQuote]",
 StyleBox["&",
  FontSize->14],
 "\[CloseCurlyDoubleQuote] connective shows that this simplicity still can be \
quite involved, but also that the key design features have been \
well-considered. This notebook with package implements this system. There \
must be some features in the package that are arbitrary. The transliteration \
is only provided for some quick indications and not the key part. The \
notebook with package looks meagre compared to the wealth and subtlety that \
already exist for the pronunciation of the natural languages and current \
conventions on pronouncing the numbers. The awkward ways of the past are \
being hardcoded now. Hopefully some of those resources can be used to support \
the full use of the place value system."
}], "Text",ExpressionUUID->"e9e0e354-1daf-4097-a836-99e14951a183"],

Cell["\<\
I have not seen this implementation of pronunciation elsewhere (except in \
Chinese though without the \
\[OpenCurlyDoubleQuote]and\[CloseCurlyDoubleQuote]), so please refer to these \
locations so that others can find the full documentation.\
\>", "Text",ExpressionUUID->"13cf4498-d369-4a88-82f4-f4e2d8511eec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". Appendix. The package"
}], "Section",ExpressionUUID->"513bc467-be63-4800-a382-09c16b8f466a"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Key properties of PlaceValue"
}], "Subsection",ExpressionUUID->"fd703472-3756-4214-b061-a073caa74ba9"],

Cell["\<\
The PlaceValue routine (PronounceInteger with Level \[Rule] 1) is the main \
routine. Key properties are:\
\>", "Text",ExpressionUUID->"5bab055c-b210-46e1-bd72-f5922c805067"],

Cell[CellGroupData[{

Cell["\<\
The Language \[Rule] \[OpenCurlyDoubleQuote]language\[CloseCurlyDoubleQuote] \
option selects the language, and determines how integers are written and \
spoken.\
\>", "Item",ExpressionUUID->"486c3ddb-96b4-419f-8992-a106d77ceaeb"],

Cell["\<\
Implemented are English, German, French, Dutch and Danish, assuming that \
$Language (the transliterator) is English. Also given are Amplish (writes an \
ampersand in smaller FontSize) and Englishty (writing \
\[OpenCurlyDoubleQuote]ty\[CloseCurlyDoubleQuote] and speaking \
\[OpenCurlyDoubleQuote]tee\[CloseCurlyDoubleQuote] for 10). \
\>", "Item",ExpressionUUID->"98aa3ce9-40ab-4bac-9a10-708afca82dc8"],

Cell[TextData[{
 StyleBox["Written output",
  FontWeight->"Bold"],
 " is in the words of PlaceValueRules[\"language\"], option True \[Rule] \
{settings}."
}], "Item",ExpressionUUID->"a888ca7d-f230-471d-a1c6-87af4fcb0669"],

Cell[TextData[{
 StyleBox["Spoken output",
  FontWeight->"Bold"],
 " is in the words of PlaceValueRules[\[OpenCurlyDoubleQuote]language\
\[CloseCurlyDoubleQuote]], option \[OpenCurlyDoubleQuote]transliterator\
\[CloseCurlyDoubleQuote] \[Rule] {settings}. These words are submitted to \
Speak. The transliterator that speaks this transliteration is $Language \
(often \[OpenCurlyDoubleQuote]English\[CloseCurlyDoubleQuote])."
}], "Item",ExpressionUUID->"48a93b44-5e4a-45c5-a136-2bc1989235fd"],

Cell[TextData[{
 "For each language  the user provides, in PlaceValueRules: (i) option True \
\[Rule] {",
 StyleBox["words ",
  FontWeight->"Bold"],
 "for the minus sign, \[OpenCurlyDoubleQuote]&\[CloseCurlyDoubleQuote], \
digits 0 ... 9 and values ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "1"], TraditionalForm]],ExpressionUUID->
  "6b3dd123-5cb8-4cc5-90df-15d9b2ba80ff"],
 ", ..., ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "6"], TraditionalForm]],ExpressionUUID->
  "fba206c9-3d0e-4e1c-8e9e-a1dfaeaf499e"],
 ", in the relevant language}, and (ii) option \
\[OpenCurlyDoubleQuote]transliterator\[CloseCurlyDoubleQuote] \[Rule] {",
 StyleBox["words",
  FontWeight->"Bold"],
 " for the same input as above but now as a transliteration in terms of that \
transliterator language (commonly $Language)}. See for example \
PlaceValueRules[\[OpenCurlyDoubleQuote]German\[CloseCurlyDoubleQuote]]."
}], "Item",ExpressionUUID->"2546648c-6000-4189-ba54-4f88122def4c"],

Cell[TextData[{
 "If PlaceValue is called for a language ",
 StyleBox["lan",
  FontSlant->"Italic"],
 " that is not in PlaceValueRules[] then it calls PlaceValueRules[Set, ",
 StyleBox["lan",
  FontSlant->"Italic"],
 "]."
}], "Item",ExpressionUUID->"851b5fed-b310-41dc-ad2f-bfc00af76256"],

Cell["\<\
SpeakTransliteration \[Rule] \"language\" currently only works for $Language. \
Perhaps in the future it might be possible to have access to other languages \
without a restart.\
\>", "Item",ExpressionUUID->"3e7ad84c-8180-4099-8a78-92ac3d3d5d9c"],

Cell[TextData[{
 "$Language has been set in the Preferences of ",
 StyleBox["Mathematica. ",
  FontSlant->"Italic"],
 "The user can set to to another language and do a restart. "
}], "Item",ExpressionUUID->"9adf5948-cee4-4bde-b6a5-532a944717d2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Overview"
}], "Subsection",ExpressionUUID->"0c731fb5-ad82-4f1d-8612-ed2c5d3126e5"],

Cell["The package has:", "Text",ExpressionUUID->"6867e9af-71db-4a29-9e21-29f09e250d1e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Cool`MathEd`PronounceInteger`*"}]], "Input",ExpressionUUID->"78e3d9df-7302-4292-927a-fc22e950cc12"],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["Cool`MathEd`PronounceInteger`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["Cool`MathEd`PronounceInteger`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["LatestPronunciation",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "LatestPronunciation", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PlaceValueDigits$Language",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValueDigits$Language", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PronounceInteger",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PronounceInteger", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"]},
        {
         ButtonBox["PartialPlaceValue",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PartialPlaceValue", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PlaceValueH",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValueH", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PronounceIntegerReadMe",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PronounceIntegerReadMe", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"]},
        {
         ButtonBox["PlaceValue",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValue", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PlaceValueIntegerName",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValueIntegerName", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PronounceIntegers",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PronounceIntegers", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"]},
        {
         ButtonBox["PlaceValueBlock",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValueBlock", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PlaceValueRules",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValueRules", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["SpeakTransliteration",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "SpeakTransliteration", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"]},
        {
         ButtonBox["PlaceValueDigits",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValueDigits", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], 
         ButtonBox["PlaceValueTable",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3973735558502-8910602", {
            "PlaceValueTable", "Cool`MathEd`PronounceInteger`"}},
          ButtonNote->"Cool`MathEd`PronounceInteger`"], ""}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.31666666666666665`]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", \
"InfoCell",ExpressionUUID->"9a85fdf0-9c18-471c-9b82-f7de82bee067"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PronounceIntegerReadMe"}]], "Input",ExpressionUUID->"23c7e892-83b9-420c-b2f7-668653f680f0"],

Cell[BoxData["\<\"PronounceIntegerReadMe[] explains the package\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info3983735558502-8910602",ExpressionUUID->"39f94697-1819-460b-afd4-\
acb4bb55cc88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PronounceIntegerReadMe", "[", "]"}]], "Input",ExpressionUUID->"22e11dca-78fa-4814-a44a-7a3f06fc894d"],

Cell[BoxData[
 FormBox["\<\"Mathematica already provides for (i) IntegerName[n, \
\\\"language\\\"], (ii) IntegerName[n, \\\"DigitsWords\\\"] for blocks of \
three digits, and (iii) WordTranslation for \\\"negative\\\", and (iv) a \
wealth of expression in IntegerString. These all encode tradition: with 56 = \
fifty-six instead of ten\[CenterDot]five & six, except in IntegerString[n, \\\
\"TraditionalChineseDecimal\\\"]. Also, these all tend to hide the steps in \
the place value system that we want to show. Our routines are:\\n(1) \
PronounceInteger provides a switch between methods, and helps to focus on \
your preferred method\\n(2) PlaceValue (main routine): word based, so that \
the pronunciation is unambiguous for the particular language. It also allows \
transliteration (speaking foreign words with approximations in English)\\n(3) \
PlaceValueDigits: integer based, for when kids go from sounds to reading and \
writing numerals\\n(4)PlaceValueBlock: show in blocks of three digits (quite \
alike DigitsWords, but notice the differences).\\n(5) PlaceValueIntegerName \
builds around IntegerName DigitsWords for full place value speech\\nLikely, \
teaching is best done likely in order (2)-(5) so that first the individual \
steps are shown and then the block form. PM. A routine f stores what is \
spoken in LatestPronunciation[] and may display differently, see the \
documentation of f\"\>", TraditionalForm]], "Output",ExpressionUUID->\
"9b1132d5-2544-42c1-9b64-61c39a126832"]
}, Open  ]],

Cell["\<\
The discussion in the notebook also uses - but not directly on pronunciation:\
\>", "Text",ExpressionUUID->"4cb29227-721e-4cb0-849a-b0fc2e16d70c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Cool`MathEd`CCSSMath`*"}]], "Input",ExpressionUUID->"75048b2a-6478-4f85-a7ff-1bf12f0c3675"],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["Cool`MathEd`CCSSMath`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["Cool`MathEd`CCSSMath`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["CCSSMathContent",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info4003735558503-8910602", {
            "CCSSMathContent", "Cool`MathEd`CCSSMath`"}},
          ButtonNote->"Cool`MathEd`CCSSMath`"], 
         ButtonBox["CCSSMathExercise",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info4003735558503-8910602", {
            "CCSSMathExercise", "Cool`MathEd`CCSSMath`"}},
          ButtonNote->"Cool`MathEd`CCSSMath`"]}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.475]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", \
"InfoCell",ExpressionUUID->"9b30848a-7ce3-4fe2-8026-3ad7b470aa6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "CCSSMathExercise"}]], "Input",ExpressionUUID->"32a51c67-e334-4617-b15f-f8f2ea033feb"],

Cell[BoxData["\<\"CCSSMathExercise[n, ..., m, opts] passes the numbers on to \
a routine that recognises the CCSSMathContent labels in opts, see \
Options[CCSSMathExercise] and CCSSMathContent. When Show -> True then the \
CCSSMathContent on those labels is shown (default \
False)\\nCCSSMathExercice[n, m:10] for \\\"Grade\\\" -> \\\"Kindergarten\\\" \
or \\\"Grade 1\\\" counts from m to n. Defaults Speak -> False, IntegerDigits \
-> False (if True, the exercise question shows digits, but still speaks full \
place value)\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info4013735558503-8910602",ExpressionUUID->"973b20c2-fc22-4f18-a4d2-\
6d158517b9a6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Switching routine"
}], "Subsection",ExpressionUUID->"2793ed36-aef3-4dc4-87a6-7bffe9bfff86"],

Cell["\<\
The PronounceInteger routine and its options were already shown above. \
\>", "Text",ExpressionUUID->"8b50b5a2-6ab4-4625-93c0-c2a194a09dd0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PronounceInteger", "[", 
  RowBox[{"12", ",", " ", 
   RowBox[{"Level", " ", "\[Rule]", " ", "0"}], ",", " ", 
   RowBox[{"Method", " ", "\[Rule]", " ", "Random"}]}], "]"}]], "Input",Expres\
sionUUID->"81d9c97e-ce55-4fc3-9284-1852ced5729f"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
   "PronounceInteger","unk",
    "\"Unknown Level -> \\!\\(\\*FormBox[\\\"0\\\", TraditionalForm]\\) and \
Method -> \\!\\(\\*FormBox[\\\"Random\\\", TraditionalForm]\\)\"",2,280,42,
    32540151164407676168,"Local",
    "Cool`MathEd`PronounceInteger`PronounceInteger"},
   "MessageTemplate2"], TraditionalForm]], "Message", \
"MSG",ExpressionUUID->"0d93113e-5c9a-4b14-81d2-6471fa176779"],

Cell[BoxData[
 FormBox["$Failed", TraditionalForm]], "Output",ExpressionUUID->"01124f14-5f18-4e3d-b02f-1cea8d159220"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 1"
}], "Subsection",ExpressionUUID->"30e28ea8-cff2-4e17-8e87-a33d76d91655"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlaceValue"}]], "Input",ExpressionUUID->"1de0ab2b-02c3-42ae-ae18-048da21143c2"],

Cell[BoxData["\<\"PlaceValue[n] gives n in the full place value system, as \
text or in Speak, and the latter with pauses for hearing and possible \
transliteration in the system default language (e.g. $Language = English). n \
is in (-10^7, 10^7).\\nThe routine is also called with PronounceInteger[n, \
Level -> 1]\\nOptions with defaults are:\\nLanguage -> \\\"Amplish\\\" uses \
PlaceValueRules[\\\"Amplish\\\"], see there\\nWordTranslation -> Automatic \
calls IntegerName and WordTranslation when the language is not available in \
PlaceValueRules, which takes some time for initialisation and does not \
provide for transliteration\\nSpeakTransliteration :> $Language (often \
\\\"English\\\"), see there\\nSpeak -> True,\\nLength -> 300, an integer for \
the duration of pause between the positions,\\nJoin -> \\\"\[CenterDot]\\\" \
(unpronounced center dot) between the texts of the weight and place \
value\\nSimplify -> True eliminates terms with 0 weights and replaces 1 P by \
P, for P = 1, 10, ..., 10^6\\nShow -> False does not show the input for \
Speak, so that one reads the words in the language itself and hears the \
transliteration (while reading affects hearing)\\nPronounceInteger[Options, \
\\\"Reset\\\"] resets the options to loading time\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info3593735575597-8910602",ExpressionUUID->"594cbbb4-88c5-47ab-b64b-\
34bcb846440d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "PlaceValue", "]"}]], "Input",ExpressionUUID->"eef6353f-fbe3-498e-a0b6-6dd1198dca2f"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Join", "\[Rule]", "\<\"\[CenterDot]\"\>"}], ",", 
    RowBox[{"Language", "\[Rule]", "\<\"Amplish\"\>"}], ",", 
    RowBox[{"Length", "\[Rule]", "300"}], ",", 
    RowBox[{"Show", "\[Rule]", "False"}], ",", 
    RowBox[{"Simplify", "\[Rule]", "True"}], ",", 
    RowBox[{"Speak", "\[Rule]", "True"}], ",", 
    RowBox[{"WordTranslation", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"SpeakTransliteration", "\[RuleDelayed]", "$Language"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"7d93dad7-df68-4ee8-9c8b-\
ef01d7ff2d72"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SpeakTransliteration"}]], "Input",ExpressionUUID->"6e68c5d6-6806-4a17-acc3-8cd8e0e1b743"],

Cell[BoxData["\<\"SpeakTransliteration is an option of PlaceValue with \
default $Language. It selects the relevant setting from the PlaceValueRules. \
If the Language option is equal to the transliterator ($Language) then \
writing and speaking will be done from the True rule. When the option \
Language is set to another value, then the integers are written from True but \
spoken by the transliterator\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info3613735575612-8910602",ExpressionUUID->"5275f1a4-67b4-46e8-acf1-\
054c45384af8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlaceValueRules"}]], "Input",ExpressionUUID->"51d6eac3-3b89-4e91-95c9-06250a50f36d"],

Cell[BoxData["\<\"PlaceValueRules[\\\"Language\\\"] = {True -> t, \
\\\"OtherLanguage\\\" -> f}, with t = {Negative -> string, And -> \\\"&\\\", \
N -> {strings for 0...9}, Power -> {strings for 10, ..., 10^6}}, for the true \
way of writing and pronunciation (when this original language = $Language), \
and f = {... similar ...} for the transliteration into the actual $Language. \
See the examples for \\\"English\\\" (f is not required given $Language = \
\\\"English\\\") and \\\"Dutch\\\" (t <> f).\\nNegative -> how the sign of a \
negative number is written or pronounced\\nAnd-> what string is used to \
separate the product terms of weights and place values\\nN -> {names how the \
digits 0 ... 9 are written or pronounced}\\nPower -> {names how 10 ... 10^6 \
are written or pronounced}.\\nSee SpeakTransliteration for checking on \
$Language.\\nImplemented are English, German, French, Dutch and Danish (with \
some guessing on transliteration). The language Amplish has True -> with an \
ampersand in a smaller font, and otherwise English. Englishty has ty for 10 \
pronounced as tee. The languages have (Greek) myriad for 10^4 and (Indian) \
lakh for 10^5\\nPlaceValueRules[] contains the list of languages for which \
there is transliteration\\nPlaceValueRules[Select, item, lan, \
translit:\\\"English\\\"] selects for lan the item (e.g. Power) from both \
True and translit, and gives a rule or list of rules (true -> \
transliteration) for replacement\\nPlaceValueRules[Set, \\\"ToLanguage\\\", \
FromLanguage:\\\"English\\\"] uses IntegerName for the digits and \
WordTranslation for \\\"negative\\\", \\\"and\\\" and \\\"million\\\" and \
imposes myriad and lakh. These routines may take time, and thus one is \
advised to save the result. There is no automation for the \
transliteration\\nPlaceValueRules[Check, \\\"Language\\\"] for another \
language than in PlaceValueRules[\\\"Checked\\\"] will issue a warning that \
the place value pronunciation is generated by automation and hasn't been \
checked on conflicts. When you have done the checking then this list can be \
adapted manually or by AppendTo\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info4553735576149-8910602",ExpressionUUID->"4c9fd4df-4526-4928-be27-\
92caa80a8f2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "]"}]], "Input",ExpressionUUID->"dea49837-b28f-4a5e-b693-29ca34d2c569"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"Amplish\"\>", ",", "\<\"Danish\"\>", ",", "\<\"Dutch\"\>", 
    ",", "\<\"Englishty\"\>", ",", "\<\"French\"\>", ",", "\<\"German\"\>", 
    ",", "\<\"Finnish\"\>", ",", "\<\"Italian\"\>", ",", "\<\"Spanish\"\>", 
    ",", "\<\"Swedish\"\>"}], "}"}], TraditionalForm]], "Output",ExpressionUUI\
D->"ace90ee4-dbb3-45a2-b8a4-ff97350951bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", "\"\<Checked\>\"", "]"}]], "Input",Expression\
UUID->"f1474c28-396c-4b0d-ac3c-0bcba4dfce79"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"English\"\>", ",", "\<\"Amplish\"\>", ",", "\<\"Danish\"\>", 
    ",", "\<\"Dutch\"\>", ",", "\<\"Englishty\"\>", ",", "\<\"French\"\>", 
    ",", "\<\"German\"\>"}], "}"}], TraditionalForm]], "Output",ExpressionUUID\
->"b5785eb0-6546-4768-a4e3-bb6f451fbcac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueRules", "[", 
  RowBox[{"Select", ",", " ", "Power", ",", " ", "\"\<French\>\""}], 
  "]"}]], "Input",ExpressionUUID->"0d6e6ec1-bfc0-4286-968c-c78bc2ed25cc"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"dix\"\>", "\[Rule]", "\<\"dees\"\>"}], ",", 
    RowBox[{"\<\"cent\"\>", "\[Rule]", "\<\"sun\"\>"}], ",", 
    RowBox[{"\<\"mille\"\>", "\[Rule]", "\<\"meel\"\>"}], ",", 
    RowBox[{"\<\"myriade\"\>", "\[Rule]", "\<\"meeri udd\"\>"}], ",", 
    RowBox[{"\<\"lakh\"\>", "\[Rule]", "\<\"lakh\"\>"}], ",", 
    RowBox[{"\<\"million\"\>", "\[Rule]", "\<\"meelyon\"\>"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"b9a3807c-1fcb-4b3a-adb4-\
22eb91acc368"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 2"
}], "Subsection",ExpressionUUID->"361d8f36-9bfc-46e5-b7e3-85d65492a76a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlaceValueDigits"}]], "Input",ExpressionUUID->"5e7d1044-6dcf-4c80-918e-0f040a274cbb"],

Cell[BoxData["\<\"PlaceValueDigits[n] pronounces n by PlaceValue[n] and \
displays by PlaceValueDigits$Language[n]\\nOptions are passed on to said \
routines, and see their own options, like Simplify and Show\\nOwn options are \
Speak -> True (default), Print -> True (default) prints the outcome of \
PlaceValue[n]. LatestPronunciation[Print] stores what is printed\\nThe \
routine is also called with PronounceInteger[n, Level -> 2]\"\>"], "Print", \
"PrintUsage",
 CellTags->
  "Info4083735558503-8910602",ExpressionUUID->"61bcc6b2-0f8e-48f7-bd20-\
bbb52d7f7cdd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "PlaceValueDigits", "]"}]], "Input",ExpressionUUID->"54e471cd-46b5-44cb-bcc1-acb4a6064447"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Speak", "\[Rule]", "True"}], ",", 
    RowBox[{"Print", "\[Rule]", "True"}]}], "}"}], TraditionalForm]], "Output",\
ExpressionUUID->"be10d0d4-625a-497d-82be-0e22ff48b31f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlaceValueDigits$Language"}]], "Input",ExpressionUUID->"8d71b0c5-31e0-49b0-be99-b852332fe878"],

Cell[BoxData["\<\"PlaceValueDigits$Language[n] pronounces n by using digits \
for the place values rather than words (PlaceValue): n can be as large as \
Mathematica allows, but also relies on how $Language pronounces those \
integers. In English 2 100 is pronounced as \\\"two one-hundred\\\". Option \
Simplify -> True (default) for handling of 0 and 1 weights, StepMonitor -> \
False (default) whether to show an intermediate step, Length -> 300 (default) \
for the pause, Join -> \\\"\[CenterDot]\\\" (default) for connection of terms \
in display (not spoken), Speak -> True (default).\\nThe routine is also \
called as a subroutine by PlaceValueDigits[n], which is also called by \
PronounceInteger[n, Level -> 2]\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info4103735558503-8910602",ExpressionUUID->"12138ea5-a6df-496a-90bb-\
7d1d45b17c78"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "PlaceValueDigits$Language", "]"}]], "Input",Expressi\
onUUID->"2b7fe640-fd81-4d1b-b0ad-4bd351f3ec5c"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"And", "\[Rule]", "\<\"&\"\>"}], ",", 
    RowBox[{"Join", "\[Rule]", "\<\"\[CenterDot]\"\>"}], ",", 
    RowBox[{"Length", "\[Rule]", "300"}], ",", 
    RowBox[{"Simplify", "\[Rule]", "True"}], ",", 
    RowBox[{"Speak", "\[Rule]", "True"}], ",", 
    RowBox[{"StepMonitor", "\[Rule]", "False"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"a8ec6e65-c9f9-4792-bdd4-\
d2f77438c470"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueDigits$Language", "[", 
  RowBox[{"22324443224", ",", " ", 
   RowBox[{"And", " ", "\[Rule]", " ", "\"\<,\>\""}], ",", " ", 
   RowBox[{"Speak", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",Expressi\
onUUID->"a0c41304-f17b-438c-89f1-8748ec326306"],

Cell[BoxData[
 FormBox["\<\"2 \[CenterDot] 10000000000    \[CenterDot]   2 \[CenterDot] \
1000000000    \[CenterDot]   3 \[CenterDot] 100000000    \[CenterDot]   2 \
\[CenterDot] 10000000    \[CenterDot]   4 \[CenterDot] 1000000    \
\[CenterDot]   4 \[CenterDot] 100000    \[CenterDot]   4 \[CenterDot] 10000   \
 \[CenterDot]   3 \[CenterDot] 1000    \[CenterDot]   2 \[CenterDot] 100    \
\[CenterDot]   2 \[CenterDot] 10    \[CenterDot]   4\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"4a84be75-616c-44ca-9b63-\
22cbf261c528"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 3"
}], "Subsection",ExpressionUUID->"5479370b-4178-4a52-9124-2c5d71d17a78"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlaceValueBlock"}]], "Input",ExpressionUUID->"91717edc-0394-4d26-9d85-2219e010d529"],

Cell[BoxData["\<\"PlaceValueBlock[n] pronounces n in digit blocks of 3, and \
within those blocks in place value manner.\\nThe routine is also called with \
PronounceInteger[n, Level -> 3]\\nFor example 123456 = {{1 hundred & 2 ten & \
3}, thousand} & {4 hundred & 5 ten & 6}. This is like common usage except for \
the integers in 11-99. Option Length -> 300 (default) puts \\\"&\\\" in the \
middle of that pause. Option Power -> {...} by default replaces 100 by \
hundred, 1000 by thousand and 10^6 by million. (This is not done in \
PlaceValueDigits$Language, because there are more words, like for the digits, \
and including the awkward 10^4 and 10^5). The numbers 11-99 use the options \
of PlaceValueDigits$Language, namely to display in numbers and not words. If \
your $Language is not \\\"English\\\", then you might consider to adapt the \
settings manually. The following is an automation \
though:\\nPlaceValueBlock[SetOptions, \\\"language\\\"] sets the options to \
stated \\\"language\\\", using WordTranslation from the current language in \
the Options (default \\\"English\\\")\\nPlaceValueBlock[Options, \
\\\"Reset\\\"] resets to the Options at loading\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info4133735558504-8910602",ExpressionUUID->"1287910b-3c84-4cda-bc96-\
e4adf76cac4d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "PlaceValueBlock", "]"}]], "Input",ExpressionUUID->"cecdfa2a-60a8-434e-af9e-6d0802b39f34"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"And", "\[Rule]", "\<\"&\"\>"}], ",", 
    RowBox[{"Join", "\[Rule]", "\<\"\[CenterDot]\"\>"}], ",", 
    RowBox[{"Language", "\[Rule]", "\<\"Amplish\"\>"}], ",", 
    RowBox[{"Length", "\[Rule]", "300"}], ",", 
    RowBox[{"Power", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1000000", "\[Rule]", "\<\"million\"\>"}], ",", 
       RowBox[{"1000", "\[Rule]", "\<\"thousand\"\>"}], ",", 
       RowBox[{"100", "\[Rule]", "\<\"hundred\"\>"}]}], "}"}]}], ",", 
    RowBox[{"Simplify", "\[Rule]", "True"}], ",", 
    RowBox[{"Speak", "\[Rule]", "True"}]}], "}"}], TraditionalForm]], "Output",\
ExpressionUUID->"f318c08b-d989-4d93-8cf0-cb6ea7163791"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueBlock", "[", "123456", "]"}]], "Input",ExpressionUUID->"148b17b3-84ec-4268-aae9-77353f184131"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"1 \[CenterDot] 100\"\>", ",", "\<\" & \"\>", 
        ",", "\<\"2 \[CenterDot] 10    &    3\"\>"}], "}"}], ",", "1000"}], 
     "}"}], ",", "\<\" & \"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"4 \[CenterDot] 100\"\>", ",", "\<\" & \"\>", 
      ",", "\<\"5 \[CenterDot] 10    &    6\"\>"}], "}"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"986643ba-6abd-4929-86b1-\
a6c5b1b47eb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"78dbc5a0-685f-4d32-9999-f4a220546564"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"1 \[CenterDot] hundred\"\>", ",", "\<\" & \"\>", 
        ",", "\<\"2 \[CenterDot] 10    &    3\"\>"}], "}"}], 
      ",", "\<\"thousand\"\>"}], "}"}], ",", "\<\" & \"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"4 \[CenterDot] hundred\"\>", ",", "\<\" & \"\>", 
      ",", "\<\"5 \[CenterDot] 10    &    6\"\>"}], "}"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"a7acc9d6-0ac3-48a0-b525-\
950a599bbf9a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level 4"
}], "Subsection",ExpressionUUID->"209e94bd-d43c-4a35-90a3-a71d73aa898c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlaceValueIntegerName"}]], "Input",ExpressionUUID->"1ce7af14-db70-412e-b2c8-4737ec9e98fc"],

Cell[BoxData["\<\"PlaceValueIntegerName[n] lets IntegerName[n, \
\\\"DigitsWords\\\"] make the blocks of 3 digits, and then calls PlaceValue \
on these digits. IntegerName DigitsWords uses text for Abs[n] < 1000, and we \
follow this. The block bases of thousand, million etcetera are translated by \
WordTranslation. The text displayed has blocks of digits, with block bases \
separated by option And -> \\\", \\\" (default). This option is not passed on \
to PlaceValue for speech of the blocks. The spoken text can be recovered from \
LatestPronunciation[]. Transliteration is called but will slow the \
execution\\nThe routine is also called with PronounceInteger[n, Level -> 4]\"\
\>"], "Print", "PrintUsage",
 CellTags->
  "Info4173735558504-8910602",ExpressionUUID->"ca526546-d793-4fe5-b58f-\
481986d3b460"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "PlaceValueIntegerName", "]"}]], "Input",ExpressionUU\
ID->"74bf70f3-a3e3-4156-b21f-f07a493589d3"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Language", "\[Rule]", "\<\"English\"\>"}], ",", 
    RowBox[{"Speak", "\[Rule]", "True"}], ",", 
    RowBox[{"And", "\[Rule]", "\<\", \"\>"}]}], "}"}], 
  TraditionalForm]], "Output",ExpressionUUID->"5fad5cbd-8737-4e11-91eb-\
369ccc2fdad1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlaceValueIntegerName", "[", "1234451011", "]"}]], "Input",Expressio\
nUUID->"5915df87-0d00-479c-8cc1-45b935b030d9"],

Cell[BoxData[
 FormBox["\<\"1  billion,   234  million,   451  thousand,   11\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"ed7a0b08-0672-4490-b161-\
fe0be52684c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatestPronunciation", "[", "]"}]], "Input",ExpressionUUID->"e926d07f-3eff-45e4-8de2-3961c8336226"],

Cell[BoxData[
 FormBox["\<\"\[CenterDot]one  billion,   two\[CenterDot]hundred  &  three\
\[CenterDot]ten  &  four\[CenterDot]  million,   four\[CenterDot]hundred  &  \
five\[CenterDot]ten  &  \[CenterDot]one  thousand,   \[CenterDot]ten  &  \
\[CenterDot]one\"\>", TraditionalForm]], "Output",ExpressionUUID->"b60ff96f-\
dd9d-4310-851c-accde517dbdf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Level -4"
}], "Subsection",ExpressionUUID->"5e9706be-eff7-4816-b914-87f4ded1c184"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PartialPlaceValue"}]], "Input",ExpressionUUID->"961c3b41-b1c4-4653-8770-0661217601fb"],

Cell[BoxData["\<\"PartialPlaceValue[n] has the traditional pronunciation and \
words of the numbers 11-99, thus in opposite order of the place value system, \
when speaking the number from Left To Right, and morphing of words. It calls \
IntegerName with DigitsWords. If Abs[n] < 1000 then there are words only, and \
higher n get combinations of both digit blocks and words for digit block \
values (thousand, million). Option defaults are Language -> \\\"English\\\" \
and Speak -> True. Speak apparently fails on the hyphen and thus this \
replaced by a space. Speak[-10] says Minus 10 but IntegerName uses Negative \
10. There is no transliteration.\\nThe routine is also called with \
PronounceInteger[n, Level -> -4]\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info4213735558504-8910602",ExpressionUUID->"ca33baba-b8ec-40cf-b0cb-\
3ca17171766d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "PartialPlaceValue", "]"}]], "Input",ExpressionUUID->"e27788f2-7d8d-4aab-9562-3c18a74f361a"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Language", "\[Rule]", "\<\"English\"\>"}], ",", 
    RowBox[{"Speak", "\[Rule]", "True"}]}], "}"}], TraditionalForm]], "Output",\
ExpressionUUID->"31a6cf94-006d-4820-a47f-d041e4a9774d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartialPlaceValue", "[", "1234451011", "]"}]], "Input",ExpressionUUI\
D->"2d13bd00-6203-413f-b629-8338610ed262"],

Cell[BoxData[
 FormBox["\<\"1 billion 234 million 451 thousand 11\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"19ff9758-27ff-4c9e-933b-\
42577bd4efdc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LatestPronunciation", "[", "]"}], "  ", 
  RowBox[{"(*", 
   RowBox[{"in", " ", "traditional", " ", "manner"}], "*)"}]}]], "Input",Expre\
ssionUUID->"dd41e06a-c91a-413c-9b19-ffdf90572893"],

Cell[BoxData[
 FormBox["\<\"1 billion 234 million 451 thousand 11\"\>", 
  TraditionalForm]], "Output",ExpressionUUID->"7f4a9d3d-a570-4c6a-8c35-\
d16b2111249f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Section"],
 ". ",
 "Literature"
}], "Section",ExpressionUUID->"8be4aff8-8a43-47f2-9330-3db5f8b311d7"],

Cell["\<\
Thomas Colignatus is the scientific name of Thomas Cool, econometrician and \
teacher of mathematics, Scheveningen, Holland.\
\>", "Text",ExpressionUUID->"d1ae5cc0-6544-4b7e-92d5-c8ae45c9331e"],

Cell[TextData[{
 "Bussi, M. G. B. & Sun X. H. (ed.)(2018), ",
 StyleBox["Building the Foundation: Whole Numbers in the Primary Grades,",
  FontSlant->"Italic"],
 "The 23rd ICMI Study, Springer International publishing AG"
}], "Text",ExpressionUUID->"030c240e-1543-46c6-8277-a4596b3ca6f4"],

Cell[TextData[{
 "Colignatus, Th. (2015a),",
 StyleBox[" A child wants nice and no mean numbers",
  FontSlant->"Italic"],
 ", \[LineSeparator](1) website: \
http://thomascool.eu/Papers/NiceNumbers/Index.html\n(2) PDF on Zenodo: \
https://zenodo.org/record/291979\n(3) Publisher for a print: \
https://www.mijnbestseller.nl/shop/index.php/catalog/product/view/id/118082/s/\
a-child-wants-nice-and-no-mean-numbers-79074-www-mijnbestseller-nl/"
}], "Text",ExpressionUUID->"9f23fa8c-1882-446f-8d36-2d4c9b11f022"],

Cell[TextData[{
 "Colignatus, Th. (2015b, 2018a), ",
 StyleBox["The need for a standard for the mathematical pronunciation of the \
natural numbers. Suggested principles of design. Implementation for English, \
German, French, Dutch and Danish",
  FontSlant->"Italic"],
 ", https://doi.org/10.5281/zenodo.774866"
}], "Text",ExpressionUUID->"275399fd-e095-4b92-8a9e-02e0c01a0fed"],

Cell[TextData[{
 "Colignatus, Th. (2016), ",
 StyleBox["Letter to VSNU and others on membership dues and open access \
publishing, ",
  FontSlant->"Italic"],
 "https://boycottholland.wordpress.com/2016/10/12/letter-to-vsnu-and-others-\
on-membership-dues-and-open-access-publishing/"
}], "Text",ExpressionUUID->"6cf08fe3-c569-4044-bb08-67fda4de7e94"],

Cell[TextData[{
 "Colignatus, Th. (2018b),",
 StyleBox[" Tables for addition and subtraction with better use of the place \
value system,",
  FontSlant->"Italic"],
 " PDF  https://doi.org/10.5281/zenodo.1241349 and notebook with package \
https://doi.org/10.5281/zenodo.1241404 and \
http://community.wolfram.com/groups/-/m/t/1313408 (update May 5)"
}], "Text",ExpressionUUID->"88d59312-b266-45e2-b46f-18f55a0512eb"],

Cell[TextData[{
 "Common Core Standards (2018), ",
 StyleBox["Number & Operations in Base Ten, ",
  FontSlant->"Italic"],
 "http://www.corestandards.org/Math/Content/NBT/ with also ",
 StyleBox["Understand place value",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"26121b96-ba61-4dec-b6ba-d1793ceae7c2"],

Cell[TextData[{
 "Fateman, R. (2013), ",
 StyleBox["How can we speak math?, ",
  FontSlant->"Italic"],
 "https://people.eecs.berkeley.edu/~fateman/papers/speakmath.pdf"
}], "Text",ExpressionUUID->"c9c9c4be-0db0-4dfa-b8ef-88049f39f183"],

Cell[TextData[{
 "Gowers, T. (2017), ",
 StyleBox["The end of an error?",
  FontSlant->"Italic"],
 ", https://www.the-tls.co.uk/articles/public/the-end-of-an-error-peer-review/"
}], "Text",ExpressionUUID->"3e8a9089-db91-4def-b5aa-6ca846cf7a9f"],

Cell[TextData[{
 "Uy, F.L. (2003), ",
 StyleBox["The Chinese Numeration System and Place Value",
  FontSlant->"Italic"],
 ", Teachting Children Mathematics, NCTM, p244-247 "
}], "Text",ExpressionUUID->"90264af9-6a06-4bc9-862d-57b8909fbc08"],

Cell[TextData[{
 "Wolfram Research, Inc. (2017), ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", Version 11.2, http://www.wolfram.com"
}], "Text",ExpressionUUID->"4ce44d16-4ff7-4cd4-ad46-29dd1d70a4a4"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{903, 880},
WindowMargins->{{Automatic, 295}, {Automatic, 31}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.3199999999999, 841.92}},
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 11, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info2763735558483-8910602"->{
  Cell[201429, 4773, 455, 11, 45, "Print",ExpressionUUID->"5cd5b3eb-85eb-481c-a10d-be0b3eb04703",
   CellTags->"Info2763735558483-8910602"]},
 "Info3203735558484-8910602"->{
  Cell[260363, 6424, 553, 9, 138, "Print",ExpressionUUID->"8858f879-1d7a-45d7-8439-565566841b9d",
   CellTags->"Info3203735558484-8910602"]},
 "Info3563735558490-8910602"->{
  Cell[308007, 7735, 1090, 16, 368, "Print",ExpressionUUID->"8de12c97-deb1-4417-8d0d-39e7cdf00e10",
   CellTags->"Info3563735558490-8910602"]},
 "Info3593735575597-8910602"->{
  Cell[397807, 10140, 1395, 19, 368, "Print",ExpressionUUID->"594cbbb4-88c5-47ab-b64b-34bcb846440d",
   CellTags->"Info3593735575597-8910602"]},
 "Info3613735575612-8910602"->{
  Cell[400125, 10188, 535, 8, 115, "Print",ExpressionUUID->"5275f1a4-67b4-46e8-acf1-054c45384af8",
   CellTags->"Info3613735575612-8910602"]},
 "Info3983735558502-8910602"->{
  Cell[391993, 9983, 193, 3, 45, "Print",ExpressionUUID->"39f94697-1819-460b-afd4-acb4bb55cc88",
   CellTags->"Info3983735558502-8910602"]},
 "Info4013735558503-8910602"->{
  Cell[395591, 10070, 655, 10, 138, "Print",ExpressionUUID->"973b20c2-fc22-4f18-a4d2-6d158517b9a6",
   CellTags->"Info4013735558503-8910602"]},
 "Info4083735558503-8910602"->{
  Cell[405232, 10306, 566, 9, 138, "Print",ExpressionUUID->"61bcc6b2-0f8e-48f7-bd20-bbb52d7f7cdd",
   CellTags->"Info4083735558503-8910602"]},
 "Info4103735558503-8910602"->{
  Cell[406367, 10337, 849, 12, 161, "Print",ExpressionUUID->"12138ea5-a6df-496a-90bb-7d1d45b17c78",
   CellTags->"Info4103735558503-8910602"]},
 "Info4133735558504-8910602"->{
  Cell[409073, 10409, 1304, 18, 276, "Print",ExpressionUUID->"1287910b-3c84-4cda-bc96-e4adf76cac4d",
   CellTags->"Info4133735558504-8910602"]},
 "Info4173735558504-8910602"->{
  Cell[413028, 10515, 814, 12, 161, "Print",ExpressionUUID->"ca526546-d793-4fe5-b58f-481986d3b460",
   CellTags->"Info4173735558504-8910602"]},
 "Info4213735558504-8910602"->{
  Cell[415544, 10589, 852, 12, 184, "Print",ExpressionUUID->"ca33baba-b8ec-40cf-b0cb-3ca17171766d",
   CellTags->"Info4213735558504-8910602"]},
 "Info4553735576149-8910602"->{
  Cell[400813, 10204, 2257, 31, 506, "Print",ExpressionUUID->"4c9fd4df-4526-4928-be27-92caa80a8f2c",
   CellTags->"Info4553735576149-8910602"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info2763735558483-8910602", 421694, 10761},
 {"Info3203735558484-8910602", 421868, 10764},
 {"Info3563735558490-8910602", 422042, 10767},
 {"Info3593735575597-8910602", 422218, 10770},
 {"Info3613735575612-8910602", 422395, 10773},
 {"Info3983735558502-8910602", 422570, 10776},
 {"Info4013735558503-8910602", 422743, 10779},
 {"Info4083735558503-8910602", 422919, 10782},
 {"Info4103735558503-8910602", 423094, 10785},
 {"Info4133735558504-8910602", 423270, 10788},
 {"Info4173735558504-8910602", 423447, 10791},
 {"Info4213735558504-8910602", 423623, 10794},
 {"Info4553735576149-8910602", 423799, 10797}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[583, 22, 149, 2, 156, "Title",ExpressionUUID->"d47f7fa6-b14e-4e6a-898d-16012f911dc9"],
Cell[735, 26, 133, 4, 78, "Text",ExpressionUUID->"acdf4973-e4b8-4f53-b4b4-1258c5167d75"],
Cell[871, 32, 107, 0, 34, "Text",ExpressionUUID->"5e558f0a-9fb9-468e-94c9-bf8fda10ce08"],
Cell[981, 34, 120, 1, 34, "Text",ExpressionUUID->"43d4427c-2256-44cf-ac7e-5e12135ae034"],
Cell[1104, 37, 1378, 20, 232, "Text",ExpressionUUID->"71bab785-308f-45ba-8e55-9810e64df125"],
Cell[2485, 59, 120, 1, 34, "Text",ExpressionUUID->"53b58d00-2f14-499d-9470-8e2ca9e5df17"],
Cell[2608, 62, 203, 3, 56, "Text",ExpressionUUID->"16390071-79db-466e-8f55-9b97e9f1d1e4"],
Cell[2814, 67, 119, 1, 34, "Text",ExpressionUUID->"cd13beeb-5887-4293-a0a7-c9542c2841c3"],
Cell[2936, 70, 130, 0, 34, "Text",ExpressionUUID->"517e5435-84df-40ee-b2a7-90a8d5a0965b"],
Cell[3069, 72, 117, 1, 34, "Text",ExpressionUUID->"e6c7d40a-daf6-443a-bd9a-e9d3259728bf"],
Cell[3189, 75, 146, 2, 34, "Text",ExpressionUUID->"808df93e-ecae-4e18-9c1f-27ff00325148"],
Cell[3338, 79, 125, 0, 34, "Text",ExpressionUUID->"f22e4a79-f9bf-428e-bf3a-753f942ba7c0"],
Cell[3466, 81, 180, 3, 34, "Text",ExpressionUUID->"f320de8e-4993-4d1e-9011-a8e9d07f413b"],
Cell[3649, 86, 181, 3, 34, "Text",ExpressionUUID->"d17a7ae1-3cae-4818-ae8e-f231d14085c3"],
Cell[3833, 91, 163, 3, 34, "Text",ExpressionUUID->"f075d037-4fcc-4eba-bb05-d82bac80f917"],
Cell[3999, 96, 266, 4, 56, "Text",ExpressionUUID->"d4254562-e5a7-4091-8e5f-b99b3a022705"],
Cell[CellGroupData[{
Cell[4290, 104, 85, 0, 53, "Subsection",ExpressionUUID->"6fb3b910-20f6-4a1b-957e-96a3c5152df1"],
Cell[4378, 106, 141, 4, 44, "Subsubsection",ExpressionUUID->"09ee1f70-35a4-4392-9863-e8a8919df0fb"],
Cell[4522, 112, 147, 4, 36, "Subsubsection",ExpressionUUID->"8cf14bf4-45ab-45d6-8665-13d14783a751"],
Cell[4672, 118, 172, 4, 36, "Subsubsection",ExpressionUUID->"d9acdca8-7519-416d-8030-f6eb19e6d4a2"],
Cell[4847, 124, 159, 4, 36, "Subsubsection",ExpressionUUID->"a9642880-d5bb-4147-8701-6210085b933c"],
Cell[5009, 130, 159, 4, 36, "Subsubsection",ExpressionUUID->"80ec5aff-f149-4ecf-8506-20d96ee7d409"],
Cell[5171, 136, 173, 4, 36, "Subsubsection",ExpressionUUID->"e94869d4-775d-4338-92a6-1d8ebaa42cd9"],
Cell[5347, 142, 146, 4, 36, "Subsubsection",ExpressionUUID->"8fd0f127-5d5b-456d-a1e0-e7d96816d70e"],
Cell[5496, 148, 141, 4, 36, "Subsubsection",ExpressionUUID->"819b7a0d-f4a7-471d-9fd3-7fc95ef60607"],
Cell[5640, 154, 140, 4, 36, "Subsubsection",ExpressionUUID->"39601f33-f632-40a1-a525-3d788d3ea5ff"],
Cell[5783, 160, 150, 4, 36, "Subsubsection",ExpressionUUID->"cd5a58e9-a605-4b2c-90da-3f5a524d076e"],
Cell[5936, 166, 139, 4, 36, "Subsubsection",ExpressionUUID->"a4b77063-c21e-45d0-b97c-a323bbb14b4f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6112, 175, 148, 2, 53, "Subsection",ExpressionUUID->"a10e6b9e-08b8-4d85-8634-ce9e607827f6"],
Cell[CellGroupData[{
Cell[6285, 181, 104, 0, 44, "Subsubsection",ExpressionUUID->"0ea01a1e-814a-4d63-aa74-031e586becdc"],
Cell[CellGroupData[{
Cell[6414, 185, 123416, 2777, 12908, "Input",ExpressionUUID->"857aa95a-df77-4958-8d1e-e7af0224747a",
 InitializationCell->True],
Cell[129833, 2964, 317, 7, 21, "Message",ExpressionUUID->"b5b027a4-1624-4789-90e6-a9916cc6736a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[130199, 2977, 96, 0, 36, "Subsubsection",ExpressionUUID->"5a8dd12a-3de4-44d6-9ecb-831c36ab298e"],
Cell[130298, 2979, 29442, 670, 4871, "Input",ExpressionUUID->"2b3586a5-a63a-4420-85b0-de1c5c3236e7",
 InitializationCell->True]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[159789, 3655, 157, 6, 53, "Section",ExpressionUUID->"dd253a8a-4545-4d7c-9848-b28ec9cc8037",
 PageBreakAbove->True],
Cell[CellGroupData[{
Cell[159971, 3665, 166, 7, 53, "Subsection",ExpressionUUID->"c56043f7-3d05-4ae6-9e74-37a782e1dea9"],
Cell[160140, 3674, 113, 0, 34, "Text",ExpressionUUID->"03b8e842-313d-46d9-aee6-734a5821c435"],
Cell[160256, 3676, 186, 5, 34, "Text",ExpressionUUID->"56bea39a-562a-4a49-a3d5-c871af2d9eaa"],
Cell[160445, 3683, 105, 0, 34, "Text",ExpressionUUID->"a9186ceb-30d8-45a9-851a-4ceff5c3e3e4"],
Cell[CellGroupData[{
Cell[160575, 3687, 139, 3, 28, "Input",ExpressionUUID->"ed0f07cf-9d78-41b6-b123-f2c9710323b0"],
Cell[160717, 3692, 207, 4, 32, "Output",ExpressionUUID->"90a187dc-cb02-436e-98c9-0979700c37b4"]
}, Open  ]],
Cell[160939, 3699, 526, 9, 56, "Text",ExpressionUUID->"55cc0400-0cf8-4dcc-9d9d-824d473c525d"],
Cell[161468, 3710, 411, 6, 78, "Text",ExpressionUUID->"8585725a-4e1a-45f5-bcab-25fb51485114"],
Cell[CellGroupData[{
Cell[161904, 3720, 285, 6, 28, "Input",ExpressionUUID->"93793cb5-ad94-45ea-94c5-5e571ff279ea"],
Cell[162192, 3728, 210, 4, 32, "Output",ExpressionUUID->"34d857f4-f3da-473e-9d5a-423d05a9e8bc"]
}, Open  ]],
Cell[162417, 3735, 587, 13, 56, "Text",ExpressionUUID->"452f1a68-e23b-4dd0-aa77-31c447ffd7b5"],
Cell[CellGroupData[{
Cell[163029, 3752, 222, 5, 28, "Input",ExpressionUUID->"bb5d849a-e405-40f7-a6e1-16ce0e1c7b83"],
Cell[163254, 3759, 1494, 41, 52, "Output",ExpressionUUID->"7b78bbce-ba1e-44c5-827c-f8710204409e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164785, 3805, 297, 6, 28, "Input",ExpressionUUID->"f35a09dc-03b1-46b6-a28a-c2d4694bda18"],
Cell[165085, 3813, 1556, 42, 52, "Output",ExpressionUUID->"d75ed71c-e4f3-43a7-8ea4-f063cf661e0f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[166690, 3861, 185, 7, 53, "Subsection",ExpressionUUID->"4ea18dd3-0eaa-4b30-bdd8-bc38088a0a64"],
Cell[166878, 3870, 530, 7, 100, "Text",ExpressionUUID->"d017fd01-b0dc-45b9-8226-2bad506985b6"],
Cell[167411, 3879, 411, 9, 56, "Text",ExpressionUUID->"ee1eefa4-e827-4443-9da0-0c98a850e9d0"],
Cell[CellGroupData[{
Cell[167847, 3892, 168, 3, 31, "Item",ExpressionUUID->"a8be31c5-1d09-4ea9-872c-2c0da65cdb2a"],
Cell[168018, 3897, 175, 3, 31, "Item",ExpressionUUID->"5872fd41-a378-4621-a8b3-162cc0caa79c"]
}, Open  ]],
Cell[168208, 3903, 504, 9, 78, "Text",ExpressionUUID->"f7fc37ef-6116-4bde-8346-0bd1d24f9ada"],
Cell[168715, 3914, 477, 11, 78, "Text",ExpressionUUID->"5405f25b-fb0e-438b-9b34-b280865ea569"],
Cell[169195, 3927, 366, 5, 78, "Text",ExpressionUUID->"f90e2d3c-ee56-473f-a13d-1246511908b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169598, 3937, 195, 7, 53, "Subsection",ExpressionUUID->"cb4e819a-049d-445a-8cb9-4a54ceeb8f77"],
Cell[169796, 3946, 858, 18, 122, "Text",ExpressionUUID->"dbffefa3-cb25-4636-8352-5adb65ba6370"],
Cell[170657, 3966, 363, 5, 78, "Text",ExpressionUUID->"57ae8348-47ed-4856-bd7f-9dd33092c972"],
Cell[171023, 3973, 786, 11, 144, "Text",ExpressionUUID->"74d69a68-3275-46af-8e91-ee4e4aff5e16"],
Cell[171812, 3986, 265, 4, 56, "Text",ExpressionUUID->"f15b328c-50b6-4175-89bb-4f9163f09f24"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172114, 3995, 201, 7, 53, "Subsection",ExpressionUUID->"68c76caa-659b-4d0d-9f0b-0e69090ff6d0"],
Cell[172318, 4004, 773, 11, 122, "Text",ExpressionUUID->"d4abd553-cd2b-44a1-8350-e64431579b6e"],
Cell[173094, 4017, 756, 16, 122, "Text",ExpressionUUID->"254c9614-03d9-4ee2-aa07-e666731118c0"],
Cell[173853, 4035, 188, 5, 31, "Item",ExpressionUUID->"622c1098-f1ed-4309-8374-db69eae42246"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174078, 4045, 183, 7, 53, "Subsection",ExpressionUUID->"55e2c961-2553-405c-84f1-c6c73952e0dc"],
Cell[174264, 4054, 726, 11, 122, "Text",ExpressionUUID->"ffc739bc-d4cc-4273-b69b-982ef919ded0"],
Cell[CellGroupData[{
Cell[175015, 4069, 331, 6, 51, "Item",ExpressionUUID->"d59db348-3b66-44d7-bdfe-a0ab0083d648"],
Cell[175349, 4077, 143, 2, 31, "Item",ExpressionUUID->"80d2863d-03f2-4547-a251-d547a5825c23"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175541, 4085, 199, 7, 53, "Subsection",ExpressionUUID->"38a809cc-ab3e-47aa-a230-ff997099a297"],
Cell[175743, 4094, 797, 11, 144, "Text",ExpressionUUID->"22291fad-2403-46b8-8a8b-8f115a746f99"],
Cell[176543, 4107, 426, 8, 78, "Text",ExpressionUUID->"8e1dc970-c142-4167-b5bc-68727460fc26"],
Cell[176972, 4117, 407, 6, 78, "Text",ExpressionUUID->"8357d9d3-657a-491c-a875-ea24bbcba3d2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[177416, 4128, 193, 7, 53, "Subsection",ExpressionUUID->"9e9aa5c1-49d5-41cc-9904-bd30a3bf4a00"],
Cell[177612, 4137, 847, 16, 122, "Text",ExpressionUUID->"b5a8a71e-8bce-4b5e-8a62-7d8fa0e8d28e"],
Cell[178462, 4155, 708, 10, 122, "Text",ExpressionUUID->"9117fb9a-1d58-462b-aa6c-f6033f21d12f"],
Cell[179173, 4167, 335, 7, 56, "Text",ExpressionUUID->"f5e48677-9102-4f1d-815e-91f5fceb3f7c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179545, 4179, 177, 7, 53, "Subsection",ExpressionUUID->"30f7c03b-64a4-4633-a1f5-b571ac567845"],
Cell[179725, 4188, 847, 16, 144, "Text",ExpressionUUID->"ac38fcca-4e12-440d-ab26-1129be33f6df"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[180621, 4210, 135, 4, 67, "Section",ExpressionUUID->"1d3a3429-18ab-42e3-a14a-86bfc503de30"],
Cell[180759, 4216, 466, 8, 78, "Text",ExpressionUUID->"7c1eedd0-102b-48c8-b0be-db10d8b41ec6"],
Cell[CellGroupData[{
Cell[181250, 4228, 175, 7, 53, "Subsection",ExpressionUUID->"b3f630e1-4a77-4cf4-bc68-e99941933552"],
Cell[181428, 4237, 487, 7, 100, "Text",ExpressionUUID->"b5dfe3fb-9240-47a2-be89-94049d629194"],
Cell[CellGroupData[{
Cell[181940, 4248, 256, 6, 28, "Input",ExpressionUUID->"760683a1-9b8c-4fdd-884f-3c62c381a7f3"],
Cell[182199, 4256, 206, 4, 32, "Output",ExpressionUUID->"cdbc4e93-5aa2-41ec-85c0-43749ffb95fe"]
}, Open  ]],
Cell[182420, 4263, 173, 3, 34, "Text",ExpressionUUID->"5a1dc4e8-265f-48db-b81f-da5429df18de"],
Cell[CellGroupData[{
Cell[182618, 4270, 122, 1, 28, "Input",ExpressionUUID->"69ffae27-44e4-49e0-9471-50c246171e5d"],
Cell[182743, 4273, 188, 3, 32, "Output",ExpressionUUID->"8b69770a-ef39-4f12-b7b1-dad7feb28c75"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[182980, 4282, 163, 7, 53, "Subsection",ExpressionUUID->"57aba9e3-242b-4193-bddc-18a3c128d14a"],
Cell[183146, 4291, 875, 12, 122, "Text",ExpressionUUID->"63e0e076-de96-4a57-aa26-b51772dd071c"],
Cell[CellGroupData[{
Cell[184046, 4307, 196, 4, 28, "Input",ExpressionUUID->"5d09ee7c-b461-4462-a299-4c79efd813e9"],
Cell[184245, 4313, 133, 1, 32, "Output",ExpressionUUID->"ae382fe8-1407-48cc-b42f-17b66b079611"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184415, 4319, 262, 5, 28, "Input",ExpressionUUID->"d545c501-14c6-4792-922d-399e9e3fb5bb"],
Cell[184680, 4326, 138, 2, 32, "Output",ExpressionUUID->"739e092d-d714-43f5-9433-bc507e1ed254"]
}, Open  ]],
Cell[184833, 4331, 151, 2, 34, "Text",ExpressionUUID->"552bc966-94a5-4ee8-9b4c-0635bc85e8a5"],
Cell[CellGroupData[{
Cell[185009, 4337, 263, 5, 28, "Input",ExpressionUUID->"318f073e-dc27-4b13-9f64-a77f2452efb2"],
Cell[185275, 4344, 209, 4, 32, "Output",ExpressionUUID->"ae17b37c-24b2-4924-8846-9e1ca255dc47"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[185533, 4354, 180, 7, 53, "Subsection",ExpressionUUID->"04844e49-fd65-4b25-9e9b-dbf3de9c3239"],
Cell[185716, 4363, 236, 5, 34, "Text",ExpressionUUID->"927d47f7-018a-48c4-b6d4-c8d52c951c32"],
Cell[CellGroupData[{
Cell[185977, 4372, 127, 1, 28, "Input",ExpressionUUID->"579ca52e-40c0-41fd-89b8-a83ab43ef024"],
Cell[186107, 4375, 144, 2, 32, "Output",ExpressionUUID->"baba444c-e897-4bf5-8d1f-e6b78b26730b"]
}, Open  ]],
Cell[186266, 4380, 123, 0, 34, "Text",ExpressionUUID->"d098cb13-2dd7-4dd8-ac47-febe931a0f13"],
Cell[CellGroupData[{
Cell[186414, 4384, 120, 1, 28, "Input",ExpressionUUID->"29c98061-6d70-4e6f-ae8f-a091ce4d7527"],
Cell[186537, 4387, 277, 5, 32, "Output",ExpressionUUID->"ac5a75c6-6697-4151-9e07-3fcec0516a97"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[186863, 4398, 170, 7, 53, "Subsection",ExpressionUUID->"aaa35a86-1771-43c2-9b9f-0d024b01c867"],
Cell[187036, 4407, 520, 9, 56, "Text",ExpressionUUID->"8c6af9b1-4dd4-4008-afe8-792bde7b3f02"],
Cell[CellGroupData[{
Cell[187581, 4420, 679, 12, 91, "Item",ExpressionUUID->"c217df7a-8cc4-4ec3-80a1-5da3324e59c2"],
Cell[188263, 4434, 339, 8, 51, "Item",ExpressionUUID->"cf27fc44-2070-49a3-bad7-7003654b5f1e"]
}, Open  ]],
Cell[188617, 4445, 1051, 20, 144, "Text",ExpressionUUID->"a5d3c6d2-a9a1-40c7-b5b0-f90792e5056f"],
Cell[189671, 4467, 1426, 35, 166, "Text",ExpressionUUID->"1952608a-1378-4a88-a0e4-dec8ed76d37b"],
Cell[191100, 4504, 522, 9, 78, "Text",ExpressionUUID->"1fbe04bb-4dcc-4fe7-bed5-378ddc893c57"],
Cell[191625, 4515, 915, 13, 166, "Text",ExpressionUUID->"45f04847-06a0-48c0-8a31-aa271fc5e08e"],
Cell[CellGroupData[{
Cell[192565, 4532, 270, 7, 28, "Input",ExpressionUUID->"343eb347-3119-482c-9a40-51ffc54a2c7d"],
Cell[192838, 4541, 207, 4, 32, "Output",ExpressionUUID->"8ba551a0-fa67-451a-9364-6e54770b3420"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193082, 4550, 211, 4, 28, "Input",ExpressionUUID->"522a76e0-6fe0-4cd1-ba40-ce63041dbf48"],
Cell[193296, 4556, 162, 3, 32, "Output",ExpressionUUID->"b7b9d730-df81-4bd4-8e3d-bdb81a1c46e6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[193507, 4565, 186, 7, 53, "Subsection",ExpressionUUID->"db0271a0-358a-4614-9574-89706b61379e"],
Cell[193696, 4574, 98, 0, 34, "Text",ExpressionUUID->"624571c0-80e4-421e-b648-bda059b37f52"],
Cell[CellGroupData[{
Cell[193819, 4578, 200, 3, 28, "Input",ExpressionUUID->"8f8ab4c1-9652-4690-bc26-1e678272871a"],
Cell[194022, 4583, 312, 5, 52, "Output",ExpressionUUID->"0cc63be6-3db6-4ae5-91b1-65a9e6a36359"]
}, Open  ]],
Cell[194349, 4591, 584, 8, 78, "Text",ExpressionUUID->"16520f85-abb7-4fbd-9c2b-336be71f37ee"],
Cell[194936, 4601, 562, 8, 78, "Text",ExpressionUUID->"0311b5df-370e-432c-a8e7-0811ec2aced2"],
Cell[195501, 4611, 1010, 14, 144, "Text",ExpressionUUID->"32ef7ae0-4ca9-4a7e-8c6a-1d06d11eb8f5"],
Cell[196514, 4627, 407, 6, 78, "Text",ExpressionUUID->"a27fd3d9-a822-43dd-9210-faa5f5cd464c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196958, 4638, 170, 7, 53, "Subsection",ExpressionUUID->"a3d55f82-4db9-4ea7-8d93-5fe4e8de1995"],
Cell[197131, 4647, 1216, 26, 144, "Text",ExpressionUUID->"6316c80d-e408-471f-808e-785db04a7331"],
Cell[CellGroupData[{
Cell[198372, 4677, 201, 4, 28, "Input",ExpressionUUID->"d34bd369-a92f-4840-b867-97c88fe5e5d9"],
Cell[198576, 4683, 140, 2, 32, "Output",ExpressionUUID->"a830ef07-f96d-4d4c-b149-4fbf132538cf"]
}, Open  ]],
Cell[198731, 4688, 231, 4, 56, "Text",ExpressionUUID->"3ca23b10-2f7d-437b-85fd-997e2d58acc7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198999, 4697, 163, 7, 53, "Subsection",ExpressionUUID->"b5361e00-b2fc-49bb-8bd2-01afe5c04f8b"],
Cell[199165, 4706, 479, 9, 56, "Text",ExpressionUUID->"5d18b350-b8d1-4009-aabf-33bb229a1e2d"],
Cell[CellGroupData[{
Cell[199669, 4719, 146, 3, 28, "Input",ExpressionUUID->"eace1411-ac68-4f04-840c-2307de8919df"],
Cell[199818, 4724, 130, 1, 32, "Output",ExpressionUUID->"8a7ac892-dd0f-449d-8b59-86bf81cd3d8f"]
}, Open  ]],
Cell[199963, 4728, 153, 2, 34, "Text",ExpressionUUID->"e8d4fd39-ae4e-4abd-aafa-c5df734254c8"],
Cell[CellGroupData[{
Cell[200141, 4734, 282, 6, 28, "Input",ExpressionUUID->"bee22bc1-5faf-4153-a544-9558a8a47622"],
Cell[200426, 4742, 219, 4, 32, "Output",ExpressionUUID->"15198ac8-29a8-45e0-a222-997f6e154233"]
}, Open  ]],
Cell[200660, 4749, 638, 17, 78, "Text",ExpressionUUID->"785de669-22a0-47cc-a2c7-e175cc5b65d1"],
Cell[CellGroupData[{
Cell[201323, 4770, 103, 1, 28, "Input",ExpressionUUID->"224c2900-c32b-4f14-b816-c37c7048b5aa"],
Cell[201429, 4773, 455, 11, 45, "Print",ExpressionUUID->"5cd5b3eb-85eb-481c-a10d-be0b3eb04703",
 CellTags->"Info2763735558483-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201921, 4789, 188, 5, 28, "Input",ExpressionUUID->"8019815f-ca64-4fc5-9256-f5810979cfc1"],
Cell[202112, 4796, 202, 6, 32, "Output",ExpressionUUID->"18c78772-3bb4-4b91-aa90-502a2b6cc953"]
}, Open  ]],
Cell[202329, 4805, 113, 1, 28, "Input",ExpressionUUID->"8dffe4cf-1508-4d63-9181-ba7ebbdab83c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[202491, 4812, 160, 4, 67, "Section",ExpressionUUID->"4f57d334-90ba-4ab9-a136-ee836f6a4eda"],
Cell[CellGroupData[{
Cell[202676, 4820, 186, 7, 53, "Subsection",ExpressionUUID->"b107f0f6-43a5-4f6c-b298-150ad443f237"],
Cell[202865, 4829, 452, 7, 56, "Text",ExpressionUUID->"701564d1-1be3-4f18-9769-b8b069e23c1a"],
Cell[203320, 4838, 110, 0, 34, "Text",ExpressionUUID->"9e98273e-8bc9-47e4-a486-7f6ebce80f22"],
Cell[203433, 4840, 287, 4, 56, "Text",ExpressionUUID->"b4c67a8a-00ad-49ea-bc27-fd108e4832d6"],
Cell[203723, 4846, 269, 4, 56, "Text",ExpressionUUID->"0ab4c52b-6568-4c47-bf36-4b87b1d3b8dc"],
Cell[203995, 4852, 377, 6, 78, "Text",ExpressionUUID->"68dae29b-ce3e-451b-9fb5-d8bc70196662"],
Cell[204375, 4860, 630, 10, 100, "Text",ExpressionUUID->"0e4f95a0-6be5-48ba-b1b0-3be3e3b446b4"],
Cell[CellGroupData[{
Cell[205030, 4874, 374, 10, 28, "Input",ExpressionUUID->"5899e718-c4a8-4c66-be8f-0c9af8ed7d3b"],
Cell[205407, 4886, 333, 8, 32, "Output",ExpressionUUID->"0918e733-fb84-4657-b1e0-a23fa281e3fd"]
}, Open  ]],
Cell[205755, 4897, 342, 5, 56, "Text",ExpressionUUID->"ffb3dfa6-fe61-468e-9cd5-da79fe4cda2c"],
Cell[206100, 4904, 559, 9, 78, "Text",ExpressionUUID->"a9e162e3-9b54-48aa-b8df-5e9728a62ffb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206696, 4918, 214, 7, 53, "Subsection",ExpressionUUID->"2462ab98-6b3b-4a3f-816f-888b01c28089"],
Cell[206913, 4927, 147, 2, 34, "Text",ExpressionUUID->"e8b2ee5b-f448-423b-a0f3-69b45ae05a31"],
Cell[207063, 4931, 1112, 15, 188, "Text",ExpressionUUID->"136c6d0e-b6c0-44d9-8b89-0f079b9de358"],
Cell[208178, 4948, 892, 16, 144, "Text",ExpressionUUID->"8544f518-6051-425b-a4b4-2a1ff0f7fae2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[209107, 4969, 166, 7, 53, "Subsection",ExpressionUUID->"2324503b-0afd-4140-9e3f-c451bcb77958"],
Cell[209276, 4978, 106, 0, 34, "Text",ExpressionUUID->"8d04974f-bc81-444e-ad37-c1e4048f5f5c"],
Cell[CellGroupData[{
Cell[209407, 4982, 353, 5, 71, "ItemNumbered",ExpressionUUID->"6816dfe3-081f-43a1-911f-1080820dfd69"],
Cell[209763, 4989, 360, 5, 71, "ItemNumbered",ExpressionUUID->"5f292f1a-d261-4a7e-91f7-385b49c2891d"],
Cell[210126, 4996, 464, 6, 71, "ItemNumbered",ExpressionUUID->"afe9767f-562a-4d86-ab45-b2660318ef39"]
}, Open  ]],
Cell[210605, 5005, 989, 15, 166, "Text",ExpressionUUID->"22520985-02e0-49f1-b2c7-cca82c28e19a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211631, 5025, 170, 7, 53, "Subsection",ExpressionUUID->"ca9f0a94-4a4e-4c91-b5fa-71b3f9398bca"],
Cell[211804, 5034, 197, 5, 34, "Text",ExpressionUUID->"10d08bc5-c7ef-4e5c-8781-dea5332eb335"],
Cell[CellGroupData[{
Cell[212026, 5043, 231, 3, 51, "Item",ExpressionUUID->"df71fc2f-3eb6-45ce-9293-b20fcebb3a95"],
Cell[212260, 5048, 145, 2, 31, "Item",ExpressionUUID->"aeda0c55-11fd-49b0-a429-7014bddae90e"],
Cell[212408, 5052, 285, 4, 51, "Item",ExpressionUUID->"4de36ae4-61a8-4db4-a627-72bb6b01772a"],
Cell[212696, 5058, 258, 4, 51, "Item",ExpressionUUID->"38948c75-734b-4696-83d1-7817b6939bb6"],
Cell[212957, 5064, 178, 3, 31, "Item",ExpressionUUID->"e7fe130c-e95a-456f-b864-8831322a11d9"],
Cell[213138, 5069, 637, 9, 111, "Item",ExpressionUUID->"3d8f6436-b2a6-4344-88ff-1648bb5c8cf0"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[213836, 5085, 147, 4, 67, "Section",ExpressionUUID->"8228ad1f-a662-4922-a9dd-e46a6f07fd68"],
Cell[CellGroupData[{
Cell[214008, 5093, 163, 7, 53, "Subsection",ExpressionUUID->"907e9818-6f1b-4f51-93c7-945b6b83e13c"],
Cell[214174, 5102, 849, 12, 166, "Text",ExpressionUUID->"92ba9114-9b6f-493a-b68f-19b74e22dfe4"],
Cell[215026, 5116, 145, 2, 34, "Text",ExpressionUUID->"b01421d1-61aa-430b-8a3d-3bcf5f74e7eb"],
Cell[215174, 5120, 471, 8, 78, "Text",ExpressionUUID->"5d46543d-6074-4c45-bb98-d664181ef0af"],
Cell[215648, 5130, 567, 8, 100, "Text",ExpressionUUID->"c6e679d2-93e6-478e-8c8a-847e346c9643"],
Cell[216218, 5140, 240, 5, 34, "Text",ExpressionUUID->"d13f20fb-830a-4e9f-ace0-8341fe62d12d"],
Cell[CellGroupData[{
Cell[216483, 5149, 366, 8, 28, "Input",ExpressionUUID->"c32dc581-d3b3-4f09-835f-f1732ba8ae27"],
Cell[216852, 5159, 200, 3, 32, "Output",ExpressionUUID->"8ba2a7e9-90dd-4dbc-a8cc-0c2a25b4fe39"]
}, Open  ]],
Cell[217067, 5165, 208, 4, 34, "Text",ExpressionUUID->"d6ba139b-d0b4-496c-af60-0d75054e735f"],
Cell[CellGroupData[{
Cell[217300, 5173, 430, 9, 28, "Input",ExpressionUUID->"0c2b47b7-1d9a-428d-83f1-37cc5fcdb08a"],
Cell[217733, 5184, 183, 3, 32, "Output",ExpressionUUID->"fd12b677-9e9d-4bc3-ada4-b84a28120dd5"]
}, Open  ]],
Cell[217931, 5190, 108, 0, 34, "Text",ExpressionUUID->"7c9faa32-adbe-4a02-b365-0ceef44c92fa"],
Cell[CellGroupData[{
Cell[218064, 5194, 321, 7, 28, "Input",ExpressionUUID->"ab7a755c-940a-402c-af4d-f9679a3b0cea"],
Cell[218388, 5203, 347, 5, 23, "Print",ExpressionUUID->"7874b6ed-46d7-4f09-96c7-4e967a24eebd"],
Cell[218738, 5210, 183, 3, 32, "Output",ExpressionUUID->"ba548d4c-2056-49e5-a0d7-ffd52e17fcee"]
}, Open  ]],
Cell[218936, 5216, 376, 7, 56, "Text",ExpressionUUID->"587f5540-c05a-4d77-9430-674f6f3ab5b0"],
Cell[CellGroupData[{
Cell[219337, 5227, 368, 8, 28, "Input",ExpressionUUID->"05e7e654-2965-4364-bfd2-fc3bdc0279d2"],
Cell[219708, 5237, 523, 14, 32, "Output",ExpressionUUID->"a1434104-3624-4695-8db3-f0593e9548b4"]
}, Open  ]],
Cell[220246, 5254, 214, 5, 34, "Text",ExpressionUUID->"9ce2d523-c77b-4019-ad12-7141f5266244"],
Cell[CellGroupData[{
Cell[220485, 5263, 368, 8, 28, "Input",ExpressionUUID->"1fe34dcc-6d11-4bcf-828a-dc3459b3a693"],
Cell[220856, 5273, 140, 2, 32, "Output",ExpressionUUID->"48eddee4-bdc0-44e9-b870-8993d33ccefd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[221033, 5280, 122, 1, 28, "Input",ExpressionUUID->"32e2bfbc-f8e9-4e45-b2df-4c53713f6675"],
Cell[221158, 5283, 269, 4, 32, "Output",ExpressionUUID->"79cfdae8-9a15-40f3-a7bf-a455118874f4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[221476, 5293, 170, 7, 53, "Subsection",ExpressionUUID->"dd7f7cea-ff28-4c7c-bbc8-617637fe8fd6"],
Cell[CellGroupData[{
Cell[221671, 5304, 222, 10, 44, "Subsubsection",ExpressionUUID->"0b4e0786-4a8d-417e-ab93-befef5f9e1bf"],
Cell[221896, 5316, 458, 6, 100, "Text",ExpressionUUID->"b5dd6183-60d1-4879-8239-d5dc250668df"],
Cell[222357, 5324, 427, 6, 78, "Text",ExpressionUUID->"7f173597-b729-4c1c-8798-0afe996133e9"],
Cell[CellGroupData[{
Cell[222809, 5334, 331, 9, 28, "Input",ExpressionUUID->"4c0518c4-1172-4e42-981d-78b2fa731d0f"],
Cell[223143, 5345, 527, 9, 32, "Output",ExpressionUUID->"be1bd2fe-37d1-43e8-bde3-ae5288eeff5a"]
}, Open  ]],
Cell[223685, 5357, 209, 3, 56, "Text",ExpressionUUID->"492c38ae-5460-4e76-b164-ae882c002702"]
}, Open  ]],
Cell[CellGroupData[{
Cell[223931, 5365, 226, 10, 44, "Subsubsection",ExpressionUUID->"afee3218-0698-4c08-81c5-afe829aabb79"],
Cell[CellGroupData[{
Cell[224182, 5379, 234, 6, 28, "Input",ExpressionUUID->"77989bfb-4e22-44ad-b163-8af1142da806"],
Cell[224419, 5387, 557, 8, 90, "Output",ExpressionUUID->"e388e4ab-7201-42b2-8307-d80c3feb829a"]
}, Open  ]],
Cell[224991, 5398, 1034, 18, 122, "Text",ExpressionUUID->"a3086da8-5907-4a2b-99fd-6845ab1bd6b5"],
Cell[226028, 5418, 160, 3, 34, "Text",ExpressionUUID->"367b57f3-c5d2-4234-bb90-a4e8b2952c2b"],
Cell[CellGroupData[{
Cell[226213, 5425, 262, 7, 28, "Input",ExpressionUUID->"d791c9c7-fb8a-4359-80cf-ac52842cb6ca"],
Cell[226478, 5434, 1119, 28, 116, "Output",ExpressionUUID->"34b930ac-2a94-42ef-8117-abf6b7afcf00"]
}, Open  ]],
Cell[227612, 5465, 92, 0, 34, "Text",ExpressionUUID->"f7db2c3b-d9d4-47ce-95ea-1ab0fd4045fd"],
Cell[CellGroupData[{
Cell[227729, 5469, 415, 12, 28, "Input",ExpressionUUID->"184435d3-c3ea-415c-b114-6b11cb8850f2"],
Cell[228147, 5483, 1118, 28, 116, "Output",ExpressionUUID->"c1eb3a52-cf8f-4ee2-aa7c-7ab14fc155a4"]
}, Open  ]],
Cell[229280, 5514, 243, 4, 34, "Text",ExpressionUUID->"393e3262-5ce0-4454-971c-8cfa51098463"],
Cell[CellGroupData[{
Cell[229548, 5522, 142, 3, 28, "Input",ExpressionUUID->"679de973-c903-4080-8237-b3d20f5d6ff8"],
Cell[229693, 5527, 192, 3, 32, "Output",ExpressionUUID->"160584e7-9eeb-44c2-ba1d-a5d0aa03e88b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[229934, 5536, 238, 10, 44, "Subsubsection",ExpressionUUID->"b40861dc-0436-42e1-a89c-83852c282f54"],
Cell[230175, 5548, 252, 4, 56, "Text",ExpressionUUID->"7267bc0c-e5d3-4dea-ae41-b974c6c38467"],
Cell[CellGroupData[{
Cell[230452, 5556, 239, 5, 28, "Input",ExpressionUUID->"5d5e7b95-0568-49e6-8479-6db961eeb3b5"],
Cell[230694, 5563, 625, 9, 52, "Output",ExpressionUUID->"a0c0666f-95a8-4a84-939e-120dc7398d0e"]
}, Open  ]],
Cell[231334, 5575, 115, 0, 34, "Text",ExpressionUUID->"a45ce415-5a1d-4f01-832b-3e3e79d03c39"],
Cell[CellGroupData[{
Cell[231474, 5579, 263, 7, 28, "Input",ExpressionUUID->"71fbc622-f522-415b-8b66-f304aa8a0128"],
Cell[231740, 5588, 1111, 27, 82, "Output",ExpressionUUID->"744346cd-8740-4ccf-8273-1af1264e3cf1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[232912, 5622, 213, 7, 53, "Subsection",ExpressionUUID->"691f773c-a1ee-46c8-8426-fedc33f63930"],
Cell[233128, 5631, 180, 3, 34, "Text",ExpressionUUID->"9d61baf4-49ea-45eb-81ef-d39cf0c23df6"],
Cell[CellGroupData[{
Cell[233333, 5638, 231, 10, 44, "Subsubsection",ExpressionUUID->"14727591-dd20-40ee-9a47-63100c2f6a91"],
Cell[233567, 5650, 320, 5, 56, "Text",ExpressionUUID->"cb2a255d-1bb2-45f5-a4b6-817b21b96edf"],
Cell[CellGroupData[{
Cell[233912, 5659, 299, 6, 28, "Input",ExpressionUUID->"f9ad06a1-184c-4b4e-b686-1c7160f1fc93"],
Cell[234214, 5667, 119, 1, 32, "Output",ExpressionUUID->"2cca5c89-971d-42f1-a23a-425a5487df30"]
}, Open  ]],
Cell[234348, 5671, 271, 4, 56, "Text",ExpressionUUID->"0e7e8eda-cf35-41fe-b635-4269006e5714"]
}, Open  ]],
Cell[CellGroupData[{
Cell[234656, 5680, 251, 10, 44, "Subsubsection",ExpressionUUID->"b91dc25d-75c8-4214-bfd9-08eeb37dfa57"],
Cell[234910, 5692, 549, 8, 100, "Text",ExpressionUUID->"60416342-615f-4f76-9536-6bb8f5c90bfb"],
Cell[CellGroupData[{
Cell[235484, 5704, 328, 8, 28, "Input",ExpressionUUID->"0d69d654-6b6b-4c06-8d5e-054bfe8446fb"],
Cell[235815, 5714, 137, 2, 23, "Print",ExpressionUUID->"7ccd76fc-2a39-4d47-8a05-2d442fbc1209"],
Cell[235955, 5718, 119, 1, 32, "Output",ExpressionUUID->"8158871d-6e2a-43bd-a15c-89b939843fba"]
}, Open  ]],
Cell[236089, 5722, 175, 3, 34, "Text",ExpressionUUID->"ed5e883c-6249-4441-a8c0-5b9431a560c1"],
Cell[CellGroupData[{
Cell[236289, 5729, 263, 5, 28, "Input",ExpressionUUID->"8885b0ae-746f-429b-b8ed-1b9d1d404a63"],
Cell[236555, 5736, 248, 6, 32, "Output",ExpressionUUID->"b21ba155-7ba9-4737-b684-e666181056b3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[236852, 5748, 248, 10, 44, "Subsubsection",ExpressionUUID->"fbcb7d41-4f3a-411d-8064-6676757d6dee"],
Cell[237103, 5760, 258, 4, 56, "Text",ExpressionUUID->"44b0853d-d38c-4742-b628-d3b850c0ca47"],
Cell[237364, 5766, 388, 5, 78, "Text",ExpressionUUID->"dcead662-b95c-45ab-9b96-849fccdda16d"],
Cell[CellGroupData[{
Cell[237777, 5775, 329, 6, 28, "Input",ExpressionUUID->"02906bd4-dbf8-4ea5-8582-3ab0770316d5"],
Cell[238109, 5783, 139, 2, 23, "Print",ExpressionUUID->"85094dd8-d564-4b44-9bc8-a916bd9775c9"],
Cell[238251, 5787, 136, 2, 32, "Output",ExpressionUUID->"6bdbcfb5-53ed-4863-aaf1-3602439df5fe"]
}, Open  ]],
Cell[238402, 5792, 493, 9, 78, "Text",ExpressionUUID->"88bbeabc-1154-4970-b437-69aeec1cc1f8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238932, 5806, 221, 10, 44, "Subsubsection",ExpressionUUID->"6c79858b-c5c8-4d81-8f4d-31ccd225def1"],
Cell[239156, 5818, 322, 6, 56, "Text",ExpressionUUID->"c15b6632-0e2a-40f8-86ad-ed2773073680"],
Cell[CellGroupData[{
Cell[239503, 5828, 200, 3, 28, "Input",ExpressionUUID->"83a25e62-4db7-47c1-9d1f-687d8f62727a"],
Cell[239706, 5833, 260, 4, 52, "Output",ExpressionUUID->"687ccf26-9b43-4cbc-acd6-2e608036c74c"]
}, Open  ]],
Cell[239981, 5840, 342, 5, 56, "Text",ExpressionUUID->"95ee8eea-18b6-4abb-bae7-c64fa0879b10"],
Cell[240326, 5847, 836, 12, 122, "Text",ExpressionUUID->"9a293a5d-2031-4644-b4e8-18e5e588b81c"],
Cell[241165, 5861, 277, 4, 56, "Text",ExpressionUUID->"90ddfd65-0e13-45b3-ae6e-89421bad0a1a"],
Cell[CellGroupData[{
Cell[241467, 5869, 125, 1, 28, "Input",ExpressionUUID->"f443cd33-53ca-4008-bd1a-ac049c7934b1"],
Cell[241595, 5872, 132, 1, 23, "Print",ExpressionUUID->"64739abd-3558-4885-9edd-5d0b7d4f5099"],
Cell[241730, 5875, 120, 1, 32, "Output",ExpressionUUID->"11bde66e-4f3e-423e-8e39-991fc7eb0294"]
}, Open  ]],
Cell[CellGroupData[{
Cell[241887, 5881, 216, 4, 28, "Input",ExpressionUUID->"4234072f-8235-43e4-baf4-5a528f189f22"],
Cell[242106, 5887, 132, 1, 23, "Print",ExpressionUUID->"be019707-9e36-42bf-aa63-2c610623fbc8"],
Cell[242241, 5890, 120, 1, 32, "Output",ExpressionUUID->"64f21101-849e-4539-966e-30219c9ce45e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[242410, 5897, 224, 10, 44, "Subsubsection",ExpressionUUID->"d53c63fa-b917-468f-8251-e8c7f12cc33f"],
Cell[242637, 5909, 602, 8, 100, "Text",ExpressionUUID->"775f1394-515b-4345-9cbe-77248ffe73a6"],
Cell[CellGroupData[{
Cell[243264, 5921, 200, 3, 28, "Input",ExpressionUUID->"fce1c662-2810-49a4-ab4d-2c00d41b2a93"],
Cell[243467, 5926, 295, 4, 52, "Output",ExpressionUUID->"e6a20a65-3443-4005-9bb0-8572cf2e27db"]
}, Open  ]],
Cell[243777, 5933, 106, 0, 34, "Text",ExpressionUUID->"5572a850-1437-461d-bff0-1cf51e718363"],
Cell[CellGroupData[{
Cell[243908, 5937, 394, 10, 28, "Input",ExpressionUUID->"f2977981-75aa-4739-8cf2-a14a2c0ce056"],
Cell[244305, 5949, 164, 4, 32, "Output",ExpressionUUID->"33388d95-d27e-4db4-8d18-880795c16d07"]
}, Open  ]],
Cell[244484, 5956, 154, 2, 34, "Text",ExpressionUUID->"3bd1e3d8-2adf-4283-b6f6-7b2348f2c63e"],
Cell[CellGroupData[{
Cell[244663, 5962, 394, 8, 28, "Input",ExpressionUUID->"9000380b-7d6a-465e-8455-60a67f2b3a8c"],
Cell[245060, 5972, 296, 4, 52, "Output",ExpressionUUID->"1086fc89-d99e-43a9-b0b6-b59e7f671ba3"]
}, Open  ]],
Cell[245371, 5979, 171, 3, 34, "Text",ExpressionUUID->"ff4aebc4-979a-4ef0-92ba-efded2620dc0"],
Cell[CellGroupData[{
Cell[245567, 5986, 122, 1, 28, "Input",ExpressionUUID->"3f4029e6-1a8d-4989-8bd9-fcea6e2a1ca6"],
Cell[245692, 5989, 469, 7, 52, "Output",ExpressionUUID->"0046fb8f-cee8-40a1-aa31-28fdb12d3692"]
}, Open  ]],
Cell[CellGroupData[{
Cell[246198, 6001, 294, 6, 28, "Input",ExpressionUUID->"a231637e-a5cb-475c-87c0-87e296330c7c"],
Cell[246495, 6009, 200, 3, 23, "Print",ExpressionUUID->"247cf805-a34c-4699-9e45-780dd248a926"],
Cell[246698, 6014, 128, 1, 32, "Output",ExpressionUUID->"cb17454e-c7b5-4b52-b6fa-4715ceed25e4"]
}, Open  ]],
Cell[246841, 6018, 264, 6, 56, "Text",ExpressionUUID->"d37aa0ca-4c5d-4b75-8773-c26d017a0d9f"],
Cell[CellGroupData[{
Cell[247130, 6028, 209, 4, 28, "Input",ExpressionUUID->"69e11500-96ae-4eaa-8724-2f98672363b9"],
Cell[247342, 6034, 283, 7, 32, "Output",ExpressionUUID->"9d3fa64c-7f2a-4721-8e9b-7125e0b774ad"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[247674, 6047, 210, 10, 44, "Subsubsection",ExpressionUUID->"833dd599-1ae5-4eb0-9ff7-6465693b4e53"],
Cell[CellGroupData[{
Cell[247909, 6061, 198, 3, 28, "Input",ExpressionUUID->"693c1513-a2e0-454f-9038-15970a07dc83"],
Cell[248110, 6066, 331, 5, 71, "Output",ExpressionUUID->"d1ad0311-b586-4c00-8d13-a645d7eaa920"]
}, Open  ]],
Cell[248456, 6074, 200, 3, 34, "Text",ExpressionUUID->"38169750-f79e-4a31-be9f-1538b0d807a1"],
Cell[CellGroupData[{
Cell[248681, 6081, 363, 9, 28, "Input",ExpressionUUID->"2f1f5215-a9ca-4fdd-855d-3bcf1d4c2f40"],
Cell[249047, 6092, 160, 4, 32, "Output",ExpressionUUID->"520b968f-32de-46e1-9646-c97648f7f627"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249244, 6101, 431, 9, 28, "Input",ExpressionUUID->"a67ecacf-9250-487a-830c-239dd82dfa36"],
Cell[249678, 6112, 296, 4, 52, "Output",ExpressionUUID->"22bf3163-2a62-482d-b480-f39c42d7e9dd"]
}, Open  ]],
Cell[249989, 6119, 245, 4, 56, "Text",ExpressionUUID->"81cec938-4fc5-4a0a-9a63-d2e138465a59"],
Cell[250237, 6125, 266, 4, 56, "Text",ExpressionUUID->"6a831ab0-550c-4294-90eb-b0920ce95cef"],
Cell[CellGroupData[{
Cell[250528, 6133, 264, 5, 28, "Input",ExpressionUUID->"542866be-d527-4482-af18-e2d8296290e0"],
Cell[250795, 6140, 138, 2, 23, "Print",ExpressionUUID->"ced9ae8d-a9f6-43b9-aaf9-a530cb7e62c4"],
Cell[250936, 6144, 137, 2, 32, "Output",ExpressionUUID->"6ab9bed7-0e0a-4c52-a86e-e51756b4ad9f"]
}, Open  ]],
Cell[251088, 6149, 264, 6, 56, "Text",ExpressionUUID->"1f13dc3e-a256-4860-9d00-a4c6decdcca9"],
Cell[CellGroupData[{
Cell[251377, 6159, 209, 4, 28, "Input",ExpressionUUID->"4db6c2d3-f09a-4d96-a421-04a1c8ab0dfd"],
Cell[251589, 6165, 230, 6, 32, "Output",ExpressionUUID->"34083d85-a440-4712-9ffd-6d1a0ab8649a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[251868, 6177, 213, 10, 44, "Subsubsection",ExpressionUUID->"78dbf143-2424-4f05-9686-53eccc04ee1c"],
Cell[CellGroupData[{
Cell[252106, 6191, 198, 3, 28, "Input",ExpressionUUID->"55be71f4-aa2a-4b5f-8072-32b1aacd7630"],
Cell[252307, 6196, 331, 5, 71, "Output",ExpressionUUID->"9748afd3-5dd5-434c-9f27-5ddfceb02278"]
}, Open  ]],
Cell[252653, 6204, 172, 3, 34, "Text",ExpressionUUID->"734286d2-48b8-4a79-b92b-02299e29d3a7"],
Cell[CellGroupData[{
Cell[252850, 6211, 222, 6, 28, "Input",ExpressionUUID->"c61ef045-d1bc-406b-9424-f68606732d3c"],
Cell[253075, 6219, 160, 4, 32, "Output",ExpressionUUID->"d646f00a-1290-4edc-ac41-160e29f9b25a"]
}, Open  ]],
Cell[253250, 6226, 260, 4, 56, "Text",ExpressionUUID->"2db1528f-d56c-4541-be29-e100a4086076"],
Cell[CellGroupData[{
Cell[253535, 6234, 431, 9, 28, "Input",ExpressionUUID->"67966a45-65f0-4b85-be0a-ddffd1231480"],
Cell[253969, 6245, 298, 4, 52, "Output",ExpressionUUID->"1d0d3d16-0541-4503-9b59-46e1072e2b49"]
}, Open  ]],
Cell[CellGroupData[{
Cell[254304, 6254, 122, 1, 28, "Input",ExpressionUUID->"c874286d-d5c9-4a40-b5b3-d2b8e9eef638"],
Cell[254429, 6257, 510, 7, 52, "Output",ExpressionUUID->"4725498d-2e67-4a87-bd83-9bb7fe559202"]
}, Open  ]],
Cell[CellGroupData[{
Cell[254976, 6269, 264, 5, 28, "Input",ExpressionUUID->"027fdd8a-eac2-434c-8bd3-1600f2e5ab35"],
Cell[255243, 6276, 206, 4, 23, "Print",ExpressionUUID->"aaf6c19f-f242-4e57-a994-15a20be74205"],
Cell[255452, 6282, 145, 2, 32, "Output",ExpressionUUID->"8c6067a9-0809-433d-889b-64eb32af2ed4"]
}, Open  ]],
Cell[255612, 6287, 264, 6, 56, "Text",ExpressionUUID->"6c45634d-4902-48a2-9476-c8347af53189"],
Cell[CellGroupData[{
Cell[255901, 6297, 209, 4, 28, "Input",ExpressionUUID->"32363af1-be9f-41f5-b423-8f7c948be15d"],
Cell[256113, 6303, 306, 8, 32, "Output",ExpressionUUID->"2a0927a3-84f2-4080-9f8d-cf3b031b56ff"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256468, 6317, 211, 10, 44, "Subsubsection",ExpressionUUID->"bfcfa38e-8eff-4153-b840-fc7899594a34"],
Cell[CellGroupData[{
Cell[256704, 6331, 200, 3, 28, "Input",ExpressionUUID->"f72bb924-ba7e-43c8-b4ff-9f18ed4125a1"],
Cell[256907, 6336, 312, 5, 52, "Output",ExpressionUUID->"572c5477-cbb3-4170-b8c3-6a199ba1bc1b"]
}, Open  ]],
Cell[257234, 6344, 262, 4, 34, "Text",ExpressionUUID->"b0e1782d-e117-4d27-b4e4-63756b3a10b8"],
Cell[CellGroupData[{
Cell[257521, 6352, 295, 6, 28, "Input",ExpressionUUID->"27724928-e009-44f8-8fcd-fb33350b8c32"],
Cell[257819, 6360, 2391, 56, 212, "Output",ExpressionUUID->"31e29a5a-7dce-4d3a-867a-815704bf942b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[260247, 6421, 113, 1, 28, "Input",ExpressionUUID->"c14d5b97-1a64-4530-8600-745d9412aa90"],
Cell[260363, 6424, 553, 9, 138, "Print",ExpressionUUID->"8858f879-1d7a-45d7-8439-565566841b9d",
 CellTags->"Info3203735558484-8910602"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[260965, 6439, 229, 10, 44, "Subsubsection",ExpressionUUID->"1c7717ab-6835-45ec-a377-0deeaeae8771"],
Cell[261197, 6451, 317, 8, 34, "Text",ExpressionUUID->"bf3dadba-b76a-4c20-8787-8f0e0a4e6374"],
Cell[CellGroupData[{
Cell[261539, 6463, 198, 3, 28, "Input",ExpressionUUID->"2c913406-c227-4da4-9ec8-e1a7057d04ed"],
Cell[261740, 6468, 337, 5, 71, "Output",ExpressionUUID->"fea39f16-20ea-4ba0-8baf-63d3633320df"]
}, Open  ]],
Cell[CellGroupData[{
Cell[262114, 6478, 268, 6, 28, "Input",ExpressionUUID->"429d3601-9cd1-4581-a86e-fb7e58818908"],
Cell[262385, 6486, 184, 5, 32, "Output",ExpressionUUID->"6c2927bf-6a49-486a-b5ab-eb52241f0ed9"]
}, Open  ]],
Cell[262584, 6494, 122, 0, 34, "Text",ExpressionUUID->"80f16469-0b0e-49c1-998f-8f44602d7c3c"],
Cell[CellGroupData[{
Cell[262731, 6498, 396, 8, 28, "Input",ExpressionUUID->"3cce4913-ec73-43d6-9667-f5ded62c00c5"],
Cell[263130, 6508, 300, 4, 52, "Output",ExpressionUUID->"2f9957f2-335d-4abd-8605-9e802439f141"]
}, Open  ]],
Cell[CellGroupData[{
Cell[263467, 6517, 122, 1, 28, "Input",ExpressionUUID->"87ddbe7a-8af9-4b56-9803-46f18424c357"],
Cell[263592, 6520, 526, 7, 52, "Output",ExpressionUUID->"d0e475ba-c5f7-4540-bfea-098a94b450ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264155, 6532, 295, 6, 28, "Input",ExpressionUUID->"f9487182-b928-4f20-8719-852eeb72c2ad"],
Cell[264453, 6540, 204, 3, 23, "Print",ExpressionUUID->"f57ce141-62b5-441b-b0a0-885a51ba3d79"],
Cell[264660, 6545, 147, 2, 32, "Output",ExpressionUUID->"7fc9ff33-60ff-4bd4-aa6c-2cba9742f5da"]
}, Open  ]],
Cell[264822, 6550, 264, 6, 56, "Text",ExpressionUUID->"8a622e29-599f-480b-84da-1f647c5dde89"],
Cell[CellGroupData[{
Cell[265111, 6560, 209, 4, 28, "Input",ExpressionUUID->"87ecd9ea-9672-4897-82de-e43b7adc3290"],
Cell[265323, 6566, 310, 8, 32, "Output",ExpressionUUID->"3ec7434c-ce5b-4a8a-988a-dc95f6bd2448"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[265682, 6580, 211, 10, 44, "Subsubsection",ExpressionUUID->"577b03bb-835e-4cf4-b27b-398478cb9b45"],
Cell[CellGroupData[{
Cell[265918, 6594, 231, 6, 28, "Input",ExpressionUUID->"de37d6b6-4a73-449a-9109-43762d380453"],
Cell[266152, 6602, 265, 4, 52, "Output",ExpressionUUID->"1e085599-e596-4125-a59f-93cd078ba00d"]
}, Open  ]],
Cell[266432, 6609, 2355, 37, 342, "Text",ExpressionUUID->"65218399-5420-439f-82f6-334d0ca5af43"],
Cell[CellGroupData[{
Cell[268812, 6650, 125, 1, 28, "Input",ExpressionUUID->"27137d26-99e8-467e-8b99-ab23318c61fb"],
Cell[268940, 6653, 1392, 40, 52, "Output",ExpressionUUID->"6f0eb0dc-579d-488e-b5c5-3003ecbbde1c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[270369, 6698, 206, 4, 28, "Input",ExpressionUUID->"3d8e91d9-f67d-45a3-b227-2841a23ae434"],
Cell[270578, 6704, 1616, 43, 52, "Output",ExpressionUUID->"f2deaa4b-00eb-4cec-b8ad-a7af1e9b5d3e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[272243, 6753, 218, 10, 44, "Subsubsection",ExpressionUUID->"120640ff-31d5-4752-b7d3-f2557001ba93"],
Cell[CellGroupData[{
Cell[272486, 6767, 206, 4, 28, "Input",ExpressionUUID->"5c7134b6-fda8-4a01-b838-ba675f8a836f"],
Cell[272695, 6773, 390, 6, 71, "Output",ExpressionUUID->"c799b2b6-e075-466d-96a0-2e957c934680"]
}, Open  ]],
Cell[CellGroupData[{
Cell[273122, 6784, 238, 5, 28, "Input",ExpressionUUID->"a1d5e0f2-e0ea-4add-b138-ce760e86a334"],
Cell[273363, 6791, 204, 3, 23, "Print",ExpressionUUID->"e884c791-6ba4-44eb-9965-b092e4dd8c9c"],
Cell[273570, 6796, 146, 2, 32, "Output",ExpressionUUID->"e8c1b188-2642-4dfe-8319-179b0f8d6764"]
}, Open  ]],
Cell[CellGroupData[{
Cell[273753, 6803, 305, 6, 28, "Input",ExpressionUUID->"97af576c-b142-42b7-8785-28c57af50ab3"],
Cell[274061, 6811, 275, 4, 23, "Print",ExpressionUUID->"32e43fe7-00ed-45c7-ae41-23c63579990c"],
Cell[274339, 6817, 187, 3, 32, "Output",ExpressionUUID->"cb98c509-4b8b-4378-a8c7-3abfac1af407"]
}, Open  ]],
Cell[CellGroupData[{
Cell[274563, 6825, 231, 6, 28, "Input",ExpressionUUID->"fe72b4ba-c104-4204-b5d7-264e5ddeae1f"],
Cell[274797, 6833, 339, 5, 71, "Output",ExpressionUUID->"e481164b-8c5b-4d8b-abf0-590cbfc10346"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275173, 6843, 229, 6, 28, "Input",ExpressionUUID->"eac51c33-8ec9-43d3-83cc-27eed0f0465b"],
Cell[275405, 6851, 232, 4, 52, "Output",ExpressionUUID->"b98e37ea-9abe-4883-b369-54e908716ef6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275674, 6860, 229, 6, 28, "Input",ExpressionUUID->"c4114b22-d532-461f-b0b4-5f398e47b988"],
Cell[275906, 6868, 268, 4, 52, "Output",ExpressionUUID->"7c1d6ed8-da81-4be9-ac0c-c0cb15965f21"]
}, Open  ]],
Cell[276189, 6875, 321, 5, 56, "Text",ExpressionUUID->"c55549d5-bedb-4473-9ddb-b846ce9a8c22"],
Cell[276513, 6882, 105, 0, 34, "Text",ExpressionUUID->"ef9926a3-fc40-4c84-9884-15fe428c66da"],
Cell[CellGroupData[{
Cell[276643, 6886, 304, 6, 28, "Input",ExpressionUUID->"b0540536-27a9-459f-b01b-bfbf9da0c64c"],
Cell[276950, 6894, 188, 3, 23, "Print",ExpressionUUID->"22860f58-9f54-4afe-8c59-3480d3835f53"],
Cell[277141, 6899, 173, 3, 32, "Output",ExpressionUUID->"146efc4d-6981-4a0d-bf38-969c62f46e56"]
}, Open  ]],
Cell[277329, 6905, 1006, 18, 122, "Text",ExpressionUUID->"7b97a3ee-4356-4de3-8bef-238b635ea697"]
}, Open  ]],
Cell[CellGroupData[{
Cell[278372, 6928, 223, 10, 44, "Subsubsection",ExpressionUUID->"bf2dd29c-fde9-4502-9277-c3d81896b4b4"],
Cell[278598, 6940, 148, 2, 34, "Text",ExpressionUUID->"533cc1d7-9f7e-4133-a40c-b3fab7e02638"],
Cell[CellGroupData[{
Cell[278771, 6946, 192, 3, 28, "Input",ExpressionUUID->"1eac009e-0932-4b3f-afeb-0b08cf277a86"],
Cell[278966, 6951, 398, 6, 52, "Output",ExpressionUUID->"1b652533-24d8-4138-8371-cb30c7e10fc6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[279401, 6962, 193, 3, 28, "Input",ExpressionUUID->"0c458b29-0d1a-4a70-ad4d-630c25e3dffc"],
Cell[279597, 6967, 470, 7, 71, "Output",ExpressionUUID->"6504b30e-d66b-4788-84ee-03d196595e24"]
}, Open  ]],
Cell[280082, 6977, 414, 6, 78, "Text",ExpressionUUID->"78239c5d-2f96-4d68-b710-1b0f3fe389c8"],
Cell[CellGroupData[{
Cell[280521, 6987, 373, 7, 28, "Input",ExpressionUUID->"fed8c7db-d25d-4fbc-a2dd-32d89a7201c3"],
Cell[CellGroupData[{
Cell[280919, 6998, 170, 3, 23, "Print",ExpressionUUID->"8e07e28e-ba91-47ce-a37e-af7fc13638a6"],
Cell[281092, 7003, 188, 3, 23, "Print",ExpressionUUID->"94d6e026-0397-44c0-a7cb-7579fc894337"]
}, Open  ]],
Cell[281295, 7009, 173, 3, 32, "Output",ExpressionUUID->"9520b2db-416f-4f04-8cec-a4a505be5e20"]
}, Open  ]],
Cell[281483, 7015, 923, 18, 122, "Text",ExpressionUUID->"427b99d5-92ea-4bac-8866-d9dd46e9e251"],
Cell[CellGroupData[{
Cell[282431, 7037, 231, 5, 28, "Input",ExpressionUUID->"ab278507-5365-491b-b704-a6ca33955c44"],
Cell[282665, 7044, 283, 4, 23, "Print",ExpressionUUID->"d1029c5c-5509-4e14-92fc-aa56993cc4e3"],
Cell[282951, 7050, 296, 4, 32, "Output",ExpressionUUID->"6698af76-73fe-436e-9254-b0c66c2e847c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[283308, 7061, 186, 7, 53, "Subsection",ExpressionUUID->"d52264bd-fb2b-4606-b62a-03df387f0394"],
Cell[283497, 7070, 147, 2, 34, "Text",ExpressionUUID->"6e0ce7fd-115c-4883-9864-aa2eab5ffbe2"],
Cell[283647, 7074, 672, 15, 78, "Text",ExpressionUUID->"ba4817bf-88ee-4376-80dd-877f1a0300e1"],
Cell[CellGroupData[{
Cell[284344, 7093, 168, 3, 28, "Input",ExpressionUUID->"23f34578-6c0a-4e92-b004-5441bdd92766"],
Cell[284515, 7098, 523, 14, 32, "Output",ExpressionUUID->"5f9fd6ed-64ce-47e8-9b23-0f02502c1bd9"]
}, Open  ]],
Cell[285053, 7115, 174, 3, 34, "Text",ExpressionUUID->"671d5261-f175-4ce6-b6c1-3405726421af"],
Cell[CellGroupData[{
Cell[285252, 7122, 291, 6, 28, "Input",ExpressionUUID->"519192b8-d85f-4c34-b83b-b49327517603"],
Cell[285546, 7130, 518, 14, 32, "Output",ExpressionUUID->"ab3dbe16-46a6-4572-bb2b-60ed2806a4c2"]
}, Open  ]],
Cell[286079, 7147, 880, 12, 100, "Text",ExpressionUUID->"7adcc57d-63d2-4f5e-8815-f49cb0ae3ca9"],
Cell[286962, 7161, 309, 6, 56, "Text",ExpressionUUID->"aaabb330-5444-494b-a8c6-1e2c0b52adfa"],
Cell[CellGroupData[{
Cell[287296, 7171, 377, 9, 28, "Input",ExpressionUUID->"9350569b-a058-497a-aeeb-37b642c0a4cc"],
Cell[287676, 7182, 10576, 272, 244, "Output",ExpressionUUID->"a924c0f9-4d82-4591-aa5f-66f171b6e664"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[298301, 7460, 173, 7, 53, "Subsection",ExpressionUUID->"d610a309-632e-4334-9c3e-8df7e7138c9d"],
Cell[298477, 7469, 870, 13, 144, "Text",ExpressionUUID->"4d62e208-a8a0-499e-a62f-da719cfb0872"],
Cell[CellGroupData[{
Cell[299372, 7486, 221, 4, 28, "Input",ExpressionUUID->"a203be12-0f2f-415a-911e-ab93b7524e11"],
Cell[299596, 7492, 208, 4, 32, "Output",ExpressionUUID->"449328d6-f233-491b-a750-8c532b4a74f0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[299841, 7501, 317, 8, 28, "Input",ExpressionUUID->"9a3bb9ba-0003-4f5f-ac91-20e54537eae7"],
Cell[300161, 7511, 132, 1, 32, "Output",ExpressionUUID->"2902bc21-4145-4dc0-8957-b24e8de43147"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300330, 7517, 122, 1, 28, "Input",ExpressionUUID->"11c57439-05ca-49ac-8b06-4c499954a9c7"],
Cell[300455, 7520, 215, 3, 32, "Output",ExpressionUUID->"ec29b6f3-9800-4299-a299-6e6b77c366ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300707, 7528, 155, 3, 28, "Input",ExpressionUUID->"6f40e717-ac9c-4f74-9f2a-34527cd7f432"],
Cell[300865, 7533, 155, 3, 32, "Output",ExpressionUUID->"f01e145a-d517-4792-8a40-04f6d8e6e676"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301057, 7541, 122, 1, 28, "Input",ExpressionUUID->"c9ab698b-937b-4648-b486-5da0e7055f8e"],
Cell[301182, 7544, 218, 3, 32, "Output",ExpressionUUID->"d4b769da-514c-4a19-8378-b60ebbd8d19a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301437, 7552, 312, 6, 28, "Input",ExpressionUUID->"51f74d66-71aa-4489-8a0d-1b7fd7df9547"],
Cell[301752, 7560, 169, 3, 32, "Output",ExpressionUUID->"5ec963b8-8068-4f3b-9d83-4fef55c4b32a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301958, 7568, 122, 1, 28, "Input",ExpressionUUID->"9b461c04-78c9-4abd-817e-8c86720540c3"],
Cell[302083, 7571, 565, 8, 32, "Output",ExpressionUUID->"74042ddb-9996-459b-b26b-7af510a58bc2"]
}, Open  ]],
Cell[302663, 7582, 181, 3, 34, "Text",ExpressionUUID->"8728c911-cad2-4cc0-a0db-0481cae92bb2"],
Cell[CellGroupData[{
Cell[302869, 7589, 235, 4, 28, "Input",ExpressionUUID->"1e25a513-eb49-40dd-b5d8-688b93869fc7"],
Cell[303107, 7595, 192, 5, 32, "Output",ExpressionUUID->"186e2e45-e142-421a-862b-1370995f23af"]
}, Open  ]],
Cell[303314, 7603, 771, 13, 100, "Text",ExpressionUUID->"50272a56-cb4b-42e2-a3a1-18b8fcd86a8f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[304122, 7621, 190, 7, 53, "Subsection",ExpressionUUID->"2c839bff-5816-4ab6-a62a-bc3a75388acc"],
Cell[304315, 7630, 905, 16, 144, "Text",ExpressionUUID->"a471d5b9-d4bd-434d-97e5-02dbc9520eaf"],
Cell[CellGroupData[{
Cell[305245, 7650, 147, 3, 28, "Input",ExpressionUUID->"28de830a-cb09-4362-b742-34a1811f2d33"],
Cell[305395, 7655, 144, 2, 32, "Output",ExpressionUUID->"5d6af71e-4415-4b81-9a8c-ebcec70e60c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305576, 7662, 150, 3, 28, "Input",ExpressionUUID->"77a23d31-eafc-4a72-9223-1868609158d7"],
Cell[305729, 7667, 136, 2, 32, "Output",ExpressionUUID->"31dab452-dcb5-4aaf-8eb0-c75989ada4b7"]
}, Open  ]],
Cell[305880, 7672, 262, 4, 56, "Text",ExpressionUUID->"7bc19437-b8f1-40fa-9a83-e6e52eb892e1"],
Cell[CellGroupData[{
Cell[306167, 7680, 237, 5, 28, "Input",ExpressionUUID->"d6d6d585-1815-4f73-b396-d26e89704b87"],
Cell[306407, 7687, 180, 3, 32, "Output",ExpressionUUID->"93b51bf0-29af-4045-9cb8-1a91078168ac"]
}, Open  ]],
Cell[306602, 7693, 258, 6, 28, "Input",ExpressionUUID->"b2505de1-69e1-4138-83ab-9ac52eac2f94"],
Cell[306863, 7701, 336, 5, 78, "Text",ExpressionUUID->"842e47bd-4fd5-4684-a56a-3578489d5e66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307236, 7711, 193, 7, 53, "Subsection",ExpressionUUID->"89f798e5-7158-4d21-9635-4e216995d9cc"],
Cell[307432, 7720, 433, 8, 78, "Text",ExpressionUUID->"dd37f37e-f5b4-425e-b7a8-f00970fe4b77"],
Cell[CellGroupData[{
Cell[307890, 7732, 114, 1, 28, "Input",ExpressionUUID->"cdbb4338-37fc-44f4-aa5f-e9eb7c1effce"],
Cell[308007, 7735, 1090, 16, 368, "Print",ExpressionUUID->"8de12c97-deb1-4417-8d0d-39e7cdf00e10",
 CellTags->"Info3563735558490-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309134, 7756, 130, 1, 28, "Input",ExpressionUUID->"75651a1d-db11-489a-a776-6079e909cc57"],
Cell[309267, 7759, 659, 15, 79, "Output",ExpressionUUID->"160f35b7-8acb-4496-8834-fe39da6ec927"]
}, Open  ]],
Cell[309941, 7777, 738, 11, 122, "Text",ExpressionUUID->"7abed85f-854c-4663-ab4d-674f8ba08871"],
Cell[CellGroupData[{
Cell[310704, 7792, 125, 1, 28, "Input",ExpressionUUID->"e7474b9e-2a22-4c4b-9ea5-b008088b2481"],
Cell[310832, 7795, 200, 3, 32, "Output",ExpressionUUID->"a55b1c3f-3048-46b5-a1ea-0da3030a3a27"]
}, Open  ]],
Cell[311047, 7801, 485, 9, 56, "Text",ExpressionUUID->"323f7715-0a7a-4d5f-896b-abc9f6162559"],
Cell[CellGroupData[{
Cell[311557, 7814, 274, 5, 28, "Input",ExpressionUUID->"1399e4fb-35e9-4456-a3fd-5b14957a5abb"],
Cell[311834, 7821, 1543, 42, 52, "Output",ExpressionUUID->"5df2917a-7b13-41d1-a5a8-fe21af36cff2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[313438, 7870, 170, 5, 67, "Section",ExpressionUUID->"2d7a5ff0-d2f5-4ced-a2c3-513dbfa99e8d",
 PageBreakAbove->True],
Cell[CellGroupData[{
Cell[313633, 7879, 203, 7, 53, "Subsection",ExpressionUUID->"4d7c4b3a-17ab-4146-8188-551e2d7e93fd"],
Cell[313839, 7888, 205, 3, 34, "Text",ExpressionUUID->"78f7194e-cb6d-42ca-814d-7cba50aceac0"],
Cell[314047, 7893, 280, 4, 56, "Text",ExpressionUUID->"a6b2d513-0624-4944-b85c-82df51946ffb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[314364, 7902, 213, 7, 53, "Subsection",ExpressionUUID->"5f26de3e-815c-4204-9797-7e2829cc5b59"],
Cell[314580, 7911, 675, 13, 78, "Text",ExpressionUUID->"5045cc95-3d77-415d-b75e-6751e80ee4e6"],
Cell[315258, 7926, 884, 12, 100, "Text",ExpressionUUID->"e35cbe32-b7bc-4b50-b979-ed5915239799"],
Cell[316145, 7940, 444, 8, 56, "Text",ExpressionUUID->"ceda04e7-3de3-40fe-b4f8-8bdde2ccbde0"],
Cell[CellGroupData[{
Cell[316614, 7952, 296, 7, 28, "Input",ExpressionUUID->"bf757e00-5d89-4975-a80e-e609efeb849d"],
Cell[316913, 7961, 1600, 43, 72, "Output",ExpressionUUID->"fefe5dec-94ba-455a-9e99-01a40b59e3e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[318550, 8009, 295, 7, 28, "Input",ExpressionUUID->"18cbe1de-7899-4e94-b60d-e2d3b286cede"],
Cell[318848, 8018, 1603, 43, 72, "Output",ExpressionUUID->"00f78b01-c7aa-4f00-862f-76f978db7da1"]
}, Open  ]],
Cell[320466, 8064, 230, 4, 34, "Text",ExpressionUUID->"3a882b1b-51bf-40c0-a02b-04b6f09f1267"],
Cell[CellGroupData[{
Cell[320721, 8072, 339, 6, 28, "Input",ExpressionUUID->"d572e1f9-ba66-42c8-9262-6d08c44b5fa3"],
Cell[321063, 8080, 210, 4, 32, "Output",ExpressionUUID->"12f15de7-0f06-451e-b89b-6765b70447d5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[321310, 8089, 274, 5, 28, "Input",ExpressionUUID->"4cd7c5b9-2ff3-4bbc-a2fa-9d1923525781"],
Cell[321587, 8096, 207, 4, 32, "Output",ExpressionUUID->"f3e337f9-d3f6-4538-8cea-79c1771c6ac8"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[321843, 8106, 178, 7, 53, "Subsection",ExpressionUUID->"183a3b28-619d-4193-bbbe-ccf92b602ce1"],
Cell[322024, 8115, 1444, 21, 166, "Text",ExpressionUUID->"62466aab-1081-42ea-ba5f-93081ac762ad"],
Cell[CellGroupData[{
Cell[323493, 8140, 273, 5, 28, "Input",ExpressionUUID->"138c00a2-c203-4759-98b8-1ef7843a2db4"],
Cell[323769, 8147, 185, 3, 32, "Output",ExpressionUUID->"0c3e68b5-dd54-45ec-acc9-d7e5f749ab6e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[323991, 8155, 376, 9, 28, "Input",ExpressionUUID->"a0fb5996-6ef1-49c6-9a49-28609f451ee7"],
Cell[324370, 8166, 2199, 53, 152, "Output",ExpressionUUID->"dd420557-72fb-4226-af91-89c2830eda2b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[326618, 8225, 186, 7, 53, "Subsection",ExpressionUUID->"1abcc975-788a-4d14-8709-d89727745e21"],
Cell[326807, 8234, 326, 5, 56, "Text",ExpressionUUID->"a4ba592d-3821-4c45-bf7c-d161b32033b2"],
Cell[CellGroupData[{
Cell[327158, 8243, 211, 4, 28, "Input",ExpressionUUID->"6164de74-30aa-45c9-8f4c-c6b3ded4cd7d"],
Cell[327372, 8249, 449, 9, 21, "Message",ExpressionUUID->"244a4817-dd82-4943-9b85-80a6a4c4c821"],
Cell[327824, 8260, 347, 8, 21, "Message",ExpressionUUID->"78018439-5283-42bd-b1e9-b6295bd72b57"],
Cell[328174, 8270, 452, 9, 21, "Message",ExpressionUUID->"95069f8c-d453-45d1-9593-20307902eb27"],
Cell[328629, 8281, 140, 2, 32, "Output",ExpressionUUID->"5994833f-4942-40d6-82f5-42432f94e849"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[328818, 8289, 188, 7, 53, "Subsection",ExpressionUUID->"596e53ca-78ab-467a-9396-1652c9850903"],
Cell[329009, 8298, 657, 9, 78, "Text",ExpressionUUID->"cbfc868e-f52a-437f-a415-c74355861ebe"],
Cell[CellGroupData[{
Cell[329691, 8311, 211, 4, 28, "Input",ExpressionUUID->"485648cf-c4d4-4846-bfb4-0fe5ccbc84fc"],
Cell[329905, 8317, 208, 4, 32, "Output",ExpressionUUID->"ff429b99-6b52-4de9-8445-d284064d7631"]
}, Open  ]],
Cell[330128, 8324, 542, 8, 78, "Text",ExpressionUUID->"14b6b826-4873-4807-a838-4260539f463e"],
Cell[CellGroupData[{
Cell[330695, 8336, 332, 9, 28, "Input",ExpressionUUID->"873fb840-e33f-419f-80d3-33bc7704c805"],
Cell[331030, 8347, 528, 9, 32, "Output",ExpressionUUID->"2bdeb46d-3296-43ad-9fc5-ebec17e9952c"]
}, Open  ]],
Cell[331573, 8359, 811, 11, 144, "Text",ExpressionUUID->"6f3835ba-d5b1-44b3-816f-64c2f0a57a7e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[332433, 8376, 161, 4, 67, "Section",ExpressionUUID->"e1fea622-f753-4367-936c-bd734cc1de0b"],
Cell[CellGroupData[{
Cell[332619, 8384, 185, 7, 53, "Subsection",ExpressionUUID->"6758d142-8eb3-47e6-9e07-d235889f2d76"],
Cell[332807, 8393, 350, 7, 56, "Text",ExpressionUUID->"6f53edec-04f0-4aa6-b590-a56a24096b10"],
Cell[333160, 8402, 621, 11, 78, "Text",ExpressionUUID->"4b6a94ee-86c2-4660-9c3c-ebfbaa457923"],
Cell[333784, 8415, 884, 18, 100, "Text",ExpressionUUID->"51576d3c-0df9-4d6a-9b34-91dafd6e8d70"]
}, Open  ]],
Cell[CellGroupData[{
Cell[334705, 8438, 201, 7, 53, "Subsection",ExpressionUUID->"b494d542-83c3-47a4-8f96-f573429e96bf"],
Cell[334909, 8447, 651, 12, 100, "Text",ExpressionUUID->"742a3c1b-6ae7-406b-b564-b5f949cd76fb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[335597, 8464, 224, 7, 53, "Subsection",ExpressionUUID->"fb851263-042e-491b-903b-15193303fbd1"],
Cell[335824, 8473, 378, 9, 56, "Text",ExpressionUUID->"cf47758e-b908-4332-9efd-f15401c26a8e"],
Cell[336205, 8484, 649, 13, 78, "Text",ExpressionUUID->"ad69172d-b077-4695-ae6e-619bada6b3b8"],
Cell[CellGroupData[{
Cell[336879, 8501, 139, 2, 28, "Input",ExpressionUUID->"dbb52ca6-d3df-4ddf-b3b7-4c93e191ec54"],
Cell[337021, 8505, 315, 6, 32, "Output",ExpressionUUID->"4710742a-7693-40b7-b2bb-b35b006bafaf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337373, 8516, 202, 10, 44, "Subsubsection",ExpressionUUID->"aaa972ce-49ec-40a1-910b-cf8babdbd3e1"],
Cell[CellGroupData[{
Cell[337600, 8530, 275, 5, 28, "Input",ExpressionUUID->"ee6aecc4-f097-4c31-891a-84960057a2f1"],
Cell[337878, 8537, 350, 6, 32, "Output",ExpressionUUID->"74d6ee97-d2aa-47f6-a7ac-3dfd747dfbe8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[338265, 8548, 138, 2, 28, "Input",ExpressionUUID->"72760207-0adc-4a09-8902-ca3b6c943310"],
Cell[338406, 8552, 1759, 39, 90, "Output",ExpressionUUID->"430510ba-900e-407b-80e7-b9bb9cfd50bd"]
}, Open  ]],
Cell[340180, 8594, 368, 5, 56, "Text",ExpressionUUID->"28a7c548-46c5-4532-8ec4-2c186803640b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[340585, 8604, 202, 10, 44, "Subsubsection",ExpressionUUID->"1579d653-e35b-4af1-a304-46e98baf9719"],
Cell[340790, 8616, 143, 4, 34, "Text",ExpressionUUID->"7cf30f7a-3734-4661-a55f-156b0b789b24"],
Cell[CellGroupData[{
Cell[340958, 8624, 275, 5, 28, "Input",ExpressionUUID->"3db2a3dc-7389-4024-8f35-0238202a0108"],
Cell[341236, 8631, 345, 6, 32, "Output",ExpressionUUID->"c67dd99e-1c30-4ff5-9fa1-8fc8fd91925f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[341618, 8642, 138, 2, 28, "Input",ExpressionUUID->"19e744cc-e87b-44da-b1f9-6bde59f8c259"],
Cell[341759, 8646, 1750, 39, 90, "Output",ExpressionUUID->"868bc1dc-81e9-4763-9efe-dc3a417d8876"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[343558, 8691, 201, 10, 44, "Subsubsection",ExpressionUUID->"4a9d7e87-af79-40f5-b51a-c5773e754b59"],
Cell[343762, 8703, 284, 4, 34, "Text",ExpressionUUID->"e3c52393-08c8-4358-ac21-402a66c4fd24"],
Cell[CellGroupData[{
Cell[344071, 8711, 274, 5, 28, "Input",ExpressionUUID->"383911b0-a6f4-4369-ba43-5c01e54c3761"],
Cell[344348, 8718, 352, 6, 32, "Output",ExpressionUUID->"b30ea837-e4a1-455b-84d7-04137f12659e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[344737, 8729, 269, 6, 28, "Input",ExpressionUUID->"d4e17437-559e-459a-9b2b-9191ac82eb1d"],
Cell[345009, 8737, 1738, 39, 90, "Output",ExpressionUUID->"9d5156b7-dcfc-4da5-ab0f-06bf9d12ac7b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[346796, 8782, 202, 10, 44, "Subsubsection",ExpressionUUID->"fc781194-64c2-4e63-ae59-4ba62fc56f48"],
Cell[347001, 8794, 142, 4, 34, "Text",ExpressionUUID->"89482403-536c-4995-9d86-c6e8bb86a548"],
Cell[CellGroupData[{
Cell[347168, 8802, 275, 5, 28, "Input",ExpressionUUID->"85653b2f-c7c3-4b11-9f79-4f5ad37126b7"],
Cell[347446, 8809, 342, 5, 32, "Output",ExpressionUUID->"14cbb1f8-f746-4d08-86de-2fe856a56805"]
}, Open  ]],
Cell[347803, 8817, 553, 8, 56, "Text",ExpressionUUID->"72555d02-bee0-4d91-9393-bc1b6e2e3237"],
Cell[CellGroupData[{
Cell[348381, 8829, 138, 2, 28, "Input",ExpressionUUID->"9ab506bb-f607-4ffb-a2dd-eb91d1f94230"],
Cell[348522, 8833, 1729, 39, 90, "Output",ExpressionUUID->"56c7ac45-d114-4fe5-b9a2-76ad0b96d747"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[350312, 8879, 212, 7, 53, "Subsection",ExpressionUUID->"25d50d3d-624e-417a-96e6-bd8862e7a4fc"],
Cell[350527, 8888, 130, 0, 34, "Text",ExpressionUUID->"f67b6737-c7fa-42f5-88b0-0b430dffa3a4"],
Cell[CellGroupData[{
Cell[350682, 8892, 203, 10, 44, "Subsubsection",ExpressionUUID->"8acb519d-5f47-4d8e-baba-d5f7f3b5d713"],
Cell[CellGroupData[{
Cell[350910, 8906, 195, 4, 28, "Input",ExpressionUUID->"536e2c58-c401-42f1-a24c-e4c491db530a"],
Cell[351108, 8912, 172, 4, 32, "Output",ExpressionUUID->"62a5c37a-017a-41df-9253-75b8145026f4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[351317, 8921, 212, 4, 28, "Input",ExpressionUUID->"5cfdba16-5d1c-440c-9b85-6aa1281840a4"],
Cell[351532, 8927, 449, 9, 21, "Message",ExpressionUUID->"3f9db840-5f3f-440f-b9ff-359865fabfb5"],
Cell[351984, 8938, 347, 8, 21, "Message",ExpressionUUID->"e7609f3d-238c-481c-8d7f-5c0528cdb37b"],
Cell[352334, 8948, 452, 9, 21, "Message",ExpressionUUID->"fb331628-44b0-4704-9c5c-df9fea313650"],
Cell[352789, 8959, 188, 3, 32, "Output",ExpressionUUID->"b90635a4-e8b4-4959-862c-e032b6ff88a6"]
}, Open  ]],
Cell[352992, 8965, 322, 5, 56, "Text",ExpressionUUID->"122bba55-5789-4b04-9870-6b6796c8732c"],
Cell[CellGroupData[{
Cell[353339, 8974, 278, 5, 28, "Input",ExpressionUUID->"41e4631c-c7cb-4861-b360-9213093d7a28"],
Cell[353620, 8981, 192, 3, 32, "Output",ExpressionUUID->"8d2d1706-e5d2-4427-a730-322e6ba83967"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353849, 8989, 139, 2, 28, "Input",ExpressionUUID->"e9af56f4-f4c1-4c9e-9f9d-529e033c10c5"],
Cell[353991, 8993, 1690, 37, 71, "Output",ExpressionUUID->"3537e7c6-dde8-4b6b-b6f3-6efa4b7d1a07"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[355730, 9036, 203, 10, 44, "Subsubsection",ExpressionUUID->"0a84e608-3397-41ef-b547-9b68251aa026"],
Cell[CellGroupData[{
Cell[355958, 9050, 194, 4, 28, "Input",ExpressionUUID->"cf4c5eb1-7c95-445f-b9c5-13f691e93580"],
Cell[356155, 9056, 172, 4, 32, "Output",ExpressionUUID->"429df6d2-a5a0-4962-aa10-febcd3c99d97"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356364, 9065, 212, 4, 28, "Input",ExpressionUUID->"0e5d0241-bf2b-4e5d-83c7-de01caf2b487"],
Cell[356579, 9071, 449, 9, 21, "Message",ExpressionUUID->"1b56ff38-88df-48fd-9b71-7ea4a4068a49"],
Cell[357031, 9082, 347, 8, 21, "Message",ExpressionUUID->"62964fd9-d1be-4c88-a60b-1040db669bc8"],
Cell[357381, 9092, 452, 9, 21, "Message",ExpressionUUID->"8a77cb85-cb99-427e-a4f4-8d83c087efe2"],
Cell[357836, 9103, 186, 3, 32, "Output",ExpressionUUID->"b6666624-978f-4c26-add7-24aa9465e626"]
}, Open  ]],
Cell[358037, 9109, 179, 3, 34, "Text",ExpressionUUID->"2fd86e17-ce91-4115-b1fa-255bb1b8beae"],
Cell[CellGroupData[{
Cell[358241, 9116, 276, 5, 28, "Input",ExpressionUUID->"4236bac8-9f4a-4d6d-a4aa-8cab0394a3fb"],
Cell[358520, 9123, 186, 3, 32, "Output",ExpressionUUID->"4af968c7-9996-4fd2-bcb7-9499a286c4ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358743, 9131, 139, 2, 28, "Input",ExpressionUUID->"bfb94494-596e-4098-bac5-18153229f429"],
Cell[358885, 9135, 1700, 37, 71, "Output",ExpressionUUID->"1cb98c1c-07c4-426b-872a-8e19307b15de"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[360646, 9179, 172, 7, 53, "Subsection",ExpressionUUID->"08fb5a69-fe46-4f6d-a62f-704ba076758f"],
Cell[360821, 9188, 540, 8, 56, "Text",ExpressionUUID->"60c9e0d5-9b7d-4afa-b9c5-da6cce09c03c"],
Cell[CellGroupData[{
Cell[361386, 9200, 214, 4, 28, "Input",ExpressionUUID->"ec1867e7-6370-47a8-8a05-3f3a75fedaba"],
Cell[361603, 9206, 206, 5, 33, "Output",ExpressionUUID->"bd945940-6ddf-41f8-938e-76f35964e5e6"]
}, Open  ]],
Cell[361824, 9214, 81, 0, 34, "Text",ExpressionUUID->"599c55f4-7f88-48f7-9623-5027bcceb6a0"],
Cell[361908, 9216, 233, 4, 32, "Output",ExpressionUUID->"0c5854e9-777c-4bd0-a633-cac2e9a02c64"],
Cell[362144, 9222, 114, 0, 34, "Text",ExpressionUUID->"58e44784-e667-4107-a6a4-b4afcbb52203"],
Cell[362261, 9224, 127, 1, 28, "Input",ExpressionUUID->"ade85c21-46c1-4aca-9679-a98d87c177ae"],
Cell[CellGroupData[{
Cell[362413, 9229, 136, 2, 28, "Input",ExpressionUUID->"3ab0f6df-09cc-47dd-a0ec-2d4c939891b2"],
Cell[362552, 9233, 125, 1, 32, "Output",ExpressionUUID->"dea5f31b-91b0-4e04-9870-654248e40164"]
}, Open  ]],
Cell[362692, 9237, 113, 1, 28, "Input",ExpressionUUID->"82f82ffe-72fa-447a-886b-b3feba7d08b6"],
Cell[362808, 9240, 179, 3, 34, "Text",ExpressionUUID->"67a75296-3a47-42de-b71e-7550ff3afd9c"],
Cell[362990, 9245, 185, 3, 34, "Text",ExpressionUUID->"a48c2e70-5a0a-4431-9db2-9d1a146d1787"],
Cell[363178, 9250, 508, 7, 100, "Text",ExpressionUUID->"eac9fc44-d942-4691-93ba-d10d14774ae0"],
Cell[363689, 9259, 222, 3, 56, "Text",ExpressionUUID->"2235641a-718d-46bf-a92d-bac9faecdd6e"],
Cell[363914, 9264, 154, 2, 34, "Text",ExpressionUUID->"e127b468-60d6-4cb9-a266-87b529380f44"],
Cell[364071, 9268, 147, 2, 34, "Text",ExpressionUUID->"35533db6-3a49-4733-8ded-5ba0383aa456"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[364267, 9276, 134, 4, 67, "Section",ExpressionUUID->"edcf5474-4dff-4ae6-baaa-b82c1183eb9d"],
Cell[364404, 9282, 719, 11, 122, "Text",ExpressionUUID->"473ff43a-16dc-4fb4-bcce-a3748e2b64b7"],
Cell[365126, 9295, 181, 3, 34, "Text",ExpressionUUID->"2ac6ff94-de6f-4895-8298-9125f233cc34"],
Cell[365310, 9300, 97, 0, 34, "Text",ExpressionUUID->"310b9c21-96eb-4b21-ad41-083a3b36a4e4"],
Cell[CellGroupData[{
Cell[365432, 9304, 202, 4, 28, "Input",ExpressionUUID->"ccb1aaf0-24b0-48ee-975d-63fd22517ee3"],
Cell[365637, 9310, 3064, 66, 232, "Output",ExpressionUUID->"099dfeb3-1a5d-49cf-8d5f-b4f959c53412"]
}, Open  ]],
Cell[368716, 9379, 124, 0, 34, "Text",ExpressionUUID->"ceadd5ef-47ba-4673-a52d-793d6c6d6376"],
Cell[CellGroupData[{
Cell[368865, 9383, 294, 6, 28, "Input",ExpressionUUID->"53613ed5-9e36-46c6-831d-af0076c51482"],
Cell[369162, 9391, 452, 9, 21, "Message",ExpressionUUID->"51a00773-ae14-450f-be64-3df7090a6c31"],
Cell[369617, 9402, 2775, 63, 232, "Output",ExpressionUUID->"cf31245d-e726-4dd3-bd3e-cf58aef652b2"]
}, Open  ]],
Cell[372407, 9468, 184, 3, 34, "Text",ExpressionUUID->"570de7d0-06fa-4fe5-b5d9-5d78fa42c2ac"],
Cell[CellGroupData[{
Cell[372616, 9475, 213, 4, 28, "Input",ExpressionUUID->"5e8328a5-0924-4afe-a07d-008288acd878"],
Cell[372832, 9481, 210, 3, 32, "Output",ExpressionUUID->"20bf2aac-e2ee-4359-be43-16e9b16eb968"]
}, Open  ]],
Cell[373057, 9487, 204, 3, 34, "Text",ExpressionUUID->"64500e90-abc1-4b85-ad17-ff015d40c956"],
Cell[CellGroupData[{
Cell[373286, 9494, 294, 6, 28, "Input",ExpressionUUID->"766f9f2b-8be9-4fe4-87ee-f0d2f11388bd"],
Cell[373583, 9502, 452, 9, 21, "Message",ExpressionUUID->"132003f9-7a86-4efd-b564-cd28946c2ac3"],
Cell[374038, 9513, 449, 9, 21, "Message",ExpressionUUID->"98b99994-1746-4fe6-84c0-8d543e46c2c6"],
Cell[374490, 9524, 347, 8, 21, "Message",ExpressionUUID->"cbee9abb-ef2f-4462-a8b3-f8bd2a930b5e"],
Cell[374840, 9534, 452, 9, 21, "Message",ExpressionUUID->"5ad8f04d-ffe6-4697-8ab0-26e0899bccf7"],
Cell[375295, 9545, 2929, 65, 235, "Output",ExpressionUUID->"262c4324-4edf-4e9a-a494-347106b52018"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[378273, 9616, 129, 4, 67, "Section",ExpressionUUID->"233f5033-1372-48f1-a996-f705e8a997a1"],
Cell[CellGroupData[{
Cell[378427, 9624, 166, 7, 53, "Subsection",ExpressionUUID->"7a4aff8b-d607-4cc5-a944-c7ad338e0de0"],
Cell[378596, 9633, 529, 7, 100, "Text",ExpressionUUID->"85abff96-3fda-41cd-99ec-786f5176c40a"],
Cell[379128, 9642, 616, 9, 122, "Text",ExpressionUUID->"45a5d232-5edd-4566-8013-d22d8bad3ad3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[379781, 9656, 175, 7, 53, "Subsection",ExpressionUUID->"cbd978bd-d431-4999-bd1c-917d5f202355"],
Cell[379959, 9665, 786, 12, 144, "Text",ExpressionUUID->"1bb95773-d6ac-41cd-8eb1-32ebc060c3e0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[380794, 9683, 133, 5, 67, "Section",ExpressionUUID->"45f5643b-ec68-4a7f-8787-941ec93d96ba"],
Cell[380930, 9690, 513, 7, 100, "Text",ExpressionUUID->"64e55278-4438-4e97-bb55-26f6a2bfd1f6"],
Cell[381446, 9699, 1086, 17, 188, "Text",ExpressionUUID->"e9e0e354-1daf-4097-a836-99e14951a183"],
Cell[382535, 9718, 321, 5, 56, "Text",ExpressionUUID->"13cf4498-d369-4a88-82f4-f4e2d8511eec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[382893, 9728, 138, 4, 67, "Section",ExpressionUUID->"513bc467-be63-4800-a382-09c16b8f466a"],
Cell[CellGroupData[{
Cell[383056, 9736, 183, 7, 53, "Subsection",ExpressionUUID->"fd703472-3756-4214-b061-a073caa74ba9"],
Cell[383242, 9745, 184, 3, 34, "Text",ExpressionUUID->"5bab055c-b210-46e1-bd72-f5922c805067"],
Cell[CellGroupData[{
Cell[383451, 9752, 240, 4, 31, "Item",ExpressionUUID->"486c3ddb-96b4-419f-8992-a106d77ceaeb"],
Cell[383694, 9758, 414, 6, 51, "Item",ExpressionUUID->"98aa3ce9-40ab-4bac-9a10-708afca82dc8"],
Cell[384111, 9766, 221, 5, 31, "Item",ExpressionUUID->"a888ca7d-f230-471d-a1c6-87af4fcb0669"],
Cell[384335, 9773, 491, 8, 51, "Item",ExpressionUUID->"48a93b44-5e4a-45c5-a136-2bc1989235fd"],
Cell[384829, 9783, 980, 23, 91, "Item",ExpressionUUID->"2546648c-6000-4189-ba54-4f88122def4c"],
Cell[385812, 9808, 288, 8, 31, "Item",ExpressionUUID->"851b5fed-b310-41dc-ad2f-bfc00af76256"],
Cell[386103, 9818, 256, 4, 51, "Item",ExpressionUUID->"3e7ad84c-8180-4099-8a78-92ac3d3d5d9c"],
Cell[386362, 9824, 245, 5, 31, "Item",ExpressionUUID->"9adf5948-cee4-4bde-b6a5-532a944717d2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[386656, 9835, 163, 7, 53, "Subsection",ExpressionUUID->"0c731fb5-ad82-4f1d-8612-ed2c5d3126e5"],
Cell[386822, 9844, 87, 0, 34, "Text",ExpressionUUID->"6867e9af-71db-4a29-9e21-29f09e250d1e"],
Cell[CellGroupData[{
Cell[386934, 9848, 128, 1, 28, "Input",ExpressionUUID->"78e3d9df-7302-4292-927a-fc22e950cc12"],
Cell[387065, 9851, 4768, 124, 148, "Print",ExpressionUUID->"9a85fdf0-9c18-471c-9b82-f7de82bee067"]
}, Open  ]],
Cell[CellGroupData[{
Cell[391870, 9980, 120, 1, 28, "Input",ExpressionUUID->"23c7e892-83b9-420c-b2f7-668653f680f0"],
Cell[391993, 9983, 193, 3, 45, "Print",ExpressionUUID->"39f94697-1819-460b-afd4-acb4bb55cc88",
 CellTags->"Info3983735558502-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[392223, 9991, 125, 1, 28, "Input",ExpressionUUID->"22e11dca-78fa-4814-a44a-7a3f06fc894d"],
Cell[392351, 9994, 1498, 20, 242, "Output",ExpressionUUID->"9b1132d5-2544-42c1-9b64-61c39a126832"]
}, Open  ]],
Cell[393864, 10017, 156, 2, 34, "Text",ExpressionUUID->"4cb29227-721e-4cb0-849a-b0fc2e16d70c"],
Cell[CellGroupData[{
Cell[394045, 10023, 120, 1, 28, "Input",ExpressionUUID->"75048b2a-6478-4f85-a7ff-1bf12f0c3675"],
Cell[394168, 10026, 1269, 36, 56, "Print",ExpressionUUID->"9b30848a-7ce3-4fe2-8026-3ad7b470aa6c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[395474, 10067, 114, 1, 28, "Input",ExpressionUUID->"32a51c67-e334-4617-b15f-f8f2ea033feb"],
Cell[395591, 10070, 655, 10, 138, "Print",ExpressionUUID->"973b20c2-fc22-4f18-a4d2-6d158517b9a6",
 CellTags->"Info4013735558503-8910602"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[396295, 10086, 172, 7, 53, "Subsection",ExpressionUUID->"2793ed36-aef3-4dc4-87a6-7bffe9bfff86"],
Cell[396470, 10095, 150, 2, 34, "Text",ExpressionUUID->"8b50b5a2-6ab4-4625-93c0-c2a194a09dd0"],
Cell[CellGroupData[{
Cell[396645, 10101, 264, 5, 28, "Input",ExpressionUUID->"81d9c97e-ce55-4fc3-9284-1852ced5729f"],
Cell[396912, 10108, 428, 9, 21, "Message",ExpressionUUID->"0d93113e-5c9a-4b14-81d2-6471fa176779"],
Cell[397343, 10119, 117, 1, 32, "Output",ExpressionUUID->"01124f14-5f18-4e3d-b02f-1cea8d159220"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[397509, 10126, 162, 7, 53, "Subsection",ExpressionUUID->"30e28ea8-cff2-4e17-8e87-a33d76d91655"],
Cell[CellGroupData[{
Cell[397696, 10137, 108, 1, 28, "Input",ExpressionUUID->"1de0ab2b-02c3-42ae-ae18-048da21143c2"],
Cell[397807, 10140, 1395, 19, 368, "Print",ExpressionUUID->"594cbbb4-88c5-47ab-b64b-34bcb846440d",
 CellTags->"Info3593735575597-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[399239, 10164, 124, 1, 28, "Input",ExpressionUUID->"eef6353f-fbe3-498e-a0b6-6dd1198dca2f"],
Cell[399366, 10167, 601, 13, 57, "Output",ExpressionUUID->"7d93dad7-df68-4ee8-9c8b-ef01d7ff2d72"]
}, Open  ]],
Cell[CellGroupData[{
Cell[400004, 10185, 118, 1, 28, "Input",ExpressionUUID->"6e68c5d6-6806-4a17-acc3-8cd8e0e1b743"],
Cell[400125, 10188, 535, 8, 115, "Print",ExpressionUUID->"5275f1a4-67b4-46e8-acf1-054c45384af8",
 CellTags->"Info3613735575612-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[400697, 10201, 113, 1, 28, "Input",ExpressionUUID->"51d6eac3-3b89-4e91-95c9-06250a50f36d"],
Cell[400813, 10204, 2257, 31, 506, "Print",ExpressionUUID->"4c9fd4df-4526-4928-be27-92caa80a8f2c",
 CellTags->"Info4553735576149-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[403107, 10240, 118, 1, 28, "Input",ExpressionUUID->"dea49837-b28f-4a5e-b693-29ca34d2c569"],
Cell[403228, 10243, 392, 7, 32, "Output",ExpressionUUID->"ace90ee4-dbb3-45a2-b8a4-ff97350951bf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[403657, 10255, 139, 2, 28, "Input",ExpressionUUID->"f1474c28-396c-4b0d-ac3c-0bcba4dfce79"],
Cell[403799, 10259, 315, 6, 32, "Output",ExpressionUUID->"b5785eb0-6546-4768-a4e3-bb6f451fbcac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[404151, 10270, 191, 3, 28, "Input",ExpressionUUID->"0d6e6ec1-bfc0-4286-968c-c78bc2ed25cc"],
Cell[404345, 10275, 534, 11, 32, "Output",ExpressionUUID->"b9a3807c-1fcb-4b3a-adb4-22eb91acc368"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[404928, 10292, 162, 7, 53, "Subsection",ExpressionUUID->"361d8f36-9bfc-46e5-b7e3-85d65492a76a"],
Cell[CellGroupData[{
Cell[405115, 10303, 114, 1, 28, "Input",ExpressionUUID->"5e7d1044-6dcf-4c80-918e-0f040a274cbb"],
Cell[405232, 10306, 566, 9, 138, "Print",ExpressionUUID->"61bcc6b2-0f8e-48f7-bd20-bbb52d7f7cdd",
 CellTags->"Info4083735558503-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405835, 10320, 130, 1, 28, "Input",ExpressionUUID->"54e471cd-46b5-44cb-bcc1-acb4a6064447"],
Cell[405968, 10323, 236, 6, 32, "Output",ExpressionUUID->"be10d0d4-625a-497d-82be-0e22ff48b31f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[406241, 10334, 123, 1, 28, "Input",ExpressionUUID->"8d71b0c5-31e0-49b0-be99-b852332fe878"],
Cell[406367, 10337, 849, 12, 161, "Print",ExpressionUUID->"12138ea5-a6df-496a-90bb-7d1d45b17c78",
 CellTags->"Info4103735558503-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[407253, 10354, 141, 2, 28, "Input",ExpressionUUID->"2b7fe640-fd81-4d1b-b0ad-4bd351f3ec5c"],
Cell[407397, 10358, 459, 11, 32, "Output",ExpressionUUID->"a8ec6e65-c9f9-4792-bdd4-d2f77438c470"]
}, Open  ]],
Cell[CellGroupData[{
Cell[407893, 10374, 286, 5, 28, "Input",ExpressionUUID->"a0c41304-f17b-438c-89f1-8748ec326306"],
Cell[408182, 10381, 539, 8, 52, "Output",ExpressionUUID->"4a84be75-616c-44ca-9b63-22cbf261c528"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[408770, 10395, 162, 7, 53, "Subsection",ExpressionUUID->"5479370b-4178-4a52-9124-2c5d71d17a78"],
Cell[CellGroupData[{
Cell[408957, 10406, 113, 1, 28, "Input",ExpressionUUID->"91717edc-0394-4d26-9d85-2219e010d529"],
Cell[409073, 10409, 1304, 18, 276, "Print",ExpressionUUID->"1287910b-3c84-4cda-bc96-e4adf76cac4d",
 CellTags->"Info4133735558504-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[410414, 10432, 129, 1, 28, "Input",ExpressionUUID->"cecdfa2a-60a8-434e-af9e-6d0802b39f34"],
Cell[410546, 10435, 727, 16, 52, "Output",ExpressionUUID->"f318c08b-d989-4d93-8cf0-cb6ea7163791"]
}, Open  ]],
Cell[CellGroupData[{
Cell[411310, 10456, 128, 1, 28, "Input",ExpressionUUID->"148b17b3-84ec-4268-aae9-77353f184131"],
Cell[411441, 10459, 523, 14, 32, "Output",ExpressionUUID->"986643ba-6abd-4929-86b1-a6c5b1b47eb3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[412001, 10478, 122, 1, 28, "Input",ExpressionUUID->"78dbc5a0-685f-4d32-9999-f4a220546564"],
Cell[412126, 10481, 544, 14, 32, "Output",ExpressionUUID->"a7acc9d6-0ac3-48a0-b525-950a599bbf9a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[412719, 10501, 162, 7, 53, "Subsection",ExpressionUUID->"209e94bd-d43c-4a35-90a3-a71d73aa898c"],
Cell[CellGroupData[{
Cell[412906, 10512, 119, 1, 28, "Input",ExpressionUUID->"1ce7af14-db70-412e-b2c8-4737ec9e98fc"],
Cell[413028, 10515, 814, 12, 161, "Print",ExpressionUUID->"ca526546-d793-4fe5-b58f-481986d3b460",
 CellTags->"Info4173735558504-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[413879, 10532, 137, 2, 28, "Input",ExpressionUUID->"74bf70f3-a3e3-4156-b21f-f07a493589d3"],
Cell[414019, 10536, 305, 8, 32, "Output",ExpressionUUID->"5fad5cbd-8737-4e11-91eb-369ccc2fdad1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[414361, 10549, 140, 2, 28, "Input",ExpressionUUID->"5915df87-0d00-479c-8cc1-45b935b030d9"],
Cell[414504, 10553, 172, 3, 32, "Output",ExpressionUUID->"ed7a0b08-0672-4490-b161-fe0be52684c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[414713, 10561, 122, 1, 28, "Input",ExpressionUUID->"e926d07f-3eff-45e4-8de2-3961c8336226"],
Cell[414838, 10564, 351, 5, 32, "Output",ExpressionUUID->"b60ff96f-dd9d-4310-851c-accde517dbdf"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[415238, 10575, 163, 7, 53, "Subsection",ExpressionUUID->"5e9706be-eff7-4816-b914-87f4ded1c184"],
Cell[CellGroupData[{
Cell[415426, 10586, 115, 1, 28, "Input",ExpressionUUID->"961c3b41-b1c4-4653-8770-0661217601fb"],
Cell[415544, 10589, 852, 12, 184, "Print",ExpressionUUID->"ca33baba-b8ec-40cf-b0cb-3ca17171766d",
 CellTags->"Info4213735558504-8910602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[416433, 10606, 131, 1, 28, "Input",ExpressionUUID->"e27788f2-7d8d-4aab-9562-3c18a74f361a"],
Cell[416567, 10609, 250, 6, 32, "Output",ExpressionUUID->"31a6cf94-006d-4820-a47f-d041e4a9774d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[416854, 10620, 136, 2, 28, "Input",ExpressionUUID->"2d13bd00-6203-413f-b629-8338610ed262"],
Cell[416993, 10624, 160, 3, 32, "Output",ExpressionUUID->"19ff9758-27ff-4c9e-933b-42577bd4efdc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[417190, 10632, 223, 5, 28, "Input",ExpressionUUID->"dd41e06a-c91a-413c-9b19-ffdf90572893"],
Cell[417416, 10639, 160, 3, 32, "Output",ExpressionUUID->"7f4a9d3d-a570-4c6a-8c35-d16b2111249f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[417637, 10649, 132, 5, 67, "Section",ExpressionUUID->"8be4aff8-8a43-47f2-9330-3db5f8b311d7"],
Cell[417772, 10656, 203, 3, 56, "Text",ExpressionUUID->"d1ae5cc0-6544-4b7e-92d5-c8ae45c9331e"],
Cell[417978, 10661, 288, 5, 56, "Text",ExpressionUUID->"030c240e-1543-46c6-8277-a4596b3ca6f4"],
Cell[418269, 10668, 508, 9, 122, "Text",ExpressionUUID->"9f23fa8c-1882-446f-8d36-2d4c9b11f022"],
Cell[418780, 10679, 379, 7, 56, "Text",ExpressionUUID->"275399fd-e095-4b92-8a9e-02e0c01a0fed"],
Cell[419162, 10688, 350, 7, 78, "Text",ExpressionUUID->"6cf08fe3-c569-4044-bb08-67fda4de7e94"],
Cell[419515, 10697, 416, 8, 78, "Text",ExpressionUUID->"88d59312-b266-45e2-b46f-18f55a0512eb"],
Cell[419934, 10707, 309, 7, 56, "Text",ExpressionUUID->"26121b96-ba61-4dec-b6ba-d1793ceae7c2"],
Cell[420246, 10716, 235, 5, 34, "Text",ExpressionUUID->"c9c9c4be-0db0-4dfa-b8ef-88049f39f183"],
Cell[420484, 10723, 244, 5, 34, "Text",ExpressionUUID->"3e8a9089-db91-4def-b5aa-6ca846cf7a9f"],
Cell[420731, 10730, 240, 5, 34, "Text",ExpressionUUID->"90264af9-6a06-4bc9-862d-57b8909fbc08"],
Cell[420974, 10737, 209, 5, 34, "Text",ExpressionUUID->"4ce44d16-4ff7-4cd4-ad46-29dd1d70a4a4"]
}, Open  ]]
}, Open  ]]
}
]
*)

