params = dict()
params['tau'] = 1
params['bs'] = False
params['errors'] = dict() #multiplicative factor on central value to set up grid search
params['limits'] = {
    'dE_10':(0,10),
    'zs_0' :(0,1),
    'zs_1' :(0,1),
    #'gA_11':(-20,20),
    #'gA_10':(-10,10),
    #'gV_11':(-20,20),
    #'gV_10':(-10,10)
}


''' a15 ensembles '''
params['a15m400'] = dict()
params['a15m400']['seed'] = 'a15m400'
params['a15m400']['Nbs']  = 5000
params['a15m400']['t_min_max'] = {
    'proton':[6,11],
    'gA'    :[3,11],
    'gV'    :[5,11]
}
params['a15m400']['plt_range'] = {
    'proton':[4,13,0.84,0.96],
    'gA'    :[0,13,1.,1.4],
    'gV'    :[2,14,0.96,1.08]
}
params['a15m400']['fit_ini'] = {
    'E_0'   :0.88198,
    'dE_10' :0.9,
    'gA_00' :1.20,
    'gA_11' :1.18,
    'gA_10' :0.0159,
    'gV_00' :0.997,
    'gV_11' :1.005,
    'gV_10' :-0.001,
    'zs_0'  :2.1e-3,
    'zp_0'  :1.2e-2,
    'zs_1'  :1.4e-6,
    'zp_1'  :5.4e+1,
    'dAss_0':-2.89e-1,
    'dAps_0':-1.07e-3,
    'dAss_1':-3.9e-6,
    'dAps_1':2.95e-3,
    'dVss_0':1.04e-1,
    'dVps_0':7.19e-5,
    'dVss_1':-8.4e-6,
    'dVps_1':-1.1e-4,
}

params['a15m350'] = dict()
params['a15m350']['seed'] = 'a15m350'
params['a15m350']['Nbs']  = 5000
params['a15m350']['t_min_max'] = {
    'proton':[4,12],
    'gA'    :[2,12],
    'gV'    :[4,12]
}
params['a15m350']['plt_range'] = {
    'proton':[2,14,0.8,0.92],
    'gA'    :[0,15,1.,1.4],
    'gV'    :[2,14,0.96,1.08]
}
params['a15m350']['fit_ini'] = {
    'E_0'   :0.83308,
    'dE_10' :0.50,
    'gA_00' :1.18,
    'gA_11' :0.961,
    'gA_10' :0.17,
    'gV_00' :0.997,
    'gV_11' :1.06,
    'gV_10' :-0.053,
    'zs_0'  :1.97e-3,
    'zp_0'  :1.08e-2,
    'zs_1'  :1.5e-3,
    'zp_1'  :1.42e-2,
    'dAss_0':-1.8e-6,
    'dAps_0':-2.14e-5,
    'dAss_1':-2.0e-7,
    'dAps_1':1.32e-6,
    'dVss_0':4.08e-6,
    'dVps_0':1.98e-5,
    'dVss_1':-1.15e-7,
    'dVps_1':-2.0e-7,
}

params['a15m310'] = dict()
params['a15m310']['seed'] = 'a15m310'
params['a15m310']['Nbs']  = 5000
params['a15m310']['t_min_max'] = {
    'proton':[4,14],
    'gA'    :[4,10],
    'gV'    :[4,15]
}
params['a15m310']['plt_range'] = {
    'proton':[2,16,0.81,0.85],
    'gA'    :[2,12,1.15,1.45],
    'gV'    :[0,17,0.98,1.08]
}
params['a15m310']['fit_ini'] = {
    'E_0'   :0.82214,
    'dE_10' :0.98,
    'gA_00' :1.1228,
    'gA_11' :0.601,
    'gA_10' :-2.62,
    'gV_00' :1.001,
    'gV_11' :0.8,
    'gV_10' :-2.5,
    'zs_0'  :5.84e-4,
    'zp_0'  :1.13e-2,
    'zs_1'  :6.96e-4,
    'zp_1'  :6.82e-3,
    'dAss_0':7.0e-7,
    'dAps_0':2.72e-4,
    'dAss_1':-2.99e-6,
    'dAps_1':4.98e-5,
    'dVss_0':1.24e-7,
    'dVps_0':-1.5e-5,
    'dVss_1':1.9e-7,
    'dVps_1':3.7e-6,
}

params['a15m220'] = dict()
params['a15m220']['seed'] = 'a15m220'
params['a15m220']['Nbs']  = 5000
params['a15m220']['t_min_max'] = {
    'proton':[3,11],
    'gA'    :[4,9],
    'gV'    :[4,9]
}
params['a15m220']['plt_range'] = {
    'proton':[1,13,0.74,0.84],
    'gA'    :[2,12,1.,1.5],
    'gV'    :[2,12,0.95,1.1]
}
params['a15m220']['fit_ini'] = {
    'E_0'   :0.7589,
    'dE_10' :1.08,
    'gA_00' :1.27,
    'gA_11' :-2.26,
    'gA_10' :-2.57,
    'gV_00' :1.001,
    'gV_11' :-.2394,
    'gV_10' :-.36,
    'zs_0'  :4.15e-4,
    'zp_0'  :1.1e-2,
    'zs_1'  :5.2e-4,
    'zp_1'  :5.4e-3,
    'dAss_0':2.43e-7,
    'dAps_0':-2.72e-6,
    'dAss_1':-4.4e-7,
    'dAps_1':1.1e-6,
    'dVss_0':7.33e-9,
    'dVps_0':3.82e-6,
    'dVss_1':1.43e-7,
    'dVps_1':-1.6e-6,
}

params['a15m130'] = dict()
params['a15m130']['seed'] = 'a15m130'
params['a15m130']['Nbs']  = 5000
params['a15m130']['t_min_max'] = {
    'proton':[2,10],
    'gA'    :[2,6],
    'gV'    :[2,7]
}
params['a15m130']['plt_range'] = {
    'proton':[0,12,0.65,0.95],
    'gA'    :[0,8,1.,1.8],
    'gV'    :[0,10,0.8,1.6]
}
params['a15m130']['fit_ini'] = {
    'E_0'   :0.7181,
    'dE_10' :0.7408,
    'gA_00' :1.25,
    'gA_11' :0.403,
    'gA_10' :3.912,
    'gV_00' :0.995,
    'gV_11' :0.75,
    'gV_10' :-0.94,
    'zs_0'  :4.55e-4,
    'zp_0'  :1.25e-2,
    'zs_1'  :3.87e-4,
    'zp_1'  :4.65e-3,
    'dAss_0':-1.03e-5,
    'dAps_0':-1.55e-3,
    'dAss_1':-4.07e-6,
    'dAps_1':-4.17e-4,
    'dVss_0':4.20e-7,
    'dVps_0':4.35e-4,
    'dVss_1':-6.96e-7,
    'dVps_1':1.17e-4,
}

''' a12 ensembles '''
params['a12m400'] = dict()
params['a12m400']['seed'] = 'a12m400'
params['a12m400']['Nbs']  = 5000
params['a12m400']['t_min_max'] = {
    'proton':[5,10],
    'gA'    :[5,11],
    'gV'    :[7,11]
}
params['a12m400']['plt_range'] = {
    'proton':[3,12,0.68,0.76],
    'gA'    :[2,14,1.1,1.4],
    'gV'    :[4,14,1.01,1.03]
}
params['a12m400']['fit_ini'] = {
    'E_0'   :0.7158,
    'dE_10' :0.5338,
    'gA_00' :1.24,
    'gA_11' :0.049,
    'gA_10' :0.104,
    'gV_00' :1.02,
    'gV_11' :1.02,
    'gV_10' :-0.174,
    'zs_0'  :1.62e-3,
    'zp_0'  :6.30e-3,
    'zs_1'  :1.67e-3,
    'zp_1'  :1.24e-2,
    'dAss_0':-3.30e-6,
    'dAps_0':-1.62e-5,
    'dAss_1':-2.87e-7,
    'dAps_1':-1.96e-6,
    'dVss_0':3.31e-6,
    'dVps_0':1.57e-5,
    'dVss_1':-2.93e-7,
    'dVps_1':2.16e-6,
}

params['a12m350'] = dict()
params['a12m350']['seed'] = 'a12m350'
params['a12m350']['Nbs']  = 5000
params['a12m350']['t_min_max'] = {
    'proton':[7,14],
    'gA'    :[5,11],
    'gV'    :[5,14]
}
params['a12m350']['plt_range'] = {
    'proton':[5,16,0.66,0.76],
    'gA'    :[2,14,1.1,1.6],
    'gV'    :[2.5,17.5,0.98,1.06]
}
params['a12m350']['fit_ini'] = {
    'E_0'   :0.6861,
    'dE_10' :0.4772,
    'gA_00' :1.26,
    'gA_11' :1.26,
    'gA_10' :0.127,
    'gV_00' :1.02,
    'gV_11' :1.03,
    'gV_10' :-0.16,
    'zs_0'  :1.57e-3,
    'zp_0'  :5.98e-3,
    'zs_1'  :1.53e-3,
    'zp_1'  :1.09e-2,
    'dAss_0':-3.54e-6,
    'dAps_0':-1.55e-5,
    'dAss_1':-5.76e-7,
    'dAps_1':-2.82e-6,
    'dVss_0':3.31e-6,
    'dVps_0':1.57e-5,
    'dVss_1':-3.83e-7,
    'dVps_1':2.61e-6,
}

params['a12m310'] = dict()
params['a12m310']['seed'] = 'a12m310'
params['a12m310']['Nbs']  = 5000
params['a12m310']['t_min_max'] = {
    'proton':[5,12],
    'gA'    :[4,12],
    'gV'    :[6,12]
}
params['a12m310']['plt_range'] = {
    'proton':[5,16,0.66,0.76],
    'gA'    :[2,14,1.1,1.6],
    'gV'    :[2.5,17.5,0.98,1.06]
}
params['a12m310']['fit_ini'] = {
    'E_0'   :0.6606,
    'dE_10' :0.5110,
    'gA_00' :1.24,
    'gA_11' :1.10,
    'gA_10' :0.183,
    'gV_00' :1.02,
    'gV_11' :1.06,
    'gV_10' :-0.195,
    'zs_0'  :1.51e-3,
    'zp_0'  :5.73e-3,
    'zs_1'  :1.59e-3,
    'zp_1'  :1.09e-2,
    'dAss_0':-3.32e-6,
    'dAps_0':-1.63e-5,
    'dAss_1':2.93e-7,
    'dAps_1':-1.89e-6,
    'dVss_0':3.36e-6,
    'dVps_0':1.59e-5,
    'dVss_1':-3.29e-7,
    'dVps_1':2.09e-6,
}

params['a12m220S'] = dict()
params['a12m220S']['seed'] = 'a12m220S'
params['a12m220S']['Nbs']  = 5000
params['a12m220S']['t_min_max'] = {
    'proton':[4,10],
    'gA'    :[5,10],
    'gV'    :[3,10]
}
params['a12m220S']['plt_range'] = {
    'proton':[2,12,0.6,0.7],
    'gA'    :[2,12,1.,2.0],
    'gV'    :[0,12,0.98,1.15]
}
params['a12m220S']['fit_ini'] = {
    'E_0'   :0.623526,
    'dE_10' :1.608,
    'gA_00' :1.29431,
    'gA_11' :13.6569,
    'gA_10' :-7005.93,
    'gV_00' :1.01772,
    'gV_11' :0.821689,
    'gV_10' :6.17338,
    'zs_0'  :8.31313e-05,
    'zp_0'  :0.00576175,
    'zs_1'  :0.000346542,
    'zp_1'  :0.00329412,
    'dAss_0':3.75286e-05,
    'dAps_0':0.052105,
    'dAss_1':-0.00161472,
    'dAps_1':0.0948096,
    'dVss_0':-4.23981e-08,
    'dVps_0':-0.000116383,
    'dVss_1':1.26796e-06,
    'dVps_1':-0.0002526,
}

params['a12m220'] = dict()
params['a12m220']['seed'] = 'a12m220'
params['a12m220']['Nbs']  = 5000
params['a12m220']['t_min_max'] = {
    'proton':[3,15],
    'gA'    :[4,10],
    'gV'    :[3,14]
}
params['a12m220']['plt_range'] = {
    'proton':[1,17,0.6,0.7],
    'gA'    :[2,12,1.1,1.5],
    'gV'    :[0,15,0.98,1.15]
}
params['a12m220']['fit_ini'] = {
    'E_0'   :0.6171,
    'dE_10' :1.02,
    'gA_00' :1.28,
    'gA_11' :-0.162,
    'gA_10' :9.54,
    'gV_00' :1.01,
    'gV_11' :0.915,
    'gV_10' :-0.168,
    'zs_0'  :8.12e-5,
    'zp_0'  :5.54e-3,
    'zs_1'  :1.15e-4,
    'zp_1'  :1.46e-3,
    'dAss_0':-4.49e-7,
    'dAps_0':-5.42e-4,
    'dAss_1':-3.98e-7,
    'dAps_1':-1.83e-4,
    'dVss_0':1.19e-8,
    'dVps_0':-3.45e-6,
    'dVss_1':1.06e-8,
    'dVps_1':-1.84e-6,
}

params['a12m220L'] = dict()
params['a12m220L']['seed'] = 'a12m220L'
params['a12m220L']['Nbs']  = 5000
params['a12m220L']['t_min_max'] = {
    'proton':[4,12],
    'gA'    :[4,12],
    'gV'    :[5,10]
}
params['a12m220L']['plt_range'] = {
    'proton':[2,14,0.6,0.7],
    'gA'    :[2,14,1.,1.6],
    'gV'    :[2,12,0.98,1.15]
}
params['a12m220L']['fit_ini'] = {
    'E_0'   :0.6125,
    'dE_10' :0.677,
    'gA_00' :1.28,
    'gA_11' :0.436,
    'gA_10' :1.72,
    'gV_00' :1.02,
    'gV_11' :1.377,
    'gV_10' :0.461,
    'zs_0'  :7.97e-5,
    'zp_0'  :5.44e-3,
    'zs_1'  :4.65e-5,
    'zp_1'  :1.50e-3,
    'dAss_0':-1.28e-8,
    'dAps_0':5.90e-6,
    'dAss_1':-3.98e-8,
    'dAps_1':2.22e-6,
    'dVss_0':-1.08e-8,
    'dVps_0':-5.21e-6,
    'dVss_1':9.78e-9,
    'dVps_1':-1.31e-6,
}

params['a12m130'] = dict()
params['a12m130']['seed'] = 'a12m130'
params['a12m130']['Nbs']  = 5000
params['a12m130']['t_min_max'] = {
    'proton':[2,13],
    'gA'    :[3,13],
    'gV'    :[2,12]
}
params['a12m130']['plt_range'] = {
    'proton':[0,15,0.5,0.75],
    'gA'    :[0,15,1.1,1.7],
    'gV'    :[0,15,0.9,1.4]
}
params['a12m130']['fit_ini'] = {
    'E_0'   :0.5764,
    'dE_10' :0.830,
    'gA_00' :1.31,
    'gA_11' :0.488,
    'gA_10' :-1.97,
    'gV_00' :1.02,
    'gV_11' :1.118,
    'gV_10' :-0.0551,
    'zs_0'  :2.39e-5,
    'zp_0'  :5.51e-3,
    'zs_1'  :3.16e-5,
    'zp_1'  :5.10e-4,
    'dAss_0':4.92e-9,
    'dAps_0':7.09e-5,
    'dAss_1':-1.02e-9,
    'dAps_1':7.80e-6,
    'dVss_0':5.76e-10,
    'dVps_0':5.13e-6,
    'dVss_1':3.23e-10,
    'dVps_1':5.15e-7,
}


''' a09 ensembles '''
params['a09m400'] = dict()
params['a09m400']['seed'] = 'a09m400'
params['a09m400']['Nbs']  = 5000
params['a09m400']['t_min_max'] = {
    'proton':[8,18],
    'gA'    :[6,15],
    'gV'    :[7,15]
}
params['a09m400']['plt_range'] = {
    'proton':[6,20,0.5,0.6],
    'gA'    :[2.5,17.5,1.1,1.5],
    'gV'    :[4,17,1.015,1.035]
}
params['a09m400']['fit_ini'] = {
    'E_0'   :0.53411,
    'dE_10' :0.37459,
    'zs_0'  :7.2e-4,
    'zp_0'  :2.6e-3,
    'zs_1'  :8.7e-4,
    'zp_1'  :5.0e-3,
    'gA_00' :1.24,
    'gA_11' :1.09,
    'gA_10' :-.17,
    'gV_00' :1.02,
    'gV_11' :1.02,
    'gV_10' :-0.18,
    'dAss_0':-1.2e-6,
    'dAps_0':-5.3e-6,
    'dAss_1':-1.2e-7,
    'dAps_1':-2.0e-6,
    'dVss_0':9.0e-7,
    'dVps_0':3.9e-6,
    'dVss_1':-7.1e-11,
    'dVps_1':4.6e-7,
}

params['a09m350'] = dict()
params['a09m350']['seed'] = 'a09m350'
params['a09m350']['Nbs']  = 5000
params['a09m350']['t_min_max'] = {
    'proton':[7,16],
    'gA'    :[8,16],
    'gV'    :[7,14]
}
params['a09m350']['plt_range'] = {
    'proton':[5,18,0.48,0.6],
    'gA'    :[6,18,1.15,1.4],
    'gV'    :[4,16,1.015,1.035]
}
params['a09m350']['fit_ini'] = {
    'E_0'   :0.51280,
    'dE_10' :0.4433,
    'zs_0'  :7.0e-4,
    'zp_0'  :2.5e-3,
    'zs_1'  :9.6e-4,
    'zp_1'  :5.8e-3,
    'gA_00' :1.26,
    'gA_11' :1.31,
    'gA_10' :0.21,
    'gV_00' :1.02,
    'gV_11' :1.05,
    'gV_10' :-0.22,
    'dAss_0':-1.2e-6,
    'dAps_0':-4.5e-6,
    'dAss_1':1.2e-7,
    'dAps_1':-1.7e-6,
    'dVss_0':9.1e-7,
    'dVps_0':3.9e-6,
    'dVss_1':-5.8e-08,
    'dVps_1':3.4e-7,
}

params['a09m310'] = dict()
params['a09m310']['seed'] = 'a09m310'
params['a09m310']['Nbs']  = 5000
params['a09m310']['t_min_max'] = {
    'proton':[9,16],
    'gA'    :[3,12],
    'gV'    :[7,17]
}
params['a09m310']['plt_range'] = {
    'proton':[7,18,0.47,0.55],
    'gA'    :[0,15,1.1,1.5],
    'gV'    :[5,20,1.015,1.035]
}
params['a09m310']['fit_ini'] = {
    'E_0'   :.49241,
    'dE_10' :.408,
    'zs_0'  :2.2e-5,
    'zp_0'  :2.3e-3,
    'zs_1'  :1.3e-5,
    'zp_1'  :3.1e-3,
    'gA_00' :1.27,
    'gV_00' :1.02,
    'gA_11' :1.55,
    'gA_10' :-.01,
    'dAss_0':-4.7e-10,
    'dAps_0':-6.2e-8,
    'dAss_1':-4.2e-10,
    'dAps_1':1.5e-8,
    'gV_11' :1.06,
    'gV_10' :-0.066,
    'dVss_0':3.9e-10,
    'dVps_0':3.1e-8,
    'dVss_1':2.6e-11,
    'dVps_1':-4.1e-10,
}

params['a09m220'] = dict()
params['a09m220']['seed'] = 'a09m220'
params['a09m220']['Nbs']  = 5000
params['a09m220']['t_min_max'] = {
    'proton':[9,15],
    'gA'    :[3,14],
    'gV'    :[6,12]
}
params['a09m220']['plt_range'] = {
    'proton':[7,17,0.4,0.5],
    'gA'    :[0,15,1.15,1.4],
    'gV'    :[4,14,1.01,1.05]
}
params['a09m220']['fit_ini'] = {
    'E_0'   :0.4470,
    'dE_10' :.4900,
    'zs_0'  :1.17496e-05,
    'zp_0'  :0.0020,
    'zs_1'  :8.71968e-06,
    'zp_1'  :0.00523,
    'gA_00' :1.2795,
    'gA_11' :1.389,
    'gA_10' :-0.0441,
    'gV_00' :1.0214,
    'gV_11' :0.9945,
    'gV_10' :-0.05271,
    'dAss_0':-1.965e-11,
    'dAps_0':-2.86655e-08,
    'dAss_1':-1.45753e-10,
    'dAps_1':-2.41056e-08,
    'dVss_0':2.20583e-10,
    'dVps_0':1.09192e-08,
    'dVss_1':7.89055e-11,
    'dVps_1':2.43325e-09,
}
