% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dea.R
\docType{data}
\name{dea}
\alias{dea}
\title{Data: Denitrification enzyme activity and in vitro N2O production rates}
\format{A dataframe with six rows and five columns:
\describe{
\item{pot}{Mesocosm ID; equivalent to "new.core.id" in other datasets}
\item{DEA}{Denitrification enzyme activity (units = nanomoles N2O / gram dry mass / hour)}
\item{IV}{"In vitro" N2O production; no nutrient solution added, just filtered seawater (units = nanomoles N2O / gram dry mass / hour)}
\item{mcf}{Moisture correction factor (1 - gravimetric water content)}
\item{bd_gcm3}{Bulk density (grams per cubic centimeter)}
}}
\usage{
dea
}
\description{
Data: Denitrification enzyme activity and in vitro N2O production rates
}
\examples{
### export to .csv:
write.csv(dea, file = "dea.csv")
}
\references{
Hill et al.
(\href{url}{text})
}
\author{
Troy D. Hill \email{Hill.Troy@gmail.com}
}
\keyword{N2O}
\keyword{datasets,}
\keyword{denitrification,}
