/******************************************************************************
 *   Copyright (C) 2019 GSI Helmholtzzentrum für Schwerionenforschung GmbH    *
 *   Copyright (C) 2019-2024 Members of R3B Collaboration                     *
 *                                                                            *
 *             This software is distributed under the terms of the            *
 *                 GNU General Public Licence (GPL) version 3,                *
 *                    copied verbatim in the file "LICENSE".                  *
 *                                                                            *
 * In applying this license GSI does not waive the privileges and immunities  *
 * granted to it by virtue of its status as an Intergovernmental Organization *
 * or submit itself to any jurisdiction.                                      *
 ******************************************************************************/

/* R3BChannelAccessEPICS.h
 * R3BROOT
 *
 * Author: Hans Törnqvist <h.toernqvist@gsi.de>
 * Date: 06/12/17
 * */

/*
 * Note that you should probably set some EPICS environment variables
 * properly before going to town, if not to at all get access IOC:s but also
 * to not cause havoc on the network, e.g.:
 *
 *  export EPICS_CA_AUTO_ADDR_LIST=no
 *  export EPICS_CA_ADDR_LIST=123.45.67.89
 *  root -l macro_mania.C
 */

#ifndef __R3BROOT__R3BCHANNELACCESSEPICS__
#define __R3BROOT__R3BCHANNELACCESSEPICS__

#include "R3BChannelAccess.h"
#include <TClonesArray.h>
#include <cadef.h>

class R3BChannelAccessEPICS : public R3BChannelAccess
{
  public:
    R3BChannelAccessEPICS(TString const& = "");
    ~R3BChannelAccessEPICS();
    double Get();
    double* GetPointer();
    chid GetID() const;
    chtype GetType() const;
    void Set(double);

    ClassDef(R3BChannelAccessEPICS, 1)

        private : TString fName;
    double fValue;
    chid fId;
    chtype fType;
};

class R3BChannelAccessGroupEPICS : public R3BChannelAccessGroup
{
  public:
    R3BChannelAccessGroupEPICS();
    ~R3BChannelAccessGroupEPICS();
    R3BChannelAccess* CreateChannel(TString const&);
    bool Commit();
    bool Fetch();

    ClassDef(R3BChannelAccessGroupEPICS, 1)

        private : bool PendIO(char const*);
    bool Search();

    TClonesArray fChannelArray;
    bool fNeedSearch;
};

class R3BChannelAccessMasterEPICS : public R3BChannelAccessMaster
{
  public:
    R3BChannelAccessMasterEPICS();
    ~R3BChannelAccessMasterEPICS();
    R3BChannelAccessGroup* CreateGroup();

    ClassDef(R3BChannelAccessMasterEPICS, 1)

        private : TClonesArray fGroupArray;
};

#endif
