/*
 *  Copyright 2012-2013 Ontology Engineering Group, Universidad Politecnica de Madrid, Spain

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

/*
 * WidocoGui2.java
 *
 * Created on 16-jun-2014, 21:38:19
 */
package widoco.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author Daniel Garijo
 */
public class GuiStep1 extends javax.swing.JFrame {
    
    private GuiController g;//pointer to be able to save and go to the next state.
    private String folderPath;

    /** Creates new form WidocoGui2
     * @param g pointer to the controller*/
    public GuiStep1(GuiController g) {
        this.g = g;
        initComponents();
        initializeGUI();
        
    }
    
    private void initializeGUI(){
        //loading logo
        Image l = g.getConfig().getWidocoLogo().getScaledInstance(widocoLogo.getWidth(), widocoLogo.getHeight(), Image.SCALE_SMOOTH);
        widocoLogo.setIcon(new ImageIcon(l));
        this.setIconImage(g.getConfig().getWidocoLogoMini());//
        
        ButtonGroup buttonGroup  = new ButtonGroup();
        buttonGroup.add(option1);
        buttonGroup.add(option2);
        buttonGroup.add(option3);
        Dimension dim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();

        // Determine the new location of the window
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width-w)/2;
        int y = (dim.height-h)/2;

        //Move the window
        this.setLocation(x, y);
        
        if(g.getConfig().getDocumentationURI()==null){
            //set the defaul text on the path text field
            File f = new File("");
            folderPath = f.getAbsolutePath();
            this.textDocPath.setText(folderPath+File.separator+textDocName.getText());
        }else{
            this.textDocPath.setText(g.getConfig().getDocumentationURI());
            folderPath = g.getConfig().getDocumentationURI();
            if(g.getConfig().getOntologyPath()!=null){
                textFieldPath.setText(g.getConfig().getOntologyPath());
            }
            if(g.getConfig().getOntologyURI()!=null){
                textFieldURL.setText(g.getConfig().getOntologyURI());                
            }
        }
        
        //to do: if we are going back, get the configuration, load the parameters.
        //if not, do as above.
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        nextButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jScrollPane1 = new javax.swing.JScrollPane();
        textPaneSteps = new javax.swing.JTextPane();
        textFieldPath = new javax.swing.JTextField();
        textFieldURL = new javax.swing.JTextField();
        jSeparator2 = new javax.swing.JSeparator();
        option1 = new javax.swing.JRadioButton();
        option2 = new javax.swing.JRadioButton();
        option3 = new javax.swing.JRadioButton();
        labelTitle = new javax.swing.JLabel();
        labelSteps = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        textDocName = new javax.swing.JTextField();
        textDocPath = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        widocoLogo = new javax.swing.JLabel();
        labelTitle1 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Step 1: Select a template");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        nextButton.setText("Next >");
        nextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        textPaneSteps.setEditable(false);
        textPaneSteps.setContentType("text/html"); // NOI18N
        textPaneSteps.setText("<html>\r\n\r<b>1. Select template</b><br/>       \n2. Load metadata<br/>\n3. Load sections<br/>\n4. Finish\n</html>\r\n");
        jScrollPane1.setViewportView(textPaneSteps);

        textFieldPath.setEditable(false);
        textFieldPath.setText("document Path");

        textFieldURL.setEditable(false);
        textFieldURL.setText("Insert here the URL of the vocabulary");
        textFieldURL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                textFieldURLActionPerformed(evt);
            }
        });

        option1.setText("Create template documentation from ontology file");
        option1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                option1ItemStateChanged(evt);
            }
        });

        option2.setText("Create template documentation from ontology URI");
        option2.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                option2ItemStateChanged(evt);
            }
        });

        option3.setText("Create empty skeleton");

        labelTitle.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        labelTitle.setText("Step 1: Select a template. ");

        labelSteps.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        labelSteps.setText("Steps");

        jLabel1.setText("Project name");

        jLabel2.setText("Project export location");

        textDocName.setText("myDocumentation");
        textDocName.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                textDocNameKeyTyped(evt);
            }
        });

        textDocPath.setEditable(false);
        textDocPath.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        textDocPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                textDocPathActionPerformed(evt);
            }
        });

        browseButton.setText("Browse");
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        widocoLogo.setText("LOGO");

        labelTitle1.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        labelTitle1.setText("Choose the type of template you want to create and where to save it");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSeparator2)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(0, 0, Short.MAX_VALUE)
                                        .addComponent(nextButton, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGap(53, 53, 53))
                                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(labelSteps, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 166, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(jLabel1)
                                            .addComponent(jLabel2))
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(layout.createSequentialGroup()
                                                .addGap(18, 18, 18)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                    .addGroup(layout.createSequentialGroup()
                                                        .addGap(21, 21, 21)
                                                        .addComponent(textFieldURL))
                                                    .addComponent(textDocPath)
                                                    .addComponent(textDocName)
                                                    .addGroup(layout.createSequentialGroup()
                                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                            .addComponent(option3)
                                                            .addComponent(option2)
                                                            .addComponent(option1))
                                                        .addGap(0, 39, Short.MAX_VALUE))))
                                            .addGroup(layout.createSequentialGroup()
                                                .addGap(39, 39, 39)
                                                .addComponent(textFieldPath)))))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 85, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(browseButton, javax.swing.GroupLayout.PREFERRED_SIZE, 85, javax.swing.GroupLayout.PREFERRED_SIZE))))
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(widocoLogo, javax.swing.GroupLayout.PREFERRED_SIZE, 166, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(17, 17, 17)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSeparator1)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(labelTitle1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(labelTitle, javax.swing.GroupLayout.PREFERRED_SIZE, 380, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGap(0, 0, Short.MAX_VALUE)))
                                .addContainerGap())))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(labelTitle)
                        .addGap(18, 18, 18)
                        .addComponent(labelTitle1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(widocoLogo, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(9, 9, 9)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(option1)
                    .addComponent(labelSteps))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(textFieldPath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(option2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(textFieldURL, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(option3)
                        .addGap(0, 16, Short.MAX_VALUE))
                    .addComponent(jScrollPane1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(textDocName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(7, 7, 7)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(textDocPath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseButton))
                .addGap(21, 21, 21)
                .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, 5, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nextButton)
                    .addComponent(cancelButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void textFieldURLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_textFieldURLActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_textFieldURLActionPerformed

    private void nextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextButtonActionPerformed
        //test if the path selected by the user is correct!
        g.getConfig().setDocumentationURI(textDocPath.getText());
        if(option1.isSelected()||option2.isSelected()){
            if(option1.isSelected()){
                //check that the path belongs to an ontology that exists.
                File f = new File(textFieldPath.getText());
                if (f.exists()){
                    g.getConfig().setOntologyPath(textFieldPath.getText());
                    g.getConfig().setFromFile(true);
                    this.g.switchState("next");
                }else{
                    JOptionPane.showMessageDialog(this, "The chosen file does not exist");  
                }
            }
            if(option2.isSelected()){
                try{
                    //check that the url is valid
                    URL url = new URL(textFieldURL.getText());
                    url.toURI();
                    g.getConfig().setOntologyPath(textFieldURL.getText());
                    g.getConfig().setOntologyURI(textFieldURL.getText());//we save the path as the URI (for loading later)
                    g.getConfig().setFromFile(false);
                    this.g.switchState("next");
                }catch(Exception e){
                    JOptionPane.showMessageDialog(this, "The Ontology URI is not well formed");
                }
                
            }            
        }else{
            if(option3.isSelected()){
                this.g.switchState("skeleton");
            }
        }
        
    }//GEN-LAST:event_nextButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        this.g.switchState("cancel");
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        JFileChooser chooser = new JFileChooser(new File("").getAbsolutePath());
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setDialogTitle("Select a folder");
        chooser.setApproveButtonText("Select");
        if(chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
           this.folderPath = chooser.getSelectedFile().getAbsolutePath();
           //test if the selected file actually exist
           if (Files.notExists(Paths.get(folderPath))){
               JOptionPane.showMessageDialog(this, "The selected folder does not exist! Please select a folder");
               return;
           }
           //no need to check if the file is a foder, as we ensure this with the "directories_only" property
           this.textDocPath.setText(folderPath+File.separator+this.textDocName.getText());
        }
    }//GEN-LAST:event_browseButtonActionPerformed

    private void textDocPathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_textDocPathActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_textDocPathActionPerformed

    private void textDocNameKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textDocNameKeyTyped
        this.textDocPath.setText(folderPath+File.separator+textDocName.getText()+evt.getKeyChar());
    }//GEN-LAST:event_textDocNameKeyTyped

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        this.g.switchState("cancel");
    }//GEN-LAST:event_formWindowClosing

    private void option2ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_option2ItemStateChanged
        if (option2.isSelected()){
            this.textFieldURL.setEditable(true);
            //if the text is the default one, delete it.
            if (textFieldURL.getText().equals("Insert here the URL of the vocabulary")){
                textFieldURL.setText("");
            }
        }else{
            this.textFieldURL.setEditable(false);
            //if the text is the default one, delete it.
            if (textFieldURL.getText().equals("")){
                textFieldURL.setText("Insert here the URL of the vocabulary");
            }
        }
    }//GEN-LAST:event_option2ItemStateChanged

    private void option1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_option1ItemStateChanged
        if(option1.isSelected()){
            JFileChooser chooser = new JFileChooser(new File("").getAbsolutePath());
            chooser.setName("Select OWL File");
            //no need to create an additional class, as we will use this filter only here.
            chooser.setFileFilter(new FileFilter() {
                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().endsWith(".owl")||
                            f.getName().endsWith(".rdf")||
                            f.getName().endsWith(".ttl");
                }

                @Override
                public String getDescription() {
                    return null;
                }
            });
            //chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            int returnVal = chooser.showOpenDialog(this);
            if(returnVal == JFileChooser.APPROVE_OPTION) {
               System.out.println("You chose to save this file: " + chooser.getSelectedFile().getName());
               this.textFieldPath.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }//GEN-LAST:event_option1ItemStateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JLabel labelSteps;
    private javax.swing.JLabel labelTitle;
    private javax.swing.JLabel labelTitle1;
    private javax.swing.JButton nextButton;
    private javax.swing.JRadioButton option1;
    private javax.swing.JRadioButton option2;
    private javax.swing.JRadioButton option3;
    private javax.swing.JTextField textDocName;
    private javax.swing.JTextField textDocPath;
    private javax.swing.JTextField textFieldPath;
    private javax.swing.JTextField textFieldURL;
    private javax.swing.JTextPane textPaneSteps;
    private javax.swing.JLabel widocoLogo;
    // End of variables declaration//GEN-END:variables
}
