import json
import geojson
import copy
from os import listdir

num_polygons = 100
min_x = 6.41 # Example west longitude
min_y = 47.52  # Example south latitude
max_x = 15.05 # Example east longitude
max_y = 54.48 # Example north latitude

def createRandomPolygons(): 
  num_vertices = 5
  index = 1
  with open('random_polygons.txt', 'w') as f:
    for c in range(num_polygons):
      geojson_data = geojson.utils.generate_random("Polygon", num_vertices, boundingBox=[min_x, min_y, max_x, max_y])
      f.write(json.dumps(geojson_data) + '\n')
      index += 1
      if (index == 7):
        print(f'{c}: num_vertices: {num_vertices}' )
        index = 1
        num_vertices += 1
      # # print(json.dumps(geojson_data, indent=4))


def createJDBoundaries():
  jd_boundaries = open('JD_boundaries_original.json', 'r').read()
  jd_boundaries_json = json.loads(jd_boundaries)
  i = 1
  with open('random_polygons.txt', 'r') as f:
    for line in f:
      polygon = json.loads(line)
      new_jd_boundaries = copy.deepcopy(jd_boundaries_json)
      points = []
      for coord in polygon['coordinates'][0]:
        point = {
          "@type": "Point",
          "lat": coord[1],
          "lon": coord[0]
        }
        points.append(point)
      new_jd_boundaries['values'][0]['multipolygons'][0]['rings'][0]['points'] = points
      file = open(f'./boundaries-tests/test-{i}.txt', "w")
      file.write(json.dumps(new_jd_boundaries, indent=2))
      i = i + 1

# TODO add support for multipolygons
def convertJsonToJD(file_path):
	jd_boundaries = open('JD_boundaries_original.json', 'r').read()
	jd_boundaries_json = json.loads(jd_boundaries)
	json_file= open(f'{file_path}', 'r').read()
	new_json = geojson.loads(json_file)
	new_jd_boundaries = copy.deepcopy(jd_boundaries_json)
	for feat in range(len(new_json.features)):
		rings = []
		for coord in range(len(new_json.features[feat].geometry['coordinates'])):
			points_obj = {"@type": "Ring", "points": []}
			for pt in new_json.features[feat].geometry['coordinates'][coord]:
				point = {
					"@type": "Point",
					"lat": pt[1],
					"lon": pt[0]
				}
				points_obj['points'].append(point)
			rings.append(points_obj)
		new_jd_boundaries['values'][0]['multipolygons'][feat]['rings'] = rings
	file = open(f'./boundaries-examples/expected-result-3.txt', "w")
	file.write(json.dumps(new_jd_boundaries, indent=2))

def convertJDtoGeoJson(file_path, file_name):
  test_number = file_name.partition('-')[2].rstrip('.txt')
  # print('number: ', test_number)
  geojson_obj = geojson.loads('{"type": "FeatureCollection","features": [{"type": "Feature","properties": {},"geometry": {"type": "Polygon","coordinates": []}}]}')
  with open(f'{file_path}', 'r') as f:
    jd_test = json.loads(f.read())
    for pol in range(len(jd_test['values'][0]['multipolygons'])):
      for ring in jd_test['values'][0]['multipolygons'][pol]['rings']:
        coords = []
        for pt in ring['points']:
          point = [pt['lon'], pt['lat']]
          coords.append(point)
        geojson_obj.features[pol].geometry.coordinates.append(coords)
    file = open(f'./boundaries-expected-results/expected-result-{test_number}.txt', "w")
    file.write(json.dumps(geojson_obj, indent=2))

def convertAllTestsToGeoJson():
  for test in listdir('./boundaries-tests'):
    convertJDtoGeoJson(f'./boundaries-tests/{test}', test)
  print("Conversion finished")
 
def main():
  createRandomPolygons()
  createJDBoundaries()
  convertAllTestsToGeoJson()
  
if __name__ == "__main__":
  main()

