% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/screening.r
\name{screening}
\alias{screening}
\title{Screens a peak- and blanklist for matches with compounds}
\usage{
screening(peaklist, blanklist = FALSE, pattern, RT = 1000, dmz = 10,
  ppm = TRUE, dRT = 500, dRTwithin = 50, dRTblank = 200, dInt = 0.2,
  Intcut = 5000, w1 = 0.8, w2 = 0.2, w3 = 0)
}
\arguments{
\item{peaklist}{Matrix or data.frame of sample peaks. 3 columns: m/z, intensity, RT.}

\item{blanklist}{Logical FALSE or matrix or data.frame of blind/blank peaks. 3 columns: m/z, intensity, RT.}

\item{pattern}{List of isotope patterns (i.e., centroids) of compounds to be screened for.}

\item{RT}{Numeric vector. Retention time to be matched; units equal to those of the input files. Must match length of \code{pattern}.}

\item{dmz}{Numeric. +/- m/z tolerance (precision)}

\item{ppm}{Logical. \code{dmass} given in ppm?}

\item{dRT}{Numeric. RT tolerance for matches with \code{peaklist}; units equal to those of the input files}

\item{dRTwithin}{Numeric. More restrictive RT tolerance relative to the most intense match.}

\item{dRTblank}{Numeric. RT tolerance window for matches with \code{blanklist}; units equal to those of the input files}

\item{dInt}{Numeric. Intensity tolerance, given as a fraction of a peak intensity.}

\item{Intcut}{Numeric. Centroids below this intensities are not screened for.}

\item{w1}{0<=Numeric<=1. Weight for fraction of expected vs. matched peaks within mass tolerances.}

\item{w2}{0<=Numeric<=1. Weight for fraction of expected vs. matched peaks within mass & intensity tolerances.}

\item{w3}{0<=Numeric<=1. Weight for fraction of expected vs. matched peaks in \code{blanklist}.}
}
\value{
List of matches with length equal to \code{pattern}
}
\description{
\code{screening} screens a peak- and blanklist for matches with the isotope patterns of compounds
}
\details{
enviMass workflow function. Each entry in the list \code{pattern} refers to the centroid masses and intensities of a specific compound.
Hence, different adducts of the same compound result in different entries in this list. \code{w1,w2,w3} must sum to 1.
First, and for each entry in \code{pattern}, a match with the highest centroid is screened for. Having detected a match,
the intensities of the remaining theretical centroids from \code{pattern} are scaled accordingly. Those remaining above
\code{Intcut} are then screened for.
}

