% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/recalib.r
\name{recalib}
\alias{recalib}
\title{Function for m/z and RT recalibration.}
\usage{
recalib(peaklist, mz, tolmz = 10, ppm = TRUE, ret, tolret, what = "mass",
  one = TRUE, knot = 5, plot_it = FALSE, path_1 = FALSE,
  path_2 = FALSE, stopit = FALSE, intermediate_results = FALSE)
}
\arguments{
\item{peaklist}{Matrix or data.frame of sample peaks. 3 columns: m/z, intensity, RT.}

\item{mz}{Numeric vector. Masses to be matched within large tolerances of \code{tolmz}.}

\item{tolmz}{Numeric. +/- m/z tolerance (precision)}

\item{ppm}{Logical. \code{tolmz} given in ppm?}

\item{ret}{Numeric vector. Retention times to be matched; units equal to those of the input files}

\item{tolret}{Numeric. RT tolerance for matches with \code{peaklist}; units equal to those of the input files}

\item{what}{Character strings "mass" or "ret".}

\item{one}{Logical. Only use recalibration \code{mz, ret} that can be matched unambiguously.}

\item{knot}{Integer. Number of spline knots.}

\item{plot_it}{Logical. Produce recalibration plot?}

\item{path_1}{Logical \code{FALSE} or character string. If not \code{FALSE}, filepath to output the plot}

\item{path_2}{Logical \code{FALSE} or character string. Filepath for saving GAM model.}

\item{stopit}{Logical. Triggers a full R error (\code{TRUE}) or returns an error message string (\code{FALSE}) if failing.}

\item{intermediate_results}{Logical. Call by reference to have intermediates in the enclosing environment?}
}
\value{
Recalibrated \code{peaklist}.
}
\description{
Function for m/z and RT recalibration.
}
\details{
enviMass workflow function. \code{mz} and \code{ret} must be of same length and specify the points to recalibrate with.
A minimum of 15 matches must be found to conduct the recalibration.
}

