% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/partcluster.r
\name{partcluster}
\alias{partcluster}
\title{Extract profiles from peak set partitions}
\usage{
partcluster(profileList, dmass = 3, ppm = TRUE, dret = 60, from = FALSE,
  to = FALSE, progbar = FALSE, plot_it = FALSE)
}
\arguments{
\item{profileList}{A profile list.}

\item{dmass}{Numeric. m/z gap size}

\item{ppm}{Logical. \code{dmass} given in ppm?}

\item{dret}{Numeric. RT gap size; units equal to those of the input files}

\item{from}{Logical FALSE or integer. Restrict to certain partitons.}

\item{to}{Logical FALSE or integer. Restrict to certain partitions.}

\item{progbar}{Logical. Should a progress bar be shown? Only for Windows.}

\item{plot_it}{Logical. Plot profile extraction? For debugging.}
}
\value{
Updated profile list
}
\description{
\code{partcluster} extract profiles from peak set partitions generated by \code{\link{agglomer}}.
}
\details{
enviMass workflow function. Works along decreasing intensities. The remaining peak of highest intensity not
yet part of a profile is either assigned to an existing profile (closest in mass) or initializes a new profile. With
addition of a peak to a new profile, profile mass tolerances are gradually adapted.
}
\seealso{
\code{\link{startprofiles}}, \code{\link{agglomer}}
}

