% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/find_raw.r
\name{find_raw}
\alias{find_raw}
\title{Match with raw data}
\usage{
find_raw(MSlist, mz, dmz = 5, ppm = TRUE, RT, dRT, int, kdTree = FALSE)
}
\arguments{
\item{MSlist}{enviPick MSlist object}

\item{mz}{Numeric vector. Mass(es) to be matched}

\item{dmz}{Numeric. +/- m/z tolerance (precision)}

\item{ppm}{Logical. \code{dmass} given in ppm?}

\item{RT}{Numeric vector. Retention times to be matched; units equal to those of the input files}

\item{dRT}{Numeric. RT tolerance window; units equal to those of the input files}

\item{int}{Numeric vector. Minimum (lower bound) intensities to be matched}

\item{kdTree}{Logical FALSE or a kdTree. If first, local kdTree will be produced in function.}
}
\value{
Vector of characters. For each \code{mz,RT,int} input, the vector entry specifies if data points in MSlist exist.
}
\description{
\code{find_raw} searches for raw data points within a given mass, RT and intensity range.
}
\details{
enviMass workflow function. Ensure that RT units of arguments \code{RT} and \code{dRT} match \code{MSlist[[4]][[2]][,3]}.
}
\seealso{
\code{search_peak}
}

