%Note that the scripts in the Dependencies folder are required to run the
%script
clear
close all
file_dir=[pwd,'\Raw Data\'];
freq=1.294e6;
%Fixed background for fixed background fitting
bg=0.003945;

%Amount of time ignored at beginning and end of each strobe
lock_time=0.25;

strobe_times{1}=[0,50,100,150,200,250,300,350];
strobe_times{2}=[0,100,150,200,250,300,350];
strobe_times{3}=[0,150,200,250,300,350];
strobe_times{4}=[0,200,250,300,350];
strobe_times{5}=[0,250,300,350];
strobe_times{6}=[0,300,350];
strobe_times{7}=[0,350];

strobe_length{1}=[5,5,5,5,5,5,5,50];
strobe_length{2}=[5,5,5,5,5,5,50];
strobe_length{3}=[5,5,5,5,5,50];
strobe_length{4}=[5,5,5,5,50];
strobe_length{5}=[5,5,5,50];
strobe_length{6}=[5,5,50];
strobe_length{7}=[5,50];

n_strobe=7;

figure(1)       

file_list=dir(file_dir);
end_trace=length(file_list);
plot_on=true;
%Colors of the plotted traces
color={'r','r','r','r','r','r','r'};
%Regular expression that each data trace matches
expr='beam_strobe_(\d*)sec_';

%Flag for plotting the averaged traces for each strobe setting
plot_single=true;
%Flag for plotting all the traces, but without the data outside the strobes
plot_all_conditioned=false;
%Flag for plotting each individual raw trace
plot_trace=false;

%Initialize loop variables
n_s=[];
y_trace={};
x_trace={};
pwrs=[];
%If the flag for plotting each trace is on, the first one is plotted in
%this figure number, then iterated.
fig_no=2;

%Loads all the traces that matches the regular expression
for i=1:end_trace
    if ~file_list(i).isdir
        %Checks if the file matches the regular expression
        strobe_str=regexp(file_list(i).name,expr,'tokens');
        %If the expression is matched and the file is sufficiently large,
        %we proceed
        if ~isempty(strobe_str) && file_list(i).bytes>1e4
            %Extracts the time of the first strobe as indicated by the file
            %name
            n_s(end+1)=str2double(strobe_str{1});
            trace=load([file_dir,file_list(i).name]);
            
            %Separates the x and y data
            y_trace{end+1}=trace(:,2)/mean(trace(1:20,2));
            x_trace{end+1}=trace(:,1);
            
            %Plots each trace if the flag is on
            if plot_trace
                figure(fig_no)
                plot(trace(:,1),trace(:,2),'b');
                fig_no=fig_no+1;
                title(file_list(i).name,'Interpreter','none');
            end
        end
    end
end

figure(1)
ax=gca;
hold on
uni_n_s=unique(n_s);
y_mean=cell(n_strobe,1);
x_mean=cell(n_strobe,1);
fitdatas=cell(n_strobe,1);
for i=1:n_strobe
    ind_trace=(n_s==uni_n_s(i));
    n(i)=sum(ind_trace);
    %Extracts the traces corresponding to the correct first strobe time
    y_tmp=y_trace(ind_trace);
    x_tmp=x_trace(ind_trace);
    
    %Initialization of variables
    min_length=min(cellfun(@(x) length(x),y_tmp));
    x_mean{i}=x_tmp{1}(1:min_length);
    y_mean{i}=zeros(min_length,1);
    
    
    for j=1:n(i)
        %Truncate data to the shortest length, this typically cuts out
        %maximum 20-30 points.
        y_tmp{j}=y_tmp{j}(1:min_length);
        x_tmp{j}=x_tmp{j}(1:min_length);
        comb_ind{i}=false(min_length,1);
        
        %Extract the indices for the strobe on times, except a lock time,
        %which is the time it takes for the homodyne fringe to relock.
        for k=1:length(strobe_times{i})
            if strobe_times{i}(k)==0
                ind=x_tmp{j}<(strobe_length{i}(k)-lock_time);
            elseif k==length(strobe_times{i})
                ind=x_tmp{j}>strobe_times{i}(k)+lock_time &...
                    x_tmp{j}<(strobe_times{i}(k)+strobe_length{i}(k));
            else
                ind=(x_tmp{j}>(strobe_times{i}(k)+lock_time) &...
                    x_tmp{j}<(strobe_times{i}(k)+strobe_length{i}(k)-lock_time));
            end
            comb_ind{i}=ind | comb_ind{i};
        end
        
        
        %Fit to the individual trace for diagnostics
        fitdata=fitArbFun('a*exp(-b*x)+c',...
            x_tmp{j}(comb_ind{i}),y_tmp{j}(comb_ind{i}),...
            'lower',[0,0,0],'upper',[1.5,1,1],'pIn',[1,1e-2,0]);
        Q(i,j)=freq/fitdata.b*pi;
        
        %Plots the strobes and the fit thereto
        if plot_all_conditioned
            figure(10*i+j);
            plot(x_tmp{j}(comb_ind{i}),y_tmp{j}(comb_ind{i}))
            hold on
            plot(fitdata)
        end
        
        %Adds the trace to the mean
        y_mean{i}=y_mean{i}+y_tmp{j}(1:min_length)/n(i);
    end
    %Normalize the mean
    y_mean{i}=y_mean{i}/mean(y_mean{i}(1:20));
    
    
    %Fit to the mean
    fitdatas{i}=fitArbFun('a*exp(-b*x)+c',...
        x_mean{i}(comb_ind{i}),y_mean{i}(comb_ind{i}),...
        'pIn',[1,1e-2,0],'lower',[0,0,0],'upper',[1.1,1,1]);
    fitdatas_nobg{i}=fitArbFun('a*exp(-b*x)',...
        x_mean{i}(comb_ind{i}),y_mean{i}(comb_ind{i}),...
        'pIn',[1,1e-2],'lower',[0,0],'upper',[1.1,1]);
    [fitdatas_fixedbg{i},gof_fixedbg{i}]=fitArbFun(...
        sprintf('a*exp(-b*x)+%d',bg),...
        x_mean{i}(comb_ind{i}),y_mean{i}(comb_ind{i}),...
        'pIn',[1,1e-2],'lower',[0,0],'upper',[1.1,1]);
    
    %Plots the averaged data and the fit to it
    if plot_single
        ax=gca;
        figure(1)
        hold on
        Q_m(i)=freq/fitdatas{i}.b*pi;
        Q_m_nobg(i)=freq/fitdatas_nobg{i}.b*pi;
        Q_m_fixedbg(i)=freq/fitdatas_fixedbg{i}.b*pi;
        plot(x_mean{i},y_mean{i},[color{i},'.']);
        plot(fitdatas{i},color{i});
    end
end
legend off
xlabel('Time (s)')
ylabel('Amplitude (arb. units)')
set(ax,'YScale','Log');
axis([0,400,1e-2,1])

save([pwd,'\metadata_strobe_700M'],'y_mean','x_mean','fitdatas','Q_m',...
    'fitdatas_nobg','fitdatas_fixedbg','comb_ind')