%Note that the scripts in the Dependencies folder are required to run the
%script
clear
close all
file_dir=[pwd,'\Raw data\'];
freq=1.332e6;


figure(1)       

file_list=dir(file_dir);
end_trace=length(file_list);
plot_on=true;
color={'r','r','r','r','r','r','r'};
expr='beam_13_ref';

plot_trace=false;

y_trace={};
x_trace={};
fig_no=2;

%Loads all the traces that matches the regular expression
for i=1:end_trace
    if ~file_list(i).isdir
        strobe_str=regexp(file_list(i).name,expr,'tokens');
        if~isempty(strobe_str) && file_list(i).bytes>1e4

            trace=load([file_dir,file_list(i).name]);
            
            %Separates the x and y data
            y_trace{end+1}=trace(:,2)/mean(trace(1:20,2));
            x_trace{end+1}=trace(:,1);
            
            %Plots each trace if the flag is on
            if plot_trace
                figure(fig_no)
                plot(trace(:,1),trace(:,2),'b');
                fig_no=fig_no+1;
                title(file_list(i).name,'Interpreter','none');
            end
        end
    end
end

for i=1:length(x_trace)
    
end
figure(1)
ax=gca;
hold on

min_length=min(cellfun(@(x) length(x),y_trace));
x_mean=x_trace{1}(1:min_length);
y_mean=zeros(min_length,1);
n=length(x_trace);

for i=1:n
    y_mean=y_mean+y_trace{i}(1:min_length)/n;
end

y_mean=y_mean/(mean(y_mean(1:20)));

plot(x_mean,y_mean,'b');
fitdata=fitArbFun('a*exp(-b*x)+c',x_mean,y_mean,'lower',[0,0,0],...
    'pIn',[1,1e-2,0],'upper',[1.1,1,1]);

plot(fitdata,'r')
Q=pi/fitdata.b*freq;

save('ref_data_800M','fitdata','Q','x_mean','y_mean','n');