%Function: makePDF.m
%Usage: makePDF(100,plot,8.3,10)
%Description: Outputs a pdf of the figure number desired named 
%'filename.pdf' in the SqueezingPaperFigures folder with desired height and
%width
%Inputs:
%figure_no - figure number (int)
%filename - desired output filename (str)
%Optional inputs:
%width -    desired width of figure in cm (if different from original) or can also type 'scale'
%           if you want to scale according to height
%height -   desired height of figure in cm (if different from original) or can also type 'scale'
%           if you want to scale according to width
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function makePDF_klab(figure_no, filename, width, height,path)
%     path='C:\Dropbox\EPFL Postdoc\MATLAB Figures\';
    h=figure(figure_no);
    set(h,'units','centimeters')
    set(h,'PaperUnits','centimeters')
    set(h, 'PaperPositionMode', 'manual');
    %Width calculations
    if ~exist('width','var')
        pos=get(figure(figure_no),'Position');
        width=pos(3);
    elseif strcmp(width,'scale')
        width=rescale(figure_no,'width',height);
    end
    %Height calculations
    if ~exist('height','var')
        pos=get(figure(figure_no),'Position');
        height=pos(4);
    elseif strcmp(height,'scale')
        height=rescale(figure_no,'height',width);
    end
    set(h, 'Position', [5 5 width height])
    set(h,'papersize',[width,height])
    set(h,'paperposition',[0,0,width,height])
    set(h, 'renderer', 'painters'); %Makes the output vector graphics
    print(h,sprintf('%s\\%s.pdf',path,filename),'-dpdf','-r600')
%     set(h, 'renderer', 'opengl')
%     print(h,sprintf('%s\\%s.png',path,filename),'-dpng','-r1200')
end