function fitdata= fitArbFun(ffun, xf, yf, varargin)
%Fits an arbitrary function to the input data. 
% Syntax:
%      	 fitdata=fitArbFun(ffun, xdata, ydata,'PropertyName',Value,'PropertyName2',Value2)
%
% Example:
% fitArbFun('a*x+b',xf,yf, 'lower',[-Inf,-Inf],'upper',[Inf,Inf],...
%           'pIn',[1,1],'color','r','show_plot',1)
% 'color':          Color of the fits and plots
% 'show_plot':      Whether to show the plot of the data and fit
% 'lower':          Lower limits of the fit parameters
% 'upper':          Upper limits of the fit parameters
% 'pIn':            Initial guesses for the fit parameters

%Loads and initalizes optional inputs
varNo=nargin(inline(ffun))-1;
initvals=struct('lower',-inf(1,varNo),'upper',inf(1,varNo),'pIn',...
    ones(1,varNo),'color','r','show_plot',0,'figure_no',31);
input_names=fieldnames(initvals);

for i=1:length(input_names)
    if ~isempty(varargin)
        index=find(strcmp(input_names(i),varargin));
        if ~isempty(index) && index+1<=length(varargin)
            initvals.(char(input_names(i)))=varargin{index+1};
        elseif ~isempty(index)
            warning('Invalid argument for %s, standard value used',...
                char(input_names(i)));
        end
    end
    inputs.(char(input_names(i)))=initvals.(char(input_names(i)));
end

fitOptions=fitoptions('Method','NonLinearLeastSquares',...
    'StartPoint',inputs.pIn,'Lower',inputs.lower,'Upper',inputs.upper);
fitType=fittype(ffun,'options',fitOptions);
fitdata=fit(xf,yf,fitType);

if(inputs.show_plot)
    figure(inputs.figure_no);
    plot(fitdata,inputs.color,xf,yf,'b.');
end

end
