from datetime import datetime
import json
import os
import requests
import sys
from os import listdir, makedirs
import progressbar
# NOTE: ollama must be running for this to work, start the ollama app or run `ollama serve`

models = {
    "codellama": "codellama",
    "llama3:instruct": "llama3-it",
    "codegemma:instruct": "codegemma-it",
    "mistral:instruct": "mistral-it"
}
     
def generate(prompt, context, model, path, test):
    response_file_path = f'{path}/{test[:-4]}-response.txt'
    makedirs(f'{path}', exist_ok=True)
    if not os.path.exists(response_file_path):
        r = requests.post('http://10.128.36.200:11434/api/generate',
                      json={
                            "model": model,
                            "prompt": prompt,
                            "format": "json",
                            "stream": False})
        r.raise_for_status()
    
        with open(response_file_path, "w") as f:
            body = r.json()
            response = body['response']
            f.write(response)

            if 'error' in body:
                raise Exception(body['error'])

            if body.get('done', False):
                return body['context']
    else:
        print(f'File {response_file_path} already exists. Skipping...')

def main():
    model = sys.argv[1]
    learning_type = sys.argv[2]

    bar = progressbar.ProgressBar(
        widgets = ['Progress: ', progressbar.Percentage(), ' ', progressbar.Bar(),' ', progressbar.Timer()],
        maxval=100)

    test_folder = './boundaries-tests/strategy_1_b'
    example_file_1 = open('./boundaries-examples/example-1-prompt.txt', 'r')
    example_file_2 = open('./boundaries-examples/example-2-prompt.txt', 'r')
    example_file_3 = open('./boundaries-examples/example-3-prompt.txt', 'r')
    prompt_file_1 = open('./prompts/boundaries_conversion_prompt1.txt', 'r')
    prompt_file_2 = open('./prompts/boundaries_conversion_prompt2.txt', 'r')
    new_prompt_1_file = open('./prompts/new_prompt_1.txt', 'r')
    init_example_file = open('./prompts/init_example_prompt.txt', 'r')
    init_example = init_example_file.read()
    example_prompt_1 = example_file_1.read()
    example_prompt_2 = example_file_2.read()
    example_prompt_3 = example_file_3.read()
    direct_conversion_prompt1 = prompt_file_1.read()
    direct_conversion_prompt2 = prompt_file_2.read()
    new_prompt_1 = new_prompt_1_file.read()
    example_file_1.close()
    example_file_2.close()
    example_file_3.close()
    prompt_file_1.close()
    new_prompt_1_file.close()
    init_example_file.close()

    context = [] # the context stores a conversation history, you can use this to make the model more context aware

    few_shot_1_example = init_example + example_prompt_1
    few_shot_2_examples = init_example + example_prompt_1 + example_prompt_2
    few_shot_3_examples = init_example + example_prompt_1 + example_prompt_2 + example_prompt_3

    bar.start()
    makedirs(f'./{models[model]}/{learning_type}', exist_ok=True)

    path = f'./{models[model]}/{learning_type}/strategy_1_b'

    process = 0
    for test in listdir(test_folder):
        with open(f'{test_folder}/{test}', 'r') as test_file:
            test_jd = test_file.read()
            test_prompt = direct_conversion_prompt1 + test_jd + direct_conversion_prompt2
        prompts = {
            "zero-shot": test_prompt,
            "few-shot-1": new_prompt_1 + test_prompt + "\n ```\n" + "example: \n" + example_prompt_1,
            "few-shot-2": few_shot_2_examples + test_prompt,
            "few-shot-3": few_shot_3_examples + test_prompt
            }
        prompt = prompts[learning_type]
        context = generate(prompt, context, model, path,test) # returns array of tokens
        process += 1
        bar.update(process)
    bar.finish()
    print(f'\n//////// Model {model} run complete {datetime.today().strftime("%Y-%m-%d %H:%M:%S")}')


if __name__ == "__main__":
    main()