/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package dsgaproteinfoldingkg;

import java.util.List;

/**
 *
 * @author mbrown15
 */
public class individual {
    public String genes;
    public boolean isSeed;
    private Folding folding;
    public double naturalFitness;
    
    individual(String g)
    {
        genes = new String();
        isSeed = false;
        genes = g;
        folding = new Folding();   
    }
    
    public void setGenes(String g)
    {
        genes = g;
    }
    
    public void setFitness(String protein)
    {
        naturalFitness = folding.computeFreeEnergy(folding.foldProtein(this, protein.length()), protein);
    }
    
    public double sharedFitness(List<individual> i, String protein)
    {
        if (i.size() == 0)
           return naturalFitness + 1.0;
        else
        {
            double m = 0.0;
            for (int x = 0; x < i.size(); x++)
            {
                individual tempI = i.get(x);
                m = m + (protein.length() - (distance(tempI) / (protein.length() / 10)));
            }
            return (naturalFitness / m) + 1.0;
        }
    }
    
    public double distance(individual i2)
    {
        double tempDistance = 0.0;
        
        for (int x = 0; x < this.genes.length(); x++)
        {
            if (this.genes.charAt(x) != i2.genes.charAt(x))
               tempDistance = tempDistance + 1.0;
        }

        return tempDistance;
    }
    
    public void print(String protein)
    {
        System.out.println("Individual " + this.genes + " natural fittness " + this.naturalFitness);
    }


    
}
