/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package dsgaproteinfoldingkg;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.*;
/**
 *
 * @author mbrown15
 */
public class dsga {
    private List<individual> currentGeneration;
    private List<individual> nextGeneration;
    private List<individual> tabuList;
    private List<individual> currentSeeds;
    
    private Random randNum;
    
    public void initialization(int populationSize, String protein)
    {
        currentGeneration = new ArrayList<>();
        nextGeneration = new ArrayList<>();
        tabuList = new ArrayList<>();
        randNum = new Random();
        
        java.text.DateFormat df = new java.text.SimpleDateFormat("ssHHMMmm");
        Date d = new Date();
        randNum.setSeed(Long.parseLong(df.format(d)));
        
        individual tempIndividual; 
        for (int x = 1; x <= populationSize; x++)
        {
            tempIndividual = new individual(computeRandomString(protein));
            currentGeneration.add(tempIndividual);
        }
    }
    
    private String computeRandomString(String protein)
    {
        String tempStr = new String();
        int randInt;
        
       // create a random individual
       for (int y = 1; y < protein.length(); y++)
       {
           randInt = randNum.nextInt(4);
           if (randInt == 0)
               tempStr = tempStr + "0";
           else if (randInt == 1)
               tempStr = tempStr + "1";
           else if (randInt == 2)
               tempStr = tempStr + "2";
           else
               tempStr = tempStr + "3";
       }
       return tempStr;
    }
    
    public void seedSelection(double radius, String protein)
    {
 //       System.out.println("Begin seed selection - radius " + radius);
        
        // computer natural fitness
        commputeNaturalFitness(currentGeneration, protein);
        
        currentSeeds = new ArrayList<>();
        List<individual> tempList = new ArrayList<>();
        
//        printCurrentGeneration();
    //    System.out.println(" ");
                
        Collections.sort(currentGeneration, new individualSorter(tabuList, protein));

        Iterator<individual> iterator = currentGeneration.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            tempList = withinRadius(tempIndividual, radius);
            
            boolean hasASeed = false;
            
            Iterator<individual> iterator2 = tempList.iterator();
	    individual tempIndividual2;
             while (iterator2.hasNext()) 
             {
                 tempIndividual2 = iterator2.next();
                 if (tempIndividual2.isSeed == true)
                         hasASeed = true;
             }
             
             if (hasASeed == false)
             {
                 tempIndividual.isSeed = true;
                 currentSeeds.add(tempIndividual);
             }
        }
         
 //       System.out.println("  Printing seeds from seed Selection");
 //       printList(currentSeeds);
 //       System.out.println("End seed selection from seed selection");
 //       System.out.println("");
    }
    
    public void selectionCrossover(int populationSize, String protein)
    {
        double sumFittness = 0.0;
//System.out.println("Being selection / crossover");
//printCurrentGeneration();

        // compute sum of fitness;
        Iterator<individual> iterator = currentGeneration.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            sumFittness = sumFittness + tempIndividual.sharedFitness(tabuList, protein);
        }
        
//        System.out.println("Shared fittness sum  " + sumFittness);
        
        for (int z = 0; z < (populationSize / 2); z++)
        {
            // locate two individuals
            individual individual1 = getIndividualSelect(sumFittness, protein);
            individual individual2 = getIndividualSelect(sumFittness, protein);

            // locate crossover point
            int crossOverPoint = randNum.nextInt(individual1.genes.length());
//System.out.println("Selection         Individual1 " + individual1.genes + "  Individual2 " + individual2.genes + 
  //      " crossover point " + crossOverPoint);


            // create two new individuals
            individual newIndividual1 = new individual(individual1.genes.subSequence(0, crossOverPoint) +
                individual2.genes.substring(crossOverPoint, individual2.genes.length()));
        
            individual newIndividual2 = new individual(individual2.genes.subSequence(0, crossOverPoint) +
                individual1.genes.substring(crossOverPoint, individual2.genes.length()));
        
 //System.out.println("Selection Results Individual1 " + newIndividual1.genes + "  Individual2 " + newIndividual2.genes);
            // add two new individuals to next generation
            nextGeneration.add(newIndividual1);
            nextGeneration.add(newIndividual2);
        }
    }
    
    public void mutation(double mutationeRate)
    {
        Iterator<individual> iterator = nextGeneration.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            for (int y = 0; y < tempIndividual.genes.length(); y++)
            {
                if (randNum.nextDouble() < mutationeRate)
                {
                    int newGeneValue = randNum.nextInt(4);
//                    System.out.println("Mutate " + tempIndividual.genes + " position " + y);
                    tempIndividual.genes = tempIndividual.genes.substring(0, y) + newGeneValue +
                                tempIndividual.genes.substring(y + 1, tempIndividual.genes.length());

//                    System.out.println("  New mutated individual  " + tempIndividual.genes);
                }
            }
        }        
    }
    
    public void seedConservation(double radius, String protein)
    {
 //       System.out.println("");
 //       System.out.println("Print current seeds in seed conservation");
 //       printList(currentSeeds);
        
        // computer natural fitness of next generation
        commputeNaturalFitness(nextGeneration, protein);
        
        Iterator<individual> iterator = currentSeeds.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            tempIndividual.isSeed = false;    // seeds have to compete again to be seeds
            
            int replacePosition = weakestPosition(tempIndividual, radius, protein);
//System.out.println(" Replace position " + replacePosition + " with " + tempIndividual.genes);            
            nextGeneration.remove(replacePosition);
            nextGeneration.add(tempIndividual);
        }
 //       System.out.println("Ending seed conservation");
   //     System.out.println("");
    }
    
    public void retireCurrentGeneration()
    {
        currentGeneration = nextGeneration;
        nextGeneration = new ArrayList<>();
    }
    
    public void reevaluation(int convergencelimit, String protein)
    {
        // put seeds on tabu list
        for (int x = 0; x < currentSeeds.size(); x++)
        {
            if ((currentSeeds.get(x).naturalFitness > 0.0) &&
                    (isOnTabuList(currentSeeds.get(x)) == false))
               tabuList.add(currentSeeds.get(x));
            
            // replace with random
 //           replaceWithRandom(currentSeeds.get(x).genes);
        }
        
        // put convergence individuals on tabu list
        for (int y = 0; y < currentGeneration.size(); y++)
        {
            individual tempIndividual = currentGeneration.get(y);
            if ((individualCount(tempIndividual.genes) >= convergencelimit) &&
                    (isOnTabuList(tempIndividual) == false))
            {
                // add to tabu list
                tabuList.add(tempIndividual);
                
                // replace with random
//                replaceWithRandom(tempIndividual.genes);
            }
        }
        
    //    System.out.println("Tabus list updated.");
        printList(tabuList);
    }
    
    public boolean isOnTabuList(individual i)
    {
        boolean t = false;
        for (int x = 0; x < tabuList.size(); x++)
        {
            if (tabuList.get(x).genes.equals(i.genes))
                t = true;
        }
        return t;
    }
    
    
    private int individualCount(String genes)
    {
        int count = 0;
        for (int y = 0; y < currentGeneration.size(); y++)
        {
            individual tempIndividual = currentGeneration.get(y);
            if (tempIndividual.genes.equals(genes))
                    count = count + 1;
        }
        return count;
    }
    
    private individual getIndividualSelect(double sumFittness, String protein)
    {
        double randomNum = randNum.nextDouble() * sumFittness;
      
        Iterator<individual> iterator = currentGeneration.iterator();
	individual tempIndividual = new individual("000000000000000000000000000"); // temp value
        
        while ((iterator.hasNext()) && (randomNum > 0.0)) 
        {
            tempIndividual = iterator.next();
            randomNum = randomNum - tempIndividual.sharedFitness(tabuList, protein);
	}
        return tempIndividual;
    }
    

    
    public void printList(List<individual> tempList)
    {
        Iterator<individual> iterator = tempList.iterator();
	individual tempIndividual;
        
//        while (iterator.hasNext()) 
//        {
//            tempIndividual = iterator.next();

//            System.out.println(tempIndividual.genes + " i=" + tempIndividual.i + 
 //                   " j=" + tempIndividual.j + " k=" + tempIndividual.k + 
  //                  "  Shared Fittness: " + tempIndividual.sharedFitness(tabuList) +
   //                 " Is a seed " + tempIndividual.isSeed);
//	}
   //     System.out.println("");
    }
    
    public List<individual> withinRadius(individual i, double radius)
    {
        List<individual> tempList = new ArrayList<>();
        
        Iterator<individual> iterator = currentGeneration.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
//System.out.println("  Within radius check " + i.genes + " and " + tempIndividual.genes + 
//        " distance " + tempIndividual.distance(i));
            if (tempIndividual.distance(i) < radius)
                tempList.add(tempIndividual);
	}
        return tempList;
    }
    
    private int weakestPosition(individual i, double radius, String protein)
    {
        int iteratorNum = 0;
        int lowestNum = -1;
        double lowestFitness = 9999.0;
        
        Iterator<individual> iterator = nextGeneration.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            if (tempIndividual.distance(i) < radius)
            {
                if (tempIndividual.sharedFitness(tabuList, protein) < lowestFitness)
                {
                    lowestNum = iteratorNum;
                    lowestFitness = tempIndividual.sharedFitness(tabuList, protein);
                }
            }
            
            iteratorNum = iteratorNum + 1;
	}
        
        if (lowestNum == -1) // replace globally weakest
        {
            Iterator<individual> iterator2 = nextGeneration.iterator();
	    individual tempIndividual2;
            iteratorNum = 0;  // reset iteration number
        
            while (iterator2.hasNext()) 
            {
                tempIndividual2 = iterator2.next();

                if (tempIndividual2.sharedFitness(tabuList, protein) < lowestFitness)
                {
                    lowestNum = iteratorNum;
                    lowestFitness = tempIndividual2.sharedFitness(tabuList, protein);
                }
                iteratorNum = iteratorNum + 1;
            }
        }
        
        return lowestNum;
    }
    
    public void print(String protein)
    {     
        System.out.println("");
        System.out.println("CURRENT GENERATION");
        for (int x = 0; x < currentGeneration.size(); x++)
        {
            individual i = currentGeneration.get(x);
            i.print(protein);
        }
        System.out.println("");
        System.out.println("TABU LIST");
        for (int y = 0; y < tabuList.size(); y++)
        {
            individual i = tabuList.get(y);
            i.print(protein);
        }
    }
   
    
    public void reduction(String protein)
    {
        
        System.out.println("");
        System.out.println("Begin reduction");
        
        // sort tabu list by fitness
        Collections.sort(tabuList, new individualSorterNaturalFitness(protein));

        Iterator<individual> iterator = tabuList.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            System.out.println("Individual =  " + tempIndividual.genes);
        }
    }
    
    public void sortTabuList(String protein)
    {
        Collections.sort(tabuList, new individualSorterNaturalFitness(protein));
    }
    
    public void commputeNaturalFitness(List<individual> list, String protein)
    {
        for (int x = 0; x < list.size(); x++)
        {
            individual i = list.get(x);
            i.setFitness(protein);
        }
    }
    
    public void computeBestIndividual(Writer w, String protein)
    {
        System.out.println("Best individual(s)");
        sortTabuList(protein);
        

        
        Iterator<individual> iterator = tabuList.iterator();
	individual tempIndividual;
        
        tempIndividual = iterator.next(); // get first individual
        double bestValue = tempIndividual.naturalFitness; // record natural fitness
        System.out.println("Individual =  " + tempIndividual.genes + " "  + tempIndividual.naturalFitness);
        try {
           w.write("Individual =  " + tempIndividual.genes + " "  + tempIndividual.naturalFitness + "\n");     
        } catch (Exception e)
        {System.out.println("Error " + e.getMessage());}
        
        tempIndividual = iterator.next();
        while (tempIndividual.naturalFitness == bestValue)
        {
            System.out.println("Individual =  " + tempIndividual.genes+ " "  + tempIndividual.naturalFitness);
            try {
               w.write("Individual =  " + tempIndividual.genes + " "  + tempIndividual.naturalFitness + "\n");     
            } catch (Exception e)
            {System.out.println("Error " + e.getMessage());}
            tempIndividual = iterator.next();
        }
        
        
    }
}
